#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1286
#define LARGE_STATE_COUNT 8
#define SYMBOL_COUNT 177
#define ALIAS_COUNT 5
#define TOKEN_COUNT 111
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 24
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 80

enum ts_symbol_identifiers {
  sym_word = 1,
  aux_sym__thing_token1 = 2,
  anon_sym_COLON = 3,
  anon_sym_AMP_COLON = 4,
  anon_sym_COLON_COLON = 5,
  aux_sym__ordinary_rule_token1 = 6,
  anon_sym_PIPE = 7,
  anon_sym_SEMI = 8,
  anon_sym_AT = 9,
  anon_sym_DASH = 10,
  anon_sym_PLUS = 11,
  anon_sym_VPATH = 12,
  anon_sym_EQ = 13,
  anon_sym_COLON_EQ = 14,
  anon_sym_COLON_COLON_EQ = 15,
  anon_sym_QMARK_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DOTRECIPEPREFIX = 18,
  anon_sym_BANG_EQ = 19,
  anon_sym_define = 20,
  anon_sym_endef = 21,
  anon_sym_include = 22,
  anon_sym_sinclude = 23,
  anon_sym_DASHinclude = 24,
  anon_sym_vpath = 25,
  anon_sym_export = 26,
  anon_sym_unexport = 27,
  anon_sym_override = 28,
  anon_sym_undefine = 29,
  anon_sym_private = 30,
  anon_sym_endif = 31,
  anon_sym_else = 32,
  anon_sym_ifeq = 33,
  anon_sym_ifneq = 34,
  anon_sym_ifdef = 35,
  anon_sym_ifndef = 36,
  anon_sym_LPAREN = 37,
  anon_sym_COMMA = 38,
  anon_sym_RPAREN = 39,
  anon_sym_DOLLAR = 40,
  anon_sym_DOLLAR_DOLLAR = 41,
  anon_sym_LPAREN2 = 42,
  anon_sym_LBRACE = 43,
  anon_sym_RBRACE = 44,
  aux_sym_variable_reference_token1 = 45,
  anon_sym_AT2 = 46,
  anon_sym_PERCENT = 47,
  anon_sym_LT = 48,
  anon_sym_QMARK = 49,
  anon_sym_CARET = 50,
  anon_sym_PLUS2 = 51,
  anon_sym_SLASH = 52,
  anon_sym_STAR = 53,
  anon_sym_PERCENT2 = 54,
  anon_sym_LT2 = 55,
  anon_sym_QMARK2 = 56,
  anon_sym_CARET2 = 57,
  anon_sym_SLASH2 = 58,
  anon_sym_STAR2 = 59,
  anon_sym_D = 60,
  anon_sym_F = 61,
  anon_sym_subst = 62,
  anon_sym_patsubst = 63,
  anon_sym_strip = 64,
  anon_sym_findstring = 65,
  anon_sym_filter = 66,
  anon_sym_filter_DASHout = 67,
  anon_sym_sort = 68,
  anon_sym_word = 69,
  anon_sym_words = 70,
  anon_sym_wordlist = 71,
  anon_sym_firstword = 72,
  anon_sym_lastword = 73,
  anon_sym_dir = 74,
  anon_sym_notdir = 75,
  anon_sym_suffix = 76,
  anon_sym_basename = 77,
  anon_sym_addsuffix = 78,
  anon_sym_addprefix = 79,
  anon_sym_join = 80,
  anon_sym_wildcard = 81,
  anon_sym_realpath = 82,
  anon_sym_abspath = 83,
  anon_sym_error = 84,
  anon_sym_warning = 85,
  anon_sym_info = 86,
  anon_sym_origin = 87,
  anon_sym_flavor = 88,
  anon_sym_foreach = 89,
  anon_sym_if = 90,
  anon_sym_or = 91,
  anon_sym_and = 92,
  anon_sym_call = 93,
  anon_sym_eval = 94,
  anon_sym_file = 95,
  anon_sym_value = 96,
  anon_sym_shell = 97,
  aux_sym_list_token1 = 98,
  anon_sym_COLON2 = 99,
  anon_sym_SEMI2 = 100,
  anon_sym_DQUOTE = 101,
  anon_sym_SQUOTE = 102,
  aux_sym__string_token1 = 103,
  anon_sym_RPAREN2 = 104,
  anon_sym_TAB = 105,
  sym__rawline = 106,
  aux_sym__shell_text_without_split_token1 = 107,
  anon_sym_SLASH_SLASH = 108,
  aux_sym_text_token1 = 109,
  sym_comment = 110,
  sym_makefile = 111,
  sym__thing = 112,
  sym_rule = 113,
  sym__ordinary_rule = 114,
  sym__static_pattern_rule = 115,
  sym__normal_prerequisites = 116,
  sym_recipe = 117,
  sym__attached_recipe_line = 118,
  sym__prefixed_recipe_line = 119,
  sym_recipe_line = 120,
  sym__variable_definition = 121,
  sym_VPATH_assignment = 122,
  sym_RECIPEPREFIX_assignment = 123,
  sym_variable_assignment = 124,
  sym_shell_assignment = 125,
  sym_define_directive = 126,
  sym__directive = 127,
  sym_include_directive = 128,
  sym_vpath_directive = 129,
  sym_export_directive = 130,
  sym_unexport_directive = 131,
  sym_override_directive = 132,
  sym_undefine_directive = 133,
  sym_private_directive = 134,
  sym_conditional = 135,
  sym_elsif_directive = 136,
  sym_else_directive = 137,
  sym__conditional_directives = 138,
  aux_sym__conditional_consequence = 139,
  sym_ifeq_directive = 140,
  sym_ifneq_directive = 141,
  sym_ifdef_directive = 142,
  sym_ifndef_directive = 143,
  sym__conditional_args_cmp = 144,
  sym__variable = 145,
  sym_variable_reference = 146,
  sym_substitution_reference = 147,
  sym_automatic_variable = 148,
  sym__function = 149,
  sym_function_call = 150,
  sym_arguments = 151,
  sym_shell_function = 152,
  sym_list = 153,
  sym_paths = 154,
  sym_concatenation = 155,
  sym_string = 156,
  aux_sym__string = 157,
  sym_archive = 158,
  sym__recipeprefix = 159,
  sym__shell_text_without_split = 160,
  sym_shell_text_with_split = 161,
  sym__shell_command = 162,
  sym_text = 163,
  aux_sym_makefile_repeat1 = 164,
  aux_sym_recipe_repeat1 = 165,
  aux_sym_recipe_line_repeat1 = 166,
  aux_sym_define_directive_repeat1 = 167,
  aux_sym_conditional_repeat1 = 168,
  aux_sym_arguments_repeat1 = 169,
  aux_sym_list_repeat1 = 170,
  aux_sym_paths_repeat1 = 171,
  aux_sym_concatenation_repeat1 = 172,
  aux_sym__shell_text_without_split_repeat1 = 173,
  aux_sym__shell_text_without_split_repeat2 = 174,
  aux_sym_text_repeat1 = 175,
  aux_sym_text_repeat2 = 176,
  alias_sym_pattern_list = 177,
  alias_sym_prerequisites = 178,
  alias_sym_raw_text = 179,
  alias_sym_shell_command = 180,
  alias_sym_targets = 181,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [aux_sym__thing_token1] = "_thing_token1",
  [anon_sym_COLON] = ":",
  [anon_sym_AMP_COLON] = "&:",
  [anon_sym_COLON_COLON] = "::",
  [aux_sym__ordinary_rule_token1] = "_ordinary_rule_token1",
  [anon_sym_PIPE] = "|",
  [anon_sym_SEMI] = ";",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_VPATH] = "VPATH",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_QMARK_EQ] = "\?=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DOTRECIPEPREFIX] = ".RECIPEPREFIX",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_define] = "define",
  [anon_sym_endef] = "endef",
  [anon_sym_include] = "include",
  [anon_sym_sinclude] = "sinclude",
  [anon_sym_DASHinclude] = "-include",
  [anon_sym_vpath] = "vpath",
  [anon_sym_export] = "export",
  [anon_sym_unexport] = "unexport",
  [anon_sym_override] = "override",
  [anon_sym_undefine] = "undefine",
  [anon_sym_private] = "private",
  [anon_sym_endif] = "endif",
  [anon_sym_else] = "else",
  [anon_sym_ifeq] = "ifeq",
  [anon_sym_ifneq] = "ifneq",
  [anon_sym_ifdef] = "ifdef",
  [anon_sym_ifndef] = "ifndef",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym_variable_reference_token1] = "word",
  [anon_sym_AT2] = "@",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT] = "<",
  [anon_sym_QMARK] = "\?",
  [anon_sym_CARET] = "^",
  [anon_sym_PLUS2] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_PERCENT2] = "%",
  [anon_sym_LT2] = "<",
  [anon_sym_QMARK2] = "\?",
  [anon_sym_CARET2] = "^",
  [anon_sym_SLASH2] = "/",
  [anon_sym_STAR2] = "*",
  [anon_sym_D] = "D",
  [anon_sym_F] = "F",
  [anon_sym_subst] = "subst",
  [anon_sym_patsubst] = "patsubst",
  [anon_sym_strip] = "strip",
  [anon_sym_findstring] = "findstring",
  [anon_sym_filter] = "filter",
  [anon_sym_filter_DASHout] = "filter-out",
  [anon_sym_sort] = "sort",
  [anon_sym_word] = "word",
  [anon_sym_words] = "words",
  [anon_sym_wordlist] = "wordlist",
  [anon_sym_firstword] = "firstword",
  [anon_sym_lastword] = "lastword",
  [anon_sym_dir] = "dir",
  [anon_sym_notdir] = "notdir",
  [anon_sym_suffix] = "suffix",
  [anon_sym_basename] = "basename",
  [anon_sym_addsuffix] = "addsuffix",
  [anon_sym_addprefix] = "addprefix",
  [anon_sym_join] = "join",
  [anon_sym_wildcard] = "wildcard",
  [anon_sym_realpath] = "realpath",
  [anon_sym_abspath] = "abspath",
  [anon_sym_error] = "error",
  [anon_sym_warning] = "warning",
  [anon_sym_info] = "info",
  [anon_sym_origin] = "origin",
  [anon_sym_flavor] = "flavor",
  [anon_sym_foreach] = "foreach",
  [anon_sym_if] = "if",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_call] = "call",
  [anon_sym_eval] = "eval",
  [anon_sym_file] = "file",
  [anon_sym_value] = "value",
  [anon_sym_shell] = "shell",
  [aux_sym_list_token1] = "\\",
  [anon_sym_COLON2] = ":",
  [anon_sym_SEMI2] = ";",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__string_token1] = "_string_token1",
  [anon_sym_RPAREN2] = ")",
  [anon_sym_TAB] = "\t",
  [sym__rawline] = "_rawline",
  [aux_sym__shell_text_without_split_token1] = "_shell_text_without_split_token1",
  [anon_sym_SLASH_SLASH] = "escape",
  [aux_sym_text_token1] = "text_token1",
  [sym_comment] = "comment",
  [sym_makefile] = "makefile",
  [sym__thing] = "_thing",
  [sym_rule] = "rule",
  [sym__ordinary_rule] = "_ordinary_rule",
  [sym__static_pattern_rule] = "_static_pattern_rule",
  [sym__normal_prerequisites] = "_normal_prerequisites",
  [sym_recipe] = "recipe",
  [sym__attached_recipe_line] = "_attached_recipe_line",
  [sym__prefixed_recipe_line] = "_prefixed_recipe_line",
  [sym_recipe_line] = "recipe_line",
  [sym__variable_definition] = "_variable_definition",
  [sym_VPATH_assignment] = "VPATH_assignment",
  [sym_RECIPEPREFIX_assignment] = "RECIPEPREFIX_assignment",
  [sym_variable_assignment] = "variable_assignment",
  [sym_shell_assignment] = "shell_assignment",
  [sym_define_directive] = "define_directive",
  [sym__directive] = "_directive",
  [sym_include_directive] = "include_directive",
  [sym_vpath_directive] = "vpath_directive",
  [sym_export_directive] = "export_directive",
  [sym_unexport_directive] = "unexport_directive",
  [sym_override_directive] = "override_directive",
  [sym_undefine_directive] = "undefine_directive",
  [sym_private_directive] = "private_directive",
  [sym_conditional] = "conditional",
  [sym_elsif_directive] = "elsif_directive",
  [sym_else_directive] = "else_directive",
  [sym__conditional_directives] = "_conditional_directives",
  [aux_sym__conditional_consequence] = "_conditional_consequence",
  [sym_ifeq_directive] = "ifeq_directive",
  [sym_ifneq_directive] = "ifneq_directive",
  [sym_ifdef_directive] = "ifdef_directive",
  [sym_ifndef_directive] = "ifndef_directive",
  [sym__conditional_args_cmp] = "_conditional_args_cmp",
  [sym__variable] = "_variable",
  [sym_variable_reference] = "variable_reference",
  [sym_substitution_reference] = "substitution_reference",
  [sym_automatic_variable] = "automatic_variable",
  [sym__function] = "_function",
  [sym_function_call] = "function_call",
  [sym_arguments] = "arguments",
  [sym_shell_function] = "shell_function",
  [sym_list] = "list",
  [sym_paths] = "paths",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [aux_sym__string] = "_string",
  [sym_archive] = "archive",
  [sym__recipeprefix] = "_recipeprefix",
  [sym__shell_text_without_split] = "_shell_text_without_split",
  [sym_shell_text_with_split] = "shell_text",
  [sym__shell_command] = "_shell_command",
  [sym_text] = "text",
  [aux_sym_makefile_repeat1] = "makefile_repeat1",
  [aux_sym_recipe_repeat1] = "recipe_repeat1",
  [aux_sym_recipe_line_repeat1] = "recipe_line_repeat1",
  [aux_sym_define_directive_repeat1] = "define_directive_repeat1",
  [aux_sym_conditional_repeat1] = "conditional_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_paths_repeat1] = "paths_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym__shell_text_without_split_repeat1] = "_shell_text_without_split_repeat1",
  [aux_sym__shell_text_without_split_repeat2] = "_shell_text_without_split_repeat2",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_text_repeat2] = "text_repeat2",
  [alias_sym_pattern_list] = "pattern_list",
  [alias_sym_prerequisites] = "prerequisites",
  [alias_sym_raw_text] = "raw_text",
  [alias_sym_shell_command] = "shell_command",
  [alias_sym_targets] = "targets",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_word] = sym_word,
  [aux_sym__thing_token1] = aux_sym__thing_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AMP_COLON] = anon_sym_AMP_COLON,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [aux_sym__ordinary_rule_token1] = aux_sym__ordinary_rule_token1,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_VPATH] = anon_sym_VPATH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_QMARK_EQ] = anon_sym_QMARK_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DOTRECIPEPREFIX] = anon_sym_DOTRECIPEPREFIX,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_endef] = anon_sym_endef,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_sinclude] = anon_sym_sinclude,
  [anon_sym_DASHinclude] = anon_sym_DASHinclude,
  [anon_sym_vpath] = anon_sym_vpath,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_unexport] = anon_sym_unexport,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_undefine] = anon_sym_undefine,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_ifeq] = anon_sym_ifeq,
  [anon_sym_ifneq] = anon_sym_ifneq,
  [anon_sym_ifdef] = anon_sym_ifdef,
  [anon_sym_ifndef] = anon_sym_ifndef,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym_variable_reference_token1] = sym_word,
  [anon_sym_AT2] = anon_sym_AT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PLUS2] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PERCENT2] = anon_sym_PERCENT,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_QMARK2] = anon_sym_QMARK,
  [anon_sym_CARET2] = anon_sym_CARET,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [anon_sym_STAR2] = anon_sym_STAR,
  [anon_sym_D] = anon_sym_D,
  [anon_sym_F] = anon_sym_F,
  [anon_sym_subst] = anon_sym_subst,
  [anon_sym_patsubst] = anon_sym_patsubst,
  [anon_sym_strip] = anon_sym_strip,
  [anon_sym_findstring] = anon_sym_findstring,
  [anon_sym_filter] = anon_sym_filter,
  [anon_sym_filter_DASHout] = anon_sym_filter_DASHout,
  [anon_sym_sort] = anon_sym_sort,
  [anon_sym_word] = anon_sym_word,
  [anon_sym_words] = anon_sym_words,
  [anon_sym_wordlist] = anon_sym_wordlist,
  [anon_sym_firstword] = anon_sym_firstword,
  [anon_sym_lastword] = anon_sym_lastword,
  [anon_sym_dir] = anon_sym_dir,
  [anon_sym_notdir] = anon_sym_notdir,
  [anon_sym_suffix] = anon_sym_suffix,
  [anon_sym_basename] = anon_sym_basename,
  [anon_sym_addsuffix] = anon_sym_addsuffix,
  [anon_sym_addprefix] = anon_sym_addprefix,
  [anon_sym_join] = anon_sym_join,
  [anon_sym_wildcard] = anon_sym_wildcard,
  [anon_sym_realpath] = anon_sym_realpath,
  [anon_sym_abspath] = anon_sym_abspath,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_warning] = anon_sym_warning,
  [anon_sym_info] = anon_sym_info,
  [anon_sym_origin] = anon_sym_origin,
  [anon_sym_flavor] = anon_sym_flavor,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_call] = anon_sym_call,
  [anon_sym_eval] = anon_sym_eval,
  [anon_sym_file] = anon_sym_file,
  [anon_sym_value] = anon_sym_value,
  [anon_sym_shell] = anon_sym_shell,
  [aux_sym_list_token1] = aux_sym_list_token1,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_SEMI2] = anon_sym_SEMI,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__string_token1] = aux_sym__string_token1,
  [anon_sym_RPAREN2] = anon_sym_RPAREN,
  [anon_sym_TAB] = anon_sym_TAB,
  [sym__rawline] = sym__rawline,
  [aux_sym__shell_text_without_split_token1] = aux_sym__shell_text_without_split_token1,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_text_token1] = aux_sym_text_token1,
  [sym_comment] = sym_comment,
  [sym_makefile] = sym_makefile,
  [sym__thing] = sym__thing,
  [sym_rule] = sym_rule,
  [sym__ordinary_rule] = sym__ordinary_rule,
  [sym__static_pattern_rule] = sym__static_pattern_rule,
  [sym__normal_prerequisites] = sym__normal_prerequisites,
  [sym_recipe] = sym_recipe,
  [sym__attached_recipe_line] = sym__attached_recipe_line,
  [sym__prefixed_recipe_line] = sym__prefixed_recipe_line,
  [sym_recipe_line] = sym_recipe_line,
  [sym__variable_definition] = sym__variable_definition,
  [sym_VPATH_assignment] = sym_VPATH_assignment,
  [sym_RECIPEPREFIX_assignment] = sym_RECIPEPREFIX_assignment,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_shell_assignment] = sym_shell_assignment,
  [sym_define_directive] = sym_define_directive,
  [sym__directive] = sym__directive,
  [sym_include_directive] = sym_include_directive,
  [sym_vpath_directive] = sym_vpath_directive,
  [sym_export_directive] = sym_export_directive,
  [sym_unexport_directive] = sym_unexport_directive,
  [sym_override_directive] = sym_override_directive,
  [sym_undefine_directive] = sym_undefine_directive,
  [sym_private_directive] = sym_private_directive,
  [sym_conditional] = sym_conditional,
  [sym_elsif_directive] = sym_elsif_directive,
  [sym_else_directive] = sym_else_directive,
  [sym__conditional_directives] = sym__conditional_directives,
  [aux_sym__conditional_consequence] = aux_sym__conditional_consequence,
  [sym_ifeq_directive] = sym_ifeq_directive,
  [sym_ifneq_directive] = sym_ifneq_directive,
  [sym_ifdef_directive] = sym_ifdef_directive,
  [sym_ifndef_directive] = sym_ifndef_directive,
  [sym__conditional_args_cmp] = sym__conditional_args_cmp,
  [sym__variable] = sym__variable,
  [sym_variable_reference] = sym_variable_reference,
  [sym_substitution_reference] = sym_substitution_reference,
  [sym_automatic_variable] = sym_automatic_variable,
  [sym__function] = sym__function,
  [sym_function_call] = sym_function_call,
  [sym_arguments] = sym_arguments,
  [sym_shell_function] = sym_shell_function,
  [sym_list] = sym_list,
  [sym_paths] = sym_paths,
  [sym_concatenation] = sym_concatenation,
  [sym_string] = sym_string,
  [aux_sym__string] = aux_sym__string,
  [sym_archive] = sym_archive,
  [sym__recipeprefix] = sym__recipeprefix,
  [sym__shell_text_without_split] = sym__shell_text_without_split,
  [sym_shell_text_with_split] = sym_shell_text_with_split,
  [sym__shell_command] = sym__shell_command,
  [sym_text] = sym_text,
  [aux_sym_makefile_repeat1] = aux_sym_makefile_repeat1,
  [aux_sym_recipe_repeat1] = aux_sym_recipe_repeat1,
  [aux_sym_recipe_line_repeat1] = aux_sym_recipe_line_repeat1,
  [aux_sym_define_directive_repeat1] = aux_sym_define_directive_repeat1,
  [aux_sym_conditional_repeat1] = aux_sym_conditional_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_paths_repeat1] = aux_sym_paths_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym__shell_text_without_split_repeat1] = aux_sym__shell_text_without_split_repeat1,
  [aux_sym__shell_text_without_split_repeat2] = aux_sym__shell_text_without_split_repeat2,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_text_repeat2] = aux_sym_text_repeat2,
  [alias_sym_pattern_list] = alias_sym_pattern_list,
  [alias_sym_prerequisites] = alias_sym_prerequisites,
  [alias_sym_raw_text] = alias_sym_raw_text,
  [alias_sym_shell_command] = alias_sym_shell_command,
  [alias_sym_targets] = alias_sym_targets,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__thing_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ordinary_rule_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VPATH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTRECIPEPREFIX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vpath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unexport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_undefine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ifeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ifneq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ifdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ifndef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_reference_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_D] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_F] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_subst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_patsubst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_findstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_word] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_words] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_wordlist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_firstword] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lastword] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_notdir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_suffix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_basename] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addsuffix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addprefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_join] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_wildcard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_realpath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abspath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_warning] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_info] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_origin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_flavor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eval] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_file] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_value] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shell] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_list_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAB] = {
    .visible = true,
    .named = false,
  },
  [sym__rawline] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__shell_text_without_split_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_text_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_makefile] = {
    .visible = true,
    .named = true,
  },
  [sym__thing] = {
    .visible = false,
    .named = true,
  },
  [sym_rule] = {
    .visible = true,
    .named = true,
  },
  [sym__ordinary_rule] = {
    .visible = false,
    .named = true,
  },
  [sym__static_pattern_rule] = {
    .visible = false,
    .named = true,
  },
  [sym__normal_prerequisites] = {
    .visible = false,
    .named = true,
  },
  [sym_recipe] = {
    .visible = true,
    .named = true,
  },
  [sym__attached_recipe_line] = {
    .visible = false,
    .named = true,
  },
  [sym__prefixed_recipe_line] = {
    .visible = false,
    .named = true,
  },
  [sym_recipe_line] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_VPATH_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_RECIPEPREFIX_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_define_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym_include_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_vpath_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_export_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_unexport_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_override_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_undefine_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_private_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_elsif_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_else_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__conditional_directives] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__conditional_consequence] = {
    .visible = false,
    .named = false,
  },
  [sym_ifeq_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_ifneq_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_ifdef_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_ifndef_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__conditional_args_cmp] = {
    .visible = false,
    .named = true,
  },
  [sym__variable] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_automatic_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__function] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_function] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paths] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__string] = {
    .visible = false,
    .named = false,
  },
  [sym_archive] = {
    .visible = true,
    .named = true,
  },
  [sym__recipeprefix] = {
    .visible = false,
    .named = true,
  },
  [sym__shell_text_without_split] = {
    .visible = false,
    .named = true,
  },
  [sym_shell_text_with_split] = {
    .visible = true,
    .named = true,
  },
  [sym__shell_command] = {
    .visible = false,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_makefile_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_define_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conditional_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paths_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_text_without_split_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_text_without_split_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_prerequisites] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shell_command] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_targets] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_archive = 1,
  field_arg0 = 2,
  field_arg1 = 3,
  field_argument = 4,
  field_condition = 5,
  field_consequence = 6,
  field_directories = 7,
  field_filenames = 8,
  field_function = 9,
  field_members = 10,
  field_name = 11,
  field_normal = 12,
  field_operator = 13,
  field_order_only = 14,
  field_pattern = 15,
  field_prerequisite = 16,
  field_replacement = 17,
  field_string = 18,
  field_target = 19,
  field_target_or_pattern = 20,
  field_text = 21,
  field_value = 22,
  field_variable = 23,
  field_variables = 24,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_archive] = "archive",
  [field_arg0] = "arg0",
  [field_arg1] = "arg1",
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_directories] = "directories",
  [field_filenames] = "filenames",
  [field_function] = "function",
  [field_members] = "members",
  [field_name] = "name",
  [field_normal] = "normal",
  [field_operator] = "operator",
  [field_order_only] = "order_only",
  [field_pattern] = "pattern",
  [field_prerequisite] = "prerequisite",
  [field_replacement] = "replacement",
  [field_string] = "string",
  [field_target] = "target",
  [field_target_or_pattern] = "target_or_pattern",
  [field_text] = "text",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_variables] = "variables",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 2},
  [10] = {.index = 12, .length = 2},
  [11] = {.index = 14, .length = 3},
  [12] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 1},
  [15] = {.index = 20, .length = 1},
  [18] = {.index = 21, .length = 1},
  [19] = {.index = 22, .length = 3},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 27, .length = 1},
  [22] = {.index = 28, .length = 2},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 32, .length = 1},
  [25] = {.index = 33, .length = 2},
  [26] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 1},
  [30] = {.index = 38, .length = 3},
  [32] = {.index = 41, .length = 1},
  [33] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 1},
  [35] = {.index = 44, .length = 1},
  [36] = {.index = 45, .length = 2},
  [37] = {.index = 47, .length = 3},
  [40] = {.index = 50, .length = 1},
  [41] = {.index = 51, .length = 1},
  [42] = {.index = 52, .length = 3},
  [43] = {.index = 55, .length = 1},
  [44] = {.index = 56, .length = 2},
  [45] = {.index = 58, .length = 2},
  [46] = {.index = 60, .length = 2},
  [47] = {.index = 62, .length = 1},
  [48] = {.index = 63, .length = 2},
  [49] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 1},
  [53] = {.index = 69, .length = 3},
  [54] = {.index = 72, .length = 1},
  [55] = {.index = 73, .length = 3},
  [56] = {.index = 76, .length = 4},
  [57] = {.index = 80, .length = 2},
  [58] = {.index = 82, .length = 2},
  [59] = {.index = 84, .length = 2},
  [60] = {.index = 86, .length = 2},
  [61] = {.index = 88, .length = 3},
  [63] = {.index = 91, .length = 3},
  [64] = {.index = 94, .length = 4},
  [65] = {.index = 98, .length = 2},
  [66] = {.index = 100, .length = 2},
  [67] = {.index = 102, .length = 4},
  [68] = {.index = 106, .length = 4},
  [69] = {.index = 110, .length = 2},
  [70] = {.index = 112, .length = 2},
  [71] = {.index = 114, .length = 3},
  [72] = {.index = 117, .length = 3},
  [73] = {.index = 120, .length = 3},
  [74] = {.index = 123, .length = 4},
  [75] = {.index = 127, .length = 4},
  [76] = {.index = 131, .length = 2},
  [77] = {.index = 133, .length = 4},
  [78] = {.index = 137, .length = 3},
  [79] = {.index = 140, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_normal, 0, .inherited = true},
    {field_order_only, 0, .inherited = true},
  [2] =
    {field_prerequisite, 0, .inherited = true},
    {field_target, 0, .inherited = true},
  [4] =
    {field_string, 0},
    {field_string, 1},
  [6] =
    {field_filenames, 1},
  [7] =
    {field_pattern, 1},
  [8] =
    {field_variables, 1},
  [9] =
    {field_variable, 1},
  [10] =
    {field_arg0, 0},
    {field_arg1, 1},
  [12] =
    {field_arg0, 1, .inherited = true},
    {field_arg1, 1, .inherited = true},
  [14] =
    {field_string, 0},
    {field_string, 1},
    {field_string, 2},
  [17] =
    {field_name, 0},
    {field_operator, 1},
  [19] =
    {field_condition, 0},
  [20] =
    {field_condition, 1},
  [21] =
    {field_normal, 0},
  [22] =
    {field_name, 0},
    {field_operator, 1},
    {field_value, 2},
  [25] =
    {field_directories, 2},
    {field_pattern, 1},
  [27] =
    {field_argument, 0},
  [28] =
    {field_name, 0},
    {field_operator, 2},
  [30] =
    {field_archive, 0},
    {field_members, 2},
  [32] =
    {field_consequence, 2},
  [33] =
    {field_condition, 1},
    {field_consequence, 2},
  [35] =
    {field_condition, 0},
    {field_consequence, 1},
  [37] =
    {field_normal, 2, .inherited = true},
  [38] =
    {field_name, 0},
    {field_operator, 2},
    {field_value, 3},
  [41] =
    {field_name, 1},
  [42] =
    {field_arg1, 2},
  [43] =
    {field_arg0, 1},
  [44] =
    {field_function, 2},
  [45] =
    {field_argument, 0},
    {field_argument, 1, .inherited = true},
  [47] =
    {field_name, 0},
    {field_operator, 1},
    {field_value, 3},
  [50] =
    {field_normal, 3, .inherited = true},
  [51] =
    {field_order_only, 3},
  [52] =
    {field_name, 2},
    {field_operator, 3},
    {field_target_or_pattern, 0},
  [55] =
    {field_target, 2},
  [56] =
    {field_name, 1},
    {field_value, 3},
  [58] =
    {field_name, 1},
    {field_operator, 2},
  [60] =
    {field_arg0, 1},
    {field_arg1, 3},
  [62] =
    {field_argument, 1},
  [63] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [65] =
    {field_name, 0},
    {field_operator, 2},
    {field_value, 4},
  [68] =
    {field_order_only, 4},
  [69] =
    {field_name, 3},
    {field_operator, 4},
    {field_target_or_pattern, 0},
  [72] =
    {field_target, 3},
  [73] =
    {field_name, 2},
    {field_operator, 4},
    {field_target_or_pattern, 0},
  [76] =
    {field_name, 2},
    {field_operator, 3},
    {field_target_or_pattern, 0},
    {field_value, 4},
  [80] =
    {field_normal, 2, .inherited = true},
    {field_order_only, 4},
  [82] =
    {field_prerequisite, 4},
    {field_target, 2},
  [84] =
    {field_name, 1},
    {field_value, 4},
  [86] =
    {field_name, 1},
    {field_operator, 3},
  [88] =
    {field_name, 1},
    {field_operator, 2},
    {field_value, 4},
  [91] =
    {field_name, 3},
    {field_operator, 5},
    {field_target_or_pattern, 0},
  [94] =
    {field_name, 3},
    {field_operator, 4},
    {field_target_or_pattern, 0},
    {field_value, 5},
  [98] =
    {field_normal, 3, .inherited = true},
    {field_order_only, 5},
  [100] =
    {field_prerequisite, 5},
    {field_target, 3},
  [102] =
    {field_name, 2},
    {field_operator, 4},
    {field_target_or_pattern, 0},
    {field_value, 5},
  [106] =
    {field_name, 2},
    {field_operator, 3},
    {field_target_or_pattern, 0},
    {field_value, 5},
  [110] =
    {field_prerequisite, 5},
    {field_target, 2},
  [112] =
    {field_name, 1},
    {field_value, 5},
  [114] =
    {field_name, 1},
    {field_operator, 3},
    {field_value, 5},
  [117] =
    {field_name, 1},
    {field_operator, 2},
    {field_value, 5},
  [120] =
    {field_pattern, 4},
    {field_replacement, 6},
    {field_text, 2},
  [123] =
    {field_name, 3},
    {field_operator, 5},
    {field_target_or_pattern, 0},
    {field_value, 6},
  [127] =
    {field_name, 3},
    {field_operator, 4},
    {field_target_or_pattern, 0},
    {field_value, 6},
  [131] =
    {field_prerequisite, 6},
    {field_target, 3},
  [133] =
    {field_name, 2},
    {field_operator, 4},
    {field_target_or_pattern, 0},
    {field_value, 6},
  [137] =
    {field_name, 1},
    {field_operator, 3},
    {field_value, 6},
  [140] =
    {field_name, 3},
    {field_operator, 5},
    {field_target_or_pattern, 0},
    {field_value, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [0] = anon_sym_SLASH_SLASH,
  },
  [13] = {
    [0] = alias_sym_shell_command,
  },
  [16] = {
    [0] = sym_shell_text_with_split,
  },
  [17] = {
    [0] = alias_sym_targets,
  },
  [18] = {
    [0] = alias_sym_prerequisites,
  },
  [27] = {
    [1] = sym_shell_text_with_split,
  },
  [28] = {
    [0] = sym_shell_text_with_split,
    [1] = sym_shell_text_with_split,
  },
  [29] = {
    [0] = alias_sym_targets,
  },
  [31] = {
    [1] = anon_sym_SLASH_SLASH,
  },
  [38] = {
    [1] = sym_shell_text_with_split,
    [2] = sym_shell_text_with_split,
  },
  [39] = {
    [0] = sym_shell_text_with_split,
    [2] = sym_shell_text_with_split,
  },
  [40] = {
    [0] = alias_sym_targets,
  },
  [41] = {
    [0] = alias_sym_targets,
    [3] = alias_sym_prerequisites,
  },
  [43] = {
    [0] = alias_sym_targets,
    [2] = alias_sym_pattern_list,
  },
  [44] = {
    [3] = alias_sym_raw_text,
  },
  [50] = {
    [1] = sym_shell_text_with_split,
    [3] = sym_shell_text_with_split,
  },
  [51] = {
    [0] = sym_shell_text_with_split,
    [3] = sym_shell_text_with_split,
  },
  [52] = {
    [0] = alias_sym_targets,
    [4] = alias_sym_prerequisites,
  },
  [54] = {
    [0] = alias_sym_targets,
    [3] = alias_sym_pattern_list,
  },
  [57] = {
    [0] = alias_sym_targets,
    [4] = alias_sym_prerequisites,
  },
  [58] = {
    [0] = alias_sym_targets,
    [2] = alias_sym_pattern_list,
    [4] = alias_sym_pattern_list,
  },
  [59] = {
    [4] = alias_sym_raw_text,
  },
  [61] = {
    [4] = alias_sym_raw_text,
  },
  [62] = {
    [1] = sym_shell_text_with_split,
    [4] = sym_shell_text_with_split,
  },
  [65] = {
    [0] = alias_sym_targets,
    [5] = alias_sym_prerequisites,
  },
  [66] = {
    [0] = alias_sym_targets,
    [3] = alias_sym_pattern_list,
    [5] = alias_sym_pattern_list,
  },
  [69] = {
    [0] = alias_sym_targets,
    [2] = alias_sym_pattern_list,
    [5] = alias_sym_pattern_list,
  },
  [70] = {
    [5] = alias_sym_raw_text,
  },
  [71] = {
    [5] = alias_sym_raw_text,
  },
  [72] = {
    [5] = alias_sym_raw_text,
  },
  [76] = {
    [0] = alias_sym_targets,
    [3] = alias_sym_pattern_list,
    [6] = alias_sym_pattern_list,
  },
  [78] = {
    [6] = alias_sym_raw_text,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_list, 4,
    sym_list,
    alias_sym_pattern_list,
    alias_sym_prerequisites,
    alias_sym_targets,
  sym__shell_text_without_split, 2,
    sym__shell_text_without_split,
    sym_shell_text_with_split,
  sym_text, 2,
    sym_text,
    alias_sym_shell_command,
  aux_sym_define_directive_repeat1, 2,
    aux_sym_define_directive_repeat1,
    alias_sym_raw_text,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 2,
  [6] = 3,
  [7] = 3,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 13,
  [16] = 13,
  [17] = 13,
  [18] = 13,
  [19] = 13,
  [20] = 13,
  [21] = 13,
  [22] = 13,
  [23] = 13,
  [24] = 13,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 31,
  [52] = 38,
  [53] = 39,
  [54] = 40,
  [55] = 41,
  [56] = 42,
  [57] = 43,
  [58] = 44,
  [59] = 45,
  [60] = 46,
  [61] = 47,
  [62] = 48,
  [63] = 49,
  [64] = 50,
  [65] = 32,
  [66] = 34,
  [67] = 35,
  [68] = 36,
  [69] = 27,
  [70] = 37,
  [71] = 28,
  [72] = 29,
  [73] = 30,
  [74] = 33,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 76,
  [79] = 75,
  [80] = 77,
  [81] = 81,
  [82] = 81,
  [83] = 81,
  [84] = 81,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 86,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 85,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 85,
  [184] = 92,
  [185] = 163,
  [186] = 139,
  [187] = 187,
  [188] = 188,
  [189] = 188,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 190,
  [195] = 195,
  [196] = 188,
  [197] = 192,
  [198] = 198,
  [199] = 198,
  [200] = 93,
  [201] = 108,
  [202] = 117,
  [203] = 118,
  [204] = 130,
  [205] = 131,
  [206] = 142,
  [207] = 191,
  [208] = 193,
  [209] = 195,
  [210] = 210,
  [211] = 188,
  [212] = 149,
  [213] = 188,
  [214] = 188,
  [215] = 188,
  [216] = 188,
  [217] = 188,
  [218] = 188,
  [219] = 188,
  [220] = 103,
  [221] = 177,
  [222] = 117,
  [223] = 178,
  [224] = 112,
  [225] = 118,
  [226] = 179,
  [227] = 180,
  [228] = 181,
  [229] = 182,
  [230] = 137,
  [231] = 138,
  [232] = 113,
  [233] = 159,
  [234] = 160,
  [235] = 187,
  [236] = 161,
  [237] = 140,
  [238] = 238,
  [239] = 141,
  [240] = 142,
  [241] = 134,
  [242] = 108,
  [243] = 238,
  [244] = 143,
  [245] = 245,
  [246] = 119,
  [247] = 144,
  [248] = 135,
  [249] = 145,
  [250] = 146,
  [251] = 147,
  [252] = 162,
  [253] = 253,
  [254] = 148,
  [255] = 120,
  [256] = 256,
  [257] = 102,
  [258] = 95,
  [259] = 164,
  [260] = 150,
  [261] = 94,
  [262] = 253,
  [263] = 151,
  [264] = 107,
  [265] = 152,
  [266] = 133,
  [267] = 256,
  [268] = 99,
  [269] = 153,
  [270] = 154,
  [271] = 155,
  [272] = 157,
  [273] = 166,
  [274] = 167,
  [275] = 168,
  [276] = 114,
  [277] = 87,
  [278] = 192,
  [279] = 169,
  [280] = 115,
  [281] = 111,
  [282] = 245,
  [283] = 283,
  [284] = 121,
  [285] = 122,
  [286] = 170,
  [287] = 123,
  [288] = 124,
  [289] = 116,
  [290] = 156,
  [291] = 96,
  [292] = 292,
  [293] = 125,
  [294] = 126,
  [295] = 158,
  [296] = 110,
  [297] = 97,
  [298] = 127,
  [299] = 136,
  [300] = 128,
  [301] = 129,
  [302] = 101,
  [303] = 130,
  [304] = 100,
  [305] = 131,
  [306] = 171,
  [307] = 292,
  [308] = 172,
  [309] = 283,
  [310] = 173,
  [311] = 104,
  [312] = 174,
  [313] = 132,
  [314] = 175,
  [315] = 105,
  [316] = 176,
  [317] = 98,
  [318] = 106,
  [319] = 319,
  [320] = 256,
  [321] = 321,
  [322] = 322,
  [323] = 238,
  [324] = 319,
  [325] = 321,
  [326] = 326,
  [327] = 326,
  [328] = 292,
  [329] = 292,
  [330] = 210,
  [331] = 331,
  [332] = 192,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 335,
  [337] = 333,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 338,
  [343] = 341,
  [344] = 338,
  [345] = 341,
  [346] = 338,
  [347] = 341,
  [348] = 338,
  [349] = 341,
  [350] = 338,
  [351] = 341,
  [352] = 338,
  [353] = 341,
  [354] = 338,
  [355] = 341,
  [356] = 338,
  [357] = 341,
  [358] = 238,
  [359] = 256,
  [360] = 360,
  [361] = 340,
  [362] = 338,
  [363] = 338,
  [364] = 341,
  [365] = 341,
  [366] = 339,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 367,
  [372] = 369,
  [373] = 373,
  [374] = 374,
  [375] = 369,
  [376] = 370,
  [377] = 367,
  [378] = 378,
  [379] = 373,
  [380] = 380,
  [381] = 369,
  [382] = 370,
  [383] = 383,
  [384] = 384,
  [385] = 373,
  [386] = 370,
  [387] = 369,
  [388] = 370,
  [389] = 367,
  [390] = 367,
  [391] = 373,
  [392] = 392,
  [393] = 369,
  [394] = 370,
  [395] = 367,
  [396] = 396,
  [397] = 373,
  [398] = 373,
  [399] = 369,
  [400] = 370,
  [401] = 367,
  [402] = 367,
  [403] = 373,
  [404] = 369,
  [405] = 369,
  [406] = 370,
  [407] = 373,
  [408] = 370,
  [409] = 409,
  [410] = 410,
  [411] = 367,
  [412] = 383,
  [413] = 413,
  [414] = 396,
  [415] = 373,
  [416] = 370,
  [417] = 369,
  [418] = 373,
  [419] = 370,
  [420] = 367,
  [421] = 369,
  [422] = 373,
  [423] = 392,
  [424] = 368,
  [425] = 392,
  [426] = 368,
  [427] = 392,
  [428] = 368,
  [429] = 392,
  [430] = 368,
  [431] = 392,
  [432] = 368,
  [433] = 392,
  [434] = 368,
  [435] = 392,
  [436] = 368,
  [437] = 392,
  [438] = 368,
  [439] = 392,
  [440] = 368,
  [441] = 392,
  [442] = 368,
  [443] = 367,
  [444] = 444,
  [445] = 445,
  [446] = 445,
  [447] = 447,
  [448] = 448,
  [449] = 447,
  [450] = 445,
  [451] = 445,
  [452] = 447,
  [453] = 453,
  [454] = 445,
  [455] = 455,
  [456] = 455,
  [457] = 447,
  [458] = 458,
  [459] = 445,
  [460] = 460,
  [461] = 461,
  [462] = 460,
  [463] = 447,
  [464] = 464,
  [465] = 445,
  [466] = 466,
  [467] = 467,
  [468] = 453,
  [469] = 469,
  [470] = 470,
  [471] = 447,
  [472] = 472,
  [473] = 445,
  [474] = 474,
  [475] = 474,
  [476] = 444,
  [477] = 477,
  [478] = 474,
  [479] = 447,
  [480] = 444,
  [481] = 481,
  [482] = 474,
  [483] = 445,
  [484] = 444,
  [485] = 447,
  [486] = 474,
  [487] = 487,
  [488] = 444,
  [489] = 445,
  [490] = 474,
  [491] = 491,
  [492] = 474,
  [493] = 447,
  [494] = 444,
  [495] = 474,
  [496] = 445,
  [497] = 444,
  [498] = 444,
  [499] = 474,
  [500] = 444,
  [501] = 474,
  [502] = 502,
  [503] = 444,
  [504] = 447,
  [505] = 474,
  [506] = 447,
  [507] = 444,
  [508] = 508,
  [509] = 481,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 472,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 481,
  [521] = 521,
  [522] = 522,
  [523] = 518,
  [524] = 517,
  [525] = 470,
  [526] = 522,
  [527] = 527,
  [528] = 514,
  [529] = 448,
  [530] = 530,
  [531] = 519,
  [532] = 448,
  [533] = 515,
  [534] = 469,
  [535] = 535,
  [536] = 527,
  [537] = 522,
  [538] = 538,
  [539] = 539,
  [540] = 487,
  [541] = 541,
  [542] = 542,
  [543] = 539,
  [544] = 487,
  [545] = 545,
  [546] = 511,
  [547] = 512,
  [548] = 522,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 549,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 557,
  [559] = 552,
  [560] = 549,
  [561] = 552,
  [562] = 549,
  [563] = 552,
  [564] = 549,
  [565] = 552,
  [566] = 549,
  [567] = 552,
  [568] = 549,
  [569] = 552,
  [570] = 549,
  [571] = 552,
  [572] = 549,
  [573] = 556,
  [574] = 549,
  [575] = 552,
  [576] = 549,
  [577] = 552,
  [578] = 551,
  [579] = 556,
  [580] = 557,
  [581] = 556,
  [582] = 557,
  [583] = 556,
  [584] = 557,
  [585] = 556,
  [586] = 557,
  [587] = 556,
  [588] = 557,
  [589] = 556,
  [590] = 557,
  [591] = 556,
  [592] = 557,
  [593] = 556,
  [594] = 557,
  [595] = 556,
  [596] = 557,
  [597] = 552,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 605,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 598,
  [615] = 608,
  [616] = 598,
  [617] = 608,
  [618] = 604,
  [619] = 608,
  [620] = 598,
  [621] = 608,
  [622] = 598,
  [623] = 608,
  [624] = 599,
  [625] = 598,
  [626] = 608,
  [627] = 598,
  [628] = 608,
  [629] = 598,
  [630] = 608,
  [631] = 631,
  [632] = 598,
  [633] = 598,
  [634] = 608,
  [635] = 635,
  [636] = 608,
  [637] = 637,
  [638] = 602,
  [639] = 607,
  [640] = 601,
  [641] = 609,
  [642] = 603,
  [643] = 643,
  [644] = 644,
  [645] = 598,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 648,
  [655] = 655,
  [656] = 656,
  [657] = 646,
  [658] = 631,
  [659] = 659,
  [660] = 660,
  [661] = 647,
  [662] = 652,
  [663] = 653,
  [664] = 664,
  [665] = 652,
  [666] = 653,
  [667] = 651,
  [668] = 668,
  [669] = 669,
  [670] = 652,
  [671] = 653,
  [672] = 672,
  [673] = 673,
  [674] = 652,
  [675] = 653,
  [676] = 676,
  [677] = 652,
  [678] = 653,
  [679] = 679,
  [680] = 600,
  [681] = 681,
  [682] = 673,
  [683] = 652,
  [684] = 637,
  [685] = 652,
  [686] = 653,
  [687] = 687,
  [688] = 643,
  [689] = 652,
  [690] = 653,
  [691] = 644,
  [692] = 611,
  [693] = 676,
  [694] = 652,
  [695] = 653,
  [696] = 696,
  [697] = 697,
  [698] = 635,
  [699] = 610,
  [700] = 612,
  [701] = 613,
  [702] = 600,
  [703] = 703,
  [704] = 704,
  [705] = 637,
  [706] = 706,
  [707] = 681,
  [708] = 652,
  [709] = 653,
  [710] = 668,
  [711] = 611,
  [712] = 612,
  [713] = 635,
  [714] = 653,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 656,
  [719] = 719,
  [720] = 650,
  [721] = 715,
  [722] = 722,
  [723] = 723,
  [724] = 722,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 715,
  [729] = 717,
  [730] = 730,
  [731] = 717,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 650,
  [736] = 655,
  [737] = 697,
  [738] = 738,
  [739] = 697,
  [740] = 740,
  [741] = 656,
  [742] = 722,
  [743] = 725,
  [744] = 719,
  [745] = 717,
  [746] = 706,
  [747] = 722,
  [748] = 725,
  [749] = 749,
  [750] = 715,
  [751] = 696,
  [752] = 733,
  [753] = 740,
  [754] = 725,
  [755] = 749,
  [756] = 664,
  [757] = 757,
  [758] = 758,
  [759] = 758,
  [760] = 649,
  [761] = 761,
  [762] = 762,
  [763] = 762,
  [764] = 758,
  [765] = 765,
  [766] = 726,
  [767] = 723,
  [768] = 727,
  [769] = 769,
  [770] = 758,
  [771] = 749,
  [772] = 765,
  [773] = 726,
  [774] = 734,
  [775] = 679,
  [776] = 769,
  [777] = 723,
  [778] = 778,
  [779] = 779,
  [780] = 761,
  [781] = 781,
  [782] = 738,
  [783] = 732,
  [784] = 781,
  [785] = 758,
  [786] = 727,
  [787] = 730,
  [788] = 758,
  [789] = 758,
  [790] = 758,
  [791] = 791,
  [792] = 758,
  [793] = 791,
  [794] = 778,
  [795] = 757,
  [796] = 758,
  [797] = 758,
  [798] = 672,
  [799] = 779,
  [800] = 758,
  [801] = 762,
  [802] = 757,
  [803] = 761,
  [804] = 804,
  [805] = 805,
  [806] = 778,
  [807] = 779,
  [808] = 804,
  [809] = 791,
  [810] = 672,
  [811] = 679,
  [812] = 812,
  [813] = 765,
  [814] = 769,
  [815] = 781,
  [816] = 812,
  [817] = 812,
  [818] = 664,
  [819] = 649,
  [820] = 820,
  [821] = 649,
  [822] = 757,
  [823] = 664,
  [824] = 781,
  [825] = 769,
  [826] = 791,
  [827] = 778,
  [828] = 761,
  [829] = 765,
  [830] = 672,
  [831] = 779,
  [832] = 762,
  [833] = 679,
  [834] = 834,
  [835] = 835,
  [836] = 834,
  [837] = 835,
  [838] = 838,
  [839] = 838,
  [840] = 840,
  [841] = 840,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 844,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 762,
  [853] = 765,
  [854] = 778,
  [855] = 779,
  [856] = 791,
  [857] = 672,
  [858] = 858,
  [859] = 664,
  [860] = 649,
  [861] = 757,
  [862] = 762,
  [863] = 765,
  [864] = 778,
  [865] = 779,
  [866] = 791,
  [867] = 672,
  [868] = 679,
  [869] = 664,
  [870] = 649,
  [871] = 757,
  [872] = 872,
  [873] = 851,
  [874] = 858,
  [875] = 872,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 679,
  [880] = 762,
  [881] = 843,
  [882] = 842,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 883,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 765,
  [896] = 896,
  [897] = 778,
  [898] = 883,
  [899] = 779,
  [900] = 791,
  [901] = 891,
  [902] = 672,
  [903] = 679,
  [904] = 664,
  [905] = 649,
  [906] = 845,
  [907] = 907,
  [908] = 876,
  [909] = 846,
  [910] = 877,
  [911] = 876,
  [912] = 762,
  [913] = 765,
  [914] = 778,
  [915] = 779,
  [916] = 791,
  [917] = 672,
  [918] = 679,
  [919] = 664,
  [920] = 649,
  [921] = 757,
  [922] = 762,
  [923] = 765,
  [924] = 778,
  [925] = 779,
  [926] = 791,
  [927] = 672,
  [928] = 928,
  [929] = 679,
  [930] = 664,
  [931] = 649,
  [932] = 757,
  [933] = 893,
  [934] = 891,
  [935] = 878,
  [936] = 936,
  [937] = 884,
  [938] = 885,
  [939] = 892,
  [940] = 877,
  [941] = 941,
  [942] = 878,
  [943] = 894,
  [944] = 847,
  [945] = 849,
  [946] = 850,
  [947] = 907,
  [948] = 843,
  [949] = 842,
  [950] = 941,
  [951] = 928,
  [952] = 757,
  [953] = 953,
  [954] = 778,
  [955] = 955,
  [956] = 956,
  [957] = 779,
  [958] = 953,
  [959] = 791,
  [960] = 672,
  [961] = 679,
  [962] = 664,
  [963] = 649,
  [964] = 757,
  [965] = 965,
  [966] = 966,
  [967] = 965,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 971,
  [973] = 973,
  [974] = 956,
  [975] = 888,
  [976] = 762,
  [977] = 765,
  [978] = 978,
  [979] = 979,
  [980] = 936,
  [981] = 968,
  [982] = 757,
  [983] = 969,
  [984] = 966,
  [985] = 762,
  [986] = 955,
  [987] = 979,
  [988] = 887,
  [989] = 765,
  [990] = 778,
  [991] = 991,
  [992] = 779,
  [993] = 791,
  [994] = 672,
  [995] = 679,
  [996] = 664,
  [997] = 978,
  [998] = 998,
  [999] = 973,
  [1000] = 886,
  [1001] = 649,
  [1002] = 991,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1008,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1006,
  [1014] = 1008,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1006,
  [1019] = 1006,
  [1020] = 1008,
  [1021] = 1006,
  [1022] = 1022,
  [1023] = 1008,
  [1024] = 1008,
  [1025] = 1006,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1006,
  [1030] = 1007,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1011,
  [1034] = 1006,
  [1035] = 1008,
  [1036] = 1022,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1006,
  [1040] = 1040,
  [1041] = 1008,
  [1042] = 1042,
  [1043] = 1006,
  [1044] = 1008,
  [1045] = 1027,
  [1046] = 1008,
  [1047] = 1047,
  [1048] = 1037,
  [1049] = 1008,
  [1050] = 1012,
  [1051] = 1004,
  [1052] = 1016,
  [1053] = 1026,
  [1054] = 1038,
  [1055] = 1031,
  [1056] = 1017,
  [1057] = 1042,
  [1058] = 1028,
  [1059] = 1006,
  [1060] = 1010,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1061,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1067,
  [1074] = 1069,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1077,
  [1080] = 1075,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1083,
  [1088] = 1088,
  [1089] = 1084,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1081,
  [1101] = 1101,
  [1102] = 1082,
  [1103] = 1083,
  [1104] = 1084,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1098,
  [1117] = 1099,
  [1118] = 1081,
  [1119] = 1082,
  [1120] = 1083,
  [1121] = 1084,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1094,
  [1130] = 1093,
  [1131] = 1113,
  [1132] = 1132,
  [1133] = 1084,
  [1134] = 1098,
  [1135] = 1088,
  [1136] = 1099,
  [1137] = 1090,
  [1138] = 1081,
  [1139] = 1082,
  [1140] = 1101,
  [1141] = 1083,
  [1142] = 1084,
  [1143] = 1143,
  [1144] = 1126,
  [1145] = 1091,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1092,
  [1150] = 1150,
  [1151] = 1083,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1098,
  [1156] = 1099,
  [1157] = 1081,
  [1158] = 1082,
  [1159] = 1083,
  [1160] = 1084,
  [1161] = 1161,
  [1162] = 1115,
  [1163] = 1098,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1150,
  [1168] = 1099,
  [1169] = 1165,
  [1170] = 1098,
  [1171] = 1096,
  [1172] = 1099,
  [1173] = 1098,
  [1174] = 1099,
  [1175] = 1081,
  [1176] = 1176,
  [1177] = 1082,
  [1178] = 1083,
  [1179] = 1084,
  [1180] = 1081,
  [1181] = 1081,
  [1182] = 1082,
  [1183] = 1082,
  [1184] = 1088,
  [1185] = 1185,
  [1186] = 1153,
  [1187] = 1187,
  [1188] = 1083,
  [1189] = 1084,
  [1190] = 1190,
  [1191] = 1125,
  [1192] = 1098,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1081,
  [1196] = 1196,
  [1197] = 1082,
  [1198] = 1083,
  [1199] = 1176,
  [1200] = 1084,
  [1201] = 1106,
  [1202] = 1196,
  [1203] = 1148,
  [1204] = 1166,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1166,
  [1209] = 1107,
  [1210] = 1210,
  [1211] = 1154,
  [1212] = 1212,
  [1213] = 1108,
  [1214] = 1143,
  [1215] = 1098,
  [1216] = 1099,
  [1217] = 1122,
  [1218] = 1081,
  [1219] = 1128,
  [1220] = 1132,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1082,
  [1224] = 1083,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1084,
  [1228] = 1228,
  [1229] = 1110,
  [1230] = 1097,
  [1231] = 1210,
  [1232] = 1123,
  [1233] = 1161,
  [1234] = 1234,
  [1235] = 1164,
  [1236] = 1112,
  [1237] = 1109,
  [1238] = 1114,
  [1239] = 1124,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1185,
  [1246] = 1164,
  [1247] = 1150,
  [1248] = 1205,
  [1249] = 1101,
  [1250] = 1165,
  [1251] = 1225,
  [1252] = 1252,
  [1253] = 1095,
  [1254] = 1241,
  [1255] = 1255,
  [1256] = 1221,
  [1257] = 1143,
  [1258] = 1243,
  [1259] = 1111,
  [1260] = 1164,
  [1261] = 1093,
  [1262] = 1086,
  [1263] = 1252,
  [1264] = 1240,
  [1265] = 1152,
  [1266] = 1105,
  [1267] = 1098,
  [1268] = 1099,
  [1269] = 1098,
  [1270] = 1082,
  [1271] = 1090,
  [1272] = 1190,
  [1273] = 1206,
  [1274] = 1212,
  [1275] = 1228,
  [1276] = 1185,
  [1277] = 1153,
  [1278] = 1099,
  [1279] = 1193,
  [1280] = 1244,
  [1281] = 1207,
  [1282] = 1081,
  [1283] = 1127,
  [1284] = 1085,
  [1285] = 1099,
};

static TSCharacterRange sym_word_character_set_1[] = {
  {'!', '$'}, {'&', '*'}, {',', ','}, {'0', '9'}, {';', '<'}, {'>', '?'}, {'E', 'E'}, {'[', '^'},
  {'`', 'b'}, {'f', 'f'}, {'n', 'n'}, {'r', 'r'}, {'t', 't'}, {'v', 'v'}, {'{', '~'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(107);
      ADVANCE_MAP(
        '!', 95,
        '"', 168,
        '#', 233,
        '$', 136,
        '%', 150,
        '&', 93,
        '\'', 169,
        '(', 138,
        ')', 200,
        '*', 156,
        '+', 154,
        ',', 133,
        '-', 121,
        '.', 185,
        '/', 155,
        ':', 166,
        ';', 167,
        '<', 151,
        '=', 123,
        '?', 152,
        '@', 149,
        '\\', 3,
        '^', 153,
        'e', 196,
        '{', 140,
        '|', 118,
        '}', 143,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\t', 201,
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '-', 194,
        '.', 185,
        '\\', 5,
      );
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 2:
      if (lookahead == '\t') ADVANCE(202);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(2);
      if (lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(207);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(45);
      if (lookahead == '\r') SKIP(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(54);
      if (lookahead == '\r') SKIP(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(49);
      if (lookahead == '\r') SKIP(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '\r') SKIP(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '\n', 109,
        '\r', 109,
        '#', 145,
        '$', 136,
        '%', 150,
        '(', 138,
        ')', 144,
        '*', 156,
        '+', 154,
        '/', 155,
        '<', 151,
        '?', 152,
        '@', 149,
        '\\', 144,
        '^', 153,
        '{', 141,
        '\t', 144,
        0x0b, 144,
        '\f', 144,
        ' ', 144,
      );
      if (lookahead != 0) ADVANCE(146);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '\n', 109,
        '\r', 109,
        '#', 147,
        '$', 136,
        '%', 150,
        '(', 139,
        '*', 156,
        '+', 154,
        '/', 155,
        '<', 151,
        '?', 152,
        '@', 149,
        '\\', 144,
        '^', 153,
        '{', 142,
        '\t', 144,
        0x0b, 144,
        '\f', 144,
        ' ', 144,
      );
      if (lookahead != 0) ADVANCE(148);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(63);
      if (lookahead == '\r') SKIP(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(80);
      if (lookahead == '\r') ADVANCE(144);
      if (lookahead == '#') ADVANCE(145);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(154);
      if (lookahead == ',') ADVANCE(134);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '<') ADVANCE(151);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '^') ADVANCE(153);
      if (lookahead == '{') ADVANCE(141);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0) ADVANCE(146);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '\r') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(227);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(88);
      if (lookahead == '\r') ADVANCE(144);
      if (lookahead == '#') ADVANCE(147);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(154);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '<') ADVANCE(151);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '^') ADVANCE(153);
      if (lookahead == '{') ADVANCE(142);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0) ADVANCE(148);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(88);
      if (lookahead == '\r') SKIP(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(81);
      if (lookahead == '\r') ADVANCE(144);
      if (lookahead == '#') ADVANCE(145);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(154);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '<') ADVANCE(151);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '^') ADVANCE(153);
      if (lookahead == '{') ADVANCE(141);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0) ADVANCE(146);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(227);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(56);
      if (lookahead == '\r') SKIP(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(55);
      if (lookahead == '\r') SKIP(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '\r') SKIP(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(64);
      if (lookahead == '\r') SKIP(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(61);
      if (lookahead == '\r') SKIP(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(67);
      if (lookahead == '\r') SKIP(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(87);
      if (lookahead == '\r') SKIP(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(2);
      if (lookahead == '\r') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(69);
      if (lookahead == '\r') SKIP(69);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(73);
      if (lookahead == '\r') SKIP(73);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(68);
      if (lookahead == '\r') SKIP(68);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(91);
      if (lookahead == '\r') SKIP(91);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(77);
      if (lookahead == '\r') SKIP(77);
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(77);
      if (lookahead == '#') ADVANCE(144);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(154);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '<') ADVANCE(151);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '^') ADVANCE(153);
      if (lookahead == '{') ADVANCE(140);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(76);
      if (lookahead == '\r') SKIP(76);
      END_STATE();
    case 36:
      ADVANCE_MAP(
        '\n', 203,
        '\r', 203,
        '#', 229,
        '\\', 37,
        'e', 41,
        '\t', 36,
        0x0b, 36,
        '\f', 36,
        ' ', 36,
      );
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 37:
      if (lookahead == '\n') ADVANCE(203);
      if (lookahead == '\r') ADVANCE(203);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 38:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 39:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead == 'e') ADVANCE(40);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 40:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 41:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead == 'n') ADVANCE(38);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(79);
      if (lookahead == '\r') SKIP(79);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 44:
      if (lookahead == '\r') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(227);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 95,
        '"', 168,
        '#', 233,
        '$', 136,
        '%', 157,
        '&', 93,
        '\'', 169,
        '(', 132,
        ')', 135,
        '*', 162,
        '+', 122,
        ',', 133,
        '-', 121,
        '.', 185,
        '/', 161,
        ':', 111,
        ';', 119,
        '<', 158,
        '=', 123,
        '?', 159,
        '@', 120,
        '\\', 3,
        '^', 160,
        'e', 196,
        '|', 118,
        '}', 143,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 95,
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '(', 138,
        ')', 200,
        '+', 174,
        ':', 111,
        '=', 123,
        '?', 175,
        '\\', 9,
        '\t', 117,
        ' ', 117,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(47);
      if (('%' <= lookahead && lookahead <= '*') ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 95,
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '+', 174,
        ':', 111,
        '=', 123,
        '?', 175,
        '\\', 7,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (lookahead == '%' ||
          lookahead == '*' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '%', 157,
        '\'', 169,
        ')', 200,
        '*', 162,
        '+', 122,
        '/', 161,
        '<', 158,
        '?', 159,
        '@', 120,
        '\\', 6,
        '^', 160,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '%', 157,
        '\'', 169,
        '*', 162,
        '+', 122,
        '/', 161,
        '<', 158,
        '?', 159,
        '@', 120,
        '\\', 6,
        '^', 160,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '(', 138,
        ')', 200,
        ':', 112,
        '\\', 9,
        '\t', 117,
        ' ', 117,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(56);
      if (('%' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '(', 138,
        ':', 112,
        ';', 119,
        '\\', 9,
        '|', 118,
        '\t', 117,
        ' ', 117,
        '\n', 109,
        '\r', 109,
      );
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(55);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '(', 132,
        ')', 200,
        ':', 112,
        '\\', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('%' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        '(', 132,
        ':', 112,
        '\\', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        ')', 135,
        ',', 133,
        '-', 194,
        '.', 185,
        ':', 112,
        '\\', 4,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (lookahead == '%' ||
          ('*' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        ':', 112,
        ';', 119,
        '\\', 21,
        '|', 118,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 56:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '&') ADVANCE(93);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ':') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(20);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '(', 138,
        ')', 135,
        ',', 133,
        ':', 110,
        '=', 123,
        '\\', 24,
        '}', 143,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (lookahead == '%' ||
          ('*' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '(', 138,
        '+', 174,
        ':', 113,
        ';', 119,
        '=', 123,
        '?', 175,
        '\\', 9,
        '|', 118,
        '\t', 117,
        ' ', 117,
        '\n', 109,
        '\r', 109,
      );
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(63);
      if (lookahead == '%' ||
          lookahead == '*' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '(', 138,
        ':', 110,
        ';', 119,
        '\\', 23,
        '|', 118,
        '\n', 109,
        '\r', 109,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(64);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '(', 138,
        ':', 165,
        ';', 167,
        '\\', 25,
        '\n', 109,
        '\r', 109,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(67);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        ')', 135,
        ',', 133,
        ':', 110,
        '=', 123,
        '\\', 24,
        '}', 143,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (lookahead == '%' ||
          ('*' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '+', 174,
        ':', 113,
        ';', 119,
        '=', 123,
        '?', 175,
        '\\', 13,
        '|', 118,
        '\n', 109,
        '\r', 109,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(63);
      if (lookahead == '%' ||
          lookahead == '*' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '+', 174,
        ':', 113,
        ';', 119,
        '=', 123,
        '?', 175,
        '\\', 13,
        '|', 118,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (lookahead == '%' ||
          lookahead == '*' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        ':', 110,
        ';', 119,
        '\\', 23,
        '|', 118,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        ';', 119,
        '\\', 22,
        '|', 118,
        '\t', 117,
        ' ', 117,
        '\n', 109,
        '\r', 109,
      );
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(66);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 66:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ';') ADVANCE(119);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '|') ADVANCE(118);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 67:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '\\') ADVANCE(25);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 68:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(68);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(173);
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == ',') ADVANCE(133);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') SKIP(29);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69);
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(73);
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(73);
      END_STATE();
    case 72:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') SKIP(30);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(73);
      END_STATE();
    case 73:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') SKIP(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(73);
      END_STATE();
    case 74:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '?') ADVANCE(98);
      if (lookahead == '\\') SKIP(35);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(117);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(109);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(76);
      END_STATE();
    case 75:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '?') ADVANCE(98);
      if (lookahead == '\\') SKIP(35);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(117);
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(76);
      END_STATE();
    case 76:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '?') ADVANCE(98);
      if (lookahead == '\\') SKIP(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(76);
      END_STATE();
    case 77:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '\\') SKIP(33);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(77);
      END_STATE();
    case 78:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '\\') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(117);
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(79);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 79:
      if (lookahead == '#') ADVANCE(233);
      if (lookahead == '\\') ADVANCE(43);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(79);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 80:
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == ',') ADVANCE(134);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(80);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 81:
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(81);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 82:
      ADVANCE_MAP(
        '#', 225,
        '$', 136,
        '/', 223,
        '\\', 19,
        '\t', 117,
        ' ', 117,
        '\n', 109,
        '\r', 109,
        0x0b, 221,
        '\f', 221,
      );
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 83:
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(117);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(85);
      if (lookahead == 0x0b ||
          lookahead == '\f') ADVANCE(221);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 84:
      ADVANCE_MAP(
        '#', 225,
        '$', 136,
        '/', 223,
        '\\', 19,
        '\n', 109,
        '\r', 109,
        '\t', 221,
        0x0b, 221,
        '\f', 221,
        ' ', 221,
      );
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 85:
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(85);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 86:
      ADVANCE_MAP(
        '#', 212,
        '$', 136,
        '+', 122,
        '-', 121,
        '/', 210,
        '@', 120,
        '\\', 27,
        '\n', 108,
        '\r', 108,
        '\t', 208,
        0x0b, 208,
        '\f', 208,
        ' ', 208,
      );
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 87:
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(87);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(208);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 88:
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(88);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(209);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 89:
      ADVANCE_MAP(
        '#', 212,
        '$', 136,
        '/', 210,
        '\\', 10,
        '\n', 109,
        '\r', 109,
        '\t', 209,
        0x0b, 209,
        '\f', 209,
        ' ', 209,
      );
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 90:
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(88);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(209);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 91:
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(91);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(171);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(173);
      END_STATE();
    case 92:
      if (lookahead == '/') ADVANCE(215);
      END_STATE();
    case 93:
      if (lookahead == ':') ADVANCE(114);
      END_STATE();
    case 94:
      if (lookahead == ':') ADVANCE(96);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 95:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 96:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 97:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 98:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      if (set_contains(sym_word_character_set_1, 15, lookahead)) ADVANCE(199);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(214);
      END_STATE();
    case 103:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(173);
      END_STATE();
    case 104:
      if (eof) ADVANCE(107);
      ADVANCE_MAP(
        '\t', 201,
        '"', 168,
        '#', 233,
        '$', 136,
        '\'', 169,
        '-', 194,
        '.', 185,
        '\\', 5,
      );
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(104);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 105:
      if (eof) ADVANCE(107);
      ADVANCE_MAP(
        '!', 95,
        '"', 168,
        '#', 233,
        '$', 136,
        '%', 157,
        '&', 93,
        '\'', 169,
        '(', 132,
        ')', 135,
        '*', 162,
        '+', 122,
        ',', 133,
        '-', 121,
        '.', 185,
        '/', 161,
        ':', 111,
        ';', 119,
        '<', 158,
        '=', 123,
        '?', 159,
        '@', 120,
        '\\', 3,
        '^', 160,
        'e', 196,
        '|', 118,
        '}', 143,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 106:
      if (eof) ADVANCE(107);
      ADVANCE_MAP(
        '"', 168,
        '#', 233,
        '$', 136,
        '&', 93,
        '\'', 169,
        ')', 135,
        ',', 133,
        '-', 194,
        '.', 185,
        ':', 112,
        '\\', 4,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(106);
      if (lookahead == '%' ||
          ('*' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym__thing_token1);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym__thing_token1);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(116);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(115);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(96);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AMP_COLON);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym__ordinary_rule_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_QMARK_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DOTRECIPEPREFIX);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_endef);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASHinclude);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_variable_reference_token1);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_variable_reference_token1);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(225);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_variable_reference_token1);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_variable_reference_token1);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(212);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_variable_reference_token1);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_AT2);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PLUS2);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT2);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_CARET2);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_STAR2);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_list_token1);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_list_token1);
      if (lookahead == '\n') ADVANCE(163);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == ':') ADVANCE(116);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_SEMI2);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(68);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(173);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(91);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(171);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(173);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead == '\r' ||
          lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\'') ADVANCE(233);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == '\\') ADVANCE(103);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'C') ADVANCE(181);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'E') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'E') ADVANCE(180);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'E') ADVANCE(184);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'F') ADVANCE(182);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'I') ADVANCE(183);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'P') ADVANCE(179);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'P') ADVANCE(186);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'R') ADVANCE(177);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'R') ADVANCE(178);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'X') ADVANCE(128);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'd') ADVANCE(191);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'd') ADVANCE(192);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'e') ADVANCE(193);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'l') ADVANCE(198);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'n') ADVANCE(189);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'n') ADVANCE(188);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == 'u') ADVANCE(190);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_RPAREN2);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_TAB);
      if (lookahead == '\t') ADVANCE(201);
      if (lookahead == '\\') ADVANCE(5);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_TAB);
      if (lookahead == '\t') ADVANCE(202);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(207);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__rawline);
      ADVANCE_MAP(
        '\n', 203,
        '\r', 203,
        '#', 229,
        '\\', 37,
        'e', 41,
        '\t', 36,
        0x0b, 36,
        '\f', 36,
        ' ', 36,
      );
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__rawline);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(204);
      if (lookahead != 0) ADVANCE(229);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__rawline);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(205);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__rawline);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '\t') ADVANCE(202);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(207);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      ADVANCE_MAP(
        '#', 212,
        '+', 122,
        '-', 121,
        '/', 210,
        '@', 120,
        '\\', 27,
        '\t', 208,
        0x0b, 208,
        '\f', 208,
        ' ', 208,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '/') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(209);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '/') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '\\') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(212);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '\\') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym__shell_text_without_split_token1);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$') ADVANCE(214);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\n') ADVANCE(227);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(225);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == ',') ADVANCE(134);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == ',') ADVANCE(134);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(15);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '/') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\\') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\\') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(227);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\r') ADVANCE(204);
      if (lookahead != 0) ADVANCE(229);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(227);
      if (lookahead == '\r') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (lookahead != 0) ADVANCE(225);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(212);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(233);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(233);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'D') ADVANCE(1);
      if (lookahead == 'F') ADVANCE(2);
      if (lookahead == 'V') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'i') ADVANCE(11);
      if (lookahead == 'j') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'n') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      if (lookahead == 'p') ADVANCE(16);
      if (lookahead == 'r') ADVANCE(17);
      if (lookahead == 's') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'v') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(anon_sym_D);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym_F);
      END_STATE();
    case 3:
      if (lookahead == 'P') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(22);
      if (lookahead == '\r') SKIP(24);
      END_STATE();
    case 5:
      if (lookahead == 'b') ADVANCE(25);
      if (lookahead == 'd') ADVANCE(26);
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(28);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(29);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      if (lookahead == 'r') ADVANCE(34);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'l') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(45);
      if (lookahead == 'v') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'i') ADVANCE(51);
      if (lookahead == 'o') ADVANCE(52);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'p') ADVANCE(57);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 22:
      if (lookahead == 'V') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == 'd') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 'i') ADVANCE(63);
      if (lookahead == 'o') ADVANCE(64);
      if (lookahead == 'p') ADVANCE(65);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'v') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      END_STATE();
    case 23:
      if (lookahead == 'A') ADVANCE(68);
      END_STATE();
    case 24:
      if (lookahead == 'V') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == 'd') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 'i') ADVANCE(63);
      if (lookahead == 'o') ADVANCE(64);
      if (lookahead == 'p') ADVANCE(65);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'v') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(71);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(73);
      END_STATE();
    case 30:
      if (lookahead == 'f') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(77);
      END_STATE();
    case 34:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(79);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(80);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(81);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(84);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == 'd') ADVANCE(86);
      if (lookahead == 'e') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(89);
      if (lookahead == 'f') ADVANCE(90);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 43:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(98);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(101);
      END_STATE();
    case 53:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 54:
      if (lookahead == 'b') ADVANCE(103);
      if (lookahead == 'f') ADVANCE(104);
      END_STATE();
    case 55:
      if (lookahead == 'd') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(109);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 63:
      if (lookahead == 'f') ADVANCE(112);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 64:
      if (lookahead == 'v') ADVANCE(46);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 66:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 67:
      if (lookahead == 'p') ADVANCE(57);
      END_STATE();
    case 68:
      if (lookahead == 'T') ADVANCE(114);
      END_STATE();
    case 69:
      if (lookahead == 'p') ADVANCE(115);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(116);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_dir);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(128);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 84:
      if (lookahead == 'v') ADVANCE(130);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 87:
      if (lookahead == 'q') ADVANCE(133);
      END_STATE();
    case 88:
      if (lookahead == 'd') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 92:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(140);
      END_STATE();
    case 94:
      if (lookahead == 'g') ADVANCE(141);
      END_STATE();
    case 95:
      if (lookahead == 'r') ADVANCE(142);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 97:
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(150);
      END_STATE();
    case 104:
      if (lookahead == 'f') ADVANCE(151);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 106:
      if (lookahead == 'x') ADVANCE(153);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 109:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(157);
      END_STATE();
    case 111:
      if (lookahead == 'd') ADVANCE(158);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(86);
      if (lookahead == 'e') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 113:
      if (lookahead == 'c') ADVANCE(89);
      END_STATE();
    case 114:
      if (lookahead == 'H') ADVANCE(159);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(162);
      END_STATE();
    case 118:
      if (lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_call);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 122:
      if (lookahead == 'f') ADVANCE(165);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(166);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_eval);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(167);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_file);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 128:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 130:
      if (lookahead == 'o') ADVANCE(171);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 132:
      if (lookahead == 'f') ADVANCE(173);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_ifeq);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 135:
      if (lookahead == 'q') ADVANCE(175);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_info);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_join);
      END_STATE();
    case 139:
      if (lookahead == 'w') ADVANCE(177);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 141:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 142:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 143:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 145:
      if (lookahead == 'p') ADVANCE(183);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_sort);
      END_STATE();
    case 149:
      if (lookahead == 'p') ADVANCE(186);
      END_STATE();
    case 150:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 152:
      if (lookahead == 'f') ADVANCE(189);
      END_STATE();
    case 153:
      if (lookahead == 'p') ADVANCE(190);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 155:
      if (lookahead == 'h') ADVANCE(192);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(194);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_word);
      if (lookahead == 'l') ADVANCE(195);
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_VPATH);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 162:
      if (lookahead == 'f') ADVANCE(199);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(200);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 167:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 168:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'w') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'r') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(207);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_ifdef);
      END_STATE();
    case 174:
      if (lookahead == 'f') ADVANCE(208);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_ifneq);
      END_STATE();
    case 176:
      if (lookahead == 'd') ADVANCE(209);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(213);
      END_STATE();
    case 181:
      if (lookahead == 'b') ADVANCE(214);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(215);
      END_STATE();
    case 183:
      if (lookahead == 'a') ADVANCE(216);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_shell);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(217);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_strip);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_subst);
      END_STATE();
    case 188:
      if (lookahead == 'x') ADVANCE(218);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_value);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_vpath);
      END_STATE();
    case 193:
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(222);
      END_STATE();
    case 195:
      if (lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_words);
      END_STATE();
    case 197:
      if (lookahead == 'h') ADVANCE(224);
      END_STATE();
    case 198:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 199:
      if (lookahead == 'f') ADVANCE(226);
      END_STATE();
    case 200:
      if (lookahead == 'm') ADVANCE(227);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_define);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_filter);
      if (lookahead == '-') ADVANCE(228);
      END_STATE();
    case 204:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 205:
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_flavor);
      END_STATE();
    case 207:
      if (lookahead == 'h') ADVANCE(231);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_ifndef);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_notdir);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_origin);
      END_STATE();
    case 213:
      if (lookahead == 'd') ADVANCE(234);
      END_STATE();
    case 214:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 216:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 217:
      if (lookahead == 'd') ADVANCE(238);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_suffix);
      END_STATE();
    case 219:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(240);
      END_STATE();
    case 221:
      if (lookahead == 'g') ADVANCE(241);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 223:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_abspath);
      END_STATE();
    case 225:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 226:
      if (lookahead == 'i') ADVANCE(245);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 228:
      if (lookahead == 'o') ADVANCE(247);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(248);
      END_STATE();
    case 230:
      if (lookahead == 'r') ADVANCE(249);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 233:
      if (lookahead == 'd') ADVANCE(250);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 237:
      if (lookahead == 'h') ADVANCE(253);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(254);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 240:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_warning);
      END_STATE();
    case 242:
      if (lookahead == 'd') ADVANCE(257);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(258);
      END_STATE();
    case 244:
      if (lookahead == 'x') ADVANCE(259);
      END_STATE();
    case 245:
      if (lookahead == 'x') ADVANCE(260);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_basename);
      END_STATE();
    case 247:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 249:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_lastword);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_patsubst);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_realpath);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_sinclude);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_undefine);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_unexport);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_wildcard);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_wordlist);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_addprefix);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_addsuffix);
      END_STATE();
    case 261:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 262:
      if (lookahead == 'g') ADVANCE(265);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_firstword);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_filter_DASHout);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_findstring);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 106},
  [2] = {.lex_state = 104},
  [3] = {.lex_state = 104},
  [4] = {.lex_state = 104},
  [5] = {.lex_state = 104},
  [6] = {.lex_state = 104},
  [7] = {.lex_state = 104},
  [8] = {.lex_state = 104},
  [9] = {.lex_state = 104},
  [10] = {.lex_state = 104},
  [11] = {.lex_state = 104},
  [12] = {.lex_state = 104},
  [13] = {.lex_state = 48},
  [14] = {.lex_state = 48},
  [15] = {.lex_state = 48},
  [16] = {.lex_state = 48},
  [17] = {.lex_state = 48},
  [18] = {.lex_state = 48},
  [19] = {.lex_state = 48},
  [20] = {.lex_state = 48},
  [21] = {.lex_state = 48},
  [22] = {.lex_state = 48},
  [23] = {.lex_state = 48},
  [24] = {.lex_state = 48},
  [25] = {.lex_state = 106},
  [26] = {.lex_state = 106},
  [27] = {.lex_state = 104},
  [28] = {.lex_state = 104},
  [29] = {.lex_state = 104},
  [30] = {.lex_state = 104},
  [31] = {.lex_state = 104},
  [32] = {.lex_state = 104},
  [33] = {.lex_state = 104},
  [34] = {.lex_state = 104},
  [35] = {.lex_state = 104},
  [36] = {.lex_state = 104},
  [37] = {.lex_state = 104},
  [38] = {.lex_state = 104},
  [39] = {.lex_state = 104},
  [40] = {.lex_state = 104},
  [41] = {.lex_state = 104},
  [42] = {.lex_state = 104},
  [43] = {.lex_state = 104},
  [44] = {.lex_state = 104},
  [45] = {.lex_state = 104},
  [46] = {.lex_state = 104},
  [47] = {.lex_state = 104},
  [48] = {.lex_state = 104},
  [49] = {.lex_state = 104},
  [50] = {.lex_state = 104},
  [51] = {.lex_state = 104},
  [52] = {.lex_state = 104},
  [53] = {.lex_state = 104},
  [54] = {.lex_state = 104},
  [55] = {.lex_state = 104},
  [56] = {.lex_state = 104},
  [57] = {.lex_state = 104},
  [58] = {.lex_state = 104},
  [59] = {.lex_state = 104},
  [60] = {.lex_state = 104},
  [61] = {.lex_state = 104},
  [62] = {.lex_state = 104},
  [63] = {.lex_state = 104},
  [64] = {.lex_state = 104},
  [65] = {.lex_state = 104},
  [66] = {.lex_state = 104},
  [67] = {.lex_state = 104},
  [68] = {.lex_state = 104},
  [69] = {.lex_state = 104},
  [70] = {.lex_state = 104},
  [71] = {.lex_state = 104},
  [72] = {.lex_state = 104},
  [73] = {.lex_state = 104},
  [74] = {.lex_state = 104},
  [75] = {.lex_state = 46},
  [76] = {.lex_state = 58},
  [77] = {.lex_state = 58},
  [78] = {.lex_state = 58},
  [79] = {.lex_state = 46},
  [80] = {.lex_state = 58},
  [81] = {.lex_state = 58},
  [82] = {.lex_state = 58},
  [83] = {.lex_state = 46},
  [84] = {.lex_state = 46},
  [85] = {.lex_state = 14},
  [86] = {.lex_state = 12},
  [87] = {.lex_state = 104},
  [88] = {.lex_state = 104},
  [89] = {.lex_state = 104},
  [90] = {.lex_state = 104},
  [91] = {.lex_state = 104},
  [92] = {.lex_state = 47},
  [93] = {.lex_state = 104},
  [94] = {.lex_state = 104},
  [95] = {.lex_state = 104},
  [96] = {.lex_state = 104},
  [97] = {.lex_state = 104},
  [98] = {.lex_state = 104},
  [99] = {.lex_state = 104},
  [100] = {.lex_state = 104},
  [101] = {.lex_state = 104},
  [102] = {.lex_state = 104},
  [103] = {.lex_state = 104},
  [104] = {.lex_state = 104},
  [105] = {.lex_state = 104},
  [106] = {.lex_state = 104},
  [107] = {.lex_state = 104},
  [108] = {.lex_state = 104},
  [109] = {.lex_state = 16},
  [110] = {.lex_state = 104},
  [111] = {.lex_state = 104},
  [112] = {.lex_state = 104},
  [113] = {.lex_state = 104},
  [114] = {.lex_state = 104},
  [115] = {.lex_state = 104},
  [116] = {.lex_state = 104},
  [117] = {.lex_state = 104},
  [118] = {.lex_state = 104},
  [119] = {.lex_state = 104},
  [120] = {.lex_state = 104},
  [121] = {.lex_state = 104},
  [122] = {.lex_state = 104},
  [123] = {.lex_state = 104},
  [124] = {.lex_state = 104},
  [125] = {.lex_state = 104},
  [126] = {.lex_state = 104},
  [127] = {.lex_state = 104},
  [128] = {.lex_state = 104},
  [129] = {.lex_state = 104},
  [130] = {.lex_state = 104},
  [131] = {.lex_state = 104},
  [132] = {.lex_state = 104},
  [133] = {.lex_state = 104},
  [134] = {.lex_state = 104},
  [135] = {.lex_state = 104},
  [136] = {.lex_state = 104},
  [137] = {.lex_state = 104},
  [138] = {.lex_state = 104},
  [139] = {.lex_state = 62},
  [140] = {.lex_state = 104},
  [141] = {.lex_state = 104},
  [142] = {.lex_state = 104},
  [143] = {.lex_state = 104},
  [144] = {.lex_state = 104},
  [145] = {.lex_state = 104},
  [146] = {.lex_state = 104},
  [147] = {.lex_state = 104},
  [148] = {.lex_state = 104},
  [149] = {.lex_state = 104},
  [150] = {.lex_state = 104},
  [151] = {.lex_state = 104},
  [152] = {.lex_state = 104},
  [153] = {.lex_state = 104},
  [154] = {.lex_state = 104},
  [155] = {.lex_state = 104},
  [156] = {.lex_state = 104},
  [157] = {.lex_state = 104},
  [158] = {.lex_state = 104},
  [159] = {.lex_state = 104},
  [160] = {.lex_state = 104},
  [161] = {.lex_state = 104},
  [162] = {.lex_state = 104},
  [163] = {.lex_state = 62},
  [164] = {.lex_state = 104},
  [165] = {.lex_state = 11},
  [166] = {.lex_state = 104},
  [167] = {.lex_state = 104},
  [168] = {.lex_state = 104},
  [169] = {.lex_state = 104},
  [170] = {.lex_state = 104},
  [171] = {.lex_state = 104},
  [172] = {.lex_state = 104},
  [173] = {.lex_state = 104},
  [174] = {.lex_state = 104},
  [175] = {.lex_state = 104},
  [176] = {.lex_state = 104},
  [177] = {.lex_state = 104},
  [178] = {.lex_state = 104},
  [179] = {.lex_state = 104},
  [180] = {.lex_state = 104},
  [181] = {.lex_state = 104},
  [182] = {.lex_state = 104},
  [183] = {.lex_state = 18},
  [184] = {.lex_state = 47},
  [185] = {.lex_state = 62},
  [186] = {.lex_state = 62},
  [187] = {.lex_state = 104},
  [188] = {.lex_state = 48},
  [189] = {.lex_state = 48},
  [190] = {.lex_state = 50},
  [191] = {.lex_state = 51},
  [192] = {.lex_state = 50},
  [193] = {.lex_state = 65},
  [194] = {.lex_state = 51},
  [195] = {.lex_state = 65},
  [196] = {.lex_state = 48},
  [197] = {.lex_state = 51},
  [198] = {.lex_state = 51},
  [199] = {.lex_state = 50},
  [200] = {.lex_state = 104},
  [201] = {.lex_state = 104},
  [202] = {.lex_state = 104},
  [203] = {.lex_state = 104},
  [204] = {.lex_state = 104},
  [205] = {.lex_state = 104},
  [206] = {.lex_state = 104},
  [207] = {.lex_state = 51},
  [208] = {.lex_state = 65},
  [209] = {.lex_state = 65},
  [210] = {.lex_state = 51},
  [211] = {.lex_state = 48},
  [212] = {.lex_state = 104},
  [213] = {.lex_state = 48},
  [214] = {.lex_state = 48},
  [215] = {.lex_state = 48},
  [216] = {.lex_state = 48},
  [217] = {.lex_state = 48},
  [218] = {.lex_state = 48},
  [219] = {.lex_state = 48},
  [220] = {.lex_state = 106},
  [221] = {.lex_state = 106},
  [222] = {.lex_state = 106},
  [223] = {.lex_state = 106},
  [224] = {.lex_state = 106},
  [225] = {.lex_state = 106},
  [226] = {.lex_state = 106},
  [227] = {.lex_state = 106},
  [228] = {.lex_state = 106},
  [229] = {.lex_state = 106},
  [230] = {.lex_state = 106},
  [231] = {.lex_state = 106},
  [232] = {.lex_state = 106},
  [233] = {.lex_state = 106},
  [234] = {.lex_state = 106},
  [235] = {.lex_state = 106},
  [236] = {.lex_state = 106},
  [237] = {.lex_state = 106},
  [238] = {.lex_state = 50},
  [239] = {.lex_state = 106},
  [240] = {.lex_state = 106},
  [241] = {.lex_state = 106},
  [242] = {.lex_state = 106},
  [243] = {.lex_state = 51},
  [244] = {.lex_state = 106},
  [245] = {.lex_state = 59},
  [246] = {.lex_state = 106},
  [247] = {.lex_state = 106},
  [248] = {.lex_state = 106},
  [249] = {.lex_state = 106},
  [250] = {.lex_state = 106},
  [251] = {.lex_state = 106},
  [252] = {.lex_state = 106},
  [253] = {.lex_state = 51},
  [254] = {.lex_state = 106},
  [255] = {.lex_state = 106},
  [256] = {.lex_state = 51},
  [257] = {.lex_state = 106},
  [258] = {.lex_state = 106},
  [259] = {.lex_state = 106},
  [260] = {.lex_state = 106},
  [261] = {.lex_state = 106},
  [262] = {.lex_state = 50},
  [263] = {.lex_state = 106},
  [264] = {.lex_state = 106},
  [265] = {.lex_state = 106},
  [266] = {.lex_state = 106},
  [267] = {.lex_state = 50},
  [268] = {.lex_state = 106},
  [269] = {.lex_state = 106},
  [270] = {.lex_state = 106},
  [271] = {.lex_state = 106},
  [272] = {.lex_state = 106},
  [273] = {.lex_state = 106},
  [274] = {.lex_state = 106},
  [275] = {.lex_state = 106},
  [276] = {.lex_state = 106},
  [277] = {.lex_state = 106},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 106},
  [280] = {.lex_state = 106},
  [281] = {.lex_state = 106},
  [282] = {.lex_state = 59},
  [283] = {.lex_state = 59},
  [284] = {.lex_state = 106},
  [285] = {.lex_state = 106},
  [286] = {.lex_state = 106},
  [287] = {.lex_state = 106},
  [288] = {.lex_state = 106},
  [289] = {.lex_state = 106},
  [290] = {.lex_state = 106},
  [291] = {.lex_state = 106},
  [292] = {.lex_state = 62},
  [293] = {.lex_state = 106},
  [294] = {.lex_state = 106},
  [295] = {.lex_state = 106},
  [296] = {.lex_state = 106},
  [297] = {.lex_state = 106},
  [298] = {.lex_state = 106},
  [299] = {.lex_state = 106},
  [300] = {.lex_state = 106},
  [301] = {.lex_state = 106},
  [302] = {.lex_state = 106},
  [303] = {.lex_state = 106},
  [304] = {.lex_state = 106},
  [305] = {.lex_state = 106},
  [306] = {.lex_state = 106},
  [307] = {.lex_state = 62},
  [308] = {.lex_state = 106},
  [309] = {.lex_state = 59},
  [310] = {.lex_state = 106},
  [311] = {.lex_state = 106},
  [312] = {.lex_state = 106},
  [313] = {.lex_state = 106},
  [314] = {.lex_state = 106},
  [315] = {.lex_state = 106},
  [316] = {.lex_state = 106},
  [317] = {.lex_state = 106},
  [318] = {.lex_state = 106},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 57},
  [321] = {.lex_state = 65},
  [322] = {.lex_state = 60},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 57},
  [325] = {.lex_state = 65},
  [326] = {.lex_state = 65},
  [327] = {.lex_state = 65},
  [328] = {.lex_state = 47},
  [329] = {.lex_state = 47},
  [330] = {.lex_state = 50},
  [331] = {.lex_state = 60},
  [332] = {.lex_state = 60},
  [333] = {.lex_state = 59},
  [334] = {.lex_state = 60},
  [335] = {.lex_state = 59},
  [336] = {.lex_state = 59},
  [337] = {.lex_state = 59},
  [338] = {.lex_state = 57},
  [339] = {.lex_state = 52},
  [340] = {.lex_state = 52},
  [341] = {.lex_state = 57},
  [342] = {.lex_state = 57},
  [343] = {.lex_state = 57},
  [344] = {.lex_state = 57},
  [345] = {.lex_state = 57},
  [346] = {.lex_state = 57},
  [347] = {.lex_state = 57},
  [348] = {.lex_state = 57},
  [349] = {.lex_state = 57},
  [350] = {.lex_state = 57},
  [351] = {.lex_state = 57},
  [352] = {.lex_state = 57},
  [353] = {.lex_state = 57},
  [354] = {.lex_state = 57},
  [355] = {.lex_state = 57},
  [356] = {.lex_state = 57},
  [357] = {.lex_state = 57},
  [358] = {.lex_state = 60},
  [359] = {.lex_state = 60},
  [360] = {.lex_state = 60},
  [361] = {.lex_state = 59},
  [362] = {.lex_state = 57},
  [363] = {.lex_state = 57},
  [364] = {.lex_state = 57},
  [365] = {.lex_state = 57},
  [366] = {.lex_state = 59},
  [367] = {.lex_state = 57},
  [368] = {.lex_state = 57},
  [369] = {.lex_state = 57},
  [370] = {.lex_state = 57},
  [371] = {.lex_state = 57},
  [372] = {.lex_state = 57},
  [373] = {.lex_state = 57},
  [374] = {.lex_state = 59},
  [375] = {.lex_state = 57},
  [376] = {.lex_state = 57},
  [377] = {.lex_state = 57},
  [378] = {.lex_state = 59},
  [379] = {.lex_state = 57},
  [380] = {.lex_state = 86},
  [381] = {.lex_state = 57},
  [382] = {.lex_state = 57},
  [383] = {.lex_state = 86},
  [384] = {.lex_state = 57},
  [385] = {.lex_state = 57},
  [386] = {.lex_state = 57},
  [387] = {.lex_state = 57},
  [388] = {.lex_state = 57},
  [389] = {.lex_state = 57},
  [390] = {.lex_state = 57},
  [391] = {.lex_state = 57},
  [392] = {.lex_state = 57},
  [393] = {.lex_state = 57},
  [394] = {.lex_state = 57},
  [395] = {.lex_state = 57},
  [396] = {.lex_state = 59},
  [397] = {.lex_state = 57},
  [398] = {.lex_state = 57},
  [399] = {.lex_state = 57},
  [400] = {.lex_state = 57},
  [401] = {.lex_state = 57},
  [402] = {.lex_state = 57},
  [403] = {.lex_state = 57},
  [404] = {.lex_state = 57},
  [405] = {.lex_state = 57},
  [406] = {.lex_state = 57},
  [407] = {.lex_state = 57},
  [408] = {.lex_state = 57},
  [409] = {.lex_state = 57},
  [410] = {.lex_state = 57},
  [411] = {.lex_state = 57},
  [412] = {.lex_state = 86},
  [413] = {.lex_state = 59},
  [414] = {.lex_state = 59},
  [415] = {.lex_state = 57},
  [416] = {.lex_state = 57},
  [417] = {.lex_state = 57},
  [418] = {.lex_state = 57},
  [419] = {.lex_state = 57},
  [420] = {.lex_state = 57},
  [421] = {.lex_state = 57},
  [422] = {.lex_state = 57},
  [423] = {.lex_state = 57},
  [424] = {.lex_state = 57},
  [425] = {.lex_state = 57},
  [426] = {.lex_state = 57},
  [427] = {.lex_state = 57},
  [428] = {.lex_state = 57},
  [429] = {.lex_state = 57},
  [430] = {.lex_state = 57},
  [431] = {.lex_state = 57},
  [432] = {.lex_state = 57},
  [433] = {.lex_state = 57},
  [434] = {.lex_state = 57},
  [435] = {.lex_state = 57},
  [436] = {.lex_state = 57},
  [437] = {.lex_state = 57},
  [438] = {.lex_state = 57},
  [439] = {.lex_state = 57},
  [440] = {.lex_state = 57},
  [441] = {.lex_state = 57},
  [442] = {.lex_state = 57},
  [443] = {.lex_state = 57},
  [444] = {.lex_state = 57},
  [445] = {.lex_state = 57},
  [446] = {.lex_state = 57},
  [447] = {.lex_state = 57},
  [448] = {.lex_state = 14},
  [449] = {.lex_state = 57},
  [450] = {.lex_state = 57},
  [451] = {.lex_state = 57},
  [452] = {.lex_state = 57},
  [453] = {.lex_state = 59},
  [454] = {.lex_state = 57},
  [455] = {.lex_state = 57},
  [456] = {.lex_state = 57},
  [457] = {.lex_state = 57},
  [458] = {.lex_state = 59},
  [459] = {.lex_state = 57},
  [460] = {.lex_state = 59},
  [461] = {.lex_state = 52},
  [462] = {.lex_state = 59},
  [463] = {.lex_state = 57},
  [464] = {.lex_state = 57},
  [465] = {.lex_state = 57},
  [466] = {.lex_state = 57},
  [467] = {.lex_state = 59},
  [468] = {.lex_state = 59},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 12},
  [471] = {.lex_state = 57},
  [472] = {.lex_state = 12},
  [473] = {.lex_state = 57},
  [474] = {.lex_state = 57},
  [475] = {.lex_state = 57},
  [476] = {.lex_state = 57},
  [477] = {.lex_state = 57},
  [478] = {.lex_state = 57},
  [479] = {.lex_state = 57},
  [480] = {.lex_state = 57},
  [481] = {.lex_state = 14},
  [482] = {.lex_state = 57},
  [483] = {.lex_state = 57},
  [484] = {.lex_state = 57},
  [485] = {.lex_state = 57},
  [486] = {.lex_state = 57},
  [487] = {.lex_state = 14},
  [488] = {.lex_state = 57},
  [489] = {.lex_state = 57},
  [490] = {.lex_state = 57},
  [491] = {.lex_state = 52},
  [492] = {.lex_state = 57},
  [493] = {.lex_state = 57},
  [494] = {.lex_state = 57},
  [495] = {.lex_state = 57},
  [496] = {.lex_state = 57},
  [497] = {.lex_state = 57},
  [498] = {.lex_state = 57},
  [499] = {.lex_state = 57},
  [500] = {.lex_state = 57},
  [501] = {.lex_state = 57},
  [502] = {.lex_state = 59},
  [503] = {.lex_state = 57},
  [504] = {.lex_state = 57},
  [505] = {.lex_state = 57},
  [506] = {.lex_state = 57},
  [507] = {.lex_state = 57},
  [508] = {.lex_state = 57},
  [509] = {.lex_state = 18},
  [510] = {.lex_state = 57},
  [511] = {.lex_state = 57},
  [512] = {.lex_state = 57},
  [513] = {.lex_state = 57},
  [514] = {.lex_state = 57},
  [515] = {.lex_state = 57},
  [516] = {.lex_state = 16},
  [517] = {.lex_state = 57},
  [518] = {.lex_state = 57},
  [519] = {.lex_state = 57},
  [520] = {.lex_state = 11},
  [521] = {.lex_state = 2},
  [522] = {.lex_state = 57},
  [523] = {.lex_state = 57},
  [524] = {.lex_state = 57},
  [525] = {.lex_state = 16},
  [526] = {.lex_state = 57},
  [527] = {.lex_state = 57},
  [528] = {.lex_state = 57},
  [529] = {.lex_state = 11},
  [530] = {.lex_state = 57},
  [531] = {.lex_state = 57},
  [532] = {.lex_state = 18},
  [533] = {.lex_state = 57},
  [534] = {.lex_state = 16},
  [535] = {.lex_state = 2},
  [536] = {.lex_state = 57},
  [537] = {.lex_state = 57},
  [538] = {.lex_state = 2},
  [539] = {.lex_state = 57},
  [540] = {.lex_state = 18},
  [541] = {.lex_state = 57},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 57},
  [544] = {.lex_state = 11},
  [545] = {.lex_state = 2},
  [546] = {.lex_state = 57},
  [547] = {.lex_state = 57},
  [548] = {.lex_state = 57},
  [549] = {.lex_state = 57},
  [550] = {.lex_state = 57},
  [551] = {.lex_state = 57},
  [552] = {.lex_state = 57},
  [553] = {.lex_state = 57},
  [554] = {.lex_state = 57},
  [555] = {.lex_state = 57},
  [556] = {.lex_state = 57},
  [557] = {.lex_state = 57},
  [558] = {.lex_state = 57},
  [559] = {.lex_state = 57},
  [560] = {.lex_state = 57},
  [561] = {.lex_state = 57},
  [562] = {.lex_state = 57},
  [563] = {.lex_state = 57},
  [564] = {.lex_state = 57},
  [565] = {.lex_state = 57},
  [566] = {.lex_state = 57},
  [567] = {.lex_state = 57},
  [568] = {.lex_state = 57},
  [569] = {.lex_state = 57},
  [570] = {.lex_state = 57},
  [571] = {.lex_state = 57},
  [572] = {.lex_state = 57},
  [573] = {.lex_state = 57},
  [574] = {.lex_state = 57},
  [575] = {.lex_state = 57},
  [576] = {.lex_state = 57},
  [577] = {.lex_state = 57},
  [578] = {.lex_state = 57},
  [579] = {.lex_state = 57},
  [580] = {.lex_state = 57},
  [581] = {.lex_state = 57},
  [582] = {.lex_state = 57},
  [583] = {.lex_state = 57},
  [584] = {.lex_state = 57},
  [585] = {.lex_state = 57},
  [586] = {.lex_state = 57},
  [587] = {.lex_state = 57},
  [588] = {.lex_state = 57},
  [589] = {.lex_state = 57},
  [590] = {.lex_state = 57},
  [591] = {.lex_state = 57},
  [592] = {.lex_state = 57},
  [593] = {.lex_state = 57},
  [594] = {.lex_state = 57},
  [595] = {.lex_state = 57},
  [596] = {.lex_state = 57},
  [597] = {.lex_state = 57},
  [598] = {.lex_state = 83},
  [599] = {.lex_state = 82},
  [600] = {.lex_state = 80},
  [601] = {.lex_state = 82},
  [602] = {.lex_state = 82},
  [603] = {.lex_state = 82},
  [604] = {.lex_state = 82},
  [605] = {.lex_state = 82},
  [606] = {.lex_state = 82},
  [607] = {.lex_state = 83},
  [608] = {.lex_state = 83},
  [609] = {.lex_state = 83},
  [610] = {.lex_state = 89},
  [611] = {.lex_state = 80},
  [612] = {.lex_state = 80},
  [613] = {.lex_state = 89},
  [614] = {.lex_state = 83},
  [615] = {.lex_state = 83},
  [616] = {.lex_state = 83},
  [617] = {.lex_state = 83},
  [618] = {.lex_state = 82},
  [619] = {.lex_state = 83},
  [620] = {.lex_state = 83},
  [621] = {.lex_state = 83},
  [622] = {.lex_state = 83},
  [623] = {.lex_state = 83},
  [624] = {.lex_state = 82},
  [625] = {.lex_state = 83},
  [626] = {.lex_state = 83},
  [627] = {.lex_state = 83},
  [628] = {.lex_state = 83},
  [629] = {.lex_state = 83},
  [630] = {.lex_state = 83},
  [631] = {.lex_state = 89},
  [632] = {.lex_state = 83},
  [633] = {.lex_state = 83},
  [634] = {.lex_state = 83},
  [635] = {.lex_state = 80},
  [636] = {.lex_state = 83},
  [637] = {.lex_state = 80},
  [638] = {.lex_state = 82},
  [639] = {.lex_state = 83},
  [640] = {.lex_state = 82},
  [641] = {.lex_state = 83},
  [642] = {.lex_state = 82},
  [643] = {.lex_state = 89},
  [644] = {.lex_state = 89},
  [645] = {.lex_state = 83},
  [646] = {.lex_state = 84},
  [647] = {.lex_state = 84},
  [648] = {.lex_state = 81},
  [649] = {.lex_state = 51},
  [650] = {.lex_state = 69},
  [651] = {.lex_state = 81},
  [652] = {.lex_state = 81},
  [653] = {.lex_state = 81},
  [654] = {.lex_state = 81},
  [655] = {.lex_state = 70},
  [656] = {.lex_state = 69},
  [657] = {.lex_state = 84},
  [658] = {.lex_state = 90},
  [659] = {.lex_state = 88},
  [660] = {.lex_state = 88},
  [661] = {.lex_state = 84},
  [662] = {.lex_state = 81},
  [663] = {.lex_state = 81},
  [664] = {.lex_state = 51},
  [665] = {.lex_state = 81},
  [666] = {.lex_state = 81},
  [667] = {.lex_state = 81},
  [668] = {.lex_state = 84},
  [669] = {.lex_state = 88},
  [670] = {.lex_state = 81},
  [671] = {.lex_state = 81},
  [672] = {.lex_state = 51},
  [673] = {.lex_state = 84},
  [674] = {.lex_state = 81},
  [675] = {.lex_state = 81},
  [676] = {.lex_state = 84},
  [677] = {.lex_state = 81},
  [678] = {.lex_state = 81},
  [679] = {.lex_state = 51},
  [680] = {.lex_state = 81},
  [681] = {.lex_state = 84},
  [682] = {.lex_state = 84},
  [683] = {.lex_state = 81},
  [684] = {.lex_state = 81},
  [685] = {.lex_state = 81},
  [686] = {.lex_state = 81},
  [687] = {.lex_state = 88},
  [688] = {.lex_state = 90},
  [689] = {.lex_state = 81},
  [690] = {.lex_state = 81},
  [691] = {.lex_state = 90},
  [692] = {.lex_state = 84},
  [693] = {.lex_state = 84},
  [694] = {.lex_state = 81},
  [695] = {.lex_state = 81},
  [696] = {.lex_state = 70},
  [697] = {.lex_state = 69},
  [698] = {.lex_state = 84},
  [699] = {.lex_state = 90},
  [700] = {.lex_state = 84},
  [701] = {.lex_state = 90},
  [702] = {.lex_state = 84},
  [703] = {.lex_state = 88},
  [704] = {.lex_state = 88},
  [705] = {.lex_state = 84},
  [706] = {.lex_state = 70},
  [707] = {.lex_state = 84},
  [708] = {.lex_state = 81},
  [709] = {.lex_state = 81},
  [710] = {.lex_state = 84},
  [711] = {.lex_state = 81},
  [712] = {.lex_state = 81},
  [713] = {.lex_state = 81},
  [714] = {.lex_state = 81},
  [715] = {.lex_state = 68},
  [716] = {.lex_state = 81},
  [717] = {.lex_state = 91},
  [718] = {.lex_state = 72},
  [719] = {.lex_state = 81},
  [720] = {.lex_state = 72},
  [721] = {.lex_state = 68},
  [722] = {.lex_state = 68},
  [723] = {.lex_state = 69},
  [724] = {.lex_state = 68},
  [725] = {.lex_state = 91},
  [726] = {.lex_state = 69},
  [727] = {.lex_state = 69},
  [728] = {.lex_state = 68},
  [729] = {.lex_state = 91},
  [730] = {.lex_state = 70},
  [731] = {.lex_state = 91},
  [732] = {.lex_state = 70},
  [733] = {.lex_state = 68},
  [734] = {.lex_state = 70},
  [735] = {.lex_state = 69},
  [736] = {.lex_state = 71},
  [737] = {.lex_state = 72},
  [738] = {.lex_state = 70},
  [739] = {.lex_state = 69},
  [740] = {.lex_state = 81},
  [741] = {.lex_state = 69},
  [742] = {.lex_state = 68},
  [743] = {.lex_state = 91},
  [744] = {.lex_state = 81},
  [745] = {.lex_state = 91},
  [746] = {.lex_state = 71},
  [747] = {.lex_state = 68},
  [748] = {.lex_state = 91},
  [749] = {.lex_state = 69},
  [750] = {.lex_state = 68},
  [751] = {.lex_state = 71},
  [752] = {.lex_state = 91},
  [753] = {.lex_state = 81},
  [754] = {.lex_state = 91},
  [755] = {.lex_state = 72},
  [756] = {.lex_state = 50},
  [757] = {.lex_state = 50},
  [758] = {.lex_state = 34},
  [759] = {.lex_state = 34},
  [760] = {.lex_state = 50},
  [761] = {.lex_state = 50},
  [762] = {.lex_state = 50},
  [763] = {.lex_state = 51},
  [764] = {.lex_state = 34},
  [765] = {.lex_state = 51},
  [766] = {.lex_state = 72},
  [767] = {.lex_state = 69},
  [768] = {.lex_state = 69},
  [769] = {.lex_state = 51},
  [770] = {.lex_state = 34},
  [771] = {.lex_state = 69},
  [772] = {.lex_state = 50},
  [773] = {.lex_state = 69},
  [774] = {.lex_state = 71},
  [775] = {.lex_state = 50},
  [776] = {.lex_state = 50},
  [777] = {.lex_state = 72},
  [778] = {.lex_state = 51},
  [779] = {.lex_state = 51},
  [780] = {.lex_state = 51},
  [781] = {.lex_state = 50},
  [782] = {.lex_state = 71},
  [783] = {.lex_state = 71},
  [784] = {.lex_state = 51},
  [785] = {.lex_state = 34},
  [786] = {.lex_state = 72},
  [787] = {.lex_state = 71},
  [788] = {.lex_state = 34},
  [789] = {.lex_state = 34},
  [790] = {.lex_state = 34},
  [791] = {.lex_state = 50},
  [792] = {.lex_state = 34},
  [793] = {.lex_state = 51},
  [794] = {.lex_state = 50},
  [795] = {.lex_state = 51},
  [796] = {.lex_state = 34},
  [797] = {.lex_state = 34},
  [798] = {.lex_state = 50},
  [799] = {.lex_state = 50},
  [800] = {.lex_state = 34},
  [801] = {.lex_state = 57},
  [802] = {.lex_state = 57},
  [803] = {.lex_state = 57},
  [804] = {.lex_state = 69},
  [805] = {.lex_state = 59},
  [806] = {.lex_state = 57},
  [807] = {.lex_state = 57},
  [808] = {.lex_state = 69},
  [809] = {.lex_state = 57},
  [810] = {.lex_state = 57},
  [811] = {.lex_state = 57},
  [812] = {.lex_state = 69},
  [813] = {.lex_state = 57},
  [814] = {.lex_state = 57},
  [815] = {.lex_state = 57},
  [816] = {.lex_state = 69},
  [817] = {.lex_state = 69},
  [818] = {.lex_state = 57},
  [819] = {.lex_state = 57},
  [820] = {.lex_state = 57},
  [821] = {.lex_state = 60},
  [822] = {.lex_state = 60},
  [823] = {.lex_state = 60},
  [824] = {.lex_state = 60},
  [825] = {.lex_state = 60},
  [826] = {.lex_state = 60},
  [827] = {.lex_state = 60},
  [828] = {.lex_state = 60},
  [829] = {.lex_state = 60},
  [830] = {.lex_state = 60},
  [831] = {.lex_state = 60},
  [832] = {.lex_state = 60},
  [833] = {.lex_state = 60},
  [834] = {.lex_state = 74},
  [835] = {.lex_state = 74},
  [836] = {.lex_state = 74},
  [837] = {.lex_state = 74},
  [838] = {.lex_state = 46},
  [839] = {.lex_state = 58},
  [840] = {.lex_state = 58},
  [841] = {.lex_state = 46},
  [842] = {.lex_state = 80},
  [843] = {.lex_state = 80},
  [844] = {.lex_state = 75},
  [845] = {.lex_state = 89},
  [846] = {.lex_state = 89},
  [847] = {.lex_state = 89},
  [848] = {.lex_state = 75},
  [849] = {.lex_state = 89},
  [850] = {.lex_state = 89},
  [851] = {.lex_state = 75},
  [852] = {.lex_state = 89},
  [853] = {.lex_state = 89},
  [854] = {.lex_state = 89},
  [855] = {.lex_state = 89},
  [856] = {.lex_state = 89},
  [857] = {.lex_state = 89},
  [858] = {.lex_state = 75},
  [859] = {.lex_state = 89},
  [860] = {.lex_state = 89},
  [861] = {.lex_state = 89},
  [862] = {.lex_state = 80},
  [863] = {.lex_state = 80},
  [864] = {.lex_state = 80},
  [865] = {.lex_state = 80},
  [866] = {.lex_state = 80},
  [867] = {.lex_state = 80},
  [868] = {.lex_state = 80},
  [869] = {.lex_state = 80},
  [870] = {.lex_state = 80},
  [871] = {.lex_state = 80},
  [872] = {.lex_state = 75},
  [873] = {.lex_state = 75},
  [874] = {.lex_state = 75},
  [875] = {.lex_state = 75},
  [876] = {.lex_state = 80},
  [877] = {.lex_state = 80},
  [878] = {.lex_state = 80},
  [879] = {.lex_state = 89},
  [880] = {.lex_state = 84},
  [881] = {.lex_state = 81},
  [882] = {.lex_state = 81},
  [883] = {.lex_state = 57},
  [884] = {.lex_state = 47},
  [885] = {.lex_state = 47},
  [886] = {.lex_state = 69},
  [887] = {.lex_state = 70},
  [888] = {.lex_state = 70},
  [889] = {.lex_state = 2},
  [890] = {.lex_state = 57},
  [891] = {.lex_state = 57},
  [892] = {.lex_state = 47},
  [893] = {.lex_state = 47},
  [894] = {.lex_state = 62},
  [895] = {.lex_state = 84},
  [896] = {.lex_state = 2},
  [897] = {.lex_state = 84},
  [898] = {.lex_state = 57},
  [899] = {.lex_state = 84},
  [900] = {.lex_state = 84},
  [901] = {.lex_state = 57},
  [902] = {.lex_state = 84},
  [903] = {.lex_state = 84},
  [904] = {.lex_state = 84},
  [905] = {.lex_state = 84},
  [906] = {.lex_state = 90},
  [907] = {.lex_state = 62},
  [908] = {.lex_state = 81},
  [909] = {.lex_state = 90},
  [910] = {.lex_state = 81},
  [911] = {.lex_state = 84},
  [912] = {.lex_state = 81},
  [913] = {.lex_state = 81},
  [914] = {.lex_state = 81},
  [915] = {.lex_state = 81},
  [916] = {.lex_state = 81},
  [917] = {.lex_state = 81},
  [918] = {.lex_state = 81},
  [919] = {.lex_state = 81},
  [920] = {.lex_state = 81},
  [921] = {.lex_state = 81},
  [922] = {.lex_state = 90},
  [923] = {.lex_state = 90},
  [924] = {.lex_state = 90},
  [925] = {.lex_state = 90},
  [926] = {.lex_state = 90},
  [927] = {.lex_state = 90},
  [928] = {.lex_state = 62},
  [929] = {.lex_state = 90},
  [930] = {.lex_state = 90},
  [931] = {.lex_state = 90},
  [932] = {.lex_state = 90},
  [933] = {.lex_state = 47},
  [934] = {.lex_state = 57},
  [935] = {.lex_state = 81},
  [936] = {.lex_state = 69},
  [937] = {.lex_state = 47},
  [938] = {.lex_state = 47},
  [939] = {.lex_state = 47},
  [940] = {.lex_state = 84},
  [941] = {.lex_state = 62},
  [942] = {.lex_state = 84},
  [943] = {.lex_state = 62},
  [944] = {.lex_state = 90},
  [945] = {.lex_state = 90},
  [946] = {.lex_state = 90},
  [947] = {.lex_state = 62},
  [948] = {.lex_state = 84},
  [949] = {.lex_state = 84},
  [950] = {.lex_state = 62},
  [951] = {.lex_state = 62},
  [952] = {.lex_state = 84},
  [953] = {.lex_state = 62},
  [954] = {.lex_state = 91},
  [955] = {.lex_state = 62},
  [956] = {.lex_state = 62},
  [957] = {.lex_state = 91},
  [958] = {.lex_state = 62},
  [959] = {.lex_state = 91},
  [960] = {.lex_state = 91},
  [961] = {.lex_state = 91},
  [962] = {.lex_state = 91},
  [963] = {.lex_state = 91},
  [964] = {.lex_state = 91},
  [965] = {.lex_state = 62},
  [966] = {.lex_state = 62},
  [967] = {.lex_state = 62},
  [968] = {.lex_state = 62},
  [969] = {.lex_state = 62},
  [970] = {.lex_state = 60},
  [971] = {.lex_state = 62},
  [972] = {.lex_state = 62},
  [973] = {.lex_state = 62},
  [974] = {.lex_state = 62},
  [975] = {.lex_state = 71},
  [976] = {.lex_state = 91},
  [977] = {.lex_state = 91},
  [978] = {.lex_state = 62},
  [979] = {.lex_state = 62},
  [980] = {.lex_state = 72},
  [981] = {.lex_state = 62},
  [982] = {.lex_state = 68},
  [983] = {.lex_state = 62},
  [984] = {.lex_state = 62},
  [985] = {.lex_state = 68},
  [986] = {.lex_state = 62},
  [987] = {.lex_state = 62},
  [988] = {.lex_state = 71},
  [989] = {.lex_state = 68},
  [990] = {.lex_state = 68},
  [991] = {.lex_state = 62},
  [992] = {.lex_state = 68},
  [993] = {.lex_state = 68},
  [994] = {.lex_state = 68},
  [995] = {.lex_state = 68},
  [996] = {.lex_state = 68},
  [997] = {.lex_state = 62},
  [998] = {.lex_state = 60},
  [999] = {.lex_state = 62},
  [1000] = {.lex_state = 72},
  [1001] = {.lex_state = 68},
  [1002] = {.lex_state = 62},
  [1003] = {.lex_state = 57},
  [1004] = {.lex_state = 106},
  [1005] = {.lex_state = 106},
  [1006] = {.lex_state = 57},
  [1007] = {.lex_state = 36},
  [1008] = {.lex_state = 57},
  [1009] = {.lex_state = 57},
  [1010] = {.lex_state = 36},
  [1011] = {.lex_state = 36},
  [1012] = {.lex_state = 36},
  [1013] = {.lex_state = 57},
  [1014] = {.lex_state = 57},
  [1015] = {.lex_state = 36},
  [1016] = {.lex_state = 36},
  [1017] = {.lex_state = 36},
  [1018] = {.lex_state = 57},
  [1019] = {.lex_state = 57},
  [1020] = {.lex_state = 57},
  [1021] = {.lex_state = 57},
  [1022] = {.lex_state = 36},
  [1023] = {.lex_state = 57},
  [1024] = {.lex_state = 57},
  [1025] = {.lex_state = 57},
  [1026] = {.lex_state = 36},
  [1027] = {.lex_state = 36},
  [1028] = {.lex_state = 36},
  [1029] = {.lex_state = 57},
  [1030] = {.lex_state = 36},
  [1031] = {.lex_state = 36},
  [1032] = {.lex_state = 106},
  [1033] = {.lex_state = 36},
  [1034] = {.lex_state = 57},
  [1035] = {.lex_state = 57},
  [1036] = {.lex_state = 36},
  [1037] = {.lex_state = 36},
  [1038] = {.lex_state = 36},
  [1039] = {.lex_state = 57},
  [1040] = {.lex_state = 106},
  [1041] = {.lex_state = 57},
  [1042] = {.lex_state = 36},
  [1043] = {.lex_state = 57},
  [1044] = {.lex_state = 57},
  [1045] = {.lex_state = 36},
  [1046] = {.lex_state = 57},
  [1047] = {.lex_state = 62},
  [1048] = {.lex_state = 36},
  [1049] = {.lex_state = 57},
  [1050] = {.lex_state = 36},
  [1051] = {.lex_state = 106},
  [1052] = {.lex_state = 36},
  [1053] = {.lex_state = 36},
  [1054] = {.lex_state = 36},
  [1055] = {.lex_state = 36},
  [1056] = {.lex_state = 36},
  [1057] = {.lex_state = 36},
  [1058] = {.lex_state = 36},
  [1059] = {.lex_state = 57},
  [1060] = {.lex_state = 36},
  [1061] = {.lex_state = 59},
  [1062] = {.lex_state = 70},
  [1063] = {.lex_state = 70},
  [1064] = {.lex_state = 70},
  [1065] = {.lex_state = 70},
  [1066] = {.lex_state = 59},
  [1067] = {.lex_state = 65},
  [1068] = {.lex_state = 36},
  [1069] = {.lex_state = 78},
  [1070] = {.lex_state = 70},
  [1071] = {.lex_state = 70},
  [1072] = {.lex_state = 70},
  [1073] = {.lex_state = 65},
  [1074] = {.lex_state = 78},
  [1075] = {.lex_state = 65},
  [1076] = {.lex_state = 70},
  [1077] = {.lex_state = 62},
  [1078] = {.lex_state = 106},
  [1079] = {.lex_state = 62},
  [1080] = {.lex_state = 65},
  [1081] = {.lex_state = 106},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 106},
  [1084] = {.lex_state = 106},
  [1085] = {.lex_state = 62},
  [1086] = {.lex_state = 57},
  [1087] = {.lex_state = 106},
  [1088] = {.lex_state = 57},
  [1089] = {.lex_state = 106},
  [1090] = {.lex_state = 57},
  [1091] = {.lex_state = 62},
  [1092] = {.lex_state = 62},
  [1093] = {.lex_state = 57},
  [1094] = {.lex_state = 62},
  [1095] = {.lex_state = 62},
  [1096] = {.lex_state = 62},
  [1097] = {.lex_state = 62},
  [1098] = {.lex_state = 106},
  [1099] = {.lex_state = 106},
  [1100] = {.lex_state = 106},
  [1101] = {.lex_state = 57},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 106},
  [1104] = {.lex_state = 106},
  [1105] = {.lex_state = 62},
  [1106] = {.lex_state = 62},
  [1107] = {.lex_state = 62},
  [1108] = {.lex_state = 62},
  [1109] = {.lex_state = 57},
  [1110] = {.lex_state = 62},
  [1111] = {.lex_state = 62},
  [1112] = {.lex_state = 62},
  [1113] = {.lex_state = 62},
  [1114] = {.lex_state = 62},
  [1115] = {.lex_state = 62},
  [1116] = {.lex_state = 106},
  [1117] = {.lex_state = 106},
  [1118] = {.lex_state = 106},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 106},
  [1121] = {.lex_state = 106},
  [1122] = {.lex_state = 62},
  [1123] = {.lex_state = 62},
  [1124] = {.lex_state = 62},
  [1125] = {.lex_state = 62},
  [1126] = {.lex_state = 62},
  [1127] = {.lex_state = 62},
  [1128] = {.lex_state = 62},
  [1129] = {.lex_state = 62},
  [1130] = {.lex_state = 57},
  [1131] = {.lex_state = 62},
  [1132] = {.lex_state = 57},
  [1133] = {.lex_state = 106},
  [1134] = {.lex_state = 106},
  [1135] = {.lex_state = 57},
  [1136] = {.lex_state = 106},
  [1137] = {.lex_state = 57},
  [1138] = {.lex_state = 106},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 57},
  [1141] = {.lex_state = 106},
  [1142] = {.lex_state = 106},
  [1143] = {.lex_state = 62},
  [1144] = {.lex_state = 62},
  [1145] = {.lex_state = 62},
  [1146] = {.lex_state = 62},
  [1147] = {.lex_state = 71},
  [1148] = {.lex_state = 62},
  [1149] = {.lex_state = 62},
  [1150] = {.lex_state = 62},
  [1151] = {.lex_state = 106},
  [1152] = {.lex_state = 62},
  [1153] = {.lex_state = 62},
  [1154] = {.lex_state = 62},
  [1155] = {.lex_state = 106},
  [1156] = {.lex_state = 106},
  [1157] = {.lex_state = 106},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 106},
  [1160] = {.lex_state = 106},
  [1161] = {.lex_state = 106},
  [1162] = {.lex_state = 62},
  [1163] = {.lex_state = 106},
  [1164] = {.lex_state = 48},
  [1165] = {.lex_state = 62},
  [1166] = {.lex_state = 62},
  [1167] = {.lex_state = 62},
  [1168] = {.lex_state = 106},
  [1169] = {.lex_state = 62},
  [1170] = {.lex_state = 106},
  [1171] = {.lex_state = 62},
  [1172] = {.lex_state = 106},
  [1173] = {.lex_state = 106},
  [1174] = {.lex_state = 106},
  [1175] = {.lex_state = 106},
  [1176] = {.lex_state = 62},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 106},
  [1179] = {.lex_state = 106},
  [1180] = {.lex_state = 106},
  [1181] = {.lex_state = 106},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 57},
  [1185] = {.lex_state = 62},
  [1186] = {.lex_state = 62},
  [1187] = {.lex_state = 62},
  [1188] = {.lex_state = 106},
  [1189] = {.lex_state = 106},
  [1190] = {.lex_state = 62},
  [1191] = {.lex_state = 62},
  [1192] = {.lex_state = 106},
  [1193] = {.lex_state = 62},
  [1194] = {.lex_state = 62},
  [1195] = {.lex_state = 106},
  [1196] = {.lex_state = 62},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 106},
  [1199] = {.lex_state = 62},
  [1200] = {.lex_state = 106},
  [1201] = {.lex_state = 62},
  [1202] = {.lex_state = 62},
  [1203] = {.lex_state = 62},
  [1204] = {.lex_state = 62},
  [1205] = {.lex_state = 62},
  [1206] = {.lex_state = 62},
  [1207] = {.lex_state = 62},
  [1208] = {.lex_state = 62},
  [1209] = {.lex_state = 62},
  [1210] = {.lex_state = 62},
  [1211] = {.lex_state = 62},
  [1212] = {.lex_state = 62},
  [1213] = {.lex_state = 62},
  [1214] = {.lex_state = 62},
  [1215] = {.lex_state = 106},
  [1216] = {.lex_state = 106},
  [1217] = {.lex_state = 62},
  [1218] = {.lex_state = 106},
  [1219] = {.lex_state = 62},
  [1220] = {.lex_state = 57},
  [1221] = {.lex_state = 62},
  [1222] = {.lex_state = 62},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 106},
  [1225] = {.lex_state = 62},
  [1226] = {.lex_state = 62},
  [1227] = {.lex_state = 106},
  [1228] = {.lex_state = 62},
  [1229] = {.lex_state = 62},
  [1230] = {.lex_state = 62},
  [1231] = {.lex_state = 62},
  [1232] = {.lex_state = 62},
  [1233] = {.lex_state = 62},
  [1234] = {.lex_state = 62},
  [1235] = {.lex_state = 48},
  [1236] = {.lex_state = 62},
  [1237] = {.lex_state = 57},
  [1238] = {.lex_state = 62},
  [1239] = {.lex_state = 62},
  [1240] = {.lex_state = 106},
  [1241] = {.lex_state = 62},
  [1242] = {.lex_state = 62},
  [1243] = {.lex_state = 62},
  [1244] = {.lex_state = 62},
  [1245] = {.lex_state = 62},
  [1246] = {.lex_state = 48},
  [1247] = {.lex_state = 62},
  [1248] = {.lex_state = 62},
  [1249] = {.lex_state = 57},
  [1250] = {.lex_state = 62},
  [1251] = {.lex_state = 62},
  [1252] = {.lex_state = 62},
  [1253] = {.lex_state = 62},
  [1254] = {.lex_state = 62},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 62},
  [1257] = {.lex_state = 62},
  [1258] = {.lex_state = 62},
  [1259] = {.lex_state = 62},
  [1260] = {.lex_state = 48},
  [1261] = {.lex_state = 57},
  [1262] = {.lex_state = 57},
  [1263] = {.lex_state = 62},
  [1264] = {.lex_state = 106},
  [1265] = {.lex_state = 62},
  [1266] = {.lex_state = 62},
  [1267] = {.lex_state = 106},
  [1268] = {.lex_state = 106},
  [1269] = {.lex_state = 106},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 57},
  [1272] = {.lex_state = 62},
  [1273] = {.lex_state = 62},
  [1274] = {.lex_state = 62},
  [1275] = {.lex_state = 62},
  [1276] = {.lex_state = 62},
  [1277] = {.lex_state = 62},
  [1278] = {.lex_state = 106},
  [1279] = {.lex_state = 62},
  [1280] = {.lex_state = 62},
  [1281] = {.lex_state = 62},
  [1282] = {.lex_state = 106},
  [1283] = {.lex_state = 62},
  [1284] = {.lex_state = 62},
  [1285] = {.lex_state = 106},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AMP_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_VPATH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_QMARK_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_endef] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_sinclude] = ACTIONS(1),
    [anon_sym_DASHinclude] = ACTIONS(1),
    [anon_sym_vpath] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_unexport] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_undefine] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_ifeq] = ACTIONS(1),
    [anon_sym_ifneq] = ACTIONS(1),
    [anon_sym_ifdef] = ACTIONS(1),
    [anon_sym_ifndef] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_AT2] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PLUS2] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT2] = ACTIONS(1),
    [anon_sym_LT2] = ACTIONS(1),
    [anon_sym_QMARK2] = ACTIONS(1),
    [anon_sym_CARET2] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [anon_sym_STAR2] = ACTIONS(1),
    [anon_sym_D] = ACTIONS(1),
    [anon_sym_F] = ACTIONS(1),
    [anon_sym_subst] = ACTIONS(1),
    [anon_sym_patsubst] = ACTIONS(1),
    [anon_sym_strip] = ACTIONS(1),
    [anon_sym_findstring] = ACTIONS(1),
    [anon_sym_filter] = ACTIONS(1),
    [anon_sym_filter_DASHout] = ACTIONS(1),
    [anon_sym_sort] = ACTIONS(1),
    [anon_sym_word] = ACTIONS(1),
    [anon_sym_words] = ACTIONS(1),
    [anon_sym_wordlist] = ACTIONS(1),
    [anon_sym_firstword] = ACTIONS(1),
    [anon_sym_lastword] = ACTIONS(1),
    [anon_sym_dir] = ACTIONS(1),
    [anon_sym_notdir] = ACTIONS(1),
    [anon_sym_suffix] = ACTIONS(1),
    [anon_sym_basename] = ACTIONS(1),
    [anon_sym_addsuffix] = ACTIONS(1),
    [anon_sym_addprefix] = ACTIONS(1),
    [anon_sym_join] = ACTIONS(1),
    [anon_sym_wildcard] = ACTIONS(1),
    [anon_sym_realpath] = ACTIONS(1),
    [anon_sym_abspath] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_warning] = ACTIONS(1),
    [anon_sym_info] = ACTIONS(1),
    [anon_sym_origin] = ACTIONS(1),
    [anon_sym_flavor] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [anon_sym_eval] = ACTIONS(1),
    [anon_sym_file] = ACTIONS(1),
    [anon_sym_value] = ACTIONS(1),
    [anon_sym_shell] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_SEMI2] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_RPAREN2] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_makefile] = STATE(1255),
    [sym__thing] = STATE(25),
    [sym_rule] = STATE(25),
    [sym__ordinary_rule] = STATE(261),
    [sym__static_pattern_rule] = STATE(258),
    [sym__variable_definition] = STATE(25),
    [sym_VPATH_assignment] = STATE(25),
    [sym_RECIPEPREFIX_assignment] = STATE(25),
    [sym_variable_assignment] = STATE(25),
    [sym_shell_assignment] = STATE(25),
    [sym_define_directive] = STATE(25),
    [sym__directive] = STATE(25),
    [sym_include_directive] = STATE(25),
    [sym_vpath_directive] = STATE(25),
    [sym_export_directive] = STATE(25),
    [sym_unexport_directive] = STATE(25),
    [sym_override_directive] = STATE(25),
    [sym_undefine_directive] = STATE(25),
    [sym_private_directive] = STATE(25),
    [sym_conditional] = STATE(25),
    [sym__conditional_directives] = STATE(3),
    [sym_ifeq_directive] = STATE(3),
    [sym_ifneq_directive] = STATE(3),
    [sym_ifdef_directive] = STATE(3),
    [sym_ifndef_directive] = STATE(3),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(191),
    [sym_function_call] = STATE(191),
    [sym_shell_function] = STATE(191),
    [sym_list] = STATE(1051),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [aux_sym_makefile_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_VPATH] = ACTIONS(9),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(11),
    [anon_sym_define] = ACTIONS(13),
    [anon_sym_include] = ACTIONS(15),
    [anon_sym_sinclude] = ACTIONS(15),
    [anon_sym_DASHinclude] = ACTIONS(15),
    [anon_sym_vpath] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_unexport] = ACTIONS(21),
    [anon_sym_override] = ACTIONS(23),
    [anon_sym_undefine] = ACTIONS(25),
    [anon_sym_private] = ACTIONS(27),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__thing] = STATE(9),
    [sym_rule] = STATE(9),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(9),
    [sym__variable_definition] = STATE(9),
    [sym_VPATH_assignment] = STATE(9),
    [sym_RECIPEPREFIX_assignment] = STATE(9),
    [sym_variable_assignment] = STATE(9),
    [sym_shell_assignment] = STATE(9),
    [sym_define_directive] = STATE(9),
    [sym__directive] = STATE(9),
    [sym_include_directive] = STATE(9),
    [sym_vpath_directive] = STATE(9),
    [sym_export_directive] = STATE(9),
    [sym_unexport_directive] = STATE(9),
    [sym_override_directive] = STATE(9),
    [sym_undefine_directive] = STATE(9),
    [sym_private_directive] = STATE(9),
    [sym_conditional] = STATE(9),
    [sym_elsif_directive] = STATE(934),
    [sym_else_directive] = STATE(1184),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(9),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(934),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(67),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
  [3] = {
    [sym__thing] = STATE(2),
    [sym_rule] = STATE(2),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(2),
    [sym__variable_definition] = STATE(2),
    [sym_VPATH_assignment] = STATE(2),
    [sym_RECIPEPREFIX_assignment] = STATE(2),
    [sym_variable_assignment] = STATE(2),
    [sym_shell_assignment] = STATE(2),
    [sym_define_directive] = STATE(2),
    [sym__directive] = STATE(2),
    [sym_include_directive] = STATE(2),
    [sym_vpath_directive] = STATE(2),
    [sym_export_directive] = STATE(2),
    [sym_unexport_directive] = STATE(2),
    [sym_override_directive] = STATE(2),
    [sym_undefine_directive] = STATE(2),
    [sym_private_directive] = STATE(2),
    [sym_conditional] = STATE(2),
    [sym_elsif_directive] = STATE(883),
    [sym_else_directive] = STATE(1093),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(2),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(883),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(79),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
  [4] = {
    [sym__thing] = STATE(9),
    [sym_rule] = STATE(9),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(9),
    [sym__variable_definition] = STATE(9),
    [sym_VPATH_assignment] = STATE(9),
    [sym_RECIPEPREFIX_assignment] = STATE(9),
    [sym_variable_assignment] = STATE(9),
    [sym_shell_assignment] = STATE(9),
    [sym_define_directive] = STATE(9),
    [sym__directive] = STATE(9),
    [sym_include_directive] = STATE(9),
    [sym_vpath_directive] = STATE(9),
    [sym_export_directive] = STATE(9),
    [sym_unexport_directive] = STATE(9),
    [sym_override_directive] = STATE(9),
    [sym_undefine_directive] = STATE(9),
    [sym_private_directive] = STATE(9),
    [sym_conditional] = STATE(9),
    [sym_elsif_directive] = STATE(891),
    [sym_else_directive] = STATE(1088),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(9),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(891),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
  [5] = {
    [sym__thing] = STATE(9),
    [sym_rule] = STATE(9),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(9),
    [sym__variable_definition] = STATE(9),
    [sym_VPATH_assignment] = STATE(9),
    [sym_RECIPEPREFIX_assignment] = STATE(9),
    [sym_variable_assignment] = STATE(9),
    [sym_shell_assignment] = STATE(9),
    [sym_define_directive] = STATE(9),
    [sym__directive] = STATE(9),
    [sym_include_directive] = STATE(9),
    [sym_vpath_directive] = STATE(9),
    [sym_export_directive] = STATE(9),
    [sym_unexport_directive] = STATE(9),
    [sym_override_directive] = STATE(9),
    [sym_undefine_directive] = STATE(9),
    [sym_private_directive] = STATE(9),
    [sym_conditional] = STATE(9),
    [sym_elsif_directive] = STATE(901),
    [sym_else_directive] = STATE(1135),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(9),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(901),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(83),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
  [6] = {
    [sym__thing] = STATE(5),
    [sym_rule] = STATE(5),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(5),
    [sym__variable_definition] = STATE(5),
    [sym_VPATH_assignment] = STATE(5),
    [sym_RECIPEPREFIX_assignment] = STATE(5),
    [sym_variable_assignment] = STATE(5),
    [sym_shell_assignment] = STATE(5),
    [sym_define_directive] = STATE(5),
    [sym__directive] = STATE(5),
    [sym_include_directive] = STATE(5),
    [sym_vpath_directive] = STATE(5),
    [sym_export_directive] = STATE(5),
    [sym_unexport_directive] = STATE(5),
    [sym_override_directive] = STATE(5),
    [sym_undefine_directive] = STATE(5),
    [sym_private_directive] = STATE(5),
    [sym_conditional] = STATE(5),
    [sym_elsif_directive] = STATE(898),
    [sym_else_directive] = STATE(1130),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(5),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(898),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(85),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
  [7] = {
    [sym__thing] = STATE(4),
    [sym_rule] = STATE(4),
    [sym__ordinary_rule] = STATE(94),
    [sym__static_pattern_rule] = STATE(95),
    [sym__prefixed_recipe_line] = STATE(4),
    [sym__variable_definition] = STATE(4),
    [sym_VPATH_assignment] = STATE(4),
    [sym_RECIPEPREFIX_assignment] = STATE(4),
    [sym_variable_assignment] = STATE(4),
    [sym_shell_assignment] = STATE(4),
    [sym_define_directive] = STATE(4),
    [sym__directive] = STATE(4),
    [sym_include_directive] = STATE(4),
    [sym_vpath_directive] = STATE(4),
    [sym_export_directive] = STATE(4),
    [sym_unexport_directive] = STATE(4),
    [sym_override_directive] = STATE(4),
    [sym_undefine_directive] = STATE(4),
    [sym_private_directive] = STATE(4),
    [sym_conditional] = STATE(4),
    [sym_elsif_directive] = STATE(890),
    [sym_else_directive] = STATE(1261),
    [sym__conditional_directives] = STATE(7),
    [aux_sym__conditional_consequence] = STATE(4),
    [sym_ifeq_directive] = STATE(7),
    [sym_ifneq_directive] = STATE(7),
    [sym_ifdef_directive] = STATE(7),
    [sym_ifndef_directive] = STATE(7),
    [sym__variable] = STATE(190),
    [sym_variable_reference] = STATE(190),
    [sym_substitution_reference] = STATE(190),
    [sym_automatic_variable] = STATE(190),
    [sym__function] = STATE(207),
    [sym_function_call] = STATE(207),
    [sym_shell_function] = STATE(207),
    [sym_list] = STATE(1004),
    [sym_concatenation] = STATE(190),
    [sym_string] = STATE(190),
    [sym_archive] = STATE(190),
    [sym__recipeprefix] = STATE(383),
    [aux_sym_conditional_repeat1] = STATE(890),
    [sym_word] = ACTIONS(45),
    [anon_sym_VPATH] = ACTIONS(47),
    [anon_sym_DOTRECIPEPREFIX] = ACTIONS(49),
    [anon_sym_define] = ACTIONS(51),
    [anon_sym_include] = ACTIONS(53),
    [anon_sym_sinclude] = ACTIONS(53),
    [anon_sym_DASHinclude] = ACTIONS(53),
    [anon_sym_vpath] = ACTIONS(55),
    [anon_sym_export] = ACTIONS(57),
    [anon_sym_unexport] = ACTIONS(59),
    [anon_sym_override] = ACTIONS(61),
    [anon_sym_undefine] = ACTIONS(63),
    [anon_sym_private] = ACTIONS(65),
    [anon_sym_endif] = ACTIONS(87),
    [anon_sym_else] = ACTIONS(69),
    [anon_sym_ifeq] = ACTIONS(29),
    [anon_sym_ifneq] = ACTIONS(31),
    [anon_sym_ifdef] = ACTIONS(33),
    [anon_sym_ifndef] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(73),
    [anon_sym_TAB] = ACTIONS(75),
    [sym_comment] = ACTIONS(77),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(45), 1,
      sym_word,
    ACTIONS(47), 1,
      anon_sym_VPATH,
    ACTIONS(49), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(51), 1,
      anon_sym_define,
    ACTIONS(55), 1,
      anon_sym_vpath,
    ACTIONS(57), 1,
      anon_sym_export,
    ACTIONS(59), 1,
      anon_sym_unexport,
    ACTIONS(61), 1,
      anon_sym_override,
    ACTIONS(63), 1,
      anon_sym_undefine,
    ACTIONS(65), 1,
      anon_sym_private,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(94), 1,
      sym__ordinary_rule,
    STATE(95), 1,
      sym__static_pattern_rule,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(1004), 1,
      sym_list,
    ACTIONS(37), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(89), 2,
      anon_sym_endif,
      anon_sym_else,
    ACTIONS(53), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(207), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(10), 19,
      sym__thing,
      sym_rule,
      sym__prefixed_recipe_line,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym__conditional_consequence,
  [122] = 29,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_word,
    ACTIONS(94), 1,
      anon_sym_VPATH,
    ACTIONS(97), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(100), 1,
      anon_sym_define,
    ACTIONS(106), 1,
      anon_sym_vpath,
    ACTIONS(109), 1,
      anon_sym_export,
    ACTIONS(112), 1,
      anon_sym_unexport,
    ACTIONS(115), 1,
      anon_sym_override,
    ACTIONS(118), 1,
      anon_sym_undefine,
    ACTIONS(121), 1,
      anon_sym_private,
    ACTIONS(126), 1,
      anon_sym_ifeq,
    ACTIONS(129), 1,
      anon_sym_ifneq,
    ACTIONS(132), 1,
      anon_sym_ifdef,
    ACTIONS(135), 1,
      anon_sym_ifndef,
    ACTIONS(141), 1,
      anon_sym_DQUOTE,
    ACTIONS(144), 1,
      anon_sym_SQUOTE,
    ACTIONS(147), 1,
      anon_sym_TAB,
    STATE(94), 1,
      sym__ordinary_rule,
    STATE(95), 1,
      sym__static_pattern_rule,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(1004), 1,
      sym_list,
    ACTIONS(124), 2,
      anon_sym_endif,
      anon_sym_else,
    ACTIONS(138), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(103), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(207), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(9), 19,
      sym__thing,
      sym_rule,
      sym__prefixed_recipe_line,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym__conditional_consequence,
  [244] = 29,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(45), 1,
      sym_word,
    ACTIONS(47), 1,
      anon_sym_VPATH,
    ACTIONS(49), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(51), 1,
      anon_sym_define,
    ACTIONS(55), 1,
      anon_sym_vpath,
    ACTIONS(57), 1,
      anon_sym_export,
    ACTIONS(59), 1,
      anon_sym_unexport,
    ACTIONS(61), 1,
      anon_sym_override,
    ACTIONS(63), 1,
      anon_sym_undefine,
    ACTIONS(65), 1,
      anon_sym_private,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(94), 1,
      sym__ordinary_rule,
    STATE(95), 1,
      sym__static_pattern_rule,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(1004), 1,
      sym_list,
    ACTIONS(37), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(150), 2,
      anon_sym_endif,
      anon_sym_else,
    ACTIONS(53), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(207), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(9), 19,
      sym__thing,
      sym_rule,
      sym__prefixed_recipe_line,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym__conditional_consequence,
  [366] = 29,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(45), 1,
      sym_word,
    ACTIONS(47), 1,
      anon_sym_VPATH,
    ACTIONS(49), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(51), 1,
      anon_sym_define,
    ACTIONS(55), 1,
      anon_sym_vpath,
    ACTIONS(57), 1,
      anon_sym_export,
    ACTIONS(59), 1,
      anon_sym_unexport,
    ACTIONS(61), 1,
      anon_sym_override,
    ACTIONS(63), 1,
      anon_sym_undefine,
    ACTIONS(65), 1,
      anon_sym_private,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_endif,
    STATE(94), 1,
      sym__ordinary_rule,
    STATE(95), 1,
      sym__static_pattern_rule,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(1004), 1,
      sym_list,
    ACTIONS(37), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(53), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(207), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(12), 19,
      sym__thing,
      sym_rule,
      sym__prefixed_recipe_line,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym__conditional_consequence,
  [487] = 29,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(45), 1,
      sym_word,
    ACTIONS(47), 1,
      anon_sym_VPATH,
    ACTIONS(49), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(51), 1,
      anon_sym_define,
    ACTIONS(55), 1,
      anon_sym_vpath,
    ACTIONS(57), 1,
      anon_sym_export,
    ACTIONS(59), 1,
      anon_sym_unexport,
    ACTIONS(61), 1,
      anon_sym_override,
    ACTIONS(63), 1,
      anon_sym_undefine,
    ACTIONS(65), 1,
      anon_sym_private,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(154), 1,
      anon_sym_endif,
    STATE(94), 1,
      sym__ordinary_rule,
    STATE(95), 1,
      sym__static_pattern_rule,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(1004), 1,
      sym_list,
    ACTIONS(37), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(53), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(207), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(9), 19,
      sym__thing,
      sym_rule,
      sym__prefixed_recipe_line,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym__conditional_consequence,
  [608] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      sym_word,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(166), 1,
      anon_sym_shell,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(158), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(418), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(164), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [689] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      sym_word,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_shell,
    ACTIONS(158), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(418), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(172), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [770] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(176), 1,
      sym_word,
    ACTIONS(182), 1,
      anon_sym_shell,
    ACTIONS(178), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(403), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(180), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [851] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_shell,
    ACTIONS(184), 1,
      sym_word,
    ACTIONS(186), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(422), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(172), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [932] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(188), 1,
      sym_word,
    ACTIONS(194), 1,
      anon_sym_shell,
    ACTIONS(190), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(398), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(192), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1013] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_word,
    ACTIONS(202), 1,
      anon_sym_shell,
    ACTIONS(198), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(415), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(200), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1094] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_word,
    ACTIONS(210), 1,
      anon_sym_shell,
    ACTIONS(206), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(407), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(208), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1175] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(212), 1,
      sym_word,
    ACTIONS(218), 1,
      anon_sym_shell,
    ACTIONS(214), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(373), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(216), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1256] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(220), 1,
      sym_word,
    ACTIONS(226), 1,
      anon_sym_shell,
    ACTIONS(222), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(379), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(224), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1337] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(228), 1,
      sym_word,
    ACTIONS(234), 1,
      anon_sym_shell,
    ACTIONS(230), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(385), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(232), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1418] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(236), 1,
      sym_word,
    ACTIONS(242), 1,
      anon_sym_shell,
    ACTIONS(238), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(391), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(240), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1499] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(244), 1,
      sym_word,
    ACTIONS(250), 1,
      anon_sym_shell,
    ACTIONS(246), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(397), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
    ACTIONS(248), 35,
      anon_sym_subst,
      anon_sym_patsubst,
      anon_sym_strip,
      anon_sym_findstring,
      anon_sym_filter,
      anon_sym_filter_DASHout,
      anon_sym_sort,
      anon_sym_word,
      anon_sym_words,
      anon_sym_wordlist,
      anon_sym_firstword,
      anon_sym_lastword,
      anon_sym_dir,
      anon_sym_notdir,
      anon_sym_suffix,
      anon_sym_basename,
      anon_sym_addsuffix,
      anon_sym_addprefix,
      anon_sym_join,
      anon_sym_wildcard,
      anon_sym_realpath,
      anon_sym_abspath,
      anon_sym_error,
      anon_sym_warning,
      anon_sym_info,
      anon_sym_origin,
      anon_sym_flavor,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_or,
      anon_sym_and,
      anon_sym_call,
      anon_sym_eval,
      anon_sym_file,
      anon_sym_value,
  [1580] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_word,
    ACTIONS(9), 1,
      anon_sym_VPATH,
    ACTIONS(11), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(13), 1,
      anon_sym_define,
    ACTIONS(17), 1,
      anon_sym_vpath,
    ACTIONS(19), 1,
      anon_sym_export,
    ACTIONS(21), 1,
      anon_sym_unexport,
    ACTIONS(23), 1,
      anon_sym_override,
    ACTIONS(25), 1,
      anon_sym_undefine,
    ACTIONS(27), 1,
      anon_sym_private,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(252), 1,
      ts_builtin_sym_end,
    STATE(258), 1,
      sym__static_pattern_rule,
    STATE(261), 1,
      sym__ordinary_rule,
    STATE(1051), 1,
      sym_list,
    ACTIONS(15), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(191), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(3), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(26), 18,
      sym__thing,
      sym_rule,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym_makefile_repeat1,
  [1696] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      ts_builtin_sym_end,
    ACTIONS(256), 1,
      sym_word,
    ACTIONS(259), 1,
      anon_sym_VPATH,
    ACTIONS(262), 1,
      anon_sym_DOTRECIPEPREFIX,
    ACTIONS(265), 1,
      anon_sym_define,
    ACTIONS(271), 1,
      anon_sym_vpath,
    ACTIONS(274), 1,
      anon_sym_export,
    ACTIONS(277), 1,
      anon_sym_unexport,
    ACTIONS(280), 1,
      anon_sym_override,
    ACTIONS(283), 1,
      anon_sym_undefine,
    ACTIONS(286), 1,
      anon_sym_private,
    ACTIONS(289), 1,
      anon_sym_ifeq,
    ACTIONS(292), 1,
      anon_sym_ifneq,
    ACTIONS(295), 1,
      anon_sym_ifdef,
    ACTIONS(298), 1,
      anon_sym_ifndef,
    ACTIONS(301), 1,
      anon_sym_DOLLAR,
    ACTIONS(304), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(307), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      anon_sym_SQUOTE,
    STATE(258), 1,
      sym__static_pattern_rule,
    STATE(261), 1,
      sym__ordinary_rule,
    STATE(1051), 1,
      sym_list,
    ACTIONS(268), 3,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
    STATE(191), 3,
      sym__function,
      sym_function_call,
      sym_shell_function,
    STATE(3), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    STATE(190), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym_concatenation,
      sym_string,
      sym_archive,
    STATE(26), 18,
      sym__thing,
      sym_rule,
      sym__variable_definition,
      sym_VPATH_assignment,
      sym_RECIPEPREFIX_assignment,
      sym_variable_assignment,
      sym_shell_assignment,
      sym_define_directive,
      sym__directive,
      sym_include_directive,
      sym_vpath_directive,
      sym_export_directive,
      sym_unexport_directive,
      sym_override_directive,
      sym_undefine_directive,
      sym_private_directive,
      sym_conditional,
      aux_sym_makefile_repeat1,
  [1812] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(313), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [1867] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(33), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(315), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [1922] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(317), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [1977] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(319), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2032] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(36), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(315), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2087] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(319), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2142] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(323), 1,
      anon_sym_ifeq,
    ACTIONS(326), 1,
      anon_sym_ifneq,
    ACTIONS(329), 1,
      anon_sym_ifdef,
    ACTIONS(332), 1,
      anon_sym_ifndef,
    ACTIONS(335), 1,
      anon_sym_TAB,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(33), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(321), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2197] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(338), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2252] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(340), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2307] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(33), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(342), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2362] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(344), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2417] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(338), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2472] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(346), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2527] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(348), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2582] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(350), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2637] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(352), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2692] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(354), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2747] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(350), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2802] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(356), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2857] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(358), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2912] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(360), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [2967] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(362), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3022] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(356), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3077] = 10,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(75), 1,
      anon_sym_TAB,
    ACTIONS(77), 1,
      sym_comment,
    STATE(383), 1,
      sym__recipeprefix,
    STATE(28), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(7), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(364), 19,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3132] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(366), 1,
      ts_builtin_sym_end,
    ACTIONS(368), 1,
      anon_sym_TAB,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(68), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(315), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3188] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(370), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(338), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3244] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(372), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(346), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3300] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(374), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(348), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3356] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(376), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(350), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3412] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(378), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(352), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3468] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(380), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(354), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3524] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(376), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(350), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3580] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(382), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(356), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3636] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(384), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(358), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3692] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(386), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(360), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3748] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(388), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(362), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3804] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(382), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(356), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3860] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(390), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(364), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3916] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(392), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(319), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [3972] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(370), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(338), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4028] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(394), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(340), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4084] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(396), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(74), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(342), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4140] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(398), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(313), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4196] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(400), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(344), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4252] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(366), 1,
      ts_builtin_sym_end,
    ACTIONS(368), 1,
      anon_sym_TAB,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(74), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(315), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4308] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(402), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(317), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4364] = 11,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_TAB,
    ACTIONS(392), 1,
      ts_builtin_sym_end,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(71), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(319), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4420] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(323), 1,
      anon_sym_ifeq,
    ACTIONS(326), 1,
      anon_sym_ifneq,
    ACTIONS(329), 1,
      anon_sym_ifdef,
    ACTIONS(332), 1,
      anon_sym_ifndef,
    ACTIONS(404), 1,
      ts_builtin_sym_end,
    ACTIONS(406), 1,
      anon_sym_TAB,
    STATE(412), 1,
      sym__recipeprefix,
    STATE(74), 3,
      sym__prefixed_recipe_line,
      sym_conditional,
      aux_sym_recipe_repeat1,
    STATE(6), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
    ACTIONS(321), 17,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [4476] = 13,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(413), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(417), 1,
      anon_sym_BANG_EQ,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(415), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4533] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(429), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(431), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4590] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(443), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(445), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4647] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(447), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(449), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4704] = 13,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(451), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(455), 1,
      anon_sym_BANG_EQ,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(453), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4761] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(457), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(459), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4818] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(411), 1,
      anon_sym_COLON,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(461), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(415), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4873] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(411), 1,
      anon_sym_COLON,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(463), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(453), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4928] = 12,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(411), 1,
      anon_sym_COLON,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(465), 1,
      aux_sym__ordinary_rule_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(453), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [4980] = 12,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(411), 1,
      anon_sym_COLON,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(467), 1,
      aux_sym__ordinary_rule_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(415), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [5032] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(473), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(475), 1,
      anon_sym_LPAREN2,
    ACTIONS(477), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(483), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(485), 1,
      aux_sym_text_token1,
    ACTIONS(469), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(481), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
    STATE(635), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [5081] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(491), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(493), 1,
      anon_sym_LPAREN2,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(497), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(501), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(503), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(487), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(499), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
    STATE(610), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [5130] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(507), 1,
      anon_sym_TAB,
    ACTIONS(505), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5162] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(511), 1,
      anon_sym_TAB,
    ACTIONS(509), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5194] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(515), 1,
      anon_sym_TAB,
    ACTIONS(513), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5226] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(519), 1,
      anon_sym_TAB,
    ACTIONS(517), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5258] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(523), 1,
      anon_sym_TAB,
    ACTIONS(521), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5290] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      sym_word,
    ACTIONS(529), 1,
      anon_sym_AMP_COLON,
    ACTIONS(533), 1,
      anon_sym_BANG_EQ,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(531), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [5338] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(539), 1,
      anon_sym_TAB,
    ACTIONS(537), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5370] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_TAB,
    ACTIONS(541), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5402] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_TAB,
    ACTIONS(545), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5434] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(551), 1,
      anon_sym_TAB,
    ACTIONS(549), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5466] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(555), 1,
      anon_sym_TAB,
    ACTIONS(553), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5498] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_TAB,
    ACTIONS(557), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5530] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_TAB,
    ACTIONS(561), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5562] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(567), 1,
      anon_sym_TAB,
    ACTIONS(565), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5594] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(571), 1,
      anon_sym_TAB,
    ACTIONS(569), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5626] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(575), 1,
      anon_sym_TAB,
    ACTIONS(573), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5658] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(579), 1,
      anon_sym_TAB,
    ACTIONS(577), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5690] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_TAB,
    ACTIONS(581), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5722] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_TAB,
    ACTIONS(585), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5754] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(591), 1,
      anon_sym_TAB,
    ACTIONS(589), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5786] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(595), 1,
      anon_sym_TAB,
    ACTIONS(593), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5818] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(599), 1,
      anon_sym_TAB,
    ACTIONS(597), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5850] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(487), 1,
      aux_sym_list_token1,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(603), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(605), 1,
      anon_sym_LPAREN2,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    ACTIONS(609), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(613), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(611), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
    STATE(699), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [5898] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_TAB,
    ACTIONS(313), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5930] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(619), 1,
      anon_sym_TAB,
    ACTIONS(617), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5962] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_TAB,
    ACTIONS(621), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [5994] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_TAB,
    ACTIONS(625), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6026] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(631), 1,
      anon_sym_TAB,
    ACTIONS(629), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6058] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(635), 1,
      anon_sym_TAB,
    ACTIONS(633), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6090] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_TAB,
    ACTIONS(637), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6122] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(643), 1,
      anon_sym_TAB,
    ACTIONS(641), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6154] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_TAB,
    ACTIONS(645), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6186] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(402), 1,
      anon_sym_TAB,
    ACTIONS(317), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6218] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(392), 1,
      anon_sym_TAB,
    ACTIONS(319), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6250] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(392), 1,
      anon_sym_TAB,
    ACTIONS(319), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6282] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_TAB,
    ACTIONS(649), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6314] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_TAB,
    ACTIONS(653), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6346] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(659), 1,
      anon_sym_TAB,
    ACTIONS(657), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6378] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(663), 1,
      anon_sym_TAB,
    ACTIONS(661), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6410] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(667), 1,
      anon_sym_TAB,
    ACTIONS(665), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6442] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_TAB,
    ACTIONS(669), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6474] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_TAB,
    ACTIONS(673), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6506] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_TAB,
    ACTIONS(677), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6538] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(683), 1,
      anon_sym_TAB,
    ACTIONS(681), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6570] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(687), 1,
      anon_sym_TAB,
    ACTIONS(685), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6602] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_TAB,
    ACTIONS(338), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6634] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(394), 1,
      anon_sym_TAB,
    ACTIONS(340), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6666] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_TAB,
    ACTIONS(689), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6698] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(400), 1,
      anon_sym_TAB,
    ACTIONS(344), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6730] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_TAB,
    ACTIONS(338), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6762] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(695), 1,
      anon_sym_TAB,
    ACTIONS(693), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6794] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(699), 1,
      anon_sym_TAB,
    ACTIONS(697), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6826] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(703), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [6870] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(707), 1,
      anon_sym_TAB,
    ACTIONS(705), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6902] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_TAB,
    ACTIONS(709), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6934] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(715), 1,
      anon_sym_TAB,
    ACTIONS(713), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6966] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(372), 1,
      anon_sym_TAB,
    ACTIONS(346), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [6998] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(719), 1,
      anon_sym_TAB,
    ACTIONS(717), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7030] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_TAB,
    ACTIONS(348), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7062] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(723), 1,
      anon_sym_TAB,
    ACTIONS(721), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7094] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(727), 1,
      anon_sym_TAB,
    ACTIONS(725), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7126] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(731), 1,
      anon_sym_TAB,
    ACTIONS(729), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7158] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_TAB,
    ACTIONS(733), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7190] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(376), 1,
      anon_sym_TAB,
    ACTIONS(350), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7222] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_TAB,
    ACTIONS(352), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7254] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(380), 1,
      anon_sym_TAB,
    ACTIONS(354), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7286] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(376), 1,
      anon_sym_TAB,
    ACTIONS(350), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7318] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(739), 1,
      anon_sym_TAB,
    ACTIONS(737), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7350] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(743), 1,
      anon_sym_TAB,
    ACTIONS(741), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7382] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(747), 1,
      anon_sym_TAB,
    ACTIONS(745), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7414] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(751), 1,
      anon_sym_TAB,
    ACTIONS(749), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7446] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_TAB,
    ACTIONS(753), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7478] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(759), 1,
      anon_sym_TAB,
    ACTIONS(757), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7510] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(763), 1,
      anon_sym_TAB,
    ACTIONS(761), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7542] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(767), 1,
      anon_sym_TAB,
    ACTIONS(765), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7574] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(382), 1,
      anon_sym_TAB,
    ACTIONS(356), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7606] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(769), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [7650] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_TAB,
    ACTIONS(358), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7682] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(771), 1,
      aux_sym__thing_token1,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(777), 1,
      anon_sym_LPAREN2,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(785), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(787), 1,
      aux_sym_text_token1,
    ACTIONS(783), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
    STATE(698), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [7730] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_TAB,
    ACTIONS(360), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7762] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(791), 1,
      anon_sym_TAB,
    ACTIONS(789), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7794] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(795), 1,
      anon_sym_TAB,
    ACTIONS(793), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7826] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(799), 1,
      anon_sym_TAB,
    ACTIONS(797), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7858] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(388), 1,
      anon_sym_TAB,
    ACTIONS(362), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7890] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(382), 1,
      anon_sym_TAB,
    ACTIONS(356), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7922] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_TAB,
    ACTIONS(801), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7954] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(807), 1,
      anon_sym_TAB,
    ACTIONS(805), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [7986] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(811), 1,
      anon_sym_TAB,
    ACTIONS(809), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8018] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(815), 1,
      anon_sym_TAB,
    ACTIONS(813), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8050] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_TAB,
    ACTIONS(817), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8082] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(823), 1,
      anon_sym_TAB,
    ACTIONS(821), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8114] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_TAB,
    ACTIONS(825), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8146] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(390), 1,
      anon_sym_TAB,
    ACTIONS(364), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8178] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(831), 1,
      anon_sym_TAB,
    ACTIONS(829), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8210] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(835), 1,
      anon_sym_TAB,
    ACTIONS(833), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8242] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_TAB,
    ACTIONS(837), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8274] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(469), 1,
      anon_sym_RPAREN,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(843), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(845), 1,
      anon_sym_LPAREN2,
    ACTIONS(847), 1,
      anon_sym_LBRACE,
    ACTIONS(849), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(853), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(855), 1,
      aux_sym_text_token1,
    ACTIONS(851), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
    STATE(713), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [8322] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      sym_word,
    ACTIONS(529), 1,
      anon_sym_AMP_COLON,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(859), 1,
      anon_sym_BANG_EQ,
    ACTIONS(527), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(857), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8370] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(861), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8414] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(863), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8458] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(867), 1,
      anon_sym_TAB,
    ACTIONS(865), 23,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [8490] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(869), 1,
      sym_word,
    ACTIONS(871), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(369), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8531] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(873), 1,
      sym_word,
    ACTIONS(875), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(405), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8572] = 11,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(427), 1,
      anon_sym_RPAREN2,
    ACTIONS(877), 1,
      aux_sym__ordinary_rule_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8619] = 11,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(877), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(879), 1,
      aux_sym__thing_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8666] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(883), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(881), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8701] = 14,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(885), 1,
      sym_word,
    ACTIONS(887), 1,
      aux_sym__thing_token1,
    ACTIONS(889), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(891), 1,
      anon_sym_PIPE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    STATE(296), 1,
      sym_recipe,
    STATE(907), 1,
      sym__normal_prerequisites,
    STATE(978), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8754] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(895), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8801] = 14,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(887), 1,
      aux_sym__thing_token1,
    ACTIONS(891), 1,
      anon_sym_PIPE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(899), 1,
      aux_sym__ordinary_rule_token1,
    STATE(296), 1,
      sym_recipe,
    STATE(941), 1,
      sym__normal_prerequisites,
    STATE(1047), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8854] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(901), 1,
      sym_word,
    ACTIONS(903), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(421), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [8895] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(883), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(881), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8930] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(905), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [8973] = 9,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(905), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [9016] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(539), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(537), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9047] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(599), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(597), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9078] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(643), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(641), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9109] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(647), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(645), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9140] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(683), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(681), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9171] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(687), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(685), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9202] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(715), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(713), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9233] = 11,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(877), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(909), 1,
      aux_sym__thing_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(411), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [9280] = 14,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(911), 1,
      sym_word,
    ACTIONS(913), 1,
      aux_sym__thing_token1,
    ACTIONS(915), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(917), 1,
      anon_sym_PIPE,
    STATE(110), 1,
      sym_recipe,
    STATE(947), 1,
      sym__normal_prerequisites,
    STATE(997), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9333] = 14,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(913), 1,
      aux_sym__thing_token1,
    ACTIONS(917), 1,
      anon_sym_PIPE,
    ACTIONS(919), 1,
      aux_sym__ordinary_rule_token1,
    STATE(110), 1,
      sym_recipe,
    STATE(950), 1,
      sym__normal_prerequisites,
    STATE(1047), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9386] = 12,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(427), 1,
      aux_sym__thing_token1,
    ACTIONS(435), 1,
      anon_sym_LPAREN2,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(895), 1,
      aux_sym__ordinary_rule_token1,
    STATE(840), 1,
      aux_sym_list_repeat1,
    ACTIONS(411), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [9435] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(921), 1,
      sym_word,
    ACTIONS(923), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(372), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9476] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(735), 2,
      ts_builtin_sym_end,
      anon_sym_TAB,
    ACTIONS(733), 21,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [9507] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(925), 1,
      sym_word,
    ACTIONS(927), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(404), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9548] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(929), 1,
      sym_word,
    ACTIONS(931), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(417), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9589] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(933), 1,
      sym_word,
    ACTIONS(935), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(375), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9630] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(937), 1,
      sym_word,
    ACTIONS(939), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(381), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9671] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(941), 1,
      sym_word,
    ACTIONS(943), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(387), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9712] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(945), 1,
      sym_word,
    ACTIONS(947), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(393), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9753] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(949), 1,
      sym_word,
    ACTIONS(951), 8,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_PERCENT2,
      anon_sym_LT2,
      anon_sym_QMARK2,
      anon_sym_CARET2,
      anon_sym_SLASH2,
      anon_sym_STAR2,
    STATE(399), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [9794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(577), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(821), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(641), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(825), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(621), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(645), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [9974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(364), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(829), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(833), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(837), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(693), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(697), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(625), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(757), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(761), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(865), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(765), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(705), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10334] = 8,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(953), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(955), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    STATE(267), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [10374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(709), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(713), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(689), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(597), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10494] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(953), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    ACTIONS(955), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    STATE(256), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [10534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(346), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10564] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(957), 1,
      sym_word,
    ACTIONS(959), 1,
      aux_sym__thing_token1,
    ACTIONS(961), 1,
      anon_sym_PIPE,
    STATE(246), 1,
      sym_recipe,
    STATE(928), 1,
      sym__normal_prerequisites,
    STATE(986), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [10614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(317), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(717), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(344), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(348), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(721), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(725), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(356), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10824] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(425), 1,
      sym_word,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(905), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(243), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [10864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(729), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(319), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10924] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(963), 1,
      sym_word,
    ACTIONS(973), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      anon_sym_SQUOTE,
    ACTIONS(970), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(966), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(968), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(256), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [10964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(573), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [10994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(545), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(358), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(350), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(541), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11114] = 8,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(905), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [11154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(352), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(593), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(354), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(340), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11274] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(979), 1,
      sym_word,
    ACTIONS(985), 1,
      anon_sym_DQUOTE,
    ACTIONS(988), 1,
      anon_sym_SQUOTE,
    ACTIONS(982), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(966), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(968), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
    STATE(267), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [11314] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(561), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(350), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(737), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(741), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(749), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(360), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(789), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(793), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(629), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(505), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11614] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      anon_sym_DOLLAR,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(883), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [11648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(797), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(633), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(617), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11738] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(993), 1,
      sym_word,
    ACTIONS(995), 1,
      aux_sym__thing_token1,
    ACTIONS(997), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_recipe,
    STATE(951), 1,
      sym__normal_prerequisites,
    STATE(955), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [11788] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(995), 1,
      aux_sym__thing_token1,
    ACTIONS(997), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_recipe,
    STATE(894), 1,
      sym__normal_prerequisites,
    STATE(1047), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [11838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(319), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(649), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(362), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(653), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(657), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [11988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(637), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12018] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(745), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(551), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(549), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12078] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(527), 1,
      anon_sym_COLON,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(999), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [12120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(661), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(665), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(753), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(313), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(553), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(669), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(338), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12330] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(675), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(673), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(677), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12390] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(569), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(681), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(565), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(685), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(356), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12540] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(527), 1,
      anon_sym_COLON,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1001), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [12582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(801), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12612] = 13,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(959), 1,
      aux_sym__thing_token1,
    ACTIONS(961), 1,
      anon_sym_PIPE,
    STATE(246), 1,
      sym_recipe,
    STATE(943), 1,
      sym__normal_prerequisites,
    STATE(1047), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [12662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(805), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(581), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(809), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(338), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(813), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(585), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(817), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(559), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(557), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(589), 18,
      anon_sym_VPATH,
      anon_sym_DOTRECIPEPREFIX,
      anon_sym_define,
      anon_sym_include,
      anon_sym_sinclude,
      anon_sym_DASHinclude,
      anon_sym_vpath,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_override,
      anon_sym_undefine,
      anon_sym_private,
      anon_sym_ifeq,
      anon_sym_ifneq,
      anon_sym_ifdef,
      anon_sym_ifndef,
      anon_sym_DOLLAR,
      sym_word,
  [12932] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_define,
    ACTIONS(25), 1,
      anon_sym_undefine,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1003), 1,
      sym_word,
    STATE(1240), 1,
      sym_list,
    STATE(268), 3,
      sym_variable_assignment,
      sym_define_directive,
      sym_undefine_directive,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [12977] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      sym_word,
    ACTIONS(1008), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1014), 1,
      anon_sym_DQUOTE,
    ACTIONS(1017), 1,
      anon_sym_SQUOTE,
    ACTIONS(966), 5,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    STATE(320), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13016] = 12,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1020), 1,
      aux_sym__thing_token1,
    ACTIONS(1022), 1,
      aux_sym__ordinary_rule_token1,
    STATE(248), 1,
      sym_recipe,
    STATE(969), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13063] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1026), 1,
      aux_sym__thing_token1,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    STATE(970), 1,
      aux_sym_paths_repeat1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1032), 2,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13106] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(955), 5,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    STATE(320), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13145] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_define,
    ACTIONS(63), 1,
      anon_sym_undefine,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1040), 1,
      sym_word,
    STATE(1264), 1,
      sym_list,
    STATE(99), 3,
      sym_variable_assignment,
      sym_define_directive,
      sym_undefine_directive,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13190] = 12,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1042), 1,
      aux_sym__thing_token1,
    ACTIONS(1044), 1,
      aux_sym__ordinary_rule_token1,
    STATE(135), 1,
      sym_recipe,
    STATE(983), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13237] = 12,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1046), 1,
      aux_sym__thing_token1,
    ACTIONS(1048), 1,
      aux_sym__ordinary_rule_token1,
    STATE(145), 1,
      sym_recipe,
    STATE(958), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13284] = 12,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1050), 1,
      aux_sym__thing_token1,
    ACTIONS(1052), 1,
      aux_sym__ordinary_rule_token1,
    STATE(249), 1,
      sym_recipe,
    STATE(953), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13331] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      sym_word,
    ACTIONS(527), 1,
      anon_sym_COLON,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(531), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13372] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      sym_word,
    ACTIONS(527), 1,
      anon_sym_COLON,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(857), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13413] = 11,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(409), 1,
      sym_word,
    ACTIONS(421), 1,
      anon_sym_LPAREN2,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(427), 1,
      anon_sym_RPAREN2,
    ACTIONS(877), 1,
      aux_sym__ordinary_rule_token1,
    STATE(841), 1,
      aux_sym_list_repeat1,
    ACTIONS(419), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(238), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13458] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1054), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13496] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(883), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(881), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13528] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1056), 1,
      aux_sym__thing_token1,
    STATE(259), 1,
      sym_recipe,
    STATE(972), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13572] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1026), 1,
      aux_sym__thing_token1,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    STATE(970), 1,
      aux_sym_paths_repeat1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1032), 2,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13612] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1058), 1,
      aux_sym__thing_token1,
    STATE(263), 1,
      sym_recipe,
    STATE(965), 1,
      sym_list,
    STATE(1241), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13656] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1060), 1,
      aux_sym__thing_token1,
    STATE(151), 1,
      sym_recipe,
    STATE(967), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13700] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1062), 1,
      aux_sym__thing_token1,
    STATE(164), 1,
      sym_recipe,
    STATE(971), 1,
      sym_list,
    STATE(1254), 1,
      sym__attached_recipe_line,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13744] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1064), 1,
      anon_sym_COLON,
    ACTIONS(1066), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13785] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1068), 1,
      sym_word,
    ACTIONS(1070), 1,
      anon_sym_COLON,
    ACTIONS(1072), 3,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN2,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13824] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(527), 1,
      anon_sym_COLON,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1068), 1,
      sym_word,
    ACTIONS(529), 3,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN2,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [13863] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1066), 1,
      anon_sym_RBRACE,
    ACTIONS(1074), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13904] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1076), 1,
      anon_sym_COLON,
    ACTIONS(1078), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13945] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1078), 1,
      anon_sym_RBRACE,
    ACTIONS(1080), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [13986] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14027] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1084), 1,
      anon_sym_RBRACE,
    ACTIONS(1086), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14068] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1088), 1,
      anon_sym_COLON,
    ACTIONS(1090), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14109] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1090), 1,
      anon_sym_RBRACE,
    ACTIONS(1092), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14150] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1094), 1,
      anon_sym_COLON,
    ACTIONS(1096), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14191] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1096), 1,
      anon_sym_RBRACE,
    ACTIONS(1098), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14232] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1100), 1,
      anon_sym_COLON,
    ACTIONS(1102), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14273] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1102), 1,
      anon_sym_RBRACE,
    ACTIONS(1104), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14314] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1106), 1,
      anon_sym_COLON,
    ACTIONS(1108), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14355] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1108), 1,
      anon_sym_RBRACE,
    ACTIONS(1110), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14396] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1112), 1,
      anon_sym_COLON,
    ACTIONS(1114), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14437] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1114), 1,
      anon_sym_RBRACE,
    ACTIONS(1116), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14478] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1118), 1,
      anon_sym_COLON,
    ACTIONS(1120), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14519] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1120), 1,
      anon_sym_RBRACE,
    ACTIONS(1122), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14560] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(955), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(359), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14595] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1124), 1,
      sym_word,
    ACTIONS(1130), 1,
      anon_sym_DQUOTE,
    ACTIONS(1133), 1,
      anon_sym_SQUOTE,
    ACTIONS(1127), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(966), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(359), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14630] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1054), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14665] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [14702] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1136), 1,
      anon_sym_COLON,
    ACTIONS(1138), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14743] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1140), 1,
      anon_sym_COLON,
    ACTIONS(1142), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14784] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1142), 1,
      anon_sym_RBRACE,
    ACTIONS(1144), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14825] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1138), 1,
      anon_sym_RBRACE,
    ACTIONS(1146), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14866] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(701), 1,
      sym_word,
    ACTIONS(1072), 1,
      aux_sym__thing_token1,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1070), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [14903] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1148), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14941] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1150), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [14979] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1084), 1,
      anon_sym_RBRACE,
    ACTIONS(1086), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15017] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1152), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15055] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1152), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15093] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1142), 1,
      anon_sym_RBRACE,
    ACTIONS(1144), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15131] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1088), 1,
      anon_sym_COLON,
    ACTIONS(1090), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15169] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1154), 1,
      aux_sym__thing_token1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15205] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1090), 1,
      anon_sym_RBRACE,
    ACTIONS(1092), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15243] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1156), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15281] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1156), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15319] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1158), 1,
      aux_sym__thing_token1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15355] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1094), 1,
      anon_sym_COLON,
    ACTIONS(1096), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15393] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1160), 1,
      aux_sym__thing_token1,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(538), 1,
      sym_shell_text_with_split,
    STATE(1062), 1,
      sym__shell_text_without_split,
    STATE(1222), 1,
      sym_recipe_line,
    ACTIONS(1162), 3,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [15435] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1096), 1,
      anon_sym_RBRACE,
    ACTIONS(1098), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15473] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1148), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15511] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1170), 1,
      aux_sym__thing_token1,
    STATE(538), 1,
      sym_shell_text_with_split,
    STATE(1062), 1,
      sym__shell_text_without_split,
    STATE(1225), 1,
      sym_recipe_line,
    ACTIONS(1162), 3,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [15553] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15591] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1100), 1,
      anon_sym_COLON,
    ACTIONS(1102), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15629] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1174), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15667] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1102), 1,
      anon_sym_RBRACE,
    ACTIONS(1104), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15705] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1176), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15743] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1176), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15781] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1174), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15819] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1106), 1,
      anon_sym_COLON,
    ACTIONS(1108), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15857] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1178), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15895] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1108), 1,
      anon_sym_RBRACE,
    ACTIONS(1110), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15933] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1180), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [15971] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1180), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16009] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(1182), 1,
      sym_word,
    ACTIONS(1184), 1,
      aux_sym__thing_token1,
    STATE(97), 1,
      sym_variable_assignment,
    STATE(1079), 1,
      sym_list,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [16047] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1112), 1,
      anon_sym_COLON,
    ACTIONS(1114), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16085] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1064), 1,
      anon_sym_COLON,
    ACTIONS(1066), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16123] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1114), 1,
      anon_sym_RBRACE,
    ACTIONS(1116), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16161] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1186), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16199] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1186), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16237] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1188), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16275] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1118), 1,
      anon_sym_COLON,
    ACTIONS(1120), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16313] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1066), 1,
      anon_sym_RBRACE,
    ACTIONS(1074), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16351] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1120), 1,
      anon_sym_RBRACE,
    ACTIONS(1122), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16389] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1190), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16427] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1082), 1,
      anon_sym_COLON,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16465] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1192), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16503] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1194), 1,
      anon_sym_COMMA,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16541] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1196), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16579] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1192), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16617] = 11,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1198), 1,
      aux_sym__thing_token1,
    STATE(538), 1,
      sym_shell_text_with_split,
    STATE(1062), 1,
      sym__shell_text_without_split,
    STATE(1251), 1,
      sym_recipe_line,
    ACTIONS(1162), 3,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [16659] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_LPAREN2,
    ACTIONS(1200), 1,
      aux_sym__thing_token1,
    ACTIONS(881), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16689] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(1202), 1,
      sym_word,
    ACTIONS(1204), 1,
      aux_sym__thing_token1,
    STATE(297), 1,
      sym_variable_assignment,
    STATE(1077), 1,
      sym_list,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [16727] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1076), 1,
      anon_sym_COLON,
    ACTIONS(1078), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16765] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1188), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16803] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1078), 1,
      anon_sym_RBRACE,
    ACTIONS(1080), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16841] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1136), 1,
      anon_sym_COLON,
    ACTIONS(1138), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16879] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1206), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16917] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1206), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16955] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1138), 1,
      anon_sym_RBRACE,
    ACTIONS(1146), 1,
      anon_sym_COLON,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [16993] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1140), 1,
      anon_sym_COLON,
    ACTIONS(1142), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17031] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1208), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17069] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1210), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17107] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1212), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17145] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1214), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17183] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1216), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17221] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1218), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17259] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1220), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17297] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1222), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17335] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1224), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17373] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1226), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17411] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1228), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17449] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1230), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17487] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1232), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17525] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1234), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17563] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1236), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17601] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1238), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17639] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1240), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17677] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1242), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17715] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1244), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17753] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1246), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17791] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1190), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17829] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1226), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17864] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1180), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17899] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1192), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17934] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1188), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [17969] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_LPAREN2,
    ACTIONS(477), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1250), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
    ACTIONS(481), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [18002] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1186), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18037] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1188), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18072] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1186), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18107] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1206), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18142] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1252), 1,
      aux_sym__thing_token1,
    STATE(1202), 1,
      sym_list,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18177] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1206), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18212] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1254), 1,
      sym_word,
    STATE(304), 1,
      sym_variable_assignment,
    STATE(1240), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18249] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1256), 1,
      sym_word,
    STATE(100), 1,
      sym_variable_assignment,
    STATE(1264), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18286] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1190), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18321] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1158), 1,
      aux_sym__thing_token1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18354] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1190), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18389] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1258), 1,
      sym_word,
    ACTIONS(1260), 1,
      aux_sym__thing_token1,
    STATE(1210), 1,
      sym_paths,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18424] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1262), 1,
      sym_word,
    ACTIONS(1264), 1,
      anon_sym_LPAREN,
    STATE(1187), 1,
      sym__conditional_args_cmp,
    STATE(530), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18461] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1258), 1,
      sym_word,
    ACTIONS(1266), 1,
      aux_sym__thing_token1,
    STATE(1231), 1,
      sym_paths,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18496] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1152), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18531] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1196), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18566] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1152), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18601] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1194), 1,
      anon_sym_COMMA,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18636] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1200), 1,
      aux_sym__thing_token1,
    ACTIONS(881), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18663] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(441), 1,
      anon_sym_SQUOTE,
    ACTIONS(897), 1,
      sym_word,
    ACTIONS(1268), 1,
      aux_sym__thing_token1,
    STATE(1196), 1,
      sym_list,
    ACTIONS(433), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [18698] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_LPAREN2,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(497), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1270), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1272), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
    ACTIONS(499), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [18731] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_LPAREN2,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(497), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1278), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1274), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1276), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
    ACTIONS(499), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [18766] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1156), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18801] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_LPAREN2,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(497), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1280), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1282), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
    ACTIONS(499), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [18834] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1156), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18869] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1178), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18904] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1208), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18939] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1210), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [18974] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_LPAREN2,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1284), 1,
      sym_word,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    STATE(323), 1,
      aux_sym_concatenation_repeat1,
    STATE(467), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [19011] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1212), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19046] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1148), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19081] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1214), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19116] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_LPAREN2,
    ACTIONS(477), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1292), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(481), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [19147] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1216), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19182] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1148), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19217] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1218), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19252] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1174), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19287] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1220), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19322] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_LPAREN2,
    ACTIONS(477), 1,
      anon_sym_LBRACE,
    ACTIONS(479), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1294), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(481), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [19353] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1222), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19388] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1174), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19423] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1224), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19458] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1262), 1,
      sym_word,
    ACTIONS(1264), 1,
      anon_sym_LPAREN,
    STATE(1234), 1,
      sym__conditional_args_cmp,
    STATE(530), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [19495] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1228), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19530] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1176), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19565] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1230), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19600] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1232), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19635] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1176), 1,
      anon_sym_RBRACE,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19670] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1234), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19705] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1150), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19740] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1236), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19775] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1238), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19810] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1240), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19845] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_word,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE,
    ACTIONS(1154), 1,
      aux_sym__thing_token1,
    ACTIONS(1028), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(358), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19878] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1242), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19913] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1192), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19948] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1244), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [19983] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1180), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [20018] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1246), 1,
      anon_sym_EQ,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [20053] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1038), 1,
      sym_word,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    STATE(323), 11,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
      aux_sym_concatenation_repeat1,
  [20088] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_LPAREN2,
    ACTIONS(847), 1,
      anon_sym_LBRACE,
    ACTIONS(849), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1292), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(851), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20118] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1296), 1,
      sym_word,
    ACTIONS(1298), 1,
      anon_sym_COMMA,
    STATE(466), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20152] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(966), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20186] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(991), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20220] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1308), 1,
      sym_word,
    ACTIONS(1310), 1,
      anon_sym_RPAREN,
    STATE(508), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20254] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(979), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20288] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(999), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20322] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LPAREN2,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    ACTIONS(609), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1280), 1,
      aux_sym_list_token1,
    ACTIONS(1282), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
    ACTIONS(611), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20354] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(956), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20388] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(968), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20422] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1312), 1,
      sym_word,
    STATE(1229), 1,
      sym_paths,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20456] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LPAREN2,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1314), 1,
      aux_sym__thing_token1,
    ACTIONS(1292), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(783), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20488] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1316), 1,
      anon_sym_TAB,
    STATE(659), 1,
      sym__recipeprefix,
    STATE(1072), 1,
      sym__shell_text_without_split,
    STATE(545), 2,
      sym_shell_text_with_split,
      aux_sym_recipe_line_repeat1,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [20526] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1318), 1,
      sym_word,
    STATE(1164), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20560] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(981), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20594] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(974), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20628] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LPAREN2,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    ACTIONS(609), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1274), 1,
      aux_sym_list_token1,
    ACTIONS(1320), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1276), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
    ACTIONS(611), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20662] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1318), 1,
      sym_word,
    STATE(1260), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20696] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(1176), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20730] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(987), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20764] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LPAREN2,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1322), 1,
      aux_sym__thing_token1,
    ACTIONS(1324), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
    ACTIONS(783), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20798] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1284), 1,
      sym_word,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    STATE(323), 1,
      aux_sym_concatenation_repeat1,
    STATE(467), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20832] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1312), 1,
      sym_word,
    STATE(1110), 1,
      sym_paths,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20866] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_LPAREN2,
    ACTIONS(847), 1,
      anon_sym_LBRACE,
    ACTIONS(849), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1250), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 4,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
    ACTIONS(851), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20898] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(973), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [20932] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LPAREN2,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    ACTIONS(609), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1270), 1,
      aux_sym_list_token1,
    ACTIONS(1272), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
    ACTIONS(611), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [20964] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1326), 1,
      anon_sym_TAB,
    STATE(687), 1,
      sym__recipeprefix,
    STATE(1064), 1,
      sym__shell_text_without_split,
    STATE(521), 2,
      sym_shell_text_with_split,
      aux_sym_recipe_line_repeat1,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [21002] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(1199), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21036] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1318), 1,
      sym_word,
    STATE(1246), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21070] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1328), 1,
      anon_sym_TAB,
    STATE(660), 1,
      sym__recipeprefix,
    STATE(1070), 1,
      sym__shell_text_without_split,
    STATE(542), 2,
      sym_shell_text_with_split,
      aux_sym_recipe_line_repeat1,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [21108] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1312), 1,
      sym_word,
    STATE(1252), 1,
      sym_paths,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21142] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_LPAREN2,
    ACTIONS(847), 1,
      anon_sym_LBRACE,
    ACTIONS(849), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1294), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(851), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [21172] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1330), 1,
      sym_word,
    ACTIONS(1332), 1,
      anon_sym_RPAREN,
    STATE(464), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21206] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1334), 1,
      anon_sym_TAB,
    STATE(703), 1,
      sym__recipeprefix,
    STATE(1065), 1,
      sym__shell_text_without_split,
    STATE(545), 2,
      sym_shell_text_with_split,
      aux_sym_recipe_line_repeat1,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [21244] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1312), 1,
      sym_word,
    STATE(1263), 1,
      sym_paths,
    STATE(334), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21278] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LPAREN2,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1336), 1,
      aux_sym__thing_token1,
    ACTIONS(1294), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
    ACTIONS(783), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [21310] = 10,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1338), 1,
      anon_sym_DOLLAR,
    ACTIONS(1341), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1344), 1,
      anon_sym_TAB,
    ACTIONS(1347), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1350), 1,
      anon_sym_SLASH_SLASH,
    STATE(669), 1,
      sym__recipeprefix,
    STATE(1147), 1,
      sym__shell_text_without_split,
    STATE(545), 2,
      sym_shell_text_with_split,
      aux_sym_recipe_line_repeat1,
    STATE(691), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [21348] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(984), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21382] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      sym_word,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    STATE(1002), 1,
      sym_list,
    STATE(194), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21416] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1318), 1,
      sym_word,
    STATE(1235), 1,
      sym_list,
    STATE(190), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21450] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1353), 1,
      sym_word,
    STATE(459), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21481] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1355), 1,
      sym_word,
    STATE(502), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21512] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(1302), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_DQUOTE,
    ACTIONS(1306), 1,
      anon_sym_SQUOTE,
    ACTIONS(1357), 1,
      sym_word,
    STATE(253), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21543] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1359), 1,
      sym_word,
    STATE(447), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21574] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1361), 1,
      sym_word,
    STATE(450), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21605] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1363), 1,
      sym_word,
    STATE(360), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21636] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    ACTIONS(1290), 1,
      anon_sym_SQUOTE,
    ACTIONS(1365), 1,
      sym_word,
    STATE(458), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21667] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1367), 1,
      sym_word,
    STATE(474), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21698] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1369), 1,
      sym_word,
    STATE(498), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21729] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1371), 1,
      sym_word,
    STATE(507), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21760] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1373), 1,
      sym_word,
    STATE(485), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21791] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1375), 1,
      sym_word,
    STATE(489), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21822] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1377), 1,
      sym_word,
    STATE(504), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21853] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1379), 1,
      sym_word,
    STATE(446), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21884] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1381), 1,
      sym_word,
    STATE(452), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21915] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1383), 1,
      sym_word,
    STATE(454), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21946] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1385), 1,
      sym_word,
    STATE(463), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [21977] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1387), 1,
      sym_word,
    STATE(465), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22008] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1389), 1,
      sym_word,
    STATE(471), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22039] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1391), 1,
      sym_word,
    STATE(473), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22070] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1393), 1,
      sym_word,
    STATE(479), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22101] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1395), 1,
      sym_word,
    STATE(483), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22132] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1397), 1,
      sym_word,
    STATE(493), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22163] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1399), 1,
      sym_word,
    STATE(496), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22194] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1401), 1,
      sym_word,
    STATE(505), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22225] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1403), 1,
      sym_word,
    STATE(445), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22256] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1405), 1,
      sym_word,
    STATE(449), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22287] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1407), 1,
      sym_word,
    STATE(451), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22318] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1409), 1,
      sym_word,
    STATE(457), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22349] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_DOLLAR,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1068), 1,
      sym_word,
    STATE(262), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22380] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1411), 1,
      sym_word,
    STATE(475), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22411] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1413), 1,
      sym_word,
    STATE(476), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22442] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1415), 1,
      sym_word,
    STATE(478), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22473] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1417), 1,
      sym_word,
    STATE(480), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22504] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1419), 1,
      sym_word,
    STATE(482), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22535] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1421), 1,
      sym_word,
    STATE(484), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22566] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1423), 1,
      sym_word,
    STATE(486), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22597] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1425), 1,
      sym_word,
    STATE(488), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22628] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1427), 1,
      sym_word,
    STATE(490), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22659] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1429), 1,
      sym_word,
    STATE(444), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22690] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1431), 1,
      sym_word,
    STATE(492), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22721] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1433), 1,
      sym_word,
    STATE(494), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22752] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1435), 1,
      sym_word,
    STATE(495), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22783] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1437), 1,
      sym_word,
    STATE(497), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22814] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1439), 1,
      sym_word,
    STATE(499), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22845] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1441), 1,
      sym_word,
    STATE(500), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22876] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1443), 1,
      sym_word,
    STATE(501), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22907] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1445), 1,
      sym_word,
    STATE(503), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22938] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_DOLLAR,
    ACTIONS(162), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_DQUOTE,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(1447), 1,
      sym_word,
    STATE(506), 10,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      sym_concatenation,
      sym_string,
      sym_archive,
  [22969] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1449), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1268), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23003] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1457), 1,
      aux_sym__thing_token1,
    ACTIONS(1459), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1243), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23037] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1469), 1,
      anon_sym_DOLLAR,
    ACTIONS(1472), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1475), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1478), 1,
      aux_sym_text_token1,
    ACTIONS(1467), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(600), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [23067] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1481), 1,
      aux_sym__thing_token1,
    ACTIONS(1483), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1272), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23101] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1485), 1,
      aux_sym__thing_token1,
    ACTIONS(1487), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1207), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23135] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1489), 1,
      aux_sym__thing_token1,
    ACTIONS(1491), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1131), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23169] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1493), 1,
      aux_sym__thing_token1,
    ACTIONS(1495), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1154), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23203] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1497), 1,
      aux_sym__thing_token1,
    ACTIONS(1499), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1091), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23237] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1501), 1,
      aux_sym__thing_token1,
    ACTIONS(1503), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1145), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23271] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1505), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1233), 1,
      sym_text,
    STATE(1244), 1,
      sym__shell_command,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23305] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1507), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1081), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23339] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1515), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1233), 1,
      sym_text,
    STATE(1273), 1,
      sym__shell_command,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23373] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(491), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(503), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1519), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1517), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(631), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [23403] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(473), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(483), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(485), 1,
      aux_sym_text_token1,
    ACTIONS(469), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(635), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [23433] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(473), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(483), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1523), 1,
      aux_sym_text_token1,
    ACTIONS(1521), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(637), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [23463] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(491), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(503), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1527), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1525), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(631), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [23493] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1529), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1172), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23527] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1531), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1181), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23561] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1533), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1278), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23595] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1535), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1282), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23629] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1537), 1,
      aux_sym__thing_token1,
    ACTIONS(1539), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1211), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23663] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1541), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1100), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23697] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1543), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1117), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23731] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1545), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1118), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23765] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1547), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1136), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23799] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1549), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1138), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23833] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1551), 1,
      aux_sym__thing_token1,
    ACTIONS(1553), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1258), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23867] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1555), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1156), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23901] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1557), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1157), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23935] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1559), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1174), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [23969] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1561), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1175), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24003] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1563), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1285), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24037] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1565), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1195), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24071] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1569), 1,
      anon_sym_DOLLAR,
    ACTIONS(1572), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1575), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1578), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1567), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(631), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [24101] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1581), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1168), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24135] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1583), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1216), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24169] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1585), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1218), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24203] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(473), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(483), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1589), 1,
      aux_sym_text_token1,
    ACTIONS(1587), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(600), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [24233] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    ACTIONS(1591), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1180), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24267] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(473), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(483), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1595), 1,
      aux_sym_text_token1,
    ACTIONS(1593), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(600), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [24297] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1597), 1,
      aux_sym__thing_token1,
    ACTIONS(1599), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1281), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24331] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1601), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1233), 1,
      sym_text,
    STATE(1280), 1,
      sym__shell_command,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24365] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1603), 1,
      aux_sym__thing_token1,
    ACTIONS(1605), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1190), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24399] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1607), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1206), 1,
      sym__shell_command,
    STATE(1233), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24433] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1609), 1,
      aux_sym__thing_token1,
    ACTIONS(1611), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1113), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24467] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(491), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(501), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(503), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(487), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(610), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [24497] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(491), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(503), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1615), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1613), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(613), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [24527] = 9,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    ACTIONS(1617), 1,
      aux_sym__ordinary_rule_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1099), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24561] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1619), 1,
      aux_sym__thing_token1,
    STATE(1212), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24592] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1621), 1,
      aux_sym__thing_token1,
    STATE(1094), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24623] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1126), 1,
      sym__shell_command,
    STATE(1233), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24654] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1623), 10,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [24675] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_DOLLAR,
    ACTIONS(1632), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1635), 1,
      anon_sym_SLASH_SLASH,
    STATE(650), 1,
      aux_sym_text_repeat1,
    ACTIONS(1627), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(878), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24704] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1233), 1,
      sym_text,
    STATE(1275), 1,
      sym__shell_command,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24735] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1087), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24766] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1089), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24797] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1144), 1,
      sym__shell_command,
    STATE(1233), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24828] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1638), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1640), 1,
      anon_sym_SLASH_SLASH,
    STATE(696), 1,
      aux_sym__shell_text_without_split_repeat1,
    ACTIONS(1525), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(850), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24857] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1644), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1646), 1,
      anon_sym_SLASH_SLASH,
    STATE(697), 1,
      aux_sym_text_repeat1,
    ACTIONS(1642), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(878), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24886] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1648), 1,
      aux_sym__thing_token1,
    STATE(1274), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24917] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1567), 1,
      aux_sym_list_token1,
    ACTIONS(1650), 1,
      anon_sym_DOLLAR,
    ACTIONS(1653), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1656), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1659), 1,
      anon_sym_SLASH_SLASH,
    STATE(658), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [24946] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(889), 1,
      sym_shell_text_with_split,
    STATE(1076), 1,
      sym__shell_text_without_split,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [24977] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(889), 1,
      sym_shell_text_with_split,
    STATE(1065), 1,
      sym__shell_text_without_split,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25008] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1662), 1,
      aux_sym__thing_token1,
    STATE(1129), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25039] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1188), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25070] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1189), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25101] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1664), 10,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [25122] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1083), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25153] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1084), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25184] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1228), 1,
      sym__shell_command,
    STATE(1233), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25215] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1668), 1,
      aux_sym__thing_token1,
    STATE(1205), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25246] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1670), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1672), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1674), 1,
      anon_sym_SLASH_SLASH,
    STATE(889), 1,
      sym_shell_text_with_split,
    STATE(1147), 1,
      sym__shell_text_without_split,
    STATE(691), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25277] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1103), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25308] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1104), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25339] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1676), 10,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [25360] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1680), 1,
      aux_sym__thing_token1,
    STATE(1092), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25391] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1120), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25422] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1121), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25453] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1682), 1,
      aux_sym__thing_token1,
    STATE(1096), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25484] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1141), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25515] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1142), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25546] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1684), 10,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [25567] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_RPAREN,
    ACTIONS(1688), 1,
      anon_sym_DOLLAR,
    ACTIONS(1691), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1694), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1697), 1,
      aux_sym_text_token1,
    STATE(680), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [25596] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1700), 1,
      aux_sym__thing_token1,
    STATE(1107), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25627] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1702), 1,
      aux_sym__thing_token1,
    STATE(1149), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25658] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1159), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25689] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(843), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(853), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1593), 1,
      anon_sym_RPAREN,
    ACTIONS(1704), 1,
      aux_sym_text_token1,
    STATE(680), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [25718] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1178), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25749] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1179), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25780] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(889), 1,
      sym_shell_text_with_split,
    STATE(1072), 1,
      sym__shell_text_without_split,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25811] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(487), 1,
      aux_sym_list_token1,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(603), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(613), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    STATE(699), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [25840] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1198), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25871] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1200), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25902] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(603), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1613), 1,
      aux_sym_list_token1,
    ACTIONS(1706), 1,
      aux_sym__shell_text_without_split_token1,
    STATE(701), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [25931] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(771), 1,
      aux_sym__thing_token1,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(785), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(787), 1,
      aux_sym_text_token1,
    STATE(698), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [25960] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1708), 1,
      aux_sym__thing_token1,
    STATE(1171), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [25991] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1224), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26022] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1161), 1,
      sym_text,
    STATE(1227), 1,
      sym__shell_command,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26053] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1712), 1,
      anon_sym_DOLLAR,
    ACTIONS(1715), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1718), 1,
      anon_sym_SLASH_SLASH,
    STATE(696), 1,
      aux_sym__shell_text_without_split_repeat1,
    ACTIONS(1710), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(850), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26082] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1644), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1646), 1,
      anon_sym_SLASH_SLASH,
    STATE(650), 1,
      aux_sym_text_repeat1,
    ACTIONS(1721), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(878), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26111] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(785), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1723), 1,
      aux_sym__thing_token1,
    ACTIONS(1725), 1,
      aux_sym_text_token1,
    STATE(702), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26140] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(603), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1517), 1,
      aux_sym_list_token1,
    ACTIONS(1727), 1,
      aux_sym__shell_text_without_split_token1,
    STATE(658), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [26169] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(785), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1642), 1,
      aux_sym__thing_token1,
    ACTIONS(1729), 1,
      aux_sym_text_token1,
    STATE(705), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26198] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(603), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1525), 1,
      aux_sym_list_token1,
    ACTIONS(1731), 1,
      aux_sym__shell_text_without_split_token1,
    STATE(658), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__shell_text_without_split_repeat2,
  [26227] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1733), 1,
      aux_sym__thing_token1,
    ACTIONS(1735), 1,
      anon_sym_DOLLAR,
    ACTIONS(1738), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1741), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1744), 1,
      aux_sym_text_token1,
    STATE(702), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26256] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(889), 1,
      sym_shell_text_with_split,
    STATE(1071), 1,
      sym__shell_text_without_split,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26287] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1166), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1168), 1,
      anon_sym_SLASH_SLASH,
    STATE(535), 1,
      sym_shell_text_with_split,
    STATE(1063), 1,
      sym__shell_text_without_split,
    STATE(644), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26318] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(785), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1721), 1,
      aux_sym__thing_token1,
    ACTIONS(1747), 1,
      aux_sym_text_token1,
    STATE(702), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26347] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1638), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1640), 1,
      anon_sym_SLASH_SLASH,
    STATE(655), 1,
      aux_sym__shell_text_without_split_repeat1,
    ACTIONS(1613), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(850), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26376] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1749), 1,
      aux_sym__thing_token1,
    STATE(1209), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26407] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1005), 1,
      sym_text,
    STATE(1151), 1,
      sym_arguments,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26438] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1133), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26469] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    ACTIONS(1751), 1,
      aux_sym__thing_token1,
    STATE(1248), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26500] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(469), 1,
      anon_sym_RPAREN,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(843), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(853), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(855), 1,
      aux_sym_text_token1,
    STATE(713), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26529] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(843), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(853), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1521), 1,
      anon_sym_RPAREN,
    ACTIONS(1753), 1,
      aux_sym_text_token1,
    STATE(684), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26558] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(843), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(853), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1587), 1,
      anon_sym_RPAREN,
    ACTIONS(1755), 1,
      aux_sym_text_token1,
    STATE(680), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym_text_repeat2,
  [26587] = 8,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1509), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1511), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1513), 1,
      aux_sym_text_token1,
    STATE(1160), 1,
      sym__shell_command,
    STATE(1161), 1,
      sym_text,
    STATE(712), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26618] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1759), 1,
      anon_sym_DQUOTE,
    ACTIONS(1761), 1,
      aux_sym__string_token1,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(733), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26642] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1451), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1453), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1455), 1,
      aux_sym_text_token1,
    STATE(1078), 1,
      sym_text,
    STATE(612), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26670] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1759), 1,
      anon_sym_SQUOTE,
    ACTIONS(1765), 1,
      aux_sym__string_token1,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(752), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26694] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1642), 1,
      aux_sym__thing_token1,
    ACTIONS(1767), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1769), 1,
      anon_sym_SLASH_SLASH,
    STATE(737), 1,
      aux_sym_text_repeat1,
    STATE(942), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26722] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1230), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26750] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1627), 1,
      aux_sym__thing_token1,
    ACTIONS(1771), 1,
      anon_sym_DOLLAR,
    ACTIONS(1774), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1777), 1,
      anon_sym_SLASH_SLASH,
    STATE(720), 1,
      aux_sym_text_repeat1,
    STATE(942), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26778] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1761), 1,
      aux_sym__string_token1,
    ACTIONS(1780), 1,
      anon_sym_DQUOTE,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(733), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26802] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1782), 1,
      anon_sym_DQUOTE,
    ACTIONS(1784), 1,
      aux_sym__string_token1,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(715), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26826] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1786), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1788), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1723), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(842), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26852] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1790), 1,
      anon_sym_DQUOTE,
    ACTIONS(1792), 1,
      aux_sym__string_token1,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(728), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26876] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1790), 1,
      anon_sym_SQUOTE,
    ACTIONS(1794), 1,
      aux_sym__string_token1,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(729), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26900] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1786), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1788), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1796), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(842), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26926] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1786), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1788), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1721), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(842), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [26952] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1761), 1,
      aux_sym__string_token1,
    ACTIONS(1798), 1,
      anon_sym_DQUOTE,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(733), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [26976] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1765), 1,
      aux_sym__string_token1,
    ACTIONS(1798), 1,
      anon_sym_SQUOTE,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(752), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27000] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1800), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1802), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1525), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(846), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27026] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1765), 1,
      aux_sym__string_token1,
    ACTIONS(1804), 1,
      anon_sym_SQUOTE,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(752), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27050] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1800), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1802), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1806), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(846), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27076] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1811), 1,
      anon_sym_DQUOTE,
    ACTIONS(1813), 1,
      aux_sym__string_token1,
    ACTIONS(1808), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(733), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27100] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1800), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1802), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1816), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(846), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27126] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_RPAREN,
    ACTIONS(1818), 1,
      anon_sym_DOLLAR,
    ACTIONS(1821), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1824), 1,
      anon_sym_SLASH_SLASH,
    STATE(735), 1,
      aux_sym_text_repeat1,
    STATE(935), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27154] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1525), 1,
      aux_sym_list_token1,
    ACTIONS(1827), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1829), 1,
      anon_sym_SLASH_SLASH,
    STATE(751), 1,
      aux_sym__shell_text_without_split_repeat1,
    STATE(946), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27182] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1721), 1,
      aux_sym__thing_token1,
    ACTIONS(1767), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1769), 1,
      anon_sym_SLASH_SLASH,
    STATE(720), 1,
      aux_sym_text_repeat1,
    STATE(942), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27210] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1800), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1802), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1517), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    STATE(846), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27236] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1721), 1,
      anon_sym_RPAREN,
    ACTIONS(1831), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1833), 1,
      anon_sym_SLASH_SLASH,
    STATE(735), 1,
      aux_sym_text_repeat1,
    STATE(935), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27264] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1265), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27292] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1642), 1,
      anon_sym_RPAREN,
    ACTIONS(1831), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1833), 1,
      anon_sym_SLASH_SLASH,
    STATE(739), 1,
      aux_sym_text_repeat1,
    STATE(935), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27320] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_DQUOTE,
    ACTIONS(1837), 1,
      aux_sym__string_token1,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(750), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27344] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1839), 1,
      anon_sym_SQUOTE,
    ACTIONS(1841), 1,
      aux_sym__string_token1,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(745), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27368] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1097), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27396] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1765), 1,
      aux_sym__string_token1,
    ACTIONS(1780), 1,
      anon_sym_SQUOTE,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(752), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27420] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1613), 1,
      aux_sym_list_token1,
    ACTIONS(1827), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1829), 1,
      anon_sym_SLASH_SLASH,
    STATE(736), 1,
      aux_sym__shell_text_without_split_repeat1,
    STATE(946), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27448] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1839), 1,
      anon_sym_DQUOTE,
    ACTIONS(1843), 1,
      aux_sym__string_token1,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(721), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27472] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_SQUOTE,
    ACTIONS(1845), 1,
      aux_sym__string_token1,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(731), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27496] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1786), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1788), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1847), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(842), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27522] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1761), 1,
      aux_sym__string_token1,
    ACTIONS(1804), 1,
      anon_sym_DQUOTE,
    ACTIONS(1757), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(733), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27546] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1710), 1,
      aux_sym_list_token1,
    ACTIONS(1849), 1,
      anon_sym_DOLLAR,
    ACTIONS(1852), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1855), 1,
      anon_sym_SLASH_SLASH,
    STATE(751), 1,
      aux_sym__shell_text_without_split_repeat1,
    STATE(946), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27574] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1811), 1,
      anon_sym_SQUOTE,
    ACTIONS(1861), 1,
      aux_sym__string_token1,
    ACTIONS(1858), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(752), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27598] = 7,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1461), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1463), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1465), 1,
      aux_sym_text_token1,
    STATE(1152), 1,
      sym_text,
    STATE(700), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27626] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1782), 1,
      anon_sym_SQUOTE,
    ACTIONS(1864), 1,
      aux_sym__string_token1,
    ACTIONS(1763), 2,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
    STATE(717), 8,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
      aux_sym__string,
  [27650] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1847), 1,
      aux_sym__thing_token1,
    ACTIONS(1866), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1868), 1,
      anon_sym_SLASH_SLASH,
    STATE(949), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27675] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1664), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27694] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1870), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27713] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(609), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1874), 1,
      anon_sym_LPAREN2,
    ACTIONS(1876), 1,
      anon_sym_LBRACE,
    ACTIONS(611), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [27736] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1878), 1,
      anon_sym_LPAREN2,
    ACTIONS(1880), 1,
      anon_sym_LBRACE,
    ACTIONS(1882), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1884), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [27759] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1623), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27778] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1888), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1886), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27797] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1890), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27816] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1890), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27835] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1894), 1,
      anon_sym_LPAREN2,
    ACTIONS(1896), 1,
      anon_sym_LBRACE,
    ACTIONS(1898), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1900), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [27858] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1902), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27877] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1796), 1,
      aux_sym__thing_token1,
    ACTIONS(1866), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1868), 1,
      anon_sym_SLASH_SLASH,
    STATE(949), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27902] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1723), 1,
      anon_sym_RPAREN,
    ACTIONS(1906), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1908), 1,
      anon_sym_SLASH_SLASH,
    STATE(882), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27927] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1721), 1,
      anon_sym_RPAREN,
    ACTIONS(1906), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1908), 1,
      anon_sym_SLASH_SLASH,
    STATE(882), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [27952] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1912), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1910), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [27971] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1914), 1,
      anon_sym_LPAREN2,
    ACTIONS(1916), 1,
      anon_sym_LBRACE,
    ACTIONS(1918), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1920), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [27994] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1847), 1,
      anon_sym_RPAREN,
    ACTIONS(1906), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1908), 1,
      anon_sym_SLASH_SLASH,
    STATE(882), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28019] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1902), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28038] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1796), 1,
      anon_sym_RPAREN,
    ACTIONS(1906), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1908), 1,
      anon_sym_SLASH_SLASH,
    STATE(882), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28063] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1816), 1,
      aux_sym_list_token1,
    ACTIONS(1922), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1924), 1,
      anon_sym_SLASH_SLASH,
    STATE(909), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28088] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1684), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28107] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1912), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1910), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28126] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1723), 1,
      aux_sym__thing_token1,
    ACTIONS(1866), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1868), 1,
      anon_sym_SLASH_SLASH,
    STATE(949), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28151] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1926), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28170] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1930), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28189] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1888), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1886), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28208] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1936), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1934), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28227] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1517), 1,
      aux_sym_list_token1,
    ACTIONS(1922), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1924), 1,
      anon_sym_SLASH_SLASH,
    STATE(909), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28252] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1806), 1,
      aux_sym_list_token1,
    ACTIONS(1922), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1924), 1,
      anon_sym_SLASH_SLASH,
    STATE(909), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28277] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1936), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1934), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28296] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1938), 1,
      anon_sym_LPAREN2,
    ACTIONS(1940), 1,
      anon_sym_LBRACE,
    ACTIONS(1942), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1944), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28319] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1721), 1,
      aux_sym__thing_token1,
    ACTIONS(1866), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1868), 1,
      anon_sym_SLASH_SLASH,
    STATE(949), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28344] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1525), 1,
      aux_sym_list_token1,
    ACTIONS(1922), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1924), 1,
      anon_sym_SLASH_SLASH,
    STATE(909), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28369] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1946), 1,
      anon_sym_LPAREN2,
    ACTIONS(1948), 1,
      anon_sym_LBRACE,
    ACTIONS(1950), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1952), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28392] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_LPAREN2,
    ACTIONS(781), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1954), 1,
      anon_sym_LBRACE,
    ACTIONS(783), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28415] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1880), 1,
      anon_sym_LBRACE,
    ACTIONS(1882), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1956), 1,
      anon_sym_LPAREN2,
    ACTIONS(1884), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28438] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1958), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28457] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(497), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1962), 1,
      anon_sym_LPAREN2,
    ACTIONS(1964), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28480] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1958), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28499] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1926), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28518] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 3,
      aux_sym__thing_token1,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(1870), 8,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28537] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_LPAREN2,
    ACTIONS(479), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1966), 1,
      anon_sym_LBRACE,
    ACTIONS(481), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28560] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_LPAREN2,
    ACTIONS(849), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1968), 1,
      anon_sym_LBRACE,
    ACTIONS(851), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28583] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1676), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28602] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 3,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
      anon_sym_RPAREN2,
    ACTIONS(1930), 8,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28621] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1970), 1,
      anon_sym_LPAREN2,
    ACTIONS(1972), 1,
      anon_sym_LBRACE,
    ACTIONS(1974), 1,
      aux_sym_variable_reference_token1,
    ACTIONS(1976), 8,
      anon_sym_AT2,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_PLUS2,
      anon_sym_SLASH,
      anon_sym_STAR,
  [28644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1890), 1,
      anon_sym_DOLLAR,
    ACTIONS(1892), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1872), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28680] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1886), 1,
      anon_sym_DOLLAR,
    ACTIONS(1888), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28698] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_DOLLAR,
    ACTIONS(1978), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1980), 1,
      anon_sym_SLASH_SLASH,
    STATE(909), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28720] = 7,
    ACTIONS(29), 1,
      anon_sym_ifeq,
    ACTIONS(31), 1,
      anon_sym_ifneq,
    ACTIONS(33), 1,
      anon_sym_ifdef,
    ACTIONS(35), 1,
      anon_sym_ifndef,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1982), 1,
      aux_sym__thing_token1,
    STATE(8), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
  [28746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1926), 1,
      anon_sym_DOLLAR,
    ACTIONS(1928), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1930), 1,
      anon_sym_DOLLAR,
    ACTIONS(1932), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28782] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1984), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1986), 1,
      anon_sym_SLASH_SLASH,
    STATE(846), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1958), 1,
      anon_sym_DOLLAR,
    ACTIONS(1960), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1676), 1,
      anon_sym_DOLLAR,
    ACTIONS(1678), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1684), 1,
      anon_sym_DOLLAR,
    ACTIONS(1686), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28858] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_DOLLAR,
    ACTIONS(1786), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1788), 1,
      anon_sym_SLASH_SLASH,
    STATE(842), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1902), 1,
      anon_sym_DOLLAR,
    ACTIONS(1904), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1910), 1,
      anon_sym_DOLLAR,
    ACTIONS(1912), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1934), 1,
      anon_sym_DOLLAR,
    ACTIONS(1936), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28934] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(1988), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1990), 1,
      anon_sym_SLASH_SLASH,
    STATE(949), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28956] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_DOLLAR,
    ACTIONS(1906), 1,
      anon_sym_DOLLAR_DOLLAR,
    ACTIONS(1908), 1,
      anon_sym_SLASH_SLASH,
    STATE(882), 7,
      sym__variable,
      sym_variable_reference,
      sym_substitution_reference,
      sym_automatic_variable,
      sym__function,
      sym_function_call,
      sym_shell_function,
  [28978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1664), 1,
      anon_sym_DOLLAR,
    ACTIONS(1666), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [28996] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1623), 1,
      anon_sym_DOLLAR,
    ACTIONS(1625), 9,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29014] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1992), 1,
      anon_sym_ifeq,
    ACTIONS(1994), 1,
      anon_sym_ifneq,
    ACTIONS(1996), 1,
      anon_sym_ifdef,
    ACTIONS(1998), 1,
      anon_sym_ifndef,
    STATE(8), 5,
      sym__conditional_directives,
      sym_ifeq_directive,
      sym_ifneq_directive,
      sym_ifdef_directive,
      sym_ifndef_directive,
  [29037] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1623), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29053] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1870), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29069] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1664), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29085] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1936), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1934), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29101] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1912), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1910), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29117] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1958), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29133] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1926), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29149] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1888), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1886), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29165] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1902), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29181] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1676), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29197] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1930), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29213] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1890), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29229] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 3,
      aux_sym__thing_token1,
      anon_sym_COLON2,
      anon_sym_SEMI2,
    ACTIONS(1684), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_word,
  [29245] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2000), 1,
      aux_sym__thing_token1,
    ACTIONS(2002), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2004), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29262] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2006), 1,
      aux_sym__thing_token1,
    ACTIONS(2008), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2010), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29279] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2012), 1,
      aux_sym__thing_token1,
    ACTIONS(2014), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2016), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29296] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2018), 1,
      aux_sym__thing_token1,
    ACTIONS(2020), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2022), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29313] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_RPAREN2,
    STATE(838), 1,
      aux_sym_list_repeat1,
    ACTIONS(2024), 2,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
  [29332] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(905), 1,
      aux_sym__thing_token1,
    STATE(839), 1,
      aux_sym_list_repeat1,
    ACTIONS(2027), 2,
      aux_sym__ordinary_rule_token1,
      aux_sym_list_token1,
    ACTIONS(907), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [29351] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(437), 1,
      aux_sym_list_token1,
    ACTIONS(529), 1,
      aux_sym__thing_token1,
    ACTIONS(2030), 1,
      aux_sym__ordinary_rule_token1,
    STATE(839), 1,
      aux_sym_list_repeat1,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [29372] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(423), 1,
      aux_sym_list_token1,
    ACTIONS(529), 1,
      anon_sym_RPAREN2,
    ACTIONS(2032), 1,
      aux_sym__ordinary_rule_token1,
    STATE(838), 1,
      aux_sym_list_repeat1,
    ACTIONS(527), 3,
      anon_sym_COLON,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
  [29393] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1467), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29405] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1294), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29417] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2034), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(449), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29431] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1280), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1282), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29445] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1567), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(2036), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29459] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1270), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1272), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29473] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2038), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(431), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29487] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1278), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1274), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1276), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [29503] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2044), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(2040), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(2042), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [29519] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2046), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(445), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29533] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1890), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29547] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1902), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29561] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1926), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29575] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1930), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29589] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1958), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29603] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1676), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29617] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2048), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2050), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29631] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1664), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29645] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1623), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29659] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1870), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29673] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1890), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29685] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1902), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29697] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1926), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29709] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1930), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29721] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1958), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29733] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1676), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29745] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1684), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29757] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1664), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29769] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1623), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29781] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1870), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29793] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2052), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2054), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29807] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2056), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(459), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29821] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2058), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2060), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29835] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2062), 1,
      aux_sym__ordinary_rule_token1,
    ACTIONS(2064), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29849] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1292), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29861] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1250), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [29875] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2068), 1,
      aux_sym_text_token1,
    ACTIONS(2066), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [29889] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(1684), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [29903] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 1,
      aux_sym__thing_token1,
    ACTIONS(1890), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29916] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1294), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29927] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1467), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [29938] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2070), 1,
      anon_sym_endif,
    ACTIONS(2072), 1,
      anon_sym_else,
    STATE(1271), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [29955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2074), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29966] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2076), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [29977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2080), 1,
      anon_sym_DOLLAR,
    ACTIONS(2078), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [29990] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2082), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(2084), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30003] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1710), 2,
      aux_sym__thing_token1,
      aux_sym_list_token1,
    ACTIONS(2086), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30016] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2088), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_TAB,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30027] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_else,
    ACTIONS(2090), 1,
      anon_sym_endif,
    STATE(1090), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [30044] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_else,
    ACTIONS(2092), 1,
      anon_sym_endif,
    STATE(1101), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [30061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2094), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30072] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2096), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30083] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2098), 1,
      aux_sym__thing_token1,
    ACTIONS(2100), 1,
      anon_sym_PIPE,
    STATE(136), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30102] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 1,
      aux_sym__thing_token1,
    ACTIONS(1902), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30115] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2102), 5,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_TAB,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30126] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 1,
      aux_sym__thing_token1,
    ACTIONS(1926), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30139] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_else,
    ACTIONS(2104), 1,
      anon_sym_endif,
    STATE(1137), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [30156] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 1,
      aux_sym__thing_token1,
    ACTIONS(1930), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30169] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 1,
      aux_sym__thing_token1,
    ACTIONS(1958), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30182] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_else,
    ACTIONS(2106), 1,
      anon_sym_endif,
    STATE(1140), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [30199] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 1,
      aux_sym__thing_token1,
    ACTIONS(1676), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30212] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 1,
      aux_sym__thing_token1,
    ACTIONS(1684), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30225] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 1,
      aux_sym__thing_token1,
    ACTIONS(1664), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30238] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 1,
      aux_sym__thing_token1,
    ACTIONS(1623), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30251] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1280), 1,
      aux_sym_list_token1,
    ACTIONS(1282), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30264] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2108), 1,
      aux_sym__thing_token1,
    ACTIONS(2110), 1,
      anon_sym_PIPE,
    STATE(255), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [30283] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1292), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30294] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1567), 1,
      aux_sym_list_token1,
    ACTIONS(2036), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30307] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1250), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 4,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30320] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1314), 1,
      aux_sym__thing_token1,
    ACTIONS(1292), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30333] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1890), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30344] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1902), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30355] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1926), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30366] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1930), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30377] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1958), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30388] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1676), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30399] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1684), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30410] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1664), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30421] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1623), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30432] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1870), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30443] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1892), 1,
      aux_sym_list_token1,
    ACTIONS(1890), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30456] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1904), 1,
      aux_sym_list_token1,
    ACTIONS(1902), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30469] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1928), 1,
      aux_sym_list_token1,
    ACTIONS(1926), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30482] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1932), 1,
      aux_sym_list_token1,
    ACTIONS(1930), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30495] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1960), 1,
      aux_sym_list_token1,
    ACTIONS(1958), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30508] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1678), 1,
      aux_sym_list_token1,
    ACTIONS(1676), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30521] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2112), 1,
      aux_sym__thing_token1,
    ACTIONS(2114), 1,
      anon_sym_PIPE,
    STATE(313), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [30540] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1686), 1,
      aux_sym_list_token1,
    ACTIONS(1684), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30553] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1666), 1,
      aux_sym_list_token1,
    ACTIONS(1664), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30566] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1625), 1,
      aux_sym_list_token1,
    ACTIONS(1623), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30579] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 1,
      aux_sym_list_token1,
    ACTIONS(1870), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30592] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2116), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30603] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_else,
    ACTIONS(2118), 1,
      anon_sym_endif,
    STATE(1249), 1,
      sym_else_directive,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [30620] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2068), 1,
      aux_sym_text_token1,
    ACTIONS(2066), 4,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2120), 1,
      anon_sym_DOLLAR,
    ACTIONS(1627), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30646] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2122), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30657] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2124), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30668] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2126), 5,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_COLON_COLON_EQ,
      anon_sym_QMARK_EQ,
      anon_sym_PLUS_EQ,
  [30679] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1322), 1,
      aux_sym__thing_token1,
    ACTIONS(1324), 1,
      aux_sym_text_token1,
    ACTIONS(1248), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30694] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2128), 1,
      aux_sym__thing_token1,
    ACTIONS(2130), 1,
      anon_sym_PIPE,
    STATE(284), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [30713] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2132), 1,
      aux_sym__thing_token1,
    ACTIONS(2134), 1,
      aux_sym_text_token1,
    ACTIONS(2066), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30728] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2136), 1,
      aux_sym__thing_token1,
    ACTIONS(2138), 1,
      anon_sym_PIPE,
    STATE(299), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [30747] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1270), 1,
      aux_sym_list_token1,
    ACTIONS(1272), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      aux_sym__shell_text_without_split_token1,
      anon_sym_SLASH_SLASH,
  [30760] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1274), 1,
      aux_sym_list_token1,
    ACTIONS(1320), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(1276), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30775] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2040), 1,
      aux_sym_list_token1,
    ACTIONS(2140), 1,
      aux_sym__shell_text_without_split_token1,
    ACTIONS(2042), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [30790] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2142), 1,
      aux_sym__thing_token1,
    ACTIONS(2144), 1,
      anon_sym_PIPE,
    STATE(120), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30809] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1336), 1,
      aux_sym__thing_token1,
    ACTIONS(1294), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30822] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1733), 1,
      aux_sym__thing_token1,
    ACTIONS(1467), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30835] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2146), 1,
      aux_sym__thing_token1,
    ACTIONS(2148), 1,
      anon_sym_PIPE,
    STATE(121), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30854] = 6,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2150), 1,
      aux_sym__thing_token1,
    ACTIONS(2152), 1,
      anon_sym_PIPE,
    STATE(132), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30873] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1872), 1,
      aux_sym__thing_token1,
    ACTIONS(1870), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
      aux_sym_text_token1,
  [30886] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2154), 1,
      aux_sym__thing_token1,
    STATE(273), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [30902] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1926), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [30912] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym__thing_token1,
    ACTIONS(2158), 1,
      anon_sym_COLON,
    ACTIONS(2160), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [30926] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2162), 1,
      aux_sym__thing_token1,
    STATE(162), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30942] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1930), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [30952] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2164), 1,
      aux_sym__thing_token1,
    STATE(166), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [30968] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1958), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [30978] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1676), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [30988] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1684), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [30998] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1664), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [31008] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1623), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [31018] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1870), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [31028] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2166), 1,
      aux_sym__thing_token1,
    STATE(286), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31044] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2168), 1,
      aux_sym__thing_token1,
    STATE(143), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31060] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2170), 1,
      aux_sym__thing_token1,
    STATE(170), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31076] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2172), 1,
      aux_sym__thing_token1,
    STATE(171), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31092] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2174), 1,
      aux_sym__thing_token1,
    STATE(265), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31108] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2176), 1,
      aux_sym__thing_token1,
    STATE(998), 1,
      aux_sym_paths_repeat1,
    ACTIONS(1032), 2,
      anon_sym_COLON2,
      anon_sym_SEMI2,
  [31122] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2178), 1,
      aux_sym__thing_token1,
    STATE(179), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31138] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2180), 1,
      aux_sym__thing_token1,
    STATE(226), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31154] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2182), 1,
      aux_sym__thing_token1,
    STATE(269), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31170] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2184), 1,
      aux_sym__thing_token1,
    STATE(252), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31186] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1710), 1,
      aux_sym_list_token1,
    ACTIONS(2086), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [31198] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1890), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [31208] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1902), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__string_token1,
  [31218] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym__thing_token1,
    ACTIONS(2186), 1,
      anon_sym_COLON,
    ACTIONS(2160), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [31232] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2188), 1,
      aux_sym__thing_token1,
    STATE(150), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31248] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1627), 1,
      aux_sym__thing_token1,
    ACTIONS(2120), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [31260] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2190), 1,
      aux_sym__thing_token1,
    STATE(306), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31276] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1870), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31286] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2192), 1,
      aux_sym__thing_token1,
    STATE(152), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31302] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2194), 1,
      aux_sym__thing_token1,
    STATE(244), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31318] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1890), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31328] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym__thing_token1,
    ACTIONS(2196), 1,
      anon_sym_COLON,
    ACTIONS(2160), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [31342] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2198), 1,
      aux_sym__thing_token1,
    STATE(260), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31358] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2082), 1,
      aux_sym_list_token1,
    ACTIONS(2084), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [31370] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1902), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31380] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1926), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31390] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2200), 1,
      aux_sym__thing_token1,
    STATE(266), 1,
      sym_recipe,
    STATE(1241), 1,
      sym__attached_recipe_line,
  [31406] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1930), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31416] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1958), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31426] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1676), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31436] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1684), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31446] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1664), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31456] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym__thing_token1,
    ACTIONS(2202), 1,
      anon_sym_COLON,
    ACTIONS(2160), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [31470] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1054), 1,
      aux_sym__thing_token1,
    STATE(998), 1,
      aux_sym_paths_repeat1,
    ACTIONS(2204), 2,
      anon_sym_COLON2,
      anon_sym_SEMI2,
  [31484] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2207), 1,
      aux_sym__thing_token1,
    STATE(153), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31500] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2078), 1,
      aux_sym__thing_token1,
    ACTIONS(2080), 3,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_SLASH_SLASH,
  [31512] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(1623), 4,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_DOLLAR,
      anon_sym_DQUOTE,
      aux_sym__string_token1,
  [31522] = 5,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(893), 1,
      anon_sym_SEMI,
    ACTIONS(2209), 1,
      aux_sym__thing_token1,
    STATE(133), 1,
      sym_recipe,
    STATE(1254), 1,
      sym__attached_recipe_line,
  [31538] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2211), 1,
      anon_sym_endif,
    ACTIONS(2213), 1,
      anon_sym_else,
    STATE(1003), 2,
      sym_elsif_directive,
      aux_sym_conditional_repeat1,
  [31552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2216), 1,
      anon_sym_COLON,
    ACTIONS(2218), 2,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
  [31563] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2220), 1,
      anon_sym_COMMA,
    ACTIONS(2222), 1,
      anon_sym_RPAREN,
    STATE(1032), 1,
      aux_sym_arguments_repeat1,
  [31576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2224), 1,
      anon_sym_RPAREN,
    ACTIONS(2226), 2,
      anon_sym_D,
      anon_sym_F,
  [31587] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2228), 1,
      anon_sym_endef,
    ACTIONS(2230), 1,
      sym__rawline,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2232), 1,
      anon_sym_RBRACE,
    ACTIONS(2234), 2,
      anon_sym_D,
      anon_sym_F,
  [31611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2224), 1,
      anon_sym_RBRACE,
    ACTIONS(2236), 2,
      anon_sym_D,
      anon_sym_F,
  [31622] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2238), 1,
      anon_sym_endef,
    STATE(1058), 1,
      aux_sym_define_directive_repeat1,
  [31635] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2240), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31648] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2242), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2244), 1,
      anon_sym_RPAREN,
    ACTIONS(2246), 2,
      anon_sym_D,
      anon_sym_F,
  [31672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2244), 1,
      anon_sym_RBRACE,
    ACTIONS(2248), 2,
      anon_sym_D,
      anon_sym_F,
  [31683] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2250), 1,
      anon_sym_endef,
    ACTIONS(2252), 1,
      sym__rawline,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31696] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2255), 1,
      anon_sym_endef,
    STATE(1033), 1,
      aux_sym_define_directive_repeat1,
  [31709] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2257), 1,
      anon_sym_endef,
    STATE(1030), 1,
      aux_sym_define_directive_repeat1,
  [31722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2259), 1,
      anon_sym_RPAREN,
    ACTIONS(2261), 2,
      anon_sym_D,
      anon_sym_F,
  [31733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2263), 1,
      anon_sym_RPAREN,
    ACTIONS(2265), 2,
      anon_sym_D,
      anon_sym_F,
  [31744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2263), 1,
      anon_sym_RBRACE,
    ACTIONS(2267), 2,
      anon_sym_D,
      anon_sym_F,
  [31755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2269), 1,
      anon_sym_RPAREN,
    ACTIONS(2271), 2,
      anon_sym_D,
      anon_sym_F,
  [31766] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2273), 1,
      anon_sym_endef,
    STATE(1026), 1,
      aux_sym_define_directive_repeat1,
  [31779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2269), 1,
      anon_sym_RBRACE,
    ACTIONS(2275), 2,
      anon_sym_D,
      anon_sym_F,
  [31790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2259), 1,
      anon_sym_RBRACE,
    ACTIONS(2277), 2,
      anon_sym_D,
      anon_sym_F,
  [31801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2279), 1,
      anon_sym_RPAREN,
    ACTIONS(2281), 2,
      anon_sym_D,
      anon_sym_F,
  [31812] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2283), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31825] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2285), 1,
      anon_sym_endef,
    STATE(1012), 1,
      aux_sym_define_directive_repeat1,
  [31838] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2287), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31851] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2289), 1,
      anon_sym_RPAREN,
    ACTIONS(2291), 2,
      anon_sym_D,
      anon_sym_F,
  [31862] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2293), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31875] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2295), 1,
      anon_sym_endef,
    STATE(1054), 1,
      aux_sym_define_directive_repeat1,
  [31888] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2220), 1,
      anon_sym_COMMA,
    ACTIONS(2297), 1,
      anon_sym_RPAREN,
    STATE(1040), 1,
      aux_sym_arguments_repeat1,
  [31901] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2299), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2301), 1,
      anon_sym_RPAREN,
    ACTIONS(2303), 2,
      anon_sym_D,
      anon_sym_F,
  [31925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2301), 1,
      anon_sym_RBRACE,
    ACTIONS(2305), 2,
      anon_sym_D,
      anon_sym_F,
  [31936] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2307), 1,
      anon_sym_endef,
    STATE(1053), 1,
      aux_sym_define_directive_repeat1,
  [31949] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2309), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31962] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2311), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [31975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2313), 1,
      anon_sym_RPAREN,
    ACTIONS(2315), 2,
      anon_sym_D,
      anon_sym_F,
  [31986] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2317), 1,
      anon_sym_COMMA,
    ACTIONS(2320), 1,
      anon_sym_RPAREN,
    STATE(1040), 1,
      aux_sym_arguments_repeat1,
  [31999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2313), 1,
      anon_sym_RBRACE,
    ACTIONS(2322), 2,
      anon_sym_D,
      anon_sym_F,
  [32010] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2324), 1,
      anon_sym_endef,
    STATE(1048), 1,
      aux_sym_define_directive_repeat1,
  [32023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2326), 1,
      anon_sym_RPAREN,
    ACTIONS(2328), 2,
      anon_sym_D,
      anon_sym_F,
  [32034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2326), 1,
      anon_sym_RBRACE,
    ACTIONS(2330), 2,
      anon_sym_D,
      anon_sym_F,
  [32045] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2332), 1,
      anon_sym_endef,
    STATE(1050), 1,
      aux_sym_define_directive_repeat1,
  [32058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2279), 1,
      anon_sym_RBRACE,
    ACTIONS(2334), 2,
      anon_sym_D,
      anon_sym_F,
  [32069] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2156), 1,
      aux_sym__thing_token1,
    ACTIONS(2160), 2,
      anon_sym_PIPE,
      anon_sym_SEMI,
  [32080] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2336), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [32093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2289), 1,
      anon_sym_RBRACE,
    ACTIONS(2338), 2,
      anon_sym_D,
      anon_sym_F,
  [32104] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2340), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [32117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2342), 1,
      anon_sym_COLON,
    ACTIONS(2344), 2,
      anon_sym_AMP_COLON,
      anon_sym_COLON_COLON,
  [32128] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2346), 1,
      anon_sym_endef,
    STATE(1011), 1,
      aux_sym_define_directive_repeat1,
  [32141] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2348), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [32154] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2350), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [32167] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2352), 1,
      anon_sym_endef,
    STATE(1038), 1,
      aux_sym_define_directive_repeat1,
  [32180] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2354), 1,
      anon_sym_endef,
    STATE(1007), 1,
      aux_sym_define_directive_repeat1,
  [32193] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2356), 1,
      anon_sym_endef,
    STATE(1037), 1,
      aux_sym_define_directive_repeat1,
  [32206] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2358), 1,
      anon_sym_endef,
    STATE(1015), 1,
      aux_sym_define_directive_repeat1,
  [32219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2232), 1,
      anon_sym_RPAREN,
    ACTIONS(2360), 2,
      anon_sym_D,
      anon_sym_F,
  [32230] = 4,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2230), 1,
      sym__rawline,
    ACTIONS(2362), 1,
      anon_sym_endef,
    STATE(1028), 1,
      aux_sym_define_directive_repeat1,
  [32243] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2364), 1,
      sym_word,
    ACTIONS(2366), 1,
      aux_sym__thing_token1,
  [32253] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2368), 1,
      aux_sym__thing_token1,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
  [32263] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2372), 1,
      aux_sym__thing_token1,
  [32273] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2374), 1,
      aux_sym__thing_token1,
  [32283] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2376), 1,
      aux_sym__thing_token1,
  [32293] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2378), 1,
      sym_word,
    ACTIONS(2380), 1,
      aux_sym__thing_token1,
  [32303] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2382), 1,
      aux_sym__thing_token1,
    ACTIONS(2384), 1,
      aux_sym__ordinary_rule_token1,
  [32313] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2386), 2,
      anon_sym_endef,
      sym__rawline,
  [32321] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2388), 1,
      sym_word,
    ACTIONS(2390), 1,
      aux_sym__ordinary_rule_token1,
  [32331] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2392), 1,
      aux_sym__thing_token1,
  [32341] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2394), 1,
      aux_sym__thing_token1,
  [32351] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2396), 1,
      aux_sym__thing_token1,
  [32361] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2398), 1,
      aux_sym__thing_token1,
    ACTIONS(2400), 1,
      aux_sym__ordinary_rule_token1,
  [32371] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2402), 1,
      sym_word,
    ACTIONS(2404), 1,
      aux_sym__ordinary_rule_token1,
  [32381] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2406), 1,
      aux_sym__thing_token1,
    ACTIONS(2408), 1,
      aux_sym__ordinary_rule_token1,
  [32391] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
    ACTIONS(2410), 1,
      aux_sym__thing_token1,
  [32401] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2412), 1,
      aux_sym__thing_token1,
    ACTIONS(2414), 1,
      anon_sym_COLON,
  [32411] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2416), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [32419] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2418), 1,
      aux_sym__thing_token1,
    ACTIONS(2420), 1,
      anon_sym_COLON,
  [32429] = 3,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2422), 1,
      aux_sym__thing_token1,
    ACTIONS(2424), 1,
      aux_sym__ordinary_rule_token1,
  [32439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2426), 1,
      anon_sym_RPAREN,
  [32446] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2428), 1,
      anon_sym_RBRACE,
  [32453] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2430), 1,
      anon_sym_RPAREN,
  [32460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2432), 1,
      anon_sym_RPAREN,
  [32467] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2434), 1,
      aux_sym__thing_token1,
  [32474] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2436), 1,
      sym_word,
  [32481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2438), 1,
      anon_sym_RPAREN,
  [32488] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2092), 1,
      anon_sym_endif,
  [32495] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2440), 1,
      anon_sym_RPAREN,
  [32502] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2442), 1,
      anon_sym_endif,
  [32509] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2444), 1,
      aux_sym__thing_token1,
  [32516] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2446), 1,
      aux_sym__thing_token1,
  [32523] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2070), 1,
      anon_sym_endif,
  [32530] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2448), 1,
      aux_sym__thing_token1,
  [32537] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2450), 1,
      aux_sym__thing_token1,
  [32544] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2452), 1,
      aux_sym__thing_token1,
  [32551] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2454), 1,
      aux_sym__thing_token1,
  [32558] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2456), 1,
      anon_sym_RPAREN,
  [32565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2458), 1,
      anon_sym_RPAREN,
  [32572] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2460), 1,
      anon_sym_RPAREN,
  [32579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2462), 1,
      anon_sym_endif,
  [32586] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2456), 1,
      anon_sym_RBRACE,
  [32593] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2464), 1,
      anon_sym_RPAREN,
  [32600] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2466), 1,
      anon_sym_RPAREN,
  [32607] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2468), 1,
      aux_sym__thing_token1,
  [32614] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2470), 1,
      aux_sym__thing_token1,
  [32621] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2472), 1,
      aux_sym__thing_token1,
  [32628] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2474), 1,
      aux_sym__thing_token1,
  [32635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2476), 1,
      sym_word,
  [32642] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2478), 1,
      aux_sym__thing_token1,
  [32649] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2480), 1,
      aux_sym__thing_token1,
  [32656] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2482), 1,
      aux_sym__thing_token1,
  [32663] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2484), 1,
      aux_sym__thing_token1,
  [32670] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2486), 1,
      aux_sym__thing_token1,
  [32677] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2488), 1,
      aux_sym__thing_token1,
  [32684] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2490), 1,
      anon_sym_RPAREN,
  [32691] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2492), 1,
      anon_sym_RPAREN,
  [32698] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2494), 1,
      anon_sym_RPAREN,
  [32705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2490), 1,
      anon_sym_RBRACE,
  [32712] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2496), 1,
      anon_sym_RPAREN,
  [32719] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2498), 1,
      anon_sym_RPAREN,
  [32726] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2500), 1,
      aux_sym__thing_token1,
  [32733] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2502), 1,
      aux_sym__thing_token1,
  [32740] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2504), 1,
      aux_sym__thing_token1,
  [32747] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2506), 1,
      aux_sym__thing_token1,
  [32754] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2508), 1,
      aux_sym__thing_token1,
  [32761] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2510), 1,
      aux_sym__thing_token1,
  [32768] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2512), 1,
      aux_sym__thing_token1,
  [32775] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2514), 1,
      aux_sym__thing_token1,
  [32782] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2104), 1,
      anon_sym_endif,
  [32789] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2516), 1,
      aux_sym__thing_token1,
  [32796] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2518), 1,
      sym_word,
  [32803] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2520), 1,
      anon_sym_RPAREN,
  [32810] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2522), 1,
      anon_sym_RPAREN,
  [32817] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2106), 1,
      anon_sym_endif,
  [32824] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2524), 1,
      anon_sym_RPAREN,
  [32831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2526), 1,
      anon_sym_endif,
  [32838] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2528), 1,
      anon_sym_RPAREN,
  [32845] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2522), 1,
      anon_sym_RBRACE,
  [32852] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2530), 1,
      anon_sym_endif,
  [32859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2532), 1,
      anon_sym_RPAREN,
  [32866] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2534), 1,
      anon_sym_RPAREN,
  [32873] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2536), 1,
      aux_sym__thing_token1,
  [32880] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2538), 1,
      aux_sym__thing_token1,
  [32887] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2540), 1,
      aux_sym__thing_token1,
  [32894] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2542), 1,
      aux_sym__thing_token1,
  [32901] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2370), 1,
      aux_sym_list_token1,
  [32908] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2544), 1,
      aux_sym__thing_token1,
  [32915] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2546), 1,
      aux_sym__thing_token1,
  [32922] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2548), 1,
      aux_sym__thing_token1,
  [32929] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2550), 1,
      anon_sym_RPAREN,
  [32936] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2552), 1,
      aux_sym__thing_token1,
  [32943] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2554), 1,
      aux_sym__thing_token1,
  [32950] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2556), 1,
      aux_sym__thing_token1,
  [32957] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2558), 1,
      anon_sym_RPAREN,
  [32964] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2560), 1,
      anon_sym_RPAREN,
  [32971] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2562), 1,
      anon_sym_RPAREN,
  [32978] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2558), 1,
      anon_sym_RBRACE,
  [32985] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2564), 1,
      anon_sym_RPAREN,
  [32992] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2566), 1,
      anon_sym_RPAREN,
  [32999] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2568), 1,
      anon_sym_RPAREN,
  [33006] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2570), 1,
      aux_sym__thing_token1,
  [33013] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2572), 1,
      anon_sym_RPAREN,
  [33020] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2574), 1,
      anon_sym_RPAREN2,
  [33027] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2576), 1,
      aux_sym__thing_token1,
  [33034] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2578), 1,
      aux_sym__thing_token1,
  [33041] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2580), 1,
      aux_sym__thing_token1,
  [33048] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2582), 1,
      anon_sym_RPAREN,
  [33055] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2584), 1,
      aux_sym__thing_token1,
  [33062] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2586), 1,
      anon_sym_RPAREN,
  [33069] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2588), 1,
      aux_sym__thing_token1,
  [33076] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2590), 1,
      anon_sym_RPAREN,
  [33083] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2592), 1,
      anon_sym_RPAREN,
  [33090] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2594), 1,
      anon_sym_RPAREN,
  [33097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2596), 1,
      anon_sym_RPAREN,
  [33104] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2598), 1,
      aux_sym__thing_token1,
  [33111] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2592), 1,
      anon_sym_RBRACE,
  [33118] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2600), 1,
      anon_sym_RPAREN,
  [33125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2602), 1,
      anon_sym_RPAREN,
  [33132] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2604), 1,
      anon_sym_RPAREN,
  [33139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2606), 1,
      anon_sym_RPAREN,
  [33146] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2586), 1,
      anon_sym_RBRACE,
  [33153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2572), 1,
      anon_sym_RBRACE,
  [33160] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2118), 1,
      anon_sym_endif,
  [33167] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2608), 1,
      aux_sym__thing_token1,
  [33174] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2610), 1,
      aux_sym__thing_token1,
  [33181] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2612), 1,
      aux_sym__thing_token1,
  [33188] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2614), 1,
      anon_sym_RPAREN,
  [33195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2616), 1,
      anon_sym_RPAREN,
  [33202] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2618), 1,
      aux_sym__thing_token1,
  [33209] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2620), 1,
      aux_sym__thing_token1,
  [33216] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2622), 1,
      anon_sym_RPAREN,
  [33223] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2624), 1,
      aux_sym__thing_token1,
  [33230] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2626), 1,
      aux_sym__thing_token1,
  [33237] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2628), 1,
      anon_sym_RPAREN,
  [33244] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2630), 1,
      aux_sym__thing_token1,
  [33251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2622), 1,
      anon_sym_RBRACE,
  [33258] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2632), 1,
      anon_sym_RPAREN,
  [33265] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2634), 1,
      aux_sym__thing_token1,
  [33272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2636), 1,
      anon_sym_RPAREN,
  [33279] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2638), 1,
      aux_sym__thing_token1,
  [33286] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2640), 1,
      aux_sym__thing_token1,
  [33293] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2642), 1,
      aux_sym__thing_token1,
  [33300] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2644), 1,
      aux_sym__thing_token1,
  [33307] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2646), 1,
      aux_sym__thing_token1,
  [33314] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2648), 1,
      aux_sym__thing_token1,
  [33321] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2650), 1,
      aux_sym__thing_token1,
  [33328] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2652), 1,
      aux_sym__thing_token1,
  [33335] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2654), 1,
      aux_sym__thing_token1,
  [33342] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2656), 1,
      aux_sym__thing_token1,
  [33349] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2658), 1,
      aux_sym__thing_token1,
  [33356] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2660), 1,
      aux_sym__thing_token1,
  [33363] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2662), 1,
      aux_sym__thing_token1,
  [33370] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2664), 1,
      aux_sym__thing_token1,
  [33377] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2666), 1,
      anon_sym_RPAREN,
  [33384] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2668), 1,
      anon_sym_RPAREN,
  [33391] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2670), 1,
      aux_sym__thing_token1,
  [33398] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2672), 1,
      anon_sym_RPAREN,
  [33405] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2674), 1,
      aux_sym__thing_token1,
  [33412] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2676), 1,
      sym_word,
  [33419] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2678), 1,
      aux_sym__thing_token1,
  [33426] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2680), 1,
      aux_sym__thing_token1,
  [33433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2666), 1,
      anon_sym_RBRACE,
  [33440] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2682), 1,
      anon_sym_RPAREN,
  [33447] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2684), 1,
      aux_sym__thing_token1,
  [33454] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2686), 1,
      aux_sym__thing_token1,
  [33461] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2688), 1,
      anon_sym_RPAREN,
  [33468] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2690), 1,
      aux_sym__thing_token1,
  [33475] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2692), 1,
      aux_sym__thing_token1,
  [33482] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2694), 1,
      aux_sym__thing_token1,
  [33489] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2696), 1,
      aux_sym__thing_token1,
  [33496] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2698), 1,
      aux_sym__thing_token1,
  [33503] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2568), 1,
      aux_sym__thing_token1,
  [33510] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2700), 1,
      aux_sym__thing_token1,
  [33517] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2702), 1,
      anon_sym_RPAREN2,
  [33524] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2704), 1,
      aux_sym__thing_token1,
  [33531] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2706), 1,
      sym_word,
  [33538] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2708), 1,
      aux_sym__thing_token1,
  [33545] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2710), 1,
      aux_sym__thing_token1,
  [33552] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2712), 1,
      anon_sym_COLON,
  [33559] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2714), 1,
      aux_sym__thing_token1,
  [33566] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2716), 1,
      aux_sym__thing_token1,
  [33573] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2718), 1,
      aux_sym__thing_token1,
  [33580] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2720), 1,
      aux_sym__thing_token1,
  [33587] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2722), 1,
      aux_sym__thing_token1,
  [33594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2724), 1,
      anon_sym_RPAREN2,
  [33601] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2726), 1,
      aux_sym__thing_token1,
  [33608] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2728), 1,
      aux_sym__thing_token1,
  [33615] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2730), 1,
      anon_sym_endif,
  [33622] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2732), 1,
      aux_sym__thing_token1,
  [33629] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2734), 1,
      aux_sym__thing_token1,
  [33636] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2736), 1,
      aux_sym__thing_token1,
  [33643] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2738), 1,
      aux_sym__thing_token1,
  [33650] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2740), 1,
      aux_sym__thing_token1,
  [33657] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2742), 1,
      ts_builtin_sym_end,
  [33664] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2744), 1,
      aux_sym__thing_token1,
  [33671] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2746), 1,
      aux_sym__thing_token1,
  [33678] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2748), 1,
      aux_sym__thing_token1,
  [33685] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2750), 1,
      aux_sym__thing_token1,
  [33692] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2752), 1,
      anon_sym_RPAREN2,
  [33699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2090), 1,
      anon_sym_endif,
  [33706] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2754), 1,
      sym_word,
  [33713] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2756), 1,
      aux_sym__thing_token1,
  [33720] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2758), 1,
      anon_sym_COLON,
  [33727] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2760), 1,
      aux_sym__thing_token1,
  [33734] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2762), 1,
      aux_sym__thing_token1,
  [33741] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2764), 1,
      anon_sym_RPAREN,
  [33748] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2766), 1,
      anon_sym_RPAREN,
  [33755] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2428), 1,
      anon_sym_RPAREN,
  [33762] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2764), 1,
      anon_sym_RBRACE,
  [33769] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2768), 1,
      anon_sym_endif,
  [33776] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2770), 1,
      aux_sym__thing_token1,
  [33783] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2772), 1,
      aux_sym__thing_token1,
  [33790] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2774), 1,
      aux_sym__thing_token1,
  [33797] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2776), 1,
      aux_sym__thing_token1,
  [33804] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2778), 1,
      aux_sym__thing_token1,
  [33811] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2780), 1,
      aux_sym__thing_token1,
  [33818] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2782), 1,
      anon_sym_RPAREN,
  [33825] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2784), 1,
      aux_sym__thing_token1,
  [33832] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2786), 1,
      aux_sym__thing_token1,
  [33839] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2788), 1,
      aux_sym__thing_token1,
  [33846] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2790), 1,
      anon_sym_RPAREN,
  [33853] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2792), 1,
      aux_sym__thing_token1,
  [33860] = 2,
    ACTIONS(77), 1,
      sym_comment,
    ACTIONS(2794), 1,
      aux_sym__thing_token1,
  [33867] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2796), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(8)] = 0,
  [SMALL_STATE(9)] = 122,
  [SMALL_STATE(10)] = 244,
  [SMALL_STATE(11)] = 366,
  [SMALL_STATE(12)] = 487,
  [SMALL_STATE(13)] = 608,
  [SMALL_STATE(14)] = 689,
  [SMALL_STATE(15)] = 770,
  [SMALL_STATE(16)] = 851,
  [SMALL_STATE(17)] = 932,
  [SMALL_STATE(18)] = 1013,
  [SMALL_STATE(19)] = 1094,
  [SMALL_STATE(20)] = 1175,
  [SMALL_STATE(21)] = 1256,
  [SMALL_STATE(22)] = 1337,
  [SMALL_STATE(23)] = 1418,
  [SMALL_STATE(24)] = 1499,
  [SMALL_STATE(25)] = 1580,
  [SMALL_STATE(26)] = 1696,
  [SMALL_STATE(27)] = 1812,
  [SMALL_STATE(28)] = 1867,
  [SMALL_STATE(29)] = 1922,
  [SMALL_STATE(30)] = 1977,
  [SMALL_STATE(31)] = 2032,
  [SMALL_STATE(32)] = 2087,
  [SMALL_STATE(33)] = 2142,
  [SMALL_STATE(34)] = 2197,
  [SMALL_STATE(35)] = 2252,
  [SMALL_STATE(36)] = 2307,
  [SMALL_STATE(37)] = 2362,
  [SMALL_STATE(38)] = 2417,
  [SMALL_STATE(39)] = 2472,
  [SMALL_STATE(40)] = 2527,
  [SMALL_STATE(41)] = 2582,
  [SMALL_STATE(42)] = 2637,
  [SMALL_STATE(43)] = 2692,
  [SMALL_STATE(44)] = 2747,
  [SMALL_STATE(45)] = 2802,
  [SMALL_STATE(46)] = 2857,
  [SMALL_STATE(47)] = 2912,
  [SMALL_STATE(48)] = 2967,
  [SMALL_STATE(49)] = 3022,
  [SMALL_STATE(50)] = 3077,
  [SMALL_STATE(51)] = 3132,
  [SMALL_STATE(52)] = 3188,
  [SMALL_STATE(53)] = 3244,
  [SMALL_STATE(54)] = 3300,
  [SMALL_STATE(55)] = 3356,
  [SMALL_STATE(56)] = 3412,
  [SMALL_STATE(57)] = 3468,
  [SMALL_STATE(58)] = 3524,
  [SMALL_STATE(59)] = 3580,
  [SMALL_STATE(60)] = 3636,
  [SMALL_STATE(61)] = 3692,
  [SMALL_STATE(62)] = 3748,
  [SMALL_STATE(63)] = 3804,
  [SMALL_STATE(64)] = 3860,
  [SMALL_STATE(65)] = 3916,
  [SMALL_STATE(66)] = 3972,
  [SMALL_STATE(67)] = 4028,
  [SMALL_STATE(68)] = 4084,
  [SMALL_STATE(69)] = 4140,
  [SMALL_STATE(70)] = 4196,
  [SMALL_STATE(71)] = 4252,
  [SMALL_STATE(72)] = 4308,
  [SMALL_STATE(73)] = 4364,
  [SMALL_STATE(74)] = 4420,
  [SMALL_STATE(75)] = 4476,
  [SMALL_STATE(76)] = 4533,
  [SMALL_STATE(77)] = 4590,
  [SMALL_STATE(78)] = 4647,
  [SMALL_STATE(79)] = 4704,
  [SMALL_STATE(80)] = 4761,
  [SMALL_STATE(81)] = 4818,
  [SMALL_STATE(82)] = 4873,
  [SMALL_STATE(83)] = 4928,
  [SMALL_STATE(84)] = 4980,
  [SMALL_STATE(85)] = 5032,
  [SMALL_STATE(86)] = 5081,
  [SMALL_STATE(87)] = 5130,
  [SMALL_STATE(88)] = 5162,
  [SMALL_STATE(89)] = 5194,
  [SMALL_STATE(90)] = 5226,
  [SMALL_STATE(91)] = 5258,
  [SMALL_STATE(92)] = 5290,
  [SMALL_STATE(93)] = 5338,
  [SMALL_STATE(94)] = 5370,
  [SMALL_STATE(95)] = 5402,
  [SMALL_STATE(96)] = 5434,
  [SMALL_STATE(97)] = 5466,
  [SMALL_STATE(98)] = 5498,
  [SMALL_STATE(99)] = 5530,
  [SMALL_STATE(100)] = 5562,
  [SMALL_STATE(101)] = 5594,
  [SMALL_STATE(102)] = 5626,
  [SMALL_STATE(103)] = 5658,
  [SMALL_STATE(104)] = 5690,
  [SMALL_STATE(105)] = 5722,
  [SMALL_STATE(106)] = 5754,
  [SMALL_STATE(107)] = 5786,
  [SMALL_STATE(108)] = 5818,
  [SMALL_STATE(109)] = 5850,
  [SMALL_STATE(110)] = 5898,
  [SMALL_STATE(111)] = 5930,
  [SMALL_STATE(112)] = 5962,
  [SMALL_STATE(113)] = 5994,
  [SMALL_STATE(114)] = 6026,
  [SMALL_STATE(115)] = 6058,
  [SMALL_STATE(116)] = 6090,
  [SMALL_STATE(117)] = 6122,
  [SMALL_STATE(118)] = 6154,
  [SMALL_STATE(119)] = 6186,
  [SMALL_STATE(120)] = 6218,
  [SMALL_STATE(121)] = 6250,
  [SMALL_STATE(122)] = 6282,
  [SMALL_STATE(123)] = 6314,
  [SMALL_STATE(124)] = 6346,
  [SMALL_STATE(125)] = 6378,
  [SMALL_STATE(126)] = 6410,
  [SMALL_STATE(127)] = 6442,
  [SMALL_STATE(128)] = 6474,
  [SMALL_STATE(129)] = 6506,
  [SMALL_STATE(130)] = 6538,
  [SMALL_STATE(131)] = 6570,
  [SMALL_STATE(132)] = 6602,
  [SMALL_STATE(133)] = 6634,
  [SMALL_STATE(134)] = 6666,
  [SMALL_STATE(135)] = 6698,
  [SMALL_STATE(136)] = 6730,
  [SMALL_STATE(137)] = 6762,
  [SMALL_STATE(138)] = 6794,
  [SMALL_STATE(139)] = 6826,
  [SMALL_STATE(140)] = 6870,
  [SMALL_STATE(141)] = 6902,
  [SMALL_STATE(142)] = 6934,
  [SMALL_STATE(143)] = 6966,
  [SMALL_STATE(144)] = 6998,
  [SMALL_STATE(145)] = 7030,
  [SMALL_STATE(146)] = 7062,
  [SMALL_STATE(147)] = 7094,
  [SMALL_STATE(148)] = 7126,
  [SMALL_STATE(149)] = 7158,
  [SMALL_STATE(150)] = 7190,
  [SMALL_STATE(151)] = 7222,
  [SMALL_STATE(152)] = 7254,
  [SMALL_STATE(153)] = 7286,
  [SMALL_STATE(154)] = 7318,
  [SMALL_STATE(155)] = 7350,
  [SMALL_STATE(156)] = 7382,
  [SMALL_STATE(157)] = 7414,
  [SMALL_STATE(158)] = 7446,
  [SMALL_STATE(159)] = 7478,
  [SMALL_STATE(160)] = 7510,
  [SMALL_STATE(161)] = 7542,
  [SMALL_STATE(162)] = 7574,
  [SMALL_STATE(163)] = 7606,
  [SMALL_STATE(164)] = 7650,
  [SMALL_STATE(165)] = 7682,
  [SMALL_STATE(166)] = 7730,
  [SMALL_STATE(167)] = 7762,
  [SMALL_STATE(168)] = 7794,
  [SMALL_STATE(169)] = 7826,
  [SMALL_STATE(170)] = 7858,
  [SMALL_STATE(171)] = 7890,
  [SMALL_STATE(172)] = 7922,
  [SMALL_STATE(173)] = 7954,
  [SMALL_STATE(174)] = 7986,
  [SMALL_STATE(175)] = 8018,
  [SMALL_STATE(176)] = 8050,
  [SMALL_STATE(177)] = 8082,
  [SMALL_STATE(178)] = 8114,
  [SMALL_STATE(179)] = 8146,
  [SMALL_STATE(180)] = 8178,
  [SMALL_STATE(181)] = 8210,
  [SMALL_STATE(182)] = 8242,
  [SMALL_STATE(183)] = 8274,
  [SMALL_STATE(184)] = 8322,
  [SMALL_STATE(185)] = 8370,
  [SMALL_STATE(186)] = 8414,
  [SMALL_STATE(187)] = 8458,
  [SMALL_STATE(188)] = 8490,
  [SMALL_STATE(189)] = 8531,
  [SMALL_STATE(190)] = 8572,
  [SMALL_STATE(191)] = 8619,
  [SMALL_STATE(192)] = 8666,
  [SMALL_STATE(193)] = 8701,
  [SMALL_STATE(194)] = 8754,
  [SMALL_STATE(195)] = 8801,
  [SMALL_STATE(196)] = 8854,
  [SMALL_STATE(197)] = 8895,
  [SMALL_STATE(198)] = 8930,
  [SMALL_STATE(199)] = 8973,
  [SMALL_STATE(200)] = 9016,
  [SMALL_STATE(201)] = 9047,
  [SMALL_STATE(202)] = 9078,
  [SMALL_STATE(203)] = 9109,
  [SMALL_STATE(204)] = 9140,
  [SMALL_STATE(205)] = 9171,
  [SMALL_STATE(206)] = 9202,
  [SMALL_STATE(207)] = 9233,
  [SMALL_STATE(208)] = 9280,
  [SMALL_STATE(209)] = 9333,
  [SMALL_STATE(210)] = 9386,
  [SMALL_STATE(211)] = 9435,
  [SMALL_STATE(212)] = 9476,
  [SMALL_STATE(213)] = 9507,
  [SMALL_STATE(214)] = 9548,
  [SMALL_STATE(215)] = 9589,
  [SMALL_STATE(216)] = 9630,
  [SMALL_STATE(217)] = 9671,
  [SMALL_STATE(218)] = 9712,
  [SMALL_STATE(219)] = 9753,
  [SMALL_STATE(220)] = 9794,
  [SMALL_STATE(221)] = 9824,
  [SMALL_STATE(222)] = 9854,
  [SMALL_STATE(223)] = 9884,
  [SMALL_STATE(224)] = 9914,
  [SMALL_STATE(225)] = 9944,
  [SMALL_STATE(226)] = 9974,
  [SMALL_STATE(227)] = 10004,
  [SMALL_STATE(228)] = 10034,
  [SMALL_STATE(229)] = 10064,
  [SMALL_STATE(230)] = 10094,
  [SMALL_STATE(231)] = 10124,
  [SMALL_STATE(232)] = 10154,
  [SMALL_STATE(233)] = 10184,
  [SMALL_STATE(234)] = 10214,
  [SMALL_STATE(235)] = 10244,
  [SMALL_STATE(236)] = 10274,
  [SMALL_STATE(237)] = 10304,
  [SMALL_STATE(238)] = 10334,
  [SMALL_STATE(239)] = 10374,
  [SMALL_STATE(240)] = 10404,
  [SMALL_STATE(241)] = 10434,
  [SMALL_STATE(242)] = 10464,
  [SMALL_STATE(243)] = 10494,
  [SMALL_STATE(244)] = 10534,
  [SMALL_STATE(245)] = 10564,
  [SMALL_STATE(246)] = 10614,
  [SMALL_STATE(247)] = 10644,
  [SMALL_STATE(248)] = 10674,
  [SMALL_STATE(249)] = 10704,
  [SMALL_STATE(250)] = 10734,
  [SMALL_STATE(251)] = 10764,
  [SMALL_STATE(252)] = 10794,
  [SMALL_STATE(253)] = 10824,
  [SMALL_STATE(254)] = 10864,
  [SMALL_STATE(255)] = 10894,
  [SMALL_STATE(256)] = 10924,
  [SMALL_STATE(257)] = 10964,
  [SMALL_STATE(258)] = 10994,
  [SMALL_STATE(259)] = 11024,
  [SMALL_STATE(260)] = 11054,
  [SMALL_STATE(261)] = 11084,
  [SMALL_STATE(262)] = 11114,
  [SMALL_STATE(263)] = 11154,
  [SMALL_STATE(264)] = 11184,
  [SMALL_STATE(265)] = 11214,
  [SMALL_STATE(266)] = 11244,
  [SMALL_STATE(267)] = 11274,
  [SMALL_STATE(268)] = 11314,
  [SMALL_STATE(269)] = 11344,
  [SMALL_STATE(270)] = 11374,
  [SMALL_STATE(271)] = 11404,
  [SMALL_STATE(272)] = 11434,
  [SMALL_STATE(273)] = 11464,
  [SMALL_STATE(274)] = 11494,
  [SMALL_STATE(275)] = 11524,
  [SMALL_STATE(276)] = 11554,
  [SMALL_STATE(277)] = 11584,
  [SMALL_STATE(278)] = 11614,
  [SMALL_STATE(279)] = 11648,
  [SMALL_STATE(280)] = 11678,
  [SMALL_STATE(281)] = 11708,
  [SMALL_STATE(282)] = 11738,
  [SMALL_STATE(283)] = 11788,
  [SMALL_STATE(284)] = 11838,
  [SMALL_STATE(285)] = 11868,
  [SMALL_STATE(286)] = 11898,
  [SMALL_STATE(287)] = 11928,
  [SMALL_STATE(288)] = 11958,
  [SMALL_STATE(289)] = 11988,
  [SMALL_STATE(290)] = 12018,
  [SMALL_STATE(291)] = 12048,
  [SMALL_STATE(292)] = 12078,
  [SMALL_STATE(293)] = 12120,
  [SMALL_STATE(294)] = 12150,
  [SMALL_STATE(295)] = 12180,
  [SMALL_STATE(296)] = 12210,
  [SMALL_STATE(297)] = 12240,
  [SMALL_STATE(298)] = 12270,
  [SMALL_STATE(299)] = 12300,
  [SMALL_STATE(300)] = 12330,
  [SMALL_STATE(301)] = 12360,
  [SMALL_STATE(302)] = 12390,
  [SMALL_STATE(303)] = 12420,
  [SMALL_STATE(304)] = 12450,
  [SMALL_STATE(305)] = 12480,
  [SMALL_STATE(306)] = 12510,
  [SMALL_STATE(307)] = 12540,
  [SMALL_STATE(308)] = 12582,
  [SMALL_STATE(309)] = 12612,
  [SMALL_STATE(310)] = 12662,
  [SMALL_STATE(311)] = 12692,
  [SMALL_STATE(312)] = 12722,
  [SMALL_STATE(313)] = 12752,
  [SMALL_STATE(314)] = 12782,
  [SMALL_STATE(315)] = 12812,
  [SMALL_STATE(316)] = 12842,
  [SMALL_STATE(317)] = 12872,
  [SMALL_STATE(318)] = 12902,
  [SMALL_STATE(319)] = 12932,
  [SMALL_STATE(320)] = 12977,
  [SMALL_STATE(321)] = 13016,
  [SMALL_STATE(322)] = 13063,
  [SMALL_STATE(323)] = 13106,
  [SMALL_STATE(324)] = 13145,
  [SMALL_STATE(325)] = 13190,
  [SMALL_STATE(326)] = 13237,
  [SMALL_STATE(327)] = 13284,
  [SMALL_STATE(328)] = 13331,
  [SMALL_STATE(329)] = 13372,
  [SMALL_STATE(330)] = 13413,
  [SMALL_STATE(331)] = 13458,
  [SMALL_STATE(332)] = 13496,
  [SMALL_STATE(333)] = 13528,
  [SMALL_STATE(334)] = 13572,
  [SMALL_STATE(335)] = 13612,
  [SMALL_STATE(336)] = 13656,
  [SMALL_STATE(337)] = 13700,
  [SMALL_STATE(338)] = 13744,
  [SMALL_STATE(339)] = 13785,
  [SMALL_STATE(340)] = 13824,
  [SMALL_STATE(341)] = 13863,
  [SMALL_STATE(342)] = 13904,
  [SMALL_STATE(343)] = 13945,
  [SMALL_STATE(344)] = 13986,
  [SMALL_STATE(345)] = 14027,
  [SMALL_STATE(346)] = 14068,
  [SMALL_STATE(347)] = 14109,
  [SMALL_STATE(348)] = 14150,
  [SMALL_STATE(349)] = 14191,
  [SMALL_STATE(350)] = 14232,
  [SMALL_STATE(351)] = 14273,
  [SMALL_STATE(352)] = 14314,
  [SMALL_STATE(353)] = 14355,
  [SMALL_STATE(354)] = 14396,
  [SMALL_STATE(355)] = 14437,
  [SMALL_STATE(356)] = 14478,
  [SMALL_STATE(357)] = 14519,
  [SMALL_STATE(358)] = 14560,
  [SMALL_STATE(359)] = 14595,
  [SMALL_STATE(360)] = 14630,
  [SMALL_STATE(361)] = 14665,
  [SMALL_STATE(362)] = 14702,
  [SMALL_STATE(363)] = 14743,
  [SMALL_STATE(364)] = 14784,
  [SMALL_STATE(365)] = 14825,
  [SMALL_STATE(366)] = 14866,
  [SMALL_STATE(367)] = 14903,
  [SMALL_STATE(368)] = 14941,
  [SMALL_STATE(369)] = 14979,
  [SMALL_STATE(370)] = 15017,
  [SMALL_STATE(371)] = 15055,
  [SMALL_STATE(372)] = 15093,
  [SMALL_STATE(373)] = 15131,
  [SMALL_STATE(374)] = 15169,
  [SMALL_STATE(375)] = 15205,
  [SMALL_STATE(376)] = 15243,
  [SMALL_STATE(377)] = 15281,
  [SMALL_STATE(378)] = 15319,
  [SMALL_STATE(379)] = 15355,
  [SMALL_STATE(380)] = 15393,
  [SMALL_STATE(381)] = 15435,
  [SMALL_STATE(382)] = 15473,
  [SMALL_STATE(383)] = 15511,
  [SMALL_STATE(384)] = 15553,
  [SMALL_STATE(385)] = 15591,
  [SMALL_STATE(386)] = 15629,
  [SMALL_STATE(387)] = 15667,
  [SMALL_STATE(388)] = 15705,
  [SMALL_STATE(389)] = 15743,
  [SMALL_STATE(390)] = 15781,
  [SMALL_STATE(391)] = 15819,
  [SMALL_STATE(392)] = 15857,
  [SMALL_STATE(393)] = 15895,
  [SMALL_STATE(394)] = 15933,
  [SMALL_STATE(395)] = 15971,
  [SMALL_STATE(396)] = 16009,
  [SMALL_STATE(397)] = 16047,
  [SMALL_STATE(398)] = 16085,
  [SMALL_STATE(399)] = 16123,
  [SMALL_STATE(400)] = 16161,
  [SMALL_STATE(401)] = 16199,
  [SMALL_STATE(402)] = 16237,
  [SMALL_STATE(403)] = 16275,
  [SMALL_STATE(404)] = 16313,
  [SMALL_STATE(405)] = 16351,
  [SMALL_STATE(406)] = 16389,
  [SMALL_STATE(407)] = 16427,
  [SMALL_STATE(408)] = 16465,
  [SMALL_STATE(409)] = 16503,
  [SMALL_STATE(410)] = 16541,
  [SMALL_STATE(411)] = 16579,
  [SMALL_STATE(412)] = 16617,
  [SMALL_STATE(413)] = 16659,
  [SMALL_STATE(414)] = 16689,
  [SMALL_STATE(415)] = 16727,
  [SMALL_STATE(416)] = 16765,
  [SMALL_STATE(417)] = 16803,
  [SMALL_STATE(418)] = 16841,
  [SMALL_STATE(419)] = 16879,
  [SMALL_STATE(420)] = 16917,
  [SMALL_STATE(421)] = 16955,
  [SMALL_STATE(422)] = 16993,
  [SMALL_STATE(423)] = 17031,
  [SMALL_STATE(424)] = 17069,
  [SMALL_STATE(425)] = 17107,
  [SMALL_STATE(426)] = 17145,
  [SMALL_STATE(427)] = 17183,
  [SMALL_STATE(428)] = 17221,
  [SMALL_STATE(429)] = 17259,
  [SMALL_STATE(430)] = 17297,
  [SMALL_STATE(431)] = 17335,
  [SMALL_STATE(432)] = 17373,
  [SMALL_STATE(433)] = 17411,
  [SMALL_STATE(434)] = 17449,
  [SMALL_STATE(435)] = 17487,
  [SMALL_STATE(436)] = 17525,
  [SMALL_STATE(437)] = 17563,
  [SMALL_STATE(438)] = 17601,
  [SMALL_STATE(439)] = 17639,
  [SMALL_STATE(440)] = 17677,
  [SMALL_STATE(441)] = 17715,
  [SMALL_STATE(442)] = 17753,
  [SMALL_STATE(443)] = 17791,
  [SMALL_STATE(444)] = 17829,
  [SMALL_STATE(445)] = 17864,
  [SMALL_STATE(446)] = 17899,
  [SMALL_STATE(447)] = 17934,
  [SMALL_STATE(448)] = 17969,
  [SMALL_STATE(449)] = 18002,
  [SMALL_STATE(450)] = 18037,
  [SMALL_STATE(451)] = 18072,
  [SMALL_STATE(452)] = 18107,
  [SMALL_STATE(453)] = 18142,
  [SMALL_STATE(454)] = 18177,
  [SMALL_STATE(455)] = 18212,
  [SMALL_STATE(456)] = 18249,
  [SMALL_STATE(457)] = 18286,
  [SMALL_STATE(458)] = 18321,
  [SMALL_STATE(459)] = 18354,
  [SMALL_STATE(460)] = 18389,
  [SMALL_STATE(461)] = 18424,
  [SMALL_STATE(462)] = 18461,
  [SMALL_STATE(463)] = 18496,
  [SMALL_STATE(464)] = 18531,
  [SMALL_STATE(465)] = 18566,
  [SMALL_STATE(466)] = 18601,
  [SMALL_STATE(467)] = 18636,
  [SMALL_STATE(468)] = 18663,
  [SMALL_STATE(469)] = 18698,
  [SMALL_STATE(470)] = 18731,
  [SMALL_STATE(471)] = 18766,
  [SMALL_STATE(472)] = 18801,
  [SMALL_STATE(473)] = 18834,
  [SMALL_STATE(474)] = 18869,
  [SMALL_STATE(475)] = 18904,
  [SMALL_STATE(476)] = 18939,
  [SMALL_STATE(477)] = 18974,
  [SMALL_STATE(478)] = 19011,
  [SMALL_STATE(479)] = 19046,
  [SMALL_STATE(480)] = 19081,
  [SMALL_STATE(481)] = 19116,
  [SMALL_STATE(482)] = 19147,
  [SMALL_STATE(483)] = 19182,
  [SMALL_STATE(484)] = 19217,
  [SMALL_STATE(485)] = 19252,
  [SMALL_STATE(486)] = 19287,
  [SMALL_STATE(487)] = 19322,
  [SMALL_STATE(488)] = 19353,
  [SMALL_STATE(489)] = 19388,
  [SMALL_STATE(490)] = 19423,
  [SMALL_STATE(491)] = 19458,
  [SMALL_STATE(492)] = 19495,
  [SMALL_STATE(493)] = 19530,
  [SMALL_STATE(494)] = 19565,
  [SMALL_STATE(495)] = 19600,
  [SMALL_STATE(496)] = 19635,
  [SMALL_STATE(497)] = 19670,
  [SMALL_STATE(498)] = 19705,
  [SMALL_STATE(499)] = 19740,
  [SMALL_STATE(500)] = 19775,
  [SMALL_STATE(501)] = 19810,
  [SMALL_STATE(502)] = 19845,
  [SMALL_STATE(503)] = 19878,
  [SMALL_STATE(504)] = 19913,
  [SMALL_STATE(505)] = 19948,
  [SMALL_STATE(506)] = 19983,
  [SMALL_STATE(507)] = 20018,
  [SMALL_STATE(508)] = 20053,
  [SMALL_STATE(509)] = 20088,
  [SMALL_STATE(510)] = 20118,
  [SMALL_STATE(511)] = 20152,
  [SMALL_STATE(512)] = 20186,
  [SMALL_STATE(513)] = 20220,
  [SMALL_STATE(514)] = 20254,
  [SMALL_STATE(515)] = 20288,
  [SMALL_STATE(516)] = 20322,
  [SMALL_STATE(517)] = 20354,
  [SMALL_STATE(518)] = 20388,
  [SMALL_STATE(519)] = 20422,
  [SMALL_STATE(520)] = 20456,
  [SMALL_STATE(521)] = 20488,
  [SMALL_STATE(522)] = 20526,
  [SMALL_STATE(523)] = 20560,
  [SMALL_STATE(524)] = 20594,
  [SMALL_STATE(525)] = 20628,
  [SMALL_STATE(526)] = 20662,
  [SMALL_STATE(527)] = 20696,
  [SMALL_STATE(528)] = 20730,
  [SMALL_STATE(529)] = 20764,
  [SMALL_STATE(530)] = 20798,
  [SMALL_STATE(531)] = 20832,
  [SMALL_STATE(532)] = 20866,
  [SMALL_STATE(533)] = 20898,
  [SMALL_STATE(534)] = 20932,
  [SMALL_STATE(535)] = 20964,
  [SMALL_STATE(536)] = 21002,
  [SMALL_STATE(537)] = 21036,
  [SMALL_STATE(538)] = 21070,
  [SMALL_STATE(539)] = 21108,
  [SMALL_STATE(540)] = 21142,
  [SMALL_STATE(541)] = 21172,
  [SMALL_STATE(542)] = 21206,
  [SMALL_STATE(543)] = 21244,
  [SMALL_STATE(544)] = 21278,
  [SMALL_STATE(545)] = 21310,
  [SMALL_STATE(546)] = 21348,
  [SMALL_STATE(547)] = 21382,
  [SMALL_STATE(548)] = 21416,
  [SMALL_STATE(549)] = 21450,
  [SMALL_STATE(550)] = 21481,
  [SMALL_STATE(551)] = 21512,
  [SMALL_STATE(552)] = 21543,
  [SMALL_STATE(553)] = 21574,
  [SMALL_STATE(554)] = 21605,
  [SMALL_STATE(555)] = 21636,
  [SMALL_STATE(556)] = 21667,
  [SMALL_STATE(557)] = 21698,
  [SMALL_STATE(558)] = 21729,
  [SMALL_STATE(559)] = 21760,
  [SMALL_STATE(560)] = 21791,
  [SMALL_STATE(561)] = 21822,
  [SMALL_STATE(562)] = 21853,
  [SMALL_STATE(563)] = 21884,
  [SMALL_STATE(564)] = 21915,
  [SMALL_STATE(565)] = 21946,
  [SMALL_STATE(566)] = 21977,
  [SMALL_STATE(567)] = 22008,
  [SMALL_STATE(568)] = 22039,
  [SMALL_STATE(569)] = 22070,
  [SMALL_STATE(570)] = 22101,
  [SMALL_STATE(571)] = 22132,
  [SMALL_STATE(572)] = 22163,
  [SMALL_STATE(573)] = 22194,
  [SMALL_STATE(574)] = 22225,
  [SMALL_STATE(575)] = 22256,
  [SMALL_STATE(576)] = 22287,
  [SMALL_STATE(577)] = 22318,
  [SMALL_STATE(578)] = 22349,
  [SMALL_STATE(579)] = 22380,
  [SMALL_STATE(580)] = 22411,
  [SMALL_STATE(581)] = 22442,
  [SMALL_STATE(582)] = 22473,
  [SMALL_STATE(583)] = 22504,
  [SMALL_STATE(584)] = 22535,
  [SMALL_STATE(585)] = 22566,
  [SMALL_STATE(586)] = 22597,
  [SMALL_STATE(587)] = 22628,
  [SMALL_STATE(588)] = 22659,
  [SMALL_STATE(589)] = 22690,
  [SMALL_STATE(590)] = 22721,
  [SMALL_STATE(591)] = 22752,
  [SMALL_STATE(592)] = 22783,
  [SMALL_STATE(593)] = 22814,
  [SMALL_STATE(594)] = 22845,
  [SMALL_STATE(595)] = 22876,
  [SMALL_STATE(596)] = 22907,
  [SMALL_STATE(597)] = 22938,
  [SMALL_STATE(598)] = 22969,
  [SMALL_STATE(599)] = 23003,
  [SMALL_STATE(600)] = 23037,
  [SMALL_STATE(601)] = 23067,
  [SMALL_STATE(602)] = 23101,
  [SMALL_STATE(603)] = 23135,
  [SMALL_STATE(604)] = 23169,
  [SMALL_STATE(605)] = 23203,
  [SMALL_STATE(606)] = 23237,
  [SMALL_STATE(607)] = 23271,
  [SMALL_STATE(608)] = 23305,
  [SMALL_STATE(609)] = 23339,
  [SMALL_STATE(610)] = 23373,
  [SMALL_STATE(611)] = 23403,
  [SMALL_STATE(612)] = 23433,
  [SMALL_STATE(613)] = 23463,
  [SMALL_STATE(614)] = 23493,
  [SMALL_STATE(615)] = 23527,
  [SMALL_STATE(616)] = 23561,
  [SMALL_STATE(617)] = 23595,
  [SMALL_STATE(618)] = 23629,
  [SMALL_STATE(619)] = 23663,
  [SMALL_STATE(620)] = 23697,
  [SMALL_STATE(621)] = 23731,
  [SMALL_STATE(622)] = 23765,
  [SMALL_STATE(623)] = 23799,
  [SMALL_STATE(624)] = 23833,
  [SMALL_STATE(625)] = 23867,
  [SMALL_STATE(626)] = 23901,
  [SMALL_STATE(627)] = 23935,
  [SMALL_STATE(628)] = 23969,
  [SMALL_STATE(629)] = 24003,
  [SMALL_STATE(630)] = 24037,
  [SMALL_STATE(631)] = 24071,
  [SMALL_STATE(632)] = 24101,
  [SMALL_STATE(633)] = 24135,
  [SMALL_STATE(634)] = 24169,
  [SMALL_STATE(635)] = 24203,
  [SMALL_STATE(636)] = 24233,
  [SMALL_STATE(637)] = 24267,
  [SMALL_STATE(638)] = 24297,
  [SMALL_STATE(639)] = 24331,
  [SMALL_STATE(640)] = 24365,
  [SMALL_STATE(641)] = 24399,
  [SMALL_STATE(642)] = 24433,
  [SMALL_STATE(643)] = 24467,
  [SMALL_STATE(644)] = 24497,
  [SMALL_STATE(645)] = 24527,
  [SMALL_STATE(646)] = 24561,
  [SMALL_STATE(647)] = 24592,
  [SMALL_STATE(648)] = 24623,
  [SMALL_STATE(649)] = 24654,
  [SMALL_STATE(650)] = 24675,
  [SMALL_STATE(651)] = 24704,
  [SMALL_STATE(652)] = 24735,
  [SMALL_STATE(653)] = 24766,
  [SMALL_STATE(654)] = 24797,
  [SMALL_STATE(655)] = 24828,
  [SMALL_STATE(656)] = 24857,
  [SMALL_STATE(657)] = 24886,
  [SMALL_STATE(658)] = 24917,
  [SMALL_STATE(659)] = 24946,
  [SMALL_STATE(660)] = 24977,
  [SMALL_STATE(661)] = 25008,
  [SMALL_STATE(662)] = 25039,
  [SMALL_STATE(663)] = 25070,
  [SMALL_STATE(664)] = 25101,
  [SMALL_STATE(665)] = 25122,
  [SMALL_STATE(666)] = 25153,
  [SMALL_STATE(667)] = 25184,
  [SMALL_STATE(668)] = 25215,
  [SMALL_STATE(669)] = 25246,
  [SMALL_STATE(670)] = 25277,
  [SMALL_STATE(671)] = 25308,
  [SMALL_STATE(672)] = 25339,
  [SMALL_STATE(673)] = 25360,
  [SMALL_STATE(674)] = 25391,
  [SMALL_STATE(675)] = 25422,
  [SMALL_STATE(676)] = 25453,
  [SMALL_STATE(677)] = 25484,
  [SMALL_STATE(678)] = 25515,
  [SMALL_STATE(679)] = 25546,
  [SMALL_STATE(680)] = 25567,
  [SMALL_STATE(681)] = 25596,
  [SMALL_STATE(682)] = 25627,
  [SMALL_STATE(683)] = 25658,
  [SMALL_STATE(684)] = 25689,
  [SMALL_STATE(685)] = 25718,
  [SMALL_STATE(686)] = 25749,
  [SMALL_STATE(687)] = 25780,
  [SMALL_STATE(688)] = 25811,
  [SMALL_STATE(689)] = 25840,
  [SMALL_STATE(690)] = 25871,
  [SMALL_STATE(691)] = 25902,
  [SMALL_STATE(692)] = 25931,
  [SMALL_STATE(693)] = 25960,
  [SMALL_STATE(694)] = 25991,
  [SMALL_STATE(695)] = 26022,
  [SMALL_STATE(696)] = 26053,
  [SMALL_STATE(697)] = 26082,
  [SMALL_STATE(698)] = 26111,
  [SMALL_STATE(699)] = 26140,
  [SMALL_STATE(700)] = 26169,
  [SMALL_STATE(701)] = 26198,
  [SMALL_STATE(702)] = 26227,
  [SMALL_STATE(703)] = 26256,
  [SMALL_STATE(704)] = 26287,
  [SMALL_STATE(705)] = 26318,
  [SMALL_STATE(706)] = 26347,
  [SMALL_STATE(707)] = 26376,
  [SMALL_STATE(708)] = 26407,
  [SMALL_STATE(709)] = 26438,
  [SMALL_STATE(710)] = 26469,
  [SMALL_STATE(711)] = 26500,
  [SMALL_STATE(712)] = 26529,
  [SMALL_STATE(713)] = 26558,
  [SMALL_STATE(714)] = 26587,
  [SMALL_STATE(715)] = 26618,
  [SMALL_STATE(716)] = 26642,
  [SMALL_STATE(717)] = 26670,
  [SMALL_STATE(718)] = 26694,
  [SMALL_STATE(719)] = 26722,
  [SMALL_STATE(720)] = 26750,
  [SMALL_STATE(721)] = 26778,
  [SMALL_STATE(722)] = 26802,
  [SMALL_STATE(723)] = 26826,
  [SMALL_STATE(724)] = 26852,
  [SMALL_STATE(725)] = 26876,
  [SMALL_STATE(726)] = 26900,
  [SMALL_STATE(727)] = 26926,
  [SMALL_STATE(728)] = 26952,
  [SMALL_STATE(729)] = 26976,
  [SMALL_STATE(730)] = 27000,
  [SMALL_STATE(731)] = 27026,
  [SMALL_STATE(732)] = 27050,
  [SMALL_STATE(733)] = 27076,
  [SMALL_STATE(734)] = 27100,
  [SMALL_STATE(735)] = 27126,
  [SMALL_STATE(736)] = 27154,
  [SMALL_STATE(737)] = 27182,
  [SMALL_STATE(738)] = 27210,
  [SMALL_STATE(739)] = 27236,
  [SMALL_STATE(740)] = 27264,
  [SMALL_STATE(741)] = 27292,
  [SMALL_STATE(742)] = 27320,
  [SMALL_STATE(743)] = 27344,
  [SMALL_STATE(744)] = 27368,
  [SMALL_STATE(745)] = 27396,
  [SMALL_STATE(746)] = 27420,
  [SMALL_STATE(747)] = 27448,
  [SMALL_STATE(748)] = 27472,
  [SMALL_STATE(749)] = 27496,
  [SMALL_STATE(750)] = 27522,
  [SMALL_STATE(751)] = 27546,
  [SMALL_STATE(752)] = 27574,
  [SMALL_STATE(753)] = 27598,
  [SMALL_STATE(754)] = 27626,
  [SMALL_STATE(755)] = 27650,
  [SMALL_STATE(756)] = 27675,
  [SMALL_STATE(757)] = 27694,
  [SMALL_STATE(758)] = 27713,
  [SMALL_STATE(759)] = 27736,
  [SMALL_STATE(760)] = 27759,
  [SMALL_STATE(761)] = 27778,
  [SMALL_STATE(762)] = 27797,
  [SMALL_STATE(763)] = 27816,
  [SMALL_STATE(764)] = 27835,
  [SMALL_STATE(765)] = 27858,
  [SMALL_STATE(766)] = 27877,
  [SMALL_STATE(767)] = 27902,
  [SMALL_STATE(768)] = 27927,
  [SMALL_STATE(769)] = 27952,
  [SMALL_STATE(770)] = 27971,
  [SMALL_STATE(771)] = 27994,
  [SMALL_STATE(772)] = 28019,
  [SMALL_STATE(773)] = 28038,
  [SMALL_STATE(774)] = 28063,
  [SMALL_STATE(775)] = 28088,
  [SMALL_STATE(776)] = 28107,
  [SMALL_STATE(777)] = 28126,
  [SMALL_STATE(778)] = 28151,
  [SMALL_STATE(779)] = 28170,
  [SMALL_STATE(780)] = 28189,
  [SMALL_STATE(781)] = 28208,
  [SMALL_STATE(782)] = 28227,
  [SMALL_STATE(783)] = 28252,
  [SMALL_STATE(784)] = 28277,
  [SMALL_STATE(785)] = 28296,
  [SMALL_STATE(786)] = 28319,
  [SMALL_STATE(787)] = 28344,
  [SMALL_STATE(788)] = 28369,
  [SMALL_STATE(789)] = 28392,
  [SMALL_STATE(790)] = 28415,
  [SMALL_STATE(791)] = 28438,
  [SMALL_STATE(792)] = 28457,
  [SMALL_STATE(793)] = 28480,
  [SMALL_STATE(794)] = 28499,
  [SMALL_STATE(795)] = 28518,
  [SMALL_STATE(796)] = 28537,
  [SMALL_STATE(797)] = 28560,
  [SMALL_STATE(798)] = 28583,
  [SMALL_STATE(799)] = 28602,
  [SMALL_STATE(800)] = 28621,
  [SMALL_STATE(801)] = 28644,
  [SMALL_STATE(802)] = 28662,
  [SMALL_STATE(803)] = 28680,
  [SMALL_STATE(804)] = 28698,
  [SMALL_STATE(805)] = 28720,
  [SMALL_STATE(806)] = 28746,
  [SMALL_STATE(807)] = 28764,
  [SMALL_STATE(808)] = 28782,
  [SMALL_STATE(809)] = 28804,
  [SMALL_STATE(810)] = 28822,
  [SMALL_STATE(811)] = 28840,
  [SMALL_STATE(812)] = 28858,
  [SMALL_STATE(813)] = 28880,
  [SMALL_STATE(814)] = 28898,
  [SMALL_STATE(815)] = 28916,
  [SMALL_STATE(816)] = 28934,
  [SMALL_STATE(817)] = 28956,
  [SMALL_STATE(818)] = 28978,
  [SMALL_STATE(819)] = 28996,
  [SMALL_STATE(820)] = 29014,
  [SMALL_STATE(821)] = 29037,
  [SMALL_STATE(822)] = 29053,
  [SMALL_STATE(823)] = 29069,
  [SMALL_STATE(824)] = 29085,
  [SMALL_STATE(825)] = 29101,
  [SMALL_STATE(826)] = 29117,
  [SMALL_STATE(827)] = 29133,
  [SMALL_STATE(828)] = 29149,
  [SMALL_STATE(829)] = 29165,
  [SMALL_STATE(830)] = 29181,
  [SMALL_STATE(831)] = 29197,
  [SMALL_STATE(832)] = 29213,
  [SMALL_STATE(833)] = 29229,
  [SMALL_STATE(834)] = 29245,
  [SMALL_STATE(835)] = 29262,
  [SMALL_STATE(836)] = 29279,
  [SMALL_STATE(837)] = 29296,
  [SMALL_STATE(838)] = 29313,
  [SMALL_STATE(839)] = 29332,
  [SMALL_STATE(840)] = 29351,
  [SMALL_STATE(841)] = 29372,
  [SMALL_STATE(842)] = 29393,
  [SMALL_STATE(843)] = 29405,
  [SMALL_STATE(844)] = 29417,
  [SMALL_STATE(845)] = 29431,
  [SMALL_STATE(846)] = 29445,
  [SMALL_STATE(847)] = 29459,
  [SMALL_STATE(848)] = 29473,
  [SMALL_STATE(849)] = 29487,
  [SMALL_STATE(850)] = 29503,
  [SMALL_STATE(851)] = 29519,
  [SMALL_STATE(852)] = 29533,
  [SMALL_STATE(853)] = 29547,
  [SMALL_STATE(854)] = 29561,
  [SMALL_STATE(855)] = 29575,
  [SMALL_STATE(856)] = 29589,
  [SMALL_STATE(857)] = 29603,
  [SMALL_STATE(858)] = 29617,
  [SMALL_STATE(859)] = 29631,
  [SMALL_STATE(860)] = 29645,
  [SMALL_STATE(861)] = 29659,
  [SMALL_STATE(862)] = 29673,
  [SMALL_STATE(863)] = 29685,
  [SMALL_STATE(864)] = 29697,
  [SMALL_STATE(865)] = 29709,
  [SMALL_STATE(866)] = 29721,
  [SMALL_STATE(867)] = 29733,
  [SMALL_STATE(868)] = 29745,
  [SMALL_STATE(869)] = 29757,
  [SMALL_STATE(870)] = 29769,
  [SMALL_STATE(871)] = 29781,
  [SMALL_STATE(872)] = 29793,
  [SMALL_STATE(873)] = 29807,
  [SMALL_STATE(874)] = 29821,
  [SMALL_STATE(875)] = 29835,
  [SMALL_STATE(876)] = 29849,
  [SMALL_STATE(877)] = 29861,
  [SMALL_STATE(878)] = 29875,
  [SMALL_STATE(879)] = 29889,
  [SMALL_STATE(880)] = 29903,
  [SMALL_STATE(881)] = 29916,
  [SMALL_STATE(882)] = 29927,
  [SMALL_STATE(883)] = 29938,
  [SMALL_STATE(884)] = 29955,
  [SMALL_STATE(885)] = 29966,
  [SMALL_STATE(886)] = 29977,
  [SMALL_STATE(887)] = 29990,
  [SMALL_STATE(888)] = 30003,
  [SMALL_STATE(889)] = 30016,
  [SMALL_STATE(890)] = 30027,
  [SMALL_STATE(891)] = 30044,
  [SMALL_STATE(892)] = 30061,
  [SMALL_STATE(893)] = 30072,
  [SMALL_STATE(894)] = 30083,
  [SMALL_STATE(895)] = 30102,
  [SMALL_STATE(896)] = 30115,
  [SMALL_STATE(897)] = 30126,
  [SMALL_STATE(898)] = 30139,
  [SMALL_STATE(899)] = 30156,
  [SMALL_STATE(900)] = 30169,
  [SMALL_STATE(901)] = 30182,
  [SMALL_STATE(902)] = 30199,
  [SMALL_STATE(903)] = 30212,
  [SMALL_STATE(904)] = 30225,
  [SMALL_STATE(905)] = 30238,
  [SMALL_STATE(906)] = 30251,
  [SMALL_STATE(907)] = 30264,
  [SMALL_STATE(908)] = 30283,
  [SMALL_STATE(909)] = 30294,
  [SMALL_STATE(910)] = 30307,
  [SMALL_STATE(911)] = 30320,
  [SMALL_STATE(912)] = 30333,
  [SMALL_STATE(913)] = 30344,
  [SMALL_STATE(914)] = 30355,
  [SMALL_STATE(915)] = 30366,
  [SMALL_STATE(916)] = 30377,
  [SMALL_STATE(917)] = 30388,
  [SMALL_STATE(918)] = 30399,
  [SMALL_STATE(919)] = 30410,
  [SMALL_STATE(920)] = 30421,
  [SMALL_STATE(921)] = 30432,
  [SMALL_STATE(922)] = 30443,
  [SMALL_STATE(923)] = 30456,
  [SMALL_STATE(924)] = 30469,
  [SMALL_STATE(925)] = 30482,
  [SMALL_STATE(926)] = 30495,
  [SMALL_STATE(927)] = 30508,
  [SMALL_STATE(928)] = 30521,
  [SMALL_STATE(929)] = 30540,
  [SMALL_STATE(930)] = 30553,
  [SMALL_STATE(931)] = 30566,
  [SMALL_STATE(932)] = 30579,
  [SMALL_STATE(933)] = 30592,
  [SMALL_STATE(934)] = 30603,
  [SMALL_STATE(935)] = 30620,
  [SMALL_STATE(936)] = 30633,
  [SMALL_STATE(937)] = 30646,
  [SMALL_STATE(938)] = 30657,
  [SMALL_STATE(939)] = 30668,
  [SMALL_STATE(940)] = 30679,
  [SMALL_STATE(941)] = 30694,
  [SMALL_STATE(942)] = 30713,
  [SMALL_STATE(943)] = 30728,
  [SMALL_STATE(944)] = 30747,
  [SMALL_STATE(945)] = 30760,
  [SMALL_STATE(946)] = 30775,
  [SMALL_STATE(947)] = 30790,
  [SMALL_STATE(948)] = 30809,
  [SMALL_STATE(949)] = 30822,
  [SMALL_STATE(950)] = 30835,
  [SMALL_STATE(951)] = 30854,
  [SMALL_STATE(952)] = 30873,
  [SMALL_STATE(953)] = 30886,
  [SMALL_STATE(954)] = 30902,
  [SMALL_STATE(955)] = 30912,
  [SMALL_STATE(956)] = 30926,
  [SMALL_STATE(957)] = 30942,
  [SMALL_STATE(958)] = 30952,
  [SMALL_STATE(959)] = 30968,
  [SMALL_STATE(960)] = 30978,
  [SMALL_STATE(961)] = 30988,
  [SMALL_STATE(962)] = 30998,
  [SMALL_STATE(963)] = 31008,
  [SMALL_STATE(964)] = 31018,
  [SMALL_STATE(965)] = 31028,
  [SMALL_STATE(966)] = 31044,
  [SMALL_STATE(967)] = 31060,
  [SMALL_STATE(968)] = 31076,
  [SMALL_STATE(969)] = 31092,
  [SMALL_STATE(970)] = 31108,
  [SMALL_STATE(971)] = 31122,
  [SMALL_STATE(972)] = 31138,
  [SMALL_STATE(973)] = 31154,
  [SMALL_STATE(974)] = 31170,
  [SMALL_STATE(975)] = 31186,
  [SMALL_STATE(976)] = 31198,
  [SMALL_STATE(977)] = 31208,
  [SMALL_STATE(978)] = 31218,
  [SMALL_STATE(979)] = 31232,
  [SMALL_STATE(980)] = 31248,
  [SMALL_STATE(981)] = 31260,
  [SMALL_STATE(982)] = 31276,
  [SMALL_STATE(983)] = 31286,
  [SMALL_STATE(984)] = 31302,
  [SMALL_STATE(985)] = 31318,
  [SMALL_STATE(986)] = 31328,
  [SMALL_STATE(987)] = 31342,
  [SMALL_STATE(988)] = 31358,
  [SMALL_STATE(989)] = 31370,
  [SMALL_STATE(990)] = 31380,
  [SMALL_STATE(991)] = 31390,
  [SMALL_STATE(992)] = 31406,
  [SMALL_STATE(993)] = 31416,
  [SMALL_STATE(994)] = 31426,
  [SMALL_STATE(995)] = 31436,
  [SMALL_STATE(996)] = 31446,
  [SMALL_STATE(997)] = 31456,
  [SMALL_STATE(998)] = 31470,
  [SMALL_STATE(999)] = 31484,
  [SMALL_STATE(1000)] = 31500,
  [SMALL_STATE(1001)] = 31512,
  [SMALL_STATE(1002)] = 31522,
  [SMALL_STATE(1003)] = 31538,
  [SMALL_STATE(1004)] = 31552,
  [SMALL_STATE(1005)] = 31563,
  [SMALL_STATE(1006)] = 31576,
  [SMALL_STATE(1007)] = 31587,
  [SMALL_STATE(1008)] = 31600,
  [SMALL_STATE(1009)] = 31611,
  [SMALL_STATE(1010)] = 31622,
  [SMALL_STATE(1011)] = 31635,
  [SMALL_STATE(1012)] = 31648,
  [SMALL_STATE(1013)] = 31661,
  [SMALL_STATE(1014)] = 31672,
  [SMALL_STATE(1015)] = 31683,
  [SMALL_STATE(1016)] = 31696,
  [SMALL_STATE(1017)] = 31709,
  [SMALL_STATE(1018)] = 31722,
  [SMALL_STATE(1019)] = 31733,
  [SMALL_STATE(1020)] = 31744,
  [SMALL_STATE(1021)] = 31755,
  [SMALL_STATE(1022)] = 31766,
  [SMALL_STATE(1023)] = 31779,
  [SMALL_STATE(1024)] = 31790,
  [SMALL_STATE(1025)] = 31801,
  [SMALL_STATE(1026)] = 31812,
  [SMALL_STATE(1027)] = 31825,
  [SMALL_STATE(1028)] = 31838,
  [SMALL_STATE(1029)] = 31851,
  [SMALL_STATE(1030)] = 31862,
  [SMALL_STATE(1031)] = 31875,
  [SMALL_STATE(1032)] = 31888,
  [SMALL_STATE(1033)] = 31901,
  [SMALL_STATE(1034)] = 31914,
  [SMALL_STATE(1035)] = 31925,
  [SMALL_STATE(1036)] = 31936,
  [SMALL_STATE(1037)] = 31949,
  [SMALL_STATE(1038)] = 31962,
  [SMALL_STATE(1039)] = 31975,
  [SMALL_STATE(1040)] = 31986,
  [SMALL_STATE(1041)] = 31999,
  [SMALL_STATE(1042)] = 32010,
  [SMALL_STATE(1043)] = 32023,
  [SMALL_STATE(1044)] = 32034,
  [SMALL_STATE(1045)] = 32045,
  [SMALL_STATE(1046)] = 32058,
  [SMALL_STATE(1047)] = 32069,
  [SMALL_STATE(1048)] = 32080,
  [SMALL_STATE(1049)] = 32093,
  [SMALL_STATE(1050)] = 32104,
  [SMALL_STATE(1051)] = 32117,
  [SMALL_STATE(1052)] = 32128,
  [SMALL_STATE(1053)] = 32141,
  [SMALL_STATE(1054)] = 32154,
  [SMALL_STATE(1055)] = 32167,
  [SMALL_STATE(1056)] = 32180,
  [SMALL_STATE(1057)] = 32193,
  [SMALL_STATE(1058)] = 32206,
  [SMALL_STATE(1059)] = 32219,
  [SMALL_STATE(1060)] = 32230,
  [SMALL_STATE(1061)] = 32243,
  [SMALL_STATE(1062)] = 32253,
  [SMALL_STATE(1063)] = 32263,
  [SMALL_STATE(1064)] = 32273,
  [SMALL_STATE(1065)] = 32283,
  [SMALL_STATE(1066)] = 32293,
  [SMALL_STATE(1067)] = 32303,
  [SMALL_STATE(1068)] = 32313,
  [SMALL_STATE(1069)] = 32321,
  [SMALL_STATE(1070)] = 32331,
  [SMALL_STATE(1071)] = 32341,
  [SMALL_STATE(1072)] = 32351,
  [SMALL_STATE(1073)] = 32361,
  [SMALL_STATE(1074)] = 32371,
  [SMALL_STATE(1075)] = 32381,
  [SMALL_STATE(1076)] = 32391,
  [SMALL_STATE(1077)] = 32401,
  [SMALL_STATE(1078)] = 32411,
  [SMALL_STATE(1079)] = 32419,
  [SMALL_STATE(1080)] = 32429,
  [SMALL_STATE(1081)] = 32439,
  [SMALL_STATE(1082)] = 32446,
  [SMALL_STATE(1083)] = 32453,
  [SMALL_STATE(1084)] = 32460,
  [SMALL_STATE(1085)] = 32467,
  [SMALL_STATE(1086)] = 32474,
  [SMALL_STATE(1087)] = 32481,
  [SMALL_STATE(1088)] = 32488,
  [SMALL_STATE(1089)] = 32495,
  [SMALL_STATE(1090)] = 32502,
  [SMALL_STATE(1091)] = 32509,
  [SMALL_STATE(1092)] = 32516,
  [SMALL_STATE(1093)] = 32523,
  [SMALL_STATE(1094)] = 32530,
  [SMALL_STATE(1095)] = 32537,
  [SMALL_STATE(1096)] = 32544,
  [SMALL_STATE(1097)] = 32551,
  [SMALL_STATE(1098)] = 32558,
  [SMALL_STATE(1099)] = 32565,
  [SMALL_STATE(1100)] = 32572,
  [SMALL_STATE(1101)] = 32579,
  [SMALL_STATE(1102)] = 32586,
  [SMALL_STATE(1103)] = 32593,
  [SMALL_STATE(1104)] = 32600,
  [SMALL_STATE(1105)] = 32607,
  [SMALL_STATE(1106)] = 32614,
  [SMALL_STATE(1107)] = 32621,
  [SMALL_STATE(1108)] = 32628,
  [SMALL_STATE(1109)] = 32635,
  [SMALL_STATE(1110)] = 32642,
  [SMALL_STATE(1111)] = 32649,
  [SMALL_STATE(1112)] = 32656,
  [SMALL_STATE(1113)] = 32663,
  [SMALL_STATE(1114)] = 32670,
  [SMALL_STATE(1115)] = 32677,
  [SMALL_STATE(1116)] = 32684,
  [SMALL_STATE(1117)] = 32691,
  [SMALL_STATE(1118)] = 32698,
  [SMALL_STATE(1119)] = 32705,
  [SMALL_STATE(1120)] = 32712,
  [SMALL_STATE(1121)] = 32719,
  [SMALL_STATE(1122)] = 32726,
  [SMALL_STATE(1123)] = 32733,
  [SMALL_STATE(1124)] = 32740,
  [SMALL_STATE(1125)] = 32747,
  [SMALL_STATE(1126)] = 32754,
  [SMALL_STATE(1127)] = 32761,
  [SMALL_STATE(1128)] = 32768,
  [SMALL_STATE(1129)] = 32775,
  [SMALL_STATE(1130)] = 32782,
  [SMALL_STATE(1131)] = 32789,
  [SMALL_STATE(1132)] = 32796,
  [SMALL_STATE(1133)] = 32803,
  [SMALL_STATE(1134)] = 32810,
  [SMALL_STATE(1135)] = 32817,
  [SMALL_STATE(1136)] = 32824,
  [SMALL_STATE(1137)] = 32831,
  [SMALL_STATE(1138)] = 32838,
  [SMALL_STATE(1139)] = 32845,
  [SMALL_STATE(1140)] = 32852,
  [SMALL_STATE(1141)] = 32859,
  [SMALL_STATE(1142)] = 32866,
  [SMALL_STATE(1143)] = 32873,
  [SMALL_STATE(1144)] = 32880,
  [SMALL_STATE(1145)] = 32887,
  [SMALL_STATE(1146)] = 32894,
  [SMALL_STATE(1147)] = 32901,
  [SMALL_STATE(1148)] = 32908,
  [SMALL_STATE(1149)] = 32915,
  [SMALL_STATE(1150)] = 32922,
  [SMALL_STATE(1151)] = 32929,
  [SMALL_STATE(1152)] = 32936,
  [SMALL_STATE(1153)] = 32943,
  [SMALL_STATE(1154)] = 32950,
  [SMALL_STATE(1155)] = 32957,
  [SMALL_STATE(1156)] = 32964,
  [SMALL_STATE(1157)] = 32971,
  [SMALL_STATE(1158)] = 32978,
  [SMALL_STATE(1159)] = 32985,
  [SMALL_STATE(1160)] = 32992,
  [SMALL_STATE(1161)] = 32999,
  [SMALL_STATE(1162)] = 33006,
  [SMALL_STATE(1163)] = 33013,
  [SMALL_STATE(1164)] = 33020,
  [SMALL_STATE(1165)] = 33027,
  [SMALL_STATE(1166)] = 33034,
  [SMALL_STATE(1167)] = 33041,
  [SMALL_STATE(1168)] = 33048,
  [SMALL_STATE(1169)] = 33055,
  [SMALL_STATE(1170)] = 33062,
  [SMALL_STATE(1171)] = 33069,
  [SMALL_STATE(1172)] = 33076,
  [SMALL_STATE(1173)] = 33083,
  [SMALL_STATE(1174)] = 33090,
  [SMALL_STATE(1175)] = 33097,
  [SMALL_STATE(1176)] = 33104,
  [SMALL_STATE(1177)] = 33111,
  [SMALL_STATE(1178)] = 33118,
  [SMALL_STATE(1179)] = 33125,
  [SMALL_STATE(1180)] = 33132,
  [SMALL_STATE(1181)] = 33139,
  [SMALL_STATE(1182)] = 33146,
  [SMALL_STATE(1183)] = 33153,
  [SMALL_STATE(1184)] = 33160,
  [SMALL_STATE(1185)] = 33167,
  [SMALL_STATE(1186)] = 33174,
  [SMALL_STATE(1187)] = 33181,
  [SMALL_STATE(1188)] = 33188,
  [SMALL_STATE(1189)] = 33195,
  [SMALL_STATE(1190)] = 33202,
  [SMALL_STATE(1191)] = 33209,
  [SMALL_STATE(1192)] = 33216,
  [SMALL_STATE(1193)] = 33223,
  [SMALL_STATE(1194)] = 33230,
  [SMALL_STATE(1195)] = 33237,
  [SMALL_STATE(1196)] = 33244,
  [SMALL_STATE(1197)] = 33251,
  [SMALL_STATE(1198)] = 33258,
  [SMALL_STATE(1199)] = 33265,
  [SMALL_STATE(1200)] = 33272,
  [SMALL_STATE(1201)] = 33279,
  [SMALL_STATE(1202)] = 33286,
  [SMALL_STATE(1203)] = 33293,
  [SMALL_STATE(1204)] = 33300,
  [SMALL_STATE(1205)] = 33307,
  [SMALL_STATE(1206)] = 33314,
  [SMALL_STATE(1207)] = 33321,
  [SMALL_STATE(1208)] = 33328,
  [SMALL_STATE(1209)] = 33335,
  [SMALL_STATE(1210)] = 33342,
  [SMALL_STATE(1211)] = 33349,
  [SMALL_STATE(1212)] = 33356,
  [SMALL_STATE(1213)] = 33363,
  [SMALL_STATE(1214)] = 33370,
  [SMALL_STATE(1215)] = 33377,
  [SMALL_STATE(1216)] = 33384,
  [SMALL_STATE(1217)] = 33391,
  [SMALL_STATE(1218)] = 33398,
  [SMALL_STATE(1219)] = 33405,
  [SMALL_STATE(1220)] = 33412,
  [SMALL_STATE(1221)] = 33419,
  [SMALL_STATE(1222)] = 33426,
  [SMALL_STATE(1223)] = 33433,
  [SMALL_STATE(1224)] = 33440,
  [SMALL_STATE(1225)] = 33447,
  [SMALL_STATE(1226)] = 33454,
  [SMALL_STATE(1227)] = 33461,
  [SMALL_STATE(1228)] = 33468,
  [SMALL_STATE(1229)] = 33475,
  [SMALL_STATE(1230)] = 33482,
  [SMALL_STATE(1231)] = 33489,
  [SMALL_STATE(1232)] = 33496,
  [SMALL_STATE(1233)] = 33503,
  [SMALL_STATE(1234)] = 33510,
  [SMALL_STATE(1235)] = 33517,
  [SMALL_STATE(1236)] = 33524,
  [SMALL_STATE(1237)] = 33531,
  [SMALL_STATE(1238)] = 33538,
  [SMALL_STATE(1239)] = 33545,
  [SMALL_STATE(1240)] = 33552,
  [SMALL_STATE(1241)] = 33559,
  [SMALL_STATE(1242)] = 33566,
  [SMALL_STATE(1243)] = 33573,
  [SMALL_STATE(1244)] = 33580,
  [SMALL_STATE(1245)] = 33587,
  [SMALL_STATE(1246)] = 33594,
  [SMALL_STATE(1247)] = 33601,
  [SMALL_STATE(1248)] = 33608,
  [SMALL_STATE(1249)] = 33615,
  [SMALL_STATE(1250)] = 33622,
  [SMALL_STATE(1251)] = 33629,
  [SMALL_STATE(1252)] = 33636,
  [SMALL_STATE(1253)] = 33643,
  [SMALL_STATE(1254)] = 33650,
  [SMALL_STATE(1255)] = 33657,
  [SMALL_STATE(1256)] = 33664,
  [SMALL_STATE(1257)] = 33671,
  [SMALL_STATE(1258)] = 33678,
  [SMALL_STATE(1259)] = 33685,
  [SMALL_STATE(1260)] = 33692,
  [SMALL_STATE(1261)] = 33699,
  [SMALL_STATE(1262)] = 33706,
  [SMALL_STATE(1263)] = 33713,
  [SMALL_STATE(1264)] = 33720,
  [SMALL_STATE(1265)] = 33727,
  [SMALL_STATE(1266)] = 33734,
  [SMALL_STATE(1267)] = 33741,
  [SMALL_STATE(1268)] = 33748,
  [SMALL_STATE(1269)] = 33755,
  [SMALL_STATE(1270)] = 33762,
  [SMALL_STATE(1271)] = 33769,
  [SMALL_STATE(1272)] = 33776,
  [SMALL_STATE(1273)] = 33783,
  [SMALL_STATE(1274)] = 33790,
  [SMALL_STATE(1275)] = 33797,
  [SMALL_STATE(1276)] = 33804,
  [SMALL_STATE(1277)] = 33811,
  [SMALL_STATE(1278)] = 33818,
  [SMALL_STATE(1279)] = 33825,
  [SMALL_STATE(1280)] = 33832,
  [SMALL_STATE(1281)] = 33839,
  [SMALL_STATE(1282)] = 33846,
  [SMALL_STATE(1283)] = 33853,
  [SMALL_STATE(1284)] = 33860,
  [SMALL_STATE(1285)] = 33867,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_makefile, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(858),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(872),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1086),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1061),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1109),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(491),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(550),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(759),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(874),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(875),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1262),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1066),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1237),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(456),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1165),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(805),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(722),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(754),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1257),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1250),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1169),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1143),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1214),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elsif_directive, 2, 0, 15),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(79),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(874),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(875),
  [100] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(1262),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(536),
  [106] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(1066),
  [109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(396),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(453),
  [115] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(324),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(1237),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(456),
  [124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(491),
  [129] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(461),
  [132] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(550),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(555),
  [138] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(759),
  [141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(722),
  [144] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(754),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__conditional_consequence, 2, 0, 0), SHIFT_REPEAT(383),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elsif_directive, 3, 0, 25),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_directive, 2, 0, 0),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_directive, 3, 0, 24),
  [156] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1025),
  [160] = {.entry = {.count = 1, .reusable = false}}, SHIFT(770),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(770),
  [164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(598),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(608),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(748),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(632),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1019),
  [180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(633),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(634),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1043),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1006),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1039),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(616),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(617),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1021),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(645),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(619),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1029),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(620),
  [218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(621),
  [220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1018),
  [224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(622),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(623),
  [228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1034),
  [232] = {.entry = {.count = 1, .reusable = false}}, SHIFT(625),
  [234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(626),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1059),
  [240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(627),
  [242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(628),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1013),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(629),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(630),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_makefile, 1, 0, 0),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0),
  [256] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(75),
  [259] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(858),
  [262] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(872),
  [265] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(1086),
  [268] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(527),
  [271] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(1061),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(414),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(468),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(319),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(1109),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(455),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(491),
  [292] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(461),
  [295] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(550),
  [298] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(555),
  [301] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(759),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(759),
  [307] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(722),
  [310] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_makefile_repeat1, 2, 0, 0), SHIFT_REPEAT(754),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 3, 0, 17),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 2, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 4, 0, 17),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 4, 0, 29),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0),
  [323] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(491),
  [326] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(461),
  [329] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(550),
  [332] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(555),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(383),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 5, 0, 40),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 5, 0, 41),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 3, 0, 0),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 5, 0, 43),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 6, 0, 52),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 6, 0, 54),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 6, 0, 57),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 6, 0, 43),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 6, 0, 58),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ordinary_rule, 7, 0, 65),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 7, 0, 54),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 7, 0, 66),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 7, 0, 69),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__static_pattern_rule, 8, 0, 76),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 2, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 5, 0, 40),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 6, 0, 52),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 6, 0, 54),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 6, 0, 57),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 6, 0, 43),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 6, 0, 58),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 7, 0, 65),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 7, 0, 54),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 7, 0, 66),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 7, 0, 69),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 8, 0, 76),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 4, 0, 29),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 5, 0, 41),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 3, 0, 0),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 3, 0, 17),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_pattern_rule, 5, 0, 43),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ordinary_rule, 4, 0, 17),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(412),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 1, 0, 0),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(624),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(790),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 1, 0, 0),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(602),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(764),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(747),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(743),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(603),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(638),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(599),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 1, 0, 4),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(796),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(862),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(863),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(876),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(723),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 1, 0, 4),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(792),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(469),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(852),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(853),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(847),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 4, 0, 12),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 4, 0, 12),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ifeq_directive, 3, 0, 10),
  [511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifeq_directive, 3, 0, 10),
  [513] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ifneq_directive, 3, 0, 10),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifneq_directive, 3, 0, 10),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ifdef_directive, 3, 0, 8),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifdef_directive, 3, 0, 8),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ifndef_directive, 3, 0, 8),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifndef_directive, 3, 0, 8),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2, 0, 0),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefixed_recipe_line, 2, 0, 0),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefixed_recipe_line, 2, 0, 0),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule, 1, 0, 1),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule, 1, 0, 1),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule, 1, 0, 2),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule, 1, 0, 2),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vpath_directive, 2, 0, 0),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vpath_directive, 2, 0, 0),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_export_directive, 2, 0, 0),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export_directive, 2, 0, 0),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unexport_directive, 2, 0, 0),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unexport_directive, 2, 0, 0),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_override_directive, 2, 0, 0),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_override_directive, 2, 0, 0),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_private_directive, 2, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_private_directive, 2, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__thing, 2, 0, 0),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__thing, 2, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_directive, 3, 0, 5),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_directive, 3, 0, 5),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vpath_directive, 3, 0, 6),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vpath_directive, 3, 0, 6),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_export_directive, 3, 0, 7),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export_directive, 3, 0, 7),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unexport_directive, 3, 0, 7),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unexport_directive, 3, 0, 7),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_undefine_directive, 3, 0, 8),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_undefine_directive, 3, 0, 8),
  [593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 3, 0, 12),
  [595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 3, 0, 12),
  [597] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 3, 0, 14),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 3, 0, 14),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(758),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [605] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [609] = {.entry = {.count = 1, .reusable = false}}, SHIFT(922),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(923),
  [613] = {.entry = {.count = 1, .reusable = false}}, SHIFT(782),
  [615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(944),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_VPATH_assignment, 4, 0, 19),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_VPATH_assignment, 4, 0, 19),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_RECIPEPREFIX_assignment, 4, 0, 19),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_RECIPEPREFIX_assignment, 4, 0, 19),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vpath_directive, 4, 0, 20),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vpath_directive, 4, 0, 20),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 4, 0, 22),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 4, 0, 22),
  [633] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 4, 0, 19),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 4, 0, 19),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_assignment, 4, 0, 19),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_assignment, 4, 0, 19),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 4, 0, 14),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 4, 0, 14),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 4, 0, 26),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 4, 0, 26),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_VPATH_assignment, 5, 0, 30),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_VPATH_assignment, 5, 0, 30),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_RECIPEPREFIX_assignment, 5, 0, 30),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_RECIPEPREFIX_assignment, 5, 0, 30),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 5, 0, 32),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 5, 0, 32),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 5, 0, 22),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 5, 0, 22),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 5, 0, 30),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 5, 0, 30),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_assignment, 5, 0, 30),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_assignment, 5, 0, 30),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 5, 0, 37),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 5, 0, 37),
  [677] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_assignment, 5, 0, 37),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_assignment, 5, 0, 37),
  [681] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 5, 0, 26),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 5, 0, 26),
  [685] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 5, 0, 14),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 5, 0, 14),
  [689] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 5, 0, 42),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 5, 0, 42),
  [693] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 6, 0, 44),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 6, 0, 44),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 6, 0, 32),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 6, 0, 32),
  [701] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [703] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 6, 0, 49),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 6, 0, 49),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_assignment, 6, 0, 49),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_assignment, 6, 0, 49),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 6, 0, 26),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 6, 0, 26),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 6, 0, 53),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 6, 0, 53),
  [721] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 6, 0, 55),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 6, 0, 55),
  [725] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 6, 0, 42),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 6, 0, 42),
  [729] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 6, 0, 56),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 6, 0, 56),
  [733] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefixed_recipe_line, 3, 0, 0),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefixed_recipe_line, 3, 0, 0),
  [737] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 7, 0, 59),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 7, 0, 59),
  [741] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 7, 0, 32),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 7, 0, 32),
  [745] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 7, 0, 60),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 7, 0, 60),
  [749] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 7, 0, 61),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 7, 0, 61),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 7, 0, 45),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 7, 0, 45),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 63),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 63),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 53),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 53),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 64),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 64),
  [769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(618),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 1, 0, 4),
  [773] = {.entry = {.count = 1, .reusable = false}}, SHIFT(789),
  [775] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(880),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(895),
  [785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(911),
  [787] = {.entry = {.count = 1, .reusable = false}}, SHIFT(777),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 55),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 55),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 67),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 67),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 7, 0, 68),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 7, 0, 68),
  [801] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 8, 0, 70),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 8, 0, 70),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 8, 0, 71),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 8, 0, 71),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 8, 0, 60),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 8, 0, 60),
  [813] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 8, 0, 72),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 8, 0, 72),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 8, 0, 63),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 8, 0, 63),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 8, 0, 74),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 8, 0, 74),
  [825] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 8, 0, 75),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 8, 0, 75),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 8, 0, 77),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 8, 0, 77),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 9, 0, 78),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 9, 0, 78),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 9, 0, 79),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 9, 0, 79),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(797),
  [843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(912),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(913),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(908),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(767),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [861] = {.entry = {.count = 1, .reusable = false}}, SHIFT(604),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(605),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_define_directive, 6, 0, 45),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_define_directive, 6, 0, 45),
  [869] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1023),
  [873] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1020),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 1, 0, 0),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 1, 0, 0),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(512),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [897] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1046),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [911] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [917] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [921] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1044),
  [925] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1009),
  [929] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1041),
  [933] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1049),
  [937] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1024),
  [941] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1035),
  [945] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1008),
  [949] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1014),
  [953] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_concatenation, 2, 0, 0),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_concatenation, 2, 0, 0),
  [957] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [961] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [963] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(197),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0),
  [968] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0),
  [970] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(764),
  [973] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(747),
  [976] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(743),
  [979] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(192),
  [982] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(790),
  [985] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(722),
  [988] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(754),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [993] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [999] = {.entry = {.count = 1, .reusable = false}}, SHIFT(601),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [1003] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [1005] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(278),
  [1008] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(770),
  [1011] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(770),
  [1014] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(742),
  [1017] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(748),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1024] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paths, 1, 0, 0),
  [1028] = {.entry = {.count = 1, .reusable = false}}, SHIFT(800),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(724),
  [1036] = {.entry = {.count = 1, .reusable = false}}, SHIFT(725),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1040] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_paths_repeat1, 2, 0, 0),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(807),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 0),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(831),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(992),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(957),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(899),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(855),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(865),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(915),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(925),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(332),
  [1127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(800),
  [1130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(724),
  [1133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2, 0, 0), SHIFT_REPEAT(725),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(952),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(982),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(964),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attached_recipe_line, 1, 0, 0),
  [1162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(704),
  [1164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [1166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(706),
  [1168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [1170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1194),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(795),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(861),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(871),
  [1182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(921),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(757),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(932),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1226),
  [1198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [1200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditional_args_cmp, 2, 0, 9),
  [1202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(822),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 1, 0, 4),
  [1250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(886),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 1, 0, 4),
  [1272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 1, 0, 4),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 1, 0, 4),
  [1276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 1, 0, 4),
  [1278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(887),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 31),
  [1282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 31),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(800),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(724),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(725),
  [1292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 1, 0, 4),
  [1294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 31),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(764),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1242),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat2, 1, 0, 4),
  [1316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(659),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(988),
  [1322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 1, 0, 4),
  [1324] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1000),
  [1326] = {.entry = {.count = 1, .reusable = false}}, SHIFT(687),
  [1328] = {.entry = {.count = 1, .reusable = false}}, SHIFT(660),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1146),
  [1334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(703),
  [1336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat2, 2, 0, 31),
  [1338] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0), SHIFT_REPEAT(758),
  [1341] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0), SHIFT_REPEAT(109),
  [1344] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0), SHIFT_REPEAT(669),
  [1347] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0), SHIFT_REPEAT(746),
  [1350] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0), SHIFT_REPEAT(688),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(652),
  [1451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [1453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(611),
  [1455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(656),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(657),
  [1461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [1463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(692),
  [1465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(718),
  [1467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0),
  [1469] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(796),
  [1472] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(481),
  [1475] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(876),
  [1478] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(812),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(661),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(668),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(673),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(676),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(707),
  [1505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(651),
  [1507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(653),
  [1509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [1511] = {.entry = {.count = 1, .reusable = false}}, SHIFT(711),
  [1513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(741),
  [1515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(654),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 2, 0, 4),
  [1519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [1521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 1, 0, 0),
  [1523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(727),
  [1525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 2, 0, 0),
  [1527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(732),
  [1529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(662),
  [1531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(663),
  [1533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(665),
  [1535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(693),
  [1541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(671),
  [1543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(674),
  [1545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(675),
  [1547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(677),
  [1549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(678),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(646),
  [1555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(683),
  [1557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(714),
  [1559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(685),
  [1561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(686),
  [1563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(689),
  [1565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(690),
  [1567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0),
  [1569] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(792),
  [1572] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(469),
  [1575] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(808),
  [1578] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(847),
  [1581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(708),
  [1583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(694),
  [1585] = {.entry = {.count = 1, .reusable = false}}, SHIFT(695),
  [1587] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 2, 0, 4),
  [1589] = {.entry = {.count = 1, .reusable = false}}, SHIFT(749),
  [1591] = {.entry = {.count = 1, .reusable = false}}, SHIFT(709),
  [1593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 2, 0, 0),
  [1595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(726),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(710),
  [1601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(667),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1605] = {.entry = {.count = 1, .reusable = false}}, SHIFT(647),
  [1607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(648),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [1613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 1, 0, 0),
  [1615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(730),
  [1617] = {.entry = {.count = 1, .reusable = false}}, SHIFT(670),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_function, 6, 0, 35),
  [1625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_function, 6, 0, 35),
  [1627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0),
  [1629] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(796),
  [1632] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(448),
  [1635] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(877),
  [1638] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [1640] = {.entry = {.count = 1, .reusable = false}}, SHIFT(849),
  [1642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 1, 0, 0),
  [1644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(877),
  [1648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1650] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(758),
  [1653] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(534),
  [1656] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(804),
  [1659] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0), SHIFT_REPEAT(944),
  [1662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 6, 0, 35),
  [1666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 6, 0, 35),
  [1668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [1672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(746),
  [1674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(688),
  [1676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 5, 0, 35),
  [1678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 5, 0, 35),
  [1680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_function, 5, 0, 35),
  [1686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_function, 5, 0, 35),
  [1688] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(797),
  [1691] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(509),
  [1694] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(908),
  [1697] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(817),
  [1700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1704] = {.entry = {.count = 1, .reusable = false}}, SHIFT(773),
  [1706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(787),
  [1708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0),
  [1712] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(792),
  [1715] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(470),
  [1718] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(849),
  [1721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 2, 0, 0),
  [1723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 2, 0, 4),
  [1725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(755),
  [1727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(774),
  [1729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(786),
  [1731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(783),
  [1733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0),
  [1735] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(789),
  [1738] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(520),
  [1741] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(911),
  [1744] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat2, 2, 0, 0), SHIFT_REPEAT(816),
  [1747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(766),
  [1749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1753] = {.entry = {.count = 1, .reusable = false}}, SHIFT(768),
  [1755] = {.entry = {.count = 1, .reusable = false}}, SHIFT(771),
  [1757] = {.entry = {.count = 1, .reusable = false}}, SHIFT(785),
  [1759] = {.entry = {.count = 1, .reusable = false}}, SHIFT(781),
  [1761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(733),
  [1763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(788),
  [1765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(752),
  [1767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [1769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(940),
  [1771] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(789),
  [1774] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(529),
  [1777] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(940),
  [1780] = {.entry = {.count = 1, .reusable = false}}, SHIFT(784),
  [1782] = {.entry = {.count = 1, .reusable = false}}, SHIFT(776),
  [1784] = {.entry = {.count = 1, .reusable = false}}, SHIFT(715),
  [1786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(843),
  [1790] = {.entry = {.count = 1, .reusable = false}}, SHIFT(825),
  [1792] = {.entry = {.count = 1, .reusable = false}}, SHIFT(728),
  [1794] = {.entry = {.count = 1, .reusable = false}}, SHIFT(729),
  [1796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 3, 0, 0),
  [1798] = {.entry = {.count = 1, .reusable = false}}, SHIFT(824),
  [1800] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [1802] = {.entry = {.count = 1, .reusable = false}}, SHIFT(845),
  [1804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(815),
  [1806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 3, 0, 0),
  [1808] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string, 2, 0, 0), SHIFT_REPEAT(785),
  [1811] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string, 2, 0, 0),
  [1813] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string, 2, 0, 0), SHIFT_REPEAT(733),
  [1816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_text_without_split, 3, 0, 4),
  [1818] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(797),
  [1821] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(532),
  [1824] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(910),
  [1827] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [1829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(945),
  [1831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(910),
  [1835] = {.entry = {.count = 1, .reusable = false}}, SHIFT(814),
  [1837] = {.entry = {.count = 1, .reusable = false}}, SHIFT(750),
  [1839] = {.entry = {.count = 1, .reusable = false}}, SHIFT(769),
  [1841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(745),
  [1843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(721),
  [1845] = {.entry = {.count = 1, .reusable = false}}, SHIFT(731),
  [1847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 3, 0, 4),
  [1849] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(758),
  [1852] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(525),
  [1855] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0), SHIFT_REPEAT(945),
  [1858] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string, 2, 0, 0), SHIFT_REPEAT(788),
  [1861] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string, 2, 0, 0), SHIFT_REPEAT(752),
  [1864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(717),
  [1866] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [1868] = {.entry = {.count = 1, .reusable = false}}, SHIFT(948),
  [1870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_substitution_reference, 8, 0, 73),
  [1872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution_reference, 8, 0, 73),
  [1874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1882] = {.entry = {.count = 1, .reusable = false}}, SHIFT(762),
  [1884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(772),
  [1886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_archive, 4, 0, 23),
  [1888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_archive, 4, 0, 23),
  [1890] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_reference, 2, 0, 0),
  [1892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_reference, 2, 0, 0),
  [1894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1898] = {.entry = {.count = 1, .reusable = false}}, SHIFT(763),
  [1900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [1902] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_automatic_variable, 2, 0, 0),
  [1904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_automatic_variable, 2, 0, 0),
  [1906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(881),
  [1910] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 3),
  [1912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 3),
  [1914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1918] = {.entry = {.count = 1, .reusable = false}}, SHIFT(801),
  [1920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [1922] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [1924] = {.entry = {.count = 1, .reusable = false}}, SHIFT(906),
  [1926] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_automatic_variable, 4, 0, 0),
  [1928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_automatic_variable, 4, 0, 0),
  [1930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_reference, 4, 0, 0),
  [1932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_reference, 4, 0, 0),
  [1934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 11),
  [1936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 11),
  [1938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(985),
  [1944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(989),
  [1946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(976),
  [1952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(977),
  [1954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1958] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_automatic_variable, 5, 0, 0),
  [1960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_automatic_variable, 5, 0, 0),
  [1962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1974] = {.entry = {.count = 1, .reusable = false}}, SHIFT(832),
  [1976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(906),
  [1982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(845),
  [1988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(948),
  [1992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [2000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1031),
  [2002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1122),
  [2004] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1080),
  [2006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1036),
  [2008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(836),
  [2010] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1073),
  [2012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1055),
  [2014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1217),
  [2016] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1075),
  [2018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1022),
  [2020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(834),
  [2022] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1067),
  [2024] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(578),
  [2027] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(551),
  [2030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [2032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [2034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(939),
  [2036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat2, 2, 0, 0),
  [2038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(892),
  [2040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 1, 0, 0),
  [2042] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 1, 0, 0),
  [2044] = {.entry = {.count = 1, .reusable = false}}, SHIFT(888),
  [2046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(893),
  [2048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [2050] = {.entry = {.count = 1, .reusable = false}}, SHIFT(531),
  [2052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(885),
  [2054] = {.entry = {.count = 1, .reusable = false}}, SHIFT(744),
  [2056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(933),
  [2058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(937),
  [2060] = {.entry = {.count = 1, .reusable = false}}, SHIFT(519),
  [2062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(938),
  [2064] = {.entry = {.count = 1, .reusable = false}}, SHIFT(719),
  [2066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 1, 0, 0),
  [2068] = {.entry = {.count = 1, .reusable = false}}, SHIFT(936),
  [2070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1150),
  [2072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [2074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [2076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(753),
  [2078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 4),
  [2080] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 4),
  [2082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 4),
  [2084] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 4),
  [2086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_text_without_split_repeat1, 2, 0, 0),
  [2088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_line_repeat1, 2, 0, 0),
  [2090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1247),
  [2092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1276),
  [2094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [2096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [2098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [2100] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [2102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_text_with_split, 2, 0, 0),
  [2104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1167),
  [2106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1185),
  [2108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [2110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [2112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [2114] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [2116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [2118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1245),
  [2120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0),
  [2122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [2124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(740),
  [2126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [2128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [2130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [2132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 1, 0, 0),
  [2134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(980),
  [2136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [2138] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [2140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(975),
  [2142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [2144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(514),
  [2146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [2148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [2150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [2152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [2154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [2156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__normal_prerequisites, 1, 0, 18),
  [2158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [2160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__normal_prerequisites, 1, 0, 18),
  [2162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [2164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [2166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [2168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [2170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [2172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [2174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [2176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paths, 2, 0, 0),
  [2178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [2180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [2182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [2184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [2186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [2188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [2190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [2192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [2194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [2196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [2198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [2200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [2202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [2204] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paths_repeat1, 2, 0, 0), SHIFT_REPEAT(554),
  [2207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [2209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [2211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_conditional_repeat1, 2, 0, 0),
  [2213] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_conditional_repeat1, 2, 0, 0), SHIFT_REPEAT(820),
  [2216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [2218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [2220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [2222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1, 0, 21),
  [2224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(806),
  [2226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1170),
  [2228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1123),
  [2230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1068),
  [2232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(864),
  [2234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1177),
  [2236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1182),
  [2238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1125),
  [2240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1106),
  [2242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1112),
  [2244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(914),
  [2246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1192),
  [2248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1197),
  [2250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_define_directive_repeat1, 2, 0, 0),
  [2252] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_define_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(1068),
  [2255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1114),
  [2257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1279),
  [2259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(897),
  [2261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1134),
  [2263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(924),
  [2265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1215),
  [2267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1223),
  [2269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(990),
  [2271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1098),
  [2273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1105),
  [2275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1102),
  [2277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1139),
  [2279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [2281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1163),
  [2283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1127),
  [2285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1162),
  [2287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1124),
  [2289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(954),
  [2291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1116),
  [2293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1232),
  [2295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1085),
  [2297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2, 0, 36),
  [2299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1201),
  [2301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(854),
  [2303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1155),
  [2305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1158),
  [2307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1266),
  [2309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1108),
  [2311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1095),
  [2313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(827),
  [2315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1269),
  [2317] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 48), SHIFT_REPEAT(716),
  [2320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 48),
  [2322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1082),
  [2324] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1111),
  [2326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(778),
  [2328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1267),
  [2330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1270),
  [2332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1115),
  [2334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1183),
  [2336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1213),
  [2338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1119),
  [2340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1236),
  [2342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [2344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [2346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1238),
  [2348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1283),
  [2350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1253),
  [2352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1284),
  [2354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1193),
  [2356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1259),
  [2358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1239),
  [2360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1173),
  [2362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1191),
  [2364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [2366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [2368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 1, 0, 16),
  [2370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(896),
  [2372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 2, 0, 27),
  [2374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 3, 0, 38),
  [2376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 3, 0, 39),
  [2378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(462),
  [2380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [2382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1017),
  [2384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1128),
  [2386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_define_directive_repeat1, 1, 0, 0),
  [2388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(844),
  [2390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1132),
  [2392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 2, 0, 28),
  [2394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 4, 0, 51),
  [2396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 4, 0, 50),
  [2398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1056),
  [2400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1219),
  [2402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(848),
  [2404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1220),
  [2406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1045),
  [2408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1221),
  [2410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 5, 0, 62),
  [2412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [2414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1069),
  [2416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 47),
  [2418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [2420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1074),
  [2422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1027),
  [2424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1256),
  [2426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(775),
  [2428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [2430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(823),
  [2432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [2434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [2436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [2438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(756),
  [2440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(760),
  [2442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1277),
  [2444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [2446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [2448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [2450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [2452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [2454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [2456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(993),
  [2458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(994),
  [2460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(995),
  [2462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1208),
  [2464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(996),
  [2466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1001),
  [2468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [2470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [2472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [2474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [2476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1148),
  [2478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [2480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [2482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [2484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [2486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [2488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [2490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(959),
  [2492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(960),
  [2494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(961),
  [2496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(962),
  [2498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(963),
  [2500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1057),
  [2502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [2504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [2506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [2508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [2510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [2512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1060),
  [2514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [2516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [2518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(873),
  [2520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [2522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(900),
  [2524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(902),
  [2526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1186),
  [2528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(903),
  [2530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1204),
  [2532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(904),
  [2534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(905),
  [2536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [2538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [2540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [2542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditional_args_cmp, 3, 0, 0),
  [2544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [2546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [2548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [2550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [2552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [2554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [2556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [2558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [2560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(857),
  [2562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(879),
  [2564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(859),
  [2566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(860),
  [2568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shell_command, 1, 0, 13),
  [2570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [2572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [2574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [2576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [2578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [2580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [2582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [2584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [2586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [2588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [2590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(810),
  [2592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(866),
  [2594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(867),
  [2596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(868),
  [2598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [2600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(869),
  [2602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(870),
  [2604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [2606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(811),
  [2608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [2610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [2612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [2614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(818),
  [2616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(819),
  [2618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [2620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [2622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(916),
  [2624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [2626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditional_args_cmp, 5, 0, 46),
  [2628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(918),
  [2630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [2632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(919),
  [2634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [2636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(920),
  [2638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [2640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [2642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [2644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [2646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [2648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [2650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [2652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [2654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [2656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [2658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [2660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [2662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [2664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [2666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(926),
  [2668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(927),
  [2670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1042),
  [2672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(929),
  [2674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1010),
  [2676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(851),
  [2678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1052),
  [2680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attached_recipe_line, 2, 0, 0),
  [2682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(930),
  [2684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [2686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditional_args_cmp, 4, 0, 33),
  [2688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(931),
  [2690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [2692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [2694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [2696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [2698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [2700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [2702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [2704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [2706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1203),
  [2708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [2710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [2712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1069),
  [2714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [2716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditional_args_cmp, 4, 0, 34),
  [2718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [2720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [2722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [2724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [2726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [2728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [2730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1166),
  [2732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [2734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [2736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [2738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [2740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [2742] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [2744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1016),
  [2746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [2748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [2750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [2752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [2754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [2756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [2758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1074),
  [2760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [2762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [2764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [2766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(798),
  [2768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1153),
  [2770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [2772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [2774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [2776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [2778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [2780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [2782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(830),
  [2784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [2786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [2788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [2790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(833),
  [2792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [2794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [2796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(917),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_make(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_word,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
