<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

December 14, 2020

Host: Michael Dolan

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [ ] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Alessandra Tomassi - Industrial Light & Magic
  * [X] Thomas Mansencal - Weta Digital
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Joseph Goldstone - ARRI

Apologies:
  * Mark Boorer
  * Mark Titchener

# **OCIO TSC Meeting Notes**

* Doug to summarize in-progress work:
    - Doug: Have PR in progress about moving app helpers to core, and for 
      category updates described in issue #1222.
        - Current PR for small BuiltinTransform changes. Much larger PR in 
          progress - adding remaining ACES transforms.
        - CDLTransform cleanup PR is ready to be merged.
        - Maya beta going out with preliminary OCIO v2 integration. Not on 
          by default - needs environment variable. Very preliminary, missing 
          stuff, but felt it was important to get it out as soon as possible. 
          We're worried it's not being tested enough. Good way to get 
          additional coverage.
        - Carol: We'll do some testing at Netflix with it.
        - Thomas: Any word on Nuke?
        - Michael: Mark Titchener mentioned last week that they are working on 
          Nuke implementation. Hoping to have something around end of January 
          or so.
        - Patrick: Regarding the preliminary Maya integration - it just hints 
          at what's coming, so keep in mind.
        - Doug: Will be a post on rendering forum with more details.
        - Michael: How long did it take to implement, roughly?
        - Patrick: Took quite a bit of time. We did deep integration of color 
          management in Maya, so replacement with OCIO v2 is a lot of work. 
          Depends on integration in your tool; could be straightforward. In 
          Maya it was deeply integrated, so was not trivial. Nothing to do 
          with library itself. Even if it's preliminary, OCIO v2 is still here. 
          Can use config and displays, etc. Limitations listed in release 
          notes.
        - Doug: Not sure in release notes, but in rendering forum. Will post 
          issues there. We had the most difficult job since we're transitioning 
          from SynColor and have to have backwards compatibility. Lot of work 
          for us, but hoping companies already using OCIO v1 exclusively will 
          be more straightforward. Some new work to take advantage of new 
          features, but getting up and running should be less complex.
        - Patrick: Someone did integration in another tool and had it up and 
          running in week.

* Enable the new GitHub Discussions feature for OCIO?
    - Michael: Been some discussion on this in Slack with mixed responses. I 
      can enable it to play with if we think it's useful.
    - Thomas: Can mark topics as answered, so could be mini Stack Overflow on 
      GH. Could be useful. Will try to use it on colour science.
    - Patrick: How do you compare it to Google groups?
    - Thomas: Good question. We don't have a lot of good Groups traffic, but 
      think will make sense to put it in GH.
    - Michael: Would be nice to get ocio-dev/ocio-user out there like that. 
      Lots of channels currently, but lists is less accessible.
    - Thomas: Not much traffic there now.
    - Carol: Would be interested in that too. Could test as method for 
      replacing it.
    - Michael: Could enable it just to test. To push buttons, etc. Could set it 
      up on OpenColorIO-Configs-ACES repo if we want to test it somewhere less 
      active.
    - Patrick: Have to be careful. We have changed a lot. Need to not lose 
      existing community. Something to keep in mind.
    - Thomas: Good point. We have same concern. Has useful features though, 
      like turning GH issues into discussion. Can move between issue and 
      discussion, to keep issue board clean. Much harder on mail list. Could 
      de-clutter issue tracker.
    - Michael: A lot of our traffic has moved to Slack, since it's more real 
      time. Same for ASWF discussion. There was initially concern about Slack,
      since it is expensive to keep history, but a lot of discussion has moved 
      there.
    - Doug: Happened to quite a few mail lists when they added Slack option.

* Remove OIIO dependency from OCIO apps (Issue #1233)
    - Michael: This topic has been ongoing for a couple years. Propose in #1233 
      to implement the fix of replace OIIO with OpenEXR and libTiff. Any 
      objections?
    - Doug: Could also use DPX vs tiff.
    - Carol: Prefer tiff.
    - Thomas: Agree.
    - Doug: DPX is simple enough that makes it easy to grab. Could be fallback 
      if libTiff implementation is involved.
    - Patrick: Do we agree on the direction?
    - Michael: The main arguments for this solution are that the apps don't 
      need to be rewritten (or duplicated) in Python, or broken into their own 
      repo. The cpp apps are currently the main implementation example for app 
      developers. Python examples are more useful for topic of config 
      authoring.
    - Patrick: Should not underestimate app examples. Some use these heavily.
    - Doug, Patrick, Thomas: Agree with proposal.
    - Thomas: OCIO/OIIO are a pain right now to build because of that circular 
      dependency.
    - Michael: Aloys is also facing issues with this in the development of 
      production VFX ref platform Docker images for aswf-docker.
    - Patrick: Should also think about package managers; brew, vcpkg, etc. 
      vcpkg is broken right now.
    - Michael: Yes, a discussion on Conan is what brought this topic back up.

* GH Actions macOS runners maintenance:
    - Michael: Received notice from GitHub that they are doing maintenance on 
      macOS runners this week, so we may see interruption.
    - Patrick: Any problems with CentOS runners?
    - Michael: No, those are run on Ubuntu runners. CentOS is purely in the 
      Docker container, managed by aswf-docker.

* Next TSC meeting January 4:
    - Michael: After tomorrow's Config working group meeting, no OCIO meetings
      until January 4th. All events have been cancelled in that window since 
      most have holidays.

* Other discussion:
    - Doug: As mentioned previously, a student is working on high priority OFX 
      plugins for OCIO, and may need assistance. If anyone has time to help 
      him, see PR #1231.
    - Michael: I reached out last week to see if specific help was needed, but 
      no request as of yet. Can bump issue to get status.
    - Michael: Also, last week we talked about sending an update to ocio-dev 
      to invite more testing, but I hadn't noticed that Doug already sent 
      something like that to announce the beta 2 release.
    - Doug: May do beta 3 before next TSC meeting. If anyone has time, would 
      appreciate testing and feedback, to move forward with RC in early 
      January.
    - Michael: Are the PRs coming this week the last major changes?
    - Doug: The last feature, aliases, should land next week. Still some other 
      PRs finishing up features already in place. Polishing, fixing, etc. 
      Will have some PRs in early January.
