/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.os.unix.UnixHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class ShellScript {
    private static final String Author = "Author: marc.eppelmann_at_gmx.de";
    private static final String Generator = "Generator: " + ShellScript.class.getName();
    private static final String SCM_ID = "$Id$";
    private static final String Revision = "$Revision$";
    private static final String CommentPre = "# ";
    private static final String H = "# ";
    private static final String lf = "\n";
    private static final String lh = "\n# ";
    private static final String explanation = "\n# This is an automatically generated Script.\n# Usually this can be removed if the Generator \n# was unable to remove the script after execution.\n";
    private static String currentDateMsg = "Generated at: " + new Date().toString();
    private static final String header = "\n\n# This is an automatically generated Script.\n# Usually this can be removed if the Generator \n# was unable to remove the script after execution.\n\n# " + Generator + "\n" + "# " + "$Id$" + "\n" + "# " + "Author: marc.eppelmann_at_gmx.de" + "\n" + "# " + "$Revision$" + "\n" + "# " + currentDateMsg + "\n" + "\n";
    private StringBuffer content = new StringBuffer();
    private String itsLocation;
    private String itsShell;
    public static final String SH = "sh";
    public static final String BOURNE_SHELL = "sh";
    public static final String BASH = "bash";
    public static final String BOURNE_AGAIN_SHELL = "bash";

    public ShellScript(String string) {
        if (null != string) {
            this.setShell(string);
            this.content.append("#!/usr/bin/env ").append(this.getShell());
            this.content.append(header);
        }
    }

    public ShellScript() {
        this("sh");
    }

    public void setShell(String string) {
        this.itsShell = string;
    }

    public String getShell() {
        return this.itsShell;
    }

    public void append(Object object) {
        this.content.append(object);
    }

    public void append(char c) {
        this.content.append(c);
    }

    public void append(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.append(string);
            if (stringArray.length <= i) continue;
            this.append(' ');
        }
    }

    public void appendln(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.append(string);
            if (stringArray.length <= i) continue;
            this.append(' ');
        }
        this.appendln();
    }

    public void appendln(Object object) {
        this.append(object);
        this.append(lf);
    }

    public void appendln(char c) {
        this.append(c);
        this.append(lf);
    }

    public void appendln() {
        this.append(lf);
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public String getContentAsString() {
        return this.content.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('\n');
        stringBuffer.append(this.itsLocation);
        stringBuffer.append('\n');
        stringBuffer.append(this.content);
        return stringBuffer.toString();
    }

    public void write(String string) {
        this.itsLocation = string;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(this.content.toString());
            bufferedWriter.write(lh + string + lf);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String exec(String string) {
        FileExecutor.getExecOutput(new String[]{UnixHelper.getCustomCommand("chmod"), "+x", this.itsLocation});
        if (string != null) {
            return FileExecutor.getExecOutput(new String[]{this.itsLocation, string});
        }
        return FileExecutor.getExecOutput(new String[]{this.itsLocation});
    }

    public String exec() {
        return this.exec(null);
    }

    public static String execute(String string, StringBuffer stringBuffer, String string2, String string3) {
        ShellScript shellScript = new ShellScript(string == null ? "sh" : string);
        shellScript.append(stringBuffer);
        shellScript.write(string2);
        return string3 == null ? shellScript.exec() : shellScript.exec(string3);
    }

    public static String execute(StringBuffer stringBuffer, String string) {
        return ShellScript.execute(null, stringBuffer, string, null);
    }

    public static String execAndDelete(String string, StringBuffer stringBuffer, String string2, String string3) {
        String string4 = ShellScript.execute(string, stringBuffer, string2, string3);
        File file = new File(string2);
        try {
            file.delete();
        }
        catch (Exception exception) {
            file.deleteOnExit();
        }
        return string4;
    }

    public static String execAndDelete(StringBuffer stringBuffer, String string) {
        return ShellScript.execAndDelete(null, stringBuffer, string, null);
    }

    public static void main(String[] stringArray) {
    }

    public void delete() {
        if (this.itsLocation != null) {
            File file = new File(this.itsLocation);
            try {
                file.delete();
            }
            catch (Exception exception) {
                file.deleteOnExit();
            }
        }
    }
}

