from _typeshed import Incomplete
from contextlib import AbstractContextManager
from typing import NamedTuple

from psutil._common import (
    FREEBSD as FREEBSD,
    NETBSD as NETBSD,
    OPENBSD as OPENBSD,
    AccessDenied as AccessDenied,
    NoSuchProcess as NoSuchProcess,
    ZombieProcess as ZombieProcess,
    conn_tmap as conn_tmap,
    conn_to_ntuple as conn_to_ntuple,
    memoize as memoize,
    pio,
    usage_percent as usage_percent,
)

__extra__all__: Incomplete
PROC_STATUSES: Incomplete
TCP_STATUSES: Incomplete
PAGESIZE: Incomplete
AF_LINK: Incomplete
HAS_PROC_NUM_THREADS: Incomplete
kinfo_proc_map: Incomplete

class svmem(NamedTuple):
    total: int
    available: int
    percent: float
    used: int
    free: int
    active: int
    inactive: int
    buffers: int
    cached: int
    shared: int
    wired: int

class scputimes(NamedTuple):
    user: float
    nice: float
    system: float
    idle: float
    irq: float

class pmem(NamedTuple):
    rss: Incomplete
    vms: Incomplete
    text: Incomplete
    data: Incomplete
    stack: Incomplete

pfullmem = pmem

class pcputimes(NamedTuple):
    user: Incomplete
    system: Incomplete
    children_user: Incomplete
    children_system: Incomplete

class pmmap_grouped(NamedTuple):
    path: Incomplete
    rss: Incomplete
    private: Incomplete
    ref_count: Incomplete
    shadow_count: Incomplete

class pmmap_ext(NamedTuple):
    addr: Incomplete
    perms: Incomplete
    path: Incomplete
    rss: Incomplete
    private: Incomplete
    ref_count: Incomplete
    shadow_count: Incomplete

class sdiskio(NamedTuple):
    read_count: Incomplete
    write_count: Incomplete
    read_bytes: Incomplete
    write_bytes: Incomplete
    read_time: Incomplete
    write_time: Incomplete
    busy_time: Incomplete

def virtual_memory() -> svmem: ...
def swap_memory(): ...
def cpu_times(): ...
def per_cpu_times(): ...
def cpu_count_logical(): ...
def cpu_count_cores() -> int | None: ...
def cpu_stats(): ...
def disk_partitions(all: bool = ...): ...

disk_usage: Incomplete
disk_io_counters: Incomplete
net_io_counters: Incomplete
net_if_addrs: Incomplete

def net_if_stats(): ...
def net_connections(kind): ...
def sensors_battery(): ...
def sensors_temperatures(): ...
def cpu_freq(): ...
def boot_time(): ...
def users(): ...

INIT_BOOT_TIME: float

def adjust_proc_create_time(ctime: float) -> float: ...
def pids(): ...
def pid_exists(pid): ...
def wrap_exceptions(fun): ...
def wrap_exceptions_procfs(inst) -> AbstractContextManager[None]: ...

class Process:
    pid: Incomplete
    def __init__(self, pid) -> None: ...
    def oneshot(self): ...
    def oneshot_enter(self) -> None: ...
    def oneshot_exit(self) -> None: ...
    def name(self): ...
    def exe(self): ...
    def cmdline(self): ...
    def environ(self): ...
    def terminal(self): ...
    def ppid(self): ...
    def uids(self): ...
    def gids(self): ...
    def cpu_times(self): ...
    def cpu_num(self): ...
    def memory_info(self): ...
    memory_full_info: Incomplete
    def create_time(self, monotonic: bool = False) -> float: ...
    def num_threads(self): ...
    def num_ctx_switches(self): ...
    def threads(self): ...
    def net_connections(self, kind: str = ...): ...
    def wait(self, timeout: Incomplete | None = ...): ...
    def nice_get(self): ...
    def nice_set(self, value): ...
    def status(self): ...
    def io_counters(self) -> pio: ...
    def cwd(self): ...

    class nt_mmap_grouped(NamedTuple):
        path: Incomplete
        rss: Incomplete
        private: Incomplete
        ref_count: Incomplete
        shadow_count: Incomplete

    class nt_mmap_ext(NamedTuple):
        addr: Incomplete
        perms: Incomplete
        path: Incomplete
        rss: Incomplete
        private: Incomplete
        ref_count: Incomplete
        shadow_count: Incomplete

    def open_files(self): ...
    def num_fds(self): ...
    def cpu_affinity_get(self): ...
    def cpu_affinity_set(self, cpus) -> None: ...
    def memory_maps(self): ...
    def rlimit(self, resource, limits: Incomplete | None = ...): ...
