/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Objects;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BusyIndicator {
    static int nextBusyId = 1;
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWhile(Display display, Runnable runnable) {
        Integer id;
        Shell[] shells;
        if (runnable == null) {
            SWT.error(4);
        }
        if (display == null && (display = Display.getCurrent()) == null) {
            runnable.run();
            return;
        }
        Integer busyId = nextBusyId;
        ++nextBusyId;
        Cursor cursor = display.getSystemCursor(1);
        for (Shell shell : shells = display.getShells()) {
            id = (Integer)shell.getData(BUSYID_NAME);
            if (id != null) continue;
            BusyIndicator.setCursorAndId(shell, cursor, busyId);
        }
        try {
            runnable.run();
        }
        finally {
            for (Shell shell : shells = display.getShells()) {
                id = (Integer)shell.getData(BUSYID_NAME);
                if (!Objects.equals(id, busyId)) continue;
                BusyIndicator.setCursorAndId(shell, null, null);
            }
        }
    }

    private static void setCursorAndId(Shell shell, Cursor cursor, Integer busyId) {
        if (!shell.isDisposed()) {
            shell.setCursor(cursor);
        }
        if (!shell.isDisposed()) {
            shell.setData(BUSYID_NAME, busyId);
        }
    }
}

