/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.javasound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.utils.AudioWaveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AudioPlayer
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(AudioPlayer.class);
    private final AudioStream audioStream;

    public AudioPlayer(AudioStream audioStream) {
        this.audioStream = audioStream;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block18: {
            openhabAudioFormat = this.audioStream.getFormat();
            audioFormat = this.convertAudioFormat(openhabAudioFormat);
            if (audioFormat == null) {
                this.logger.warn("Audio format is unsupported or does not have enough details in order to be played");
                return;
            }
            info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                break block18;
            }
            catch (Exception e) {
                this.logger.warn("No line found: {}", (Object)e.getMessage());
                this.logger.info("Available lines are:");
                var11_9 = mixerInfo = AudioSystem.getMixerInfo();
                var10_10 = mixerInfo.length;
                var9_11 = 0;
                ** while (var9_11 < var10_10)
            }
lbl-1000:
            // 1 sources

            {
                value = var11_9[var9_11];
                mixer = AudioSystem.getMixer(value);
                var16_23 = lineInfos = mixer.getSourceLineInfo();
                var15_22 = lineInfos.length;
                var14_21 = 0;
                while (var14_21 < var15_22) {
                    lineInfo = var16_23[var14_21];
                    this.logger.info("{}", (Object)lineInfo);
                    ++var14_21;
                }
                ++var9_11;
                continue;
            }
lbl30:
            // 1 sources

            return;
        }
        line.start();
        nRead = 0;
        abData = new byte[65532];
        try {
            try {
                if ("WAVE".equals(openhabAudioFormat.getContainer())) {
                    AudioWaveUtils.removeFMT(this.audioStream);
                }
                while (-1 != nRead) {
                    nRead = this.audioStream.read(abData, 0, abData.length);
                    if (nRead < 0) continue;
                    line.write(abData, 0, nRead);
                }
            }
            catch (IOException e) {
                this.logger.error("Error while playing audio: {}", (Object)e.getMessage());
                line.drain();
                line.close();
                try {
                    this.audioStream.close();
                }
                catch (IOException var9_12) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            line.drain();
            line.close();
            try {
                this.audioStream.close();
            }
            catch (IOException var9_14) {}
        }
    }

    protected @Nullable javax.sound.sampled.AudioFormat convertAudioFormat(AudioFormat audioFormat) {
        String codec = audioFormat.getCodec();
        AudioFormat.Encoding encoding = new AudioFormat.Encoding(codec);
        if ("PCM_SIGNED".equals(codec)) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if ("ULAW".equals(codec)) {
            encoding = AudioFormat.Encoding.ULAW;
        } else if ("ALAW".equals(codec)) {
            encoding = AudioFormat.Encoding.ALAW;
        }
        Long frequency = audioFormat.getFrequency();
        if (frequency == null) {
            return null;
        }
        float sampleRate = frequency.floatValue();
        Integer bitDepth = audioFormat.getBitDepth();
        if (bitDepth == null) {
            return null;
        }
        int sampleSizeInBits = bitDepth;
        int channels = audioFormat.getChannels() == null ? Integer.valueOf(1) : audioFormat.getChannels();
        int frameSize = channels * sampleSizeInBits / 8;
        float frameRate = (float)channels * sampleRate / (float)frameSize;
        Boolean bigEndian = audioFormat.isBigEndian();
        if (bigEndian == null) {
            return null;
        }
        return new javax.sound.sampled.AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
    }
}

