## RabbitMQ 3.13.6

RabbitMQ `3.13.6` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

This upgrade is **highly recommended** to all users currently on earlier `3.13.x` series and
in particular between `3.13.3` and `3.13.5`, inclusive.

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Quorum queue validation on startup was too strict and prevented upgrades from certain older versions from succeeding.
   This validation has been reduced from an error to a warning.

   GitHub issue: [https://github.com/rabbitmq/rabbitmq-server/issues/11789](#11789), [#11794](https://github.com/rabbitmq/rabbitmq-server/pull/11794)

#### Enhancements

 * Stream replication port range now can be configured via `rabbitmq.conf`:

   ```
   stream.replication.port_range.min = 4000
   stream.replication.port_range.max = 4600
   ```

   GitHub issue: [#11774](https://github.com/rabbitmq/rabbitmq-server/pull/11774)


### Dependency Changes

 * Ra was [upgraded to `2.13.5`](https://github.com/rabbitmq/ra/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.6.tar.xz`
instead of the source tarball produced by GitHub.
