RabbitMQ `3.9.5` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.

### Core Server

#### Bug Fixes

 * Virtual host metadata (description, tags) was not imported from definitions.

   GitHub issue: [#3333](https://github.com/rabbitmq/rabbitmq-server/pull/3333)

 * Reduced unnecessary debug logging from streams.

   GitHub issue: [#3279](https://github.com/rabbitmq/rabbitmq-server/pull/3279)


### AWS Peer Discovery Plugin

#### Enhancements

 * AWS API calls are now retried multiple times.

   Contributed by AWS.

   GitHub issue: [#3329](https://github.com/rabbitmq/rabbitmq-server/pull/3329)


### Management Plugin

#### Enhancements

 * `PUT /api/vhosts/{name}` now can update metadata (tags and descriptions) for existing
   virtual hosts.

   GitHub issue: [#3319](https://github.com/rabbitmq/rabbitmq-server/pull/3319)



## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.5.tar.xz` instead of the source tarball produced by GitHub.
