/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCachesProvider;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.ivyservice.DefaultArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ReadOnlyArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.WritableArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheCleanupStrategyFactory;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.versionedcache.UsedGradleVersions;
import org.gradle.util.internal.IncubationLogger;
import org.jspecify.annotations.Nullable;

public class DefaultArtifactCaches
implements ArtifactCachesProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultArtifactCaches.class);
    private final DefaultArtifactCacheMetadata writableCacheMetadata;
    private final DefaultArtifactCacheMetadata readOnlyCacheMetadata;
    private final LateInitWritableArtifactCacheLockingAccessCoordinator writableCacheAccessCoordinator;
    private final ReadOnlyArtifactCacheLockingAccessCoordinator readOnlyCacheAccessCoordinator;

    public DefaultArtifactCaches(GlobalScopedCacheBuilderFactory cacheBuilderFactory, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, WritableArtifactCacheLockingParameters params, DocumentationRegistry documentationRegistry, CacheConfigurationsInternal cacheConfigurations, CacheCleanupStrategyFactory cacheCleanupStrategyFactory) {
        this.writableCacheMetadata = new DefaultArtifactCacheMetadata(cacheBuilderFactory);
        this.writableCacheAccessCoordinator = new LateInitWritableArtifactCacheLockingAccessCoordinator(() -> new WritableArtifactCacheLockingAccessCoordinator(unscopedCacheBuilderFactory, this.writableCacheMetadata, params.getFileAccessTimeJournal(), params.getUsedGradleVersions(), cacheConfigurations, cacheCleanupStrategyFactory));
        String roCache = System.getenv("GRADLE_RO_DEP_CACHE");
        if (StringUtils.isNotEmpty((CharSequence)roCache)) {
            IncubationLogger.incubatingFeatureUsed((String)"Shared read-only dependency cache");
            File baseDir = DefaultArtifactCaches.validateReadOnlyCache(documentationRegistry, new File(roCache).getAbsoluteFile());
            if (baseDir != null) {
                this.readOnlyCacheMetadata = new DefaultArtifactCacheMetadata(cacheBuilderFactory, baseDir);
                this.readOnlyCacheAccessCoordinator = new ReadOnlyArtifactCacheLockingAccessCoordinator(unscopedCacheBuilderFactory, this.readOnlyCacheMetadata);
                LOGGER.info("The read-only dependency cache is enabled \nThe {} environment variable was set to {}", (Object)"GRADLE_RO_DEP_CACHE", (Object)baseDir);
            } else {
                this.readOnlyCacheMetadata = null;
                this.readOnlyCacheAccessCoordinator = null;
            }
        } else {
            this.readOnlyCacheMetadata = null;
            this.readOnlyCacheAccessCoordinator = null;
        }
    }

    private static @Nullable File validateReadOnlyCache(DocumentationRegistry documentationRegistry, File cacheDir) {
        if (!cacheDir.exists()) {
            LOGGER.warn("The read-only dependency cache is disabled because of a configuration problem:");
            LOGGER.warn("The GRADLE_RO_DEP_CACHE environment variable was set to " + cacheDir + " which doesn't exist!");
            return null;
        }
        File root = CacheLayout.MODULES.getPath(cacheDir);
        if (!root.exists()) {
            String docLink = documentationRegistry.getDocumentationRecommendationFor("instructions on how to do this", "dependency_resolution", "sub:shared-readonly-cache");
            LOGGER.warn("The read-only dependency cache is disabled because of a configuration problem:");
            LOGGER.warn("Read-only cache is configured but the directory layout isn't expected. You must have a pre-populated " + CacheLayout.MODULES.getKey() + " directory at " + root + " . " + docLink);
            return null;
        }
        return cacheDir;
    }

    @Override
    public ArtifactCacheMetadata getWritableCacheMetadata() {
        return this.writableCacheMetadata;
    }

    @Override
    public Optional<ArtifactCacheMetadata> getReadOnlyCacheMetadata() {
        return Optional.ofNullable(this.readOnlyCacheMetadata);
    }

    @Override
    public ArtifactCacheLockingAccessCoordinator getWritableCacheAccessCoordinator() {
        return this.writableCacheAccessCoordinator;
    }

    @Override
    public Optional<ArtifactCacheLockingAccessCoordinator> getReadOnlyCacheAccessCoordinator() {
        return Optional.ofNullable(this.readOnlyCacheAccessCoordinator);
    }

    public List<File> getGlobalCacheRoots() {
        return this.readOnlyCacheMetadata == null ? ImmutableList.of() : this.readOnlyCacheMetadata.getGlobalCacheRoots();
    }

    @Override
    public void close() {
        this.writableCacheAccessCoordinator.close();
        if (this.readOnlyCacheAccessCoordinator != null) {
            this.readOnlyCacheAccessCoordinator.close();
        }
    }

    private static class LateInitWritableArtifactCacheLockingAccessCoordinator
    implements ArtifactCacheLockingAccessCoordinator,
    Closeable {
        private final Factory<WritableArtifactCacheLockingAccessCoordinator> factory;
        private volatile WritableArtifactCacheLockingAccessCoordinator delegate;

        private LateInitWritableArtifactCacheLockingAccessCoordinator(Factory<WritableArtifactCacheLockingAccessCoordinator> factory) {
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WritableArtifactCacheLockingAccessCoordinator getDelegate() {
            if (this.delegate == null) {
                Factory<WritableArtifactCacheLockingAccessCoordinator> factory = this.factory;
                synchronized (factory) {
                    if (this.delegate == null) {
                        this.delegate = (WritableArtifactCacheLockingAccessCoordinator)this.factory.create();
                    }
                }
            }
            return this.delegate;
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        public <T> T withFileLock(Supplier<? extends T> action) {
            return this.getDelegate().withFileLock(action);
        }

        public void withFileLock(Runnable action) {
            this.getDelegate().withFileLock(action);
        }

        public <T> T useCache(Supplier<? extends T> action) {
            return this.getDelegate().useCache(action);
        }

        public void useCache(Runnable action) {
            this.getDelegate().useCache(action);
        }

        @Override
        public <K, V> IndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return this.getDelegate().createCache(cacheName, keySerializer, valueSerializer);
        }
    }

    @ServiceScope(value={Scope.UserHome.class})
    public static interface WritableArtifactCacheLockingParameters {
        public FileAccessTimeJournal getFileAccessTimeJournal();

        public UsedGradleVersions getUsedGradleVersions();
    }
}

