/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.witness;

import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmStaticFieldLocation
extends JvmMemoryLocation {
    public final String fqn;

    public JvmStaticFieldLocation(String fqn) {
        this(null, fqn);
    }

    public JvmStaticFieldLocation(ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> argNode, String fqn) {
        this.argNode = argNode;
        this.fqn = fqn;
    }

    @Override
    public JvmStaticFieldLocation copy() {
        return new JvmStaticFieldLocation(this.argNode, this.fqn);
    }

    @Override
    public <T extends LatticeAbstractState> T extractValueOrDefault(JvmAbstractState abstractState, T defaultValue) {
        return abstractState.getStaticOrDefault(this.fqn, defaultValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmStaticFieldLocation)) {
            return false;
        }
        JvmStaticFieldLocation other = (JvmStaticFieldLocation)obj;
        return super.equals(other) && this.fqn.equals(other.fqn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argNode, this.fqn.hashCode());
    }

    public String toString() {
        return "JvmStaticFieldLocation(" + this.fqn + ")" + (this.argNode == null ? "" : "@" + ((JvmCfaNode)this.argNode.getProgramLocation()).getSignature().getFqn() + ":" + ((JvmCfaNode)this.argNode.getProgramLocation()).getOffset());
    }
}

