/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.HashSet;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.visitor.ConstructorMethodFilter;
import proguard.classfile.visitor.MethodCollector;
import proguard.util.ProcessingFlagSetter;

public class InitializerEditor
implements AttributeVisitor {
    private static final String EXTRA_INIT_METHOD_NAME = "init$";
    private static final String EXTRA_INIT_METHOD_DESCRIPTOR = "()V";
    private final ProgramClass programClass;
    private Instruction[] insertInstructions;

    public InitializerEditor(ProgramClass programClass) {
        this.programClass = programClass;
    }

    public void addStaticInitializerInstructions(boolean mergeIntoExistingInitializer, CodeBuilder codeBuilder) {
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder(this.programClass);
        codeBuilder.build(builder);
        this.addStaticInitializerInstructions(mergeIntoExistingInitializer, builder.instructions());
    }

    public void addStaticInitializerInstructions(boolean mergeIntoExistingInitializer, Instruction[] instructions) {
        Method method = this.programClass.findMethod("<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR);
        if (method == null) {
            new ClassBuilder(this.programClass).addMethod(8, "<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR, 2 * instructions.length + 10, ____ -> ____.appendInstructions(instructions).return_());
        } else if (mergeIntoExistingInitializer) {
            this.insertInstructions = instructions;
            method.accept(this.programClass, new AllAttributeVisitor(this));
        } else {
            String methodName = this.uniqueMethodName(EXTRA_INIT_METHOD_DESCRIPTOR);
            new ClassBuilder(this.programClass).addMethod(8, methodName, EXTRA_INIT_METHOD_DESCRIPTOR, 2 * instructions.length + 10, ____ -> ____.appendInstructions(instructions).return_(), new ProcessingFlagSetter(0x200000));
            Method extraInitMethod = this.programClass.findMethod(methodName, EXTRA_INIT_METHOD_DESCRIPTOR);
            this.insertInstructions = new InstructionSequenceBuilder(this.programClass).invokestatic(this.programClass, extraInitMethod).instructions();
            method.accept(this.programClass, new AllAttributeVisitor(this));
        }
    }

    public void addInitializerInstructions(CodeBuilder codeBuilder) {
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder(this.programClass);
        codeBuilder.build(builder);
        this.addInitializerInstructions(builder.instructions());
    }

    public void addInitializerInstructions(Instruction[] instructions) {
        Method method = this.programClass.findMethod("<init>", null);
        if (method == null) {
            new ClassBuilder(this.programClass).addMethod(1, "<init>", EXTRA_INIT_METHOD_DESCRIPTOR, 2 * instructions.length + 10, ____ -> ____.aload_0().invokespecial(this.programClass.getSuperName(), "<init>", EXTRA_INIT_METHOD_DESCRIPTOR).appendInstructions(instructions).return_());
        } else {
            HashSet<Method> constructors = new HashSet<Method>();
            this.programClass.methodsAccept(new ConstructorMethodFilter(new MethodCollector(constructors), null, null));
            if (constructors.size() == 1) {
                this.insertInstructions = instructions;
                ((Method)constructors.iterator().next()).accept(this.programClass, new AllAttributeVisitor(this));
            } else {
                Method initMethod = this.programClass.findMethod(EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR);
                if (initMethod == null) {
                    new ClassBuilder(this.programClass).addMethod(8, EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR, 2 * instructions.length + 10, ____ -> ____.appendInstructions(instructions).return_(), new ProcessingFlagSetter(0x200000));
                    this.insertInstructions = new InstructionSequenceBuilder(this.programClass).aload_0().invokespecial(this.programClass.getName(), EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR).instructions();
                    this.programClass.methodsAccept(new ConstructorMethodFilter(new AllAttributeVisitor(this), null, null));
                } else {
                    this.insertInstructions = instructions;
                    initMethod.accept(this.programClass, new AllAttributeVisitor(this));
                }
            }
        }
    }

    private String uniqueMethodName(String methodDescriptor) {
        String methodName;
        int counter = 0;
        while (this.programClass.findMethod(methodName = EXTRA_INIT_METHOD_NAME + counter++, methodDescriptor) != null) {
        }
        return methodName;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttributeEditor.insertBeforeOffset(0, this.insertInstructions);
        codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public static interface CodeBuilder {
        public void build(InstructionSequenceBuilder var1);
    }
}

