/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public abstract class Instruction {
    public static final byte OP_NOP = 0;
    public static final byte OP_ACONST_NULL = 1;
    public static final byte OP_ICONST_M1 = 2;
    public static final byte OP_ICONST_0 = 3;
    public static final byte OP_ICONST_1 = 4;
    public static final byte OP_ICONST_2 = 5;
    public static final byte OP_ICONST_3 = 6;
    public static final byte OP_ICONST_4 = 7;
    public static final byte OP_ICONST_5 = 8;
    public static final byte OP_LCONST_0 = 9;
    public static final byte OP_LCONST_1 = 10;
    public static final byte OP_FCONST_0 = 11;
    public static final byte OP_FCONST_1 = 12;
    public static final byte OP_FCONST_2 = 13;
    public static final byte OP_DCONST_0 = 14;
    public static final byte OP_DCONST_1 = 15;
    public static final byte OP_BIPUSH = 16;
    public static final byte OP_SIPUSH = 17;
    public static final byte OP_LDC = 18;
    public static final byte OP_LDC_W = 19;
    public static final byte OP_LDC2_W = 20;
    public static final byte OP_ILOAD = 21;
    public static final byte OP_LLOAD = 22;
    public static final byte OP_FLOAD = 23;
    public static final byte OP_DLOAD = 24;
    public static final byte OP_ALOAD = 25;
    public static final byte OP_ILOAD_0 = 26;
    public static final byte OP_ILOAD_1 = 27;
    public static final byte OP_ILOAD_2 = 28;
    public static final byte OP_ILOAD_3 = 29;
    public static final byte OP_LLOAD_0 = 30;
    public static final byte OP_LLOAD_1 = 31;
    public static final byte OP_LLOAD_2 = 32;
    public static final byte OP_LLOAD_3 = 33;
    public static final byte OP_FLOAD_0 = 34;
    public static final byte OP_FLOAD_1 = 35;
    public static final byte OP_FLOAD_2 = 36;
    public static final byte OP_FLOAD_3 = 37;
    public static final byte OP_DLOAD_0 = 38;
    public static final byte OP_DLOAD_1 = 39;
    public static final byte OP_DLOAD_2 = 40;
    public static final byte OP_DLOAD_3 = 41;
    public static final byte OP_ALOAD_0 = 42;
    public static final byte OP_ALOAD_1 = 43;
    public static final byte OP_ALOAD_2 = 44;
    public static final byte OP_ALOAD_3 = 45;
    public static final byte OP_IALOAD = 46;
    public static final byte OP_LALOAD = 47;
    public static final byte OP_FALOAD = 48;
    public static final byte OP_DALOAD = 49;
    public static final byte OP_AALOAD = 50;
    public static final byte OP_BALOAD = 51;
    public static final byte OP_CALOAD = 52;
    public static final byte OP_SALOAD = 53;
    public static final byte OP_ISTORE = 54;
    public static final byte OP_LSTORE = 55;
    public static final byte OP_FSTORE = 56;
    public static final byte OP_DSTORE = 57;
    public static final byte OP_ASTORE = 58;
    public static final byte OP_ISTORE_0 = 59;
    public static final byte OP_ISTORE_1 = 60;
    public static final byte OP_ISTORE_2 = 61;
    public static final byte OP_ISTORE_3 = 62;
    public static final byte OP_LSTORE_0 = 63;
    public static final byte OP_LSTORE_1 = 64;
    public static final byte OP_LSTORE_2 = 65;
    public static final byte OP_LSTORE_3 = 66;
    public static final byte OP_FSTORE_0 = 67;
    public static final byte OP_FSTORE_1 = 68;
    public static final byte OP_FSTORE_2 = 69;
    public static final byte OP_FSTORE_3 = 70;
    public static final byte OP_DSTORE_0 = 71;
    public static final byte OP_DSTORE_1 = 72;
    public static final byte OP_DSTORE_2 = 73;
    public static final byte OP_DSTORE_3 = 74;
    public static final byte OP_ASTORE_0 = 75;
    public static final byte OP_ASTORE_1 = 76;
    public static final byte OP_ASTORE_2 = 77;
    public static final byte OP_ASTORE_3 = 78;
    public static final byte OP_IASTORE = 79;
    public static final byte OP_LASTORE = 80;
    public static final byte OP_FASTORE = 81;
    public static final byte OP_DASTORE = 82;
    public static final byte OP_AASTORE = 83;
    public static final byte OP_BASTORE = 84;
    public static final byte OP_CASTORE = 85;
    public static final byte OP_SASTORE = 86;
    public static final byte OP_POP = 87;
    public static final byte OP_POP2 = 88;
    public static final byte OP_DUP = 89;
    public static final byte OP_DUP_X1 = 90;
    public static final byte OP_DUP_X2 = 91;
    public static final byte OP_DUP2 = 92;
    public static final byte OP_DUP2_X1 = 93;
    public static final byte OP_DUP2_X2 = 94;
    public static final byte OP_SWAP = 95;
    public static final byte OP_IADD = 96;
    public static final byte OP_LADD = 97;
    public static final byte OP_FADD = 98;
    public static final byte OP_DADD = 99;
    public static final byte OP_ISUB = 100;
    public static final byte OP_LSUB = 101;
    public static final byte OP_FSUB = 102;
    public static final byte OP_DSUB = 103;
    public static final byte OP_IMUL = 104;
    public static final byte OP_LMUL = 105;
    public static final byte OP_FMUL = 106;
    public static final byte OP_DMUL = 107;
    public static final byte OP_IDIV = 108;
    public static final byte OP_LDIV = 109;
    public static final byte OP_FDIV = 110;
    public static final byte OP_DDIV = 111;
    public static final byte OP_IREM = 112;
    public static final byte OP_LREM = 113;
    public static final byte OP_FREM = 114;
    public static final byte OP_DREM = 115;
    public static final byte OP_INEG = 116;
    public static final byte OP_LNEG = 117;
    public static final byte OP_FNEG = 118;
    public static final byte OP_DNEG = 119;
    public static final byte OP_ISHL = 120;
    public static final byte OP_LSHL = 121;
    public static final byte OP_ISHR = 122;
    public static final byte OP_LSHR = 123;
    public static final byte OP_IUSHR = 124;
    public static final byte OP_LUSHR = 125;
    public static final byte OP_IAND = 126;
    public static final byte OP_LAND = 127;
    public static final byte OP_IOR = -128;
    public static final byte OP_LOR = -127;
    public static final byte OP_IXOR = -126;
    public static final byte OP_LXOR = -125;
    public static final byte OP_IINC = -124;
    public static final byte OP_I2L = -123;
    public static final byte OP_I2F = -122;
    public static final byte OP_I2D = -121;
    public static final byte OP_L2I = -120;
    public static final byte OP_L2F = -119;
    public static final byte OP_L2D = -118;
    public static final byte OP_F2I = -117;
    public static final byte OP_F2L = -116;
    public static final byte OP_F2D = -115;
    public static final byte OP_D2I = -114;
    public static final byte OP_D2L = -113;
    public static final byte OP_D2F = -112;
    public static final byte OP_I2B = -111;
    public static final byte OP_I2C = -110;
    public static final byte OP_I2S = -109;
    public static final byte OP_LCMP = -108;
    public static final byte OP_FCMPL = -107;
    public static final byte OP_FCMPG = -106;
    public static final byte OP_DCMPL = -105;
    public static final byte OP_DCMPG = -104;
    public static final byte OP_IFEQ = -103;
    public static final byte OP_IFNE = -102;
    public static final byte OP_IFLT = -101;
    public static final byte OP_IFGE = -100;
    public static final byte OP_IFGT = -99;
    public static final byte OP_IFLE = -98;
    public static final byte OP_IFICMPEQ = -97;
    public static final byte OP_IFICMPNE = -96;
    public static final byte OP_IFICMPLT = -95;
    public static final byte OP_IFICMPGE = -94;
    public static final byte OP_IFICMPGT = -93;
    public static final byte OP_IFICMPLE = -92;
    public static final byte OP_IFACMPEQ = -91;
    public static final byte OP_IFACMPNE = -90;
    public static final byte OP_GOTO = -89;
    public static final byte OP_JSR = -88;
    public static final byte OP_RET = -87;
    public static final byte OP_TABLESWITCH = -86;
    public static final byte OP_LOOKUPSWITCH = -85;
    public static final byte OP_IRETURN = -84;
    public static final byte OP_LRETURN = -83;
    public static final byte OP_FRETURN = -82;
    public static final byte OP_DRETURN = -81;
    public static final byte OP_ARETURN = -80;
    public static final byte OP_RETURN = -79;
    public static final byte OP_GETSTATIC = -78;
    public static final byte OP_PUTSTATIC = -77;
    public static final byte OP_GETFIELD = -76;
    public static final byte OP_PUTFIELD = -75;
    public static final byte OP_INVOKEVIRTUAL = -74;
    public static final byte OP_INVOKESPECIAL = -73;
    public static final byte OP_INVOKESTATIC = -72;
    public static final byte OP_INVOKEINTERFACE = -71;
    public static final byte OP_INVOKEDYNAMIC = -70;
    public static final byte OP_NEW = -69;
    public static final byte OP_NEWARRAY = -68;
    public static final byte OP_ANEWARRAY = -67;
    public static final byte OP_ARRAYLENGTH = -66;
    public static final byte OP_ATHROW = -65;
    public static final byte OP_CHECKCAST = -64;
    public static final byte OP_INSTANCEOF = -63;
    public static final byte OP_MONITORENTER = -62;
    public static final byte OP_MONITOREXIT = -61;
    public static final byte OP_WIDE = -60;
    public static final byte OP_MULTIANEWARRAY = -59;
    public static final byte OP_IFNULL = -58;
    public static final byte OP_IFNONNULL = -57;
    public static final byte OP_GOTO_W = -56;
    public static final byte OP_JSR_W = -55;
    public static final String[] NAMES = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "invokedynamic", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w"};
    public static final byte ARRAY_T_BOOLEAN = 4;
    public static final byte ARRAY_T_CHAR = 5;
    public static final byte ARRAY_T_FLOAT = 6;
    public static final byte ARRAY_T_DOUBLE = 7;
    public static final byte ARRAY_T_BYTE = 8;
    public static final byte ARRAY_T_SHORT = 9;
    public static final byte ARRAY_T_INT = 10;
    public static final byte ARRAY_T_LONG = 11;
    private static final boolean[] MAY_THROW_EXCEPTIONS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, false, true, false, false, false, false};
    private static final boolean[] IS_CATEGORY2 = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, false, false, true, true, true, false, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int[] STACK_POP_COUNTS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 3, 4, 3, 4, 3, 3, 3, 3, 1, 2, 1, 2, 3, 2, 3, 4, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 1, 2, 1, 2, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2, 4, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4, 2, 2, 4, 4, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 1, 2, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0};
    private static final int[] STACK_PUSH_COUNTS = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 4, 5, 6, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1};
    public byte opcode;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public byte canonicalOpcode() {
        return this.opcode;
    }

    public byte actualOpcode() {
        return this.opcode;
    }

    public abstract Instruction shrink();

    public final void write(CodeAttribute codeAttribute, int offset) {
        this.write(codeAttribute.code, offset);
    }

    public void write(byte[] code, int offset) {
        if (this.isWide()) {
            code[offset++] = -60;
        }
        code[offset++] = this.actualOpcode();
        this.writeInfo(code, offset);
    }

    protected boolean isWide() {
        return false;
    }

    protected abstract void readInfo(byte[] var1, int var2);

    protected abstract void writeInfo(byte[] var1, int var2);

    public abstract int length(int var1);

    public abstract void accept(Clazz var1, Method var2, CodeAttribute var3, int var4, InstructionVisitor var5);

    public String toString(Clazz clazz, int offset) {
        return this.toString(offset);
    }

    public String toString(int offset) {
        return "[" + offset + "] " + this.toString();
    }

    public String getName() {
        return NAMES[this.opcode & 0xFF];
    }

    public boolean mayThrowExceptions() {
        return MAY_THROW_EXCEPTIONS[this.opcode & 0xFF];
    }

    public boolean mayInstanceThrowExceptions(Clazz clazz) {
        return this.mayThrowExceptions();
    }

    public boolean isCategory2() {
        return IS_CATEGORY2[this.opcode & 0xFF];
    }

    public int stackPopCount(Clazz clazz) {
        return STACK_POP_COUNTS[this.opcode & 0xFF];
    }

    public int stackPushCount(Clazz clazz) {
        return STACK_PUSH_COUNTS[this.opcode & 0xFF];
    }

    public int stackEntryIndexBefore(Clazz clazz, int stackEntryIndexAfter) {
        return -1;
    }

    protected static int readByte(byte[] code, int offset) {
        return code[offset] & 0xFF;
    }

    protected static int readShort(byte[] code, int offset) {
        return (code[offset++] & 0xFF) << 8 | code[offset] & 0xFF;
    }

    protected static int readInt(byte[] code, int offset) {
        return code[offset++] << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset] & 0xFF;
    }

    protected static int readValue(byte[] code, int offset, int valueSize) {
        switch (valueSize) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readByte(code, offset);
            }
            case 2: {
                return Instruction.readShort(code, offset);
            }
            case 4: {
                return Instruction.readInt(code, offset);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
    }

    protected static int readSignedByte(byte[] code, int offset) {
        return code[offset];
    }

    protected static int readSignedShort(byte[] code, int offset) {
        return code[offset++] << 8 | code[offset] & 0xFF;
    }

    protected static int readSignedValue(byte[] code, int offset, int valueSize) {
        switch (valueSize) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readSignedByte(code, offset);
            }
            case 2: {
                return Instruction.readSignedShort(code, offset);
            }
            case 4: {
                return Instruction.readInt(code, offset);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
    }

    protected static void writeByte(byte[] code, int offset, int value) {
        if (value > 255) {
            throw new IllegalArgumentException("Unsigned byte value larger than 0xff [" + value + "]");
        }
        code[offset] = (byte)value;
    }

    protected static void writeShort(byte[] code, int offset, int value) {
        if (value > 65535) {
            throw new IllegalArgumentException("Unsigned short value larger than 0xffff [" + value + "]");
        }
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeInt(byte[] code, int offset, int value) {
        code[offset++] = (byte)(value >> 24);
        code[offset++] = (byte)(value >> 16);
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeValue(byte[] code, int offset, int value, int valueSize) {
        switch (valueSize) {
            case 0: {
                break;
            }
            case 1: {
                Instruction.writeByte(code, offset, value);
                break;
            }
            case 2: {
                Instruction.writeShort(code, offset, value);
                break;
            }
            case 4: {
                Instruction.writeInt(code, offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
            }
        }
    }

    protected static void writeSignedByte(byte[] code, int offset, int value) {
        if ((byte)value != value) {
            throw new IllegalArgumentException("Signed byte value out of range [" + value + "]");
        }
        code[offset] = (byte)value;
    }

    protected static void writeSignedShort(byte[] code, int offset, int value) {
        if ((short)value != value) {
            throw new IllegalArgumentException("Signed short value out of range [" + value + "]");
        }
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeSignedValue(byte[] code, int offset, int value, int valueSize) {
        switch (valueSize) {
            case 0: {
                break;
            }
            case 1: {
                Instruction.writeSignedByte(code, offset, value);
                break;
            }
            case 2: {
                Instruction.writeSignedShort(code, offset, value);
                break;
            }
            case 4: {
                Instruction.writeInt(code, offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
            }
        }
    }
}

