/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class InjectedClassFilter
implements ClassVisitor {
    private final ClassVisitor injectedClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public InjectedClassFilter(ClassVisitor injectedClassVisitor, ClassVisitor otherClassVisitor) {
        this.injectedClassVisitor = injectedClassVisitor;
        this.otherClassVisitor = otherClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor delegate = this.delegateVisitor(programClass);
        if (delegate != null) {
            delegate.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.otherClassVisitor != null) {
            this.otherClassVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor delegateVisitor(ProgramClass programClass) {
        return (programClass.processingFlags & 0x200) != 0 ? this.injectedClassVisitor : this.otherClassVisitor;
    }
}

