/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassMemberPair;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.util.MultiValueMap;

public class ReverseDependencyStore {
    private final MultiValueMap<ProgramMethodOptimizationInfo, Method> methodsByProgramMethodOptimizationInfo;
    private final MultiValueMap<Method, ClassMemberPair> calledBy;

    public ReverseDependencyStore(MultiValueMap<Method, ClassMemberPair> calledBy, MultiValueMap<ProgramMethodOptimizationInfo, Method> methodsByProgramMethodOptimizationInfo) {
        this.calledBy = calledBy;
        this.methodsByProgramMethodOptimizationInfo = methodsByProgramMethodOptimizationInfo;
    }

    public class InfluencedMethodTraveller
    implements MemberVisitor {
        private final MemberVisitor memberVisitor;

        public InfluencedMethodTraveller(MemberVisitor memberVisitor) {
            this.memberVisitor = memberVisitor;
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(programMethod);
            if (methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
                ProgramMethodOptimizationInfo info = (ProgramMethodOptimizationInfo)methodOptimizationInfo;
                for (Method rootMethod : ReverseDependencyStore.this.methodsByProgramMethodOptimizationInfo.get(info)) {
                    if (!ReverseDependencyStore.this.calledBy.keySet().contains(rootMethod)) continue;
                    for (ClassMemberPair locatedMember : ReverseDependencyStore.this.calledBy.get(rootMethod)) {
                        locatedMember.accept(this.memberVisitor);
                    }
                }
            }
        }
    }
}

