/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept key_change_session_keyring function
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - Keyring support
 *
 * Timeline:
 *  - Created: 12.XII.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_KEY_CHANGE_SESSION_KEYRING_H
#define P_LKRG_EXPLOIT_DETECTION_KEY_CHANGE_SESSION_KEYRING_H

/* per-instance private data */
struct p_key_change_session_keyring_data {
    ktime_t entry_stamp;
};


int p_key_change_session_keyring_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_key_change_session_keyring_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_key_change_session_keyring_hook(int p_isra);
void p_uninstall_key_change_session_keyring_hook(void);

#endif
