/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.output.OutputWriter;

public class UnregisterCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "unregister";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Unregister the current device from the signal server.");
        subparser.addArgument(new String[]{"--delete-account"}).help("Delete account completely from server. CAUTION: Only do this if you won't use this number again!").action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        try {
            if (Boolean.TRUE.equals(ns.getBoolean("delete-account"))) {
                m.deleteAccount();
            } else {
                m.unregister();
            }
        }
        catch (IOException e) {
            throw new IOErrorException("Unregister error: " + e.getMessage(), e);
        }
    }
}

