/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class RandomUtils {
    private static final ThreadLocal<SecureRandom> LOCAL_RANDOM = ThreadLocal.withInitial(() -> {
        SecureRandom rand = RandomUtils.getSecureRandomUnseeded();
        rand.nextBoolean();
        return rand;
    });

    private static SecureRandom getSecureRandomUnseeded() {
        try {
            return SecureRandom.getInstance("NativePRNG");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e1) {
                return new SecureRandom();
            }
        }
    }

    public static SecureRandom getSecureRandom() {
        return LOCAL_RANDOM.get();
    }
}

