/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.senderKeys;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.UUID;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class SenderKeyRecordStore
implements SenderKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(SenderKeyRecordStore.class);
    private static final String TABLE_SENDER_KEY = "sender_key";
    private final Database database;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE sender_key (\n  _id INTEGER PRIMARY KEY,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  record BLOB NOT NULL,\n  created_timestamp INTEGER NOT NULL,\n  UNIQUE(address, device_id, distribution_id)\n) STRICT;\n");
        }
    }

    SenderKeyRecordStore(Database database) {
        this.database = database;
    }

    public SenderKeyRecord loadSenderKey(SignalProtocolAddress address, UUID distributionId) {
        SenderKeyRecord senderKeyRecord;
        block8: {
            Key key = this.getKey(address, distributionId);
            Connection connection = this.database.getConnection();
            try {
                senderKeyRecord = this.loadSenderKey(connection, key);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from sender key store", e);
                }
            }
            connection.close();
        }
        return senderKeyRecord;
    }

    public void storeSenderKey(SignalProtocolAddress address, UUID distributionId, SenderKeyRecord record) {
        Key key = this.getKey(address, distributionId);
        try (Connection connection = this.database.getConnection();){
            this.storeSenderKey(connection, key, record);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sender key store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    long getCreateTimeForKey(ServiceId selfServiceId, int selfDeviceId, UUID distributionId) {
        String sql = "SELECT s.created_timestamp\nFROM %s AS s\nWHERE s.address = ? AND s.device_id = ? AND s.distribution_id = ?\n".formatted(TABLE_SENDER_KEY);
        try (Connection connection = this.database.getConnection();){
            long l;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, selfServiceId.toString());
                    statement.setInt(2, selfDeviceId);
                    statement.setBytes(3, UuidUtil.toByteArray((UUID)distributionId));
                    l = Utils.executeQueryForOptional(statement, res -> res.getLong("created_timestamp")).orElse(-1L);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from sender key store", e);
        }
    }

    void deleteSenderKey(ServiceId serviceId, UUID distributionId) {
        String sql = "DELETE FROM %s AS s\nWHERE s.address = ? AND s.distribution_id = ?\n".formatted(TABLE_SENDER_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, serviceId.toString());
            statement.setBytes(2, UuidUtil.toByteArray((UUID)distributionId));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sender key store", e);
        }
    }

    void deleteAll() {
        String sql = "DELETE FROM %s AS s\n".formatted(TABLE_SENDER_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sender key store", e);
        }
    }

    void deleteAllFor(ServiceId serviceId) {
        try (Connection connection = this.database.getConnection();){
            this.deleteAllFor(connection, serviceId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sender key store", e);
        }
    }

    void addLegacySenderKeys(Collection<Pair<Key, SenderKeyRecord>> senderKeys) {
        logger.debug("Migrating legacy sender keys to database");
        long start = System.nanoTime();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (Pair<Key, SenderKeyRecord> pair : senderKeys) {
                this.storeSenderKey(connection, pair.first(), pair.second());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sender keys store", e);
        }
        logger.debug("Complete sender keys migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private Key getKey(SignalProtocolAddress address, UUID distributionId) {
        return new Key(address.getName(), address.getDeviceId(), distributionId);
    }

    private SenderKeyRecord loadSenderKey(Connection connection, Key key) throws SQLException {
        String sql = "SELECT s.record\nFROM %s AS s\nWHERE s.address = ? AND s.device_id = ? AND s.distribution_id = ?\n".formatted(TABLE_SENDER_KEY);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, key.address());
            statement.setInt(2, key.deviceId());
            statement.setBytes(3, UuidUtil.toByteArray((UUID)key.distributionId()));
            SenderKeyRecord senderKeyRecord = Utils.executeQueryForOptional(statement, this::getSenderKeyRecordFromResultSet).orElse(null);
            return senderKeyRecord;
        }
    }

    private void storeSenderKey(Connection connection, Key key, SenderKeyRecord senderKeyRecord) throws SQLException {
        String sqlUpdate = "UPDATE %s\nSET record = ?\nWHERE address = ? AND device_id = ? and distribution_id = ?\n".formatted(TABLE_SENDER_KEY);
        try (PreparedStatement statement = connection.prepareStatement(sqlUpdate);){
            statement.setBytes(1, senderKeyRecord.serialize());
            statement.setString(2, key.address());
            statement.setLong(3, key.deviceId());
            statement.setBytes(4, UuidUtil.toByteArray((UUID)key.distributionId()));
            int rows = statement.executeUpdate();
            if (rows > 0) {
                return;
            }
        }
        String sqlInsert = "INSERT OR REPLACE INTO %s (address, device_id, distribution_id, record, created_timestamp)\nVALUES (?, ?, ?, ?, ?)\n".formatted(TABLE_SENDER_KEY);
        try (PreparedStatement statement = connection.prepareStatement(sqlInsert);){
            statement.setString(1, key.address());
            statement.setInt(2, key.deviceId());
            statement.setBytes(3, UuidUtil.toByteArray((UUID)key.distributionId()));
            statement.setBytes(4, senderKeyRecord.serialize());
            statement.setLong(5, System.currentTimeMillis());
            statement.executeUpdate();
        }
    }

    private void deleteAllFor(Connection connection, ServiceId serviceId) throws SQLException {
        String sql = "DELETE FROM %s AS s\nWHERE s.address = ?\n".formatted(TABLE_SENDER_KEY);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, serviceId.toString());
            statement.executeUpdate();
        }
    }

    private SenderKeyRecord getSenderKeyRecordFromResultSet(ResultSet resultSet) throws SQLException {
        try {
            byte[] record = resultSet.getBytes("record");
            return new SenderKeyRecord(record);
        }
        catch (InvalidMessageException e) {
            logger.warn("Failed to load sender key, resetting: {}", (Object)e.getMessage());
            return null;
        }
    }

    record Key(String address, int deviceId, UUID distributionId) {
    }
}

