/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChunkedOutputStream {
    protected final OutputStream out;

    public ChunkedOutputStream(OutputStream out) {
        this.out = out;
    }

    protected void writeVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.out.write(value);
                return;
            }
            this.out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    protected void writeStream(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            this.out.write(buffer, 0, read);
        }
        in.close();
    }
}

