/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/util/TlsProxySocketFactory;", "Ljavax/net/SocketFactory;", "proxyHost", "", "proxyPort", "", "dns", "Ljava/util/Optional;", "Lokhttp3/Dns;", "(Ljava/lang/String;ILjava/util/Optional;)V", "system", "Ljavax/net/ssl/SSLSocketFactory;", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "address", "localAddress", "localPort", "localHost", "ProxySocket", "signal-service-java"})
public final class TlsProxySocketFactory
extends SocketFactory {
    @Nullable
    private final String proxyHost;
    private final int proxyPort;
    @NotNull
    private final Optional<Dns> dns;
    @NotNull
    private final SSLSocketFactory system;

    /*
     * WARNING - void declaration
     */
    public TlsProxySocketFactory(@Nullable String proxyHost, int proxyPort, @NotNull Optional<Dns> dns) {
        SSLSocketFactory sSLSocketFactory;
        Intrinsics.checkNotNullParameter(dns, (String)"dns");
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.dns = dns;
        TlsProxySocketFactory tlsProxySocketFactory = this;
        try {
            TlsProxySocketFactory tlsProxySocketFactory2 = tlsProxySocketFactory;
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            sSLSocketFactory = context.getSocketFactory();
            Intrinsics.checkNotNull((Object)sSLSocketFactory);
        }
        catch (NoSuchAlgorithmException context) {
            void e;
            TlsProxySocketFactory tlsProxySocketFactory3 = tlsProxySocketFactory;
            throw new AssertionError(e);
        }
        catch (KeyManagementException e) {
            TlsProxySocketFactory tlsProxySocketFactory4 = tlsProxySocketFactory;
            throw new AssertionError((Object)e);
        }
        tlsProxySocketFactory2.system = sSLSocketFactory;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port) throws IOException, UnknownHostException {
        List resolved;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.dns.isPresent() && !((Collection)(resolved = this.dns.get().lookup(host))).isEmpty()) {
            return this.createSocket((InetAddress)resolved.get(0), port);
        }
        Socket socket = this.system.createSocket(this.proxyHost, this.proxyPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"createSocket(...)");
        return new ProxySocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @NotNull InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        List resolved;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        if (this.dns.isPresent() && !((Collection)(resolved = this.dns.get().lookup(host))).isEmpty()) {
            return this.createSocket((InetAddress)resolved.get(0), port, localHost, localPort);
        }
        Socket socket = this.system.createSocket(this.proxyHost, this.proxyPort, localHost, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"createSocket(...)");
        return new ProxySocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress host, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.system.createSocket(this.proxyHost, this.proxyPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"createSocket(...)");
        return new ProxySocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port, @NotNull InetAddress localAddress, int localPort) throws IOException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Socket socket = this.system.createSocket(this.proxyHost, this.proxyPort, localAddress, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"createSocket(...)");
        return new ProxySocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket() throws IOException {
        Socket socket = this.system.createSocket(this.proxyHost, this.proxyPort);
        Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket socket2 = (SSLSocket)socket;
        socket2.startHandshake();
        return new ProxySocket(socket2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\fH\u0016J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0014H\u0016J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0014H\u0016J \u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020\u00052\u0006\u00103\u001a\u00020\fH\u0016J\u0018\u00106\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00142\u0006\u00107\u001a\u00020\fH\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00109\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0014H\u0016J\u0010\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\fH\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\b\u0010=\u001a\u00020\u0005H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/whispersystems/signalservice/api/util/TlsProxySocketFactory$ProxySocket;", "Ljava/net/Socket;", "delegate", "(Ljava/net/Socket;)V", "bind", "", "bindpoint", "Ljava/net/SocketAddress;", "close", "connect", "endpoint", "timeout", "", "getChannel", "Ljava/nio/channels/SocketChannel;", "getInetAddress", "Ljava/net/InetAddress;", "getInputStream", "Ljava/io/InputStream;", "getKeepAlive", "", "getLocalAddress", "getLocalPort", "getLocalSocketAddress", "getOOBInline", "getOutputStream", "Ljava/io/OutputStream;", "getPort", "getReceiveBufferSize", "getRemoteSocketAddress", "getReuseAddress", "getSendBufferSize", "getSoLinger", "getSoTimeout", "getTcpNoDelay", "getTrafficClass", "isBound", "isClosed", "isConnected", "isInputShutdown", "isOutputShutdown", "sendUrgentData", "data", "setKeepAlive", "on", "setOOBInline", "setPerformancePreferences", "connectionTime", "latency", "bandwidth", "setReceiveBufferSize", "size", "setReuseAddress", "setSendBufferSize", "setSoLinger", "linger", "setSoTimeout", "setTcpNoDelay", "setTrafficClass", "tc", "shutdownInput", "shutdownOutput", "toString", "", "signal-service-java"})
    private static final class ProxySocket
    extends Socket {
        @NotNull
        private final Socket delegate;

        public ProxySocket(@NotNull Socket delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @Override
        public void connect(@NotNull SocketAddress endpoint) throws IOException {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        }

        @Override
        public void connect(@NotNull SocketAddress endpoint, int timeout) throws IOException {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        }

        @Override
        public void bind(@NotNull SocketAddress bindpoint) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bindpoint, (String)"bindpoint");
            this.delegate.bind(bindpoint);
        }

        @Override
        @NotNull
        public InetAddress getInetAddress() {
            InetAddress inetAddress = this.delegate.getInetAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getInetAddress(...)");
            return inetAddress;
        }

        @Override
        @NotNull
        public InetAddress getLocalAddress() {
            InetAddress inetAddress = this.delegate.getLocalAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLocalAddress(...)");
            return inetAddress;
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getLocalPort() {
            return this.delegate.getLocalPort();
        }

        @Override
        @NotNull
        public SocketAddress getRemoteSocketAddress() {
            SocketAddress socketAddress = this.delegate.getRemoteSocketAddress();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getRemoteSocketAddress(...)");
            return socketAddress;
        }

        @Override
        @NotNull
        public SocketAddress getLocalSocketAddress() {
            SocketAddress socketAddress = this.delegate.getLocalSocketAddress();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getLocalSocketAddress(...)");
            return socketAddress;
        }

        @Override
        @NotNull
        public SocketChannel getChannel() {
            SocketChannel socketChannel = this.delegate.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"getChannel(...)");
            return socketChannel;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream = this.delegate.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            return inputStream;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream() throws IOException {
            OutputStream outputStream = this.delegate.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            return outputStream;
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.delegate.setTcpNoDelay(on);
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.delegate.getTcpNoDelay();
        }

        @Override
        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.delegate.setSoLinger(on, linger);
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.delegate.getSoLinger();
        }

        @Override
        public void sendUrgentData(int data) throws IOException {
            this.delegate.sendUrgentData(data);
        }

        @Override
        public void setOOBInline(boolean on) throws SocketException {
            this.delegate.setOOBInline(on);
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.delegate.getOOBInline();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.delegate.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.delegate.getSoTimeout();
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.delegate.setSendBufferSize(size);
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.delegate.getSendBufferSize();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.delegate.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.delegate.getReceiveBufferSize();
        }

        @Override
        public void setKeepAlive(boolean on) throws SocketException {
            this.delegate.setKeepAlive(on);
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.delegate.getKeepAlive();
        }

        @Override
        public void setTrafficClass(int tc) throws SocketException {
            this.delegate.setTrafficClass(tc);
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.delegate.getTrafficClass();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.delegate.setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.delegate.getReuseAddress();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void shutdownInput() throws IOException {
            this.delegate.shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.delegate.shutdownOutput();
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.delegate.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public boolean isBound() {
            return this.delegate.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public boolean isInputShutdown() {
            return this.delegate.isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.delegate.isOutputShutdown();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }
}

