/* validator-utils.h
 *
 * Copyright (C) 2021 - Daniel Léonard Schardijn
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <chirurgien-types.h>

G_BEGIN_DECLS

/* Common parser functions */

gboolean              validator_utils_validate_hex_value    (GMarkupParseContext *,
                                                             const gchar *,
                                                             const gchar *,
                                                             GError **);
void                  validator_utils_hex_to_binary         (const gchar *,
                                                             gpointer *,
                                                             gsize *,
                                                             gboolean);

void                  validator_utils_prefix_attr_error     (GMarkupParseContext *,
                                                             GError **);

/* Initialization functions */

FormatDefinition *    format_definition_create              (void);

/* Destroy functions */

void                  format_definition_destroy             (FormatDefinition *);

void                  format_color_destroy                  (gpointer);
void                  magic_step_destroy                    (gpointer);
void                  run_step_destroy                      (gpointer);
void                  field_def_destroy                     (gpointer);

G_END_DECLS
