/*
 * Decompiled with CFR 0.152.
 */
package plugin.pcgtracker;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ImagePreview;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.FileMenuOpenMessage;
import gmgen.pluginmgr.messages.GMGenBeingClosedMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.PlayerCharacterWasClosedMessage;
import pcgen.pluginmgr.messages.PlayerCharacterWasLoadedMessage;
import pcgen.pluginmgr.messages.RequestOpenPlayerCharacterMessage;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import plugin.pcgtracker.PCGTrackerModel;
import plugin.pcgtracker.gui.PCGTrackerView;

public class PCGTrackerPlugin
implements InteractivePlugin,
ActionListener {
    public static final String LOG_NAME = "PCG_Tracker";
    private static final String OPTION_NAME_SYSTEM = "PCG_Tracker.System";
    private static final String OPTION_NAME_LOADORDER = "PCG_Tracker.LoadOrder";
    private static final String FILENAME_PCP = "pcp";
    private static final String FILENAME_PCG = "pcg";
    private JMenuItem charToolsItem = new JMenuItem();
    private PCGTrackerModel model = new PCGTrackerModel();
    private PCGTrackerView theView;
    private static final String NAME = "Character Tracker";
    private static final String IN_NAME = "in_plugin_pcgtracker_name";
    private static final String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.theView = new PCGTrackerView();
        this.theView.getLoadedList().setModel(this.model);
        this.initListeners();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.getLocalizedName(), this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)OPTION_NAME_LOADORDER, (int)1000);
    }

    public String getPluginName() {
        return NAME;
    }

    private String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public Component getView() {
        return this.theView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PlayerCharacter pc;
        if (e.getSource() == this.theView.getRemoveButton()) {
            this.removeSelected();
        }
        if (e.getSource() == this.theView.getSaveButton()) {
            for (Object obj : this.theView.getLoadedList().getSelectedValuesList()) {
                pc = this.model.get(obj);
                this.savePC(pc, false);
            }
        }
        if (e.getSource() == this.theView.getSaveAsButton()) {
            for (Object obj : this.theView.getLoadedList().getSelectedValuesList()) {
                pc = this.model.get(obj);
                this.savePC(pc, true);
            }
        }
        if (e.getSource() == this.theView.getLoadButton()) {
            this.handleOpen();
        }
        this.theView.getLoadedList().repaint();
    }

    public void handleClose() {
        if (this.model.size() > 0) {
            GMGenSystemView.getTabPane().setSelectedComponent(this.theView);
        }
        for (int i = 0; i < this.model.size(); ++i) {
            this.model.get(i);
        }
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof FileMenuOpenMessage) {
            if (this.isActive()) {
                this.handleOpen();
            }
        } else if (message instanceof PlayerCharacterWasLoadedMessage) {
            PlayerCharacterWasLoadedMessage cmessage = (PlayerCharacterWasLoadedMessage)message;
            this.model.add(cmessage.getPc());
        } else if (message instanceof FocusOrStateChangeOccurredMessage) {
            if (this.isActive()) {
                this.charToolsItem.setEnabled(false);
                try {
                    GMGenSystem.inst.openFileItem.setEnabled(true);
                }
                catch (Exception e) {}
            } else {
                this.charToolsItem.setEnabled(true);
            }
        } else if (message instanceof GMGenBeingClosedMessage) {
            this.handleClose();
        } else if (message instanceof PlayerCharacterWasClosedMessage) {
            PlayerCharacterWasClosedMessage cmessage = (PlayerCharacterWasClosedMessage)message;
            this.model.remove(cmessage.getPC());
        }
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    public void handleOpen() {
        File defaultFile = new File(PCGenSettings.getPcgDir());
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(defaultFile);
        String[] pcgs = new String[]{FILENAME_PCG, FILENAME_PCP};
        SimpleFileFilter ff = new SimpleFileFilter(pcgs, LanguageBundle.getString((String)"in_pcgen_file"));
        chooser.addChoosableFileFilter((FileFilter)ff);
        chooser.setFileFilter((FileFilter)ff);
        chooser.setMultiSelectionEnabled(true);
        GMGenSystem component = GMGenSystem.inst;
        Cursor originalCursor = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        int option = chooser.showOpenDialog((Component)GMGenSystem.inst);
        if (option == 0) {
            for (File selectedFile : chooser.getSelectedFiles()) {
                if (!PCGFile.isPCGenCharacterOrPartyFile((File)selectedFile)) continue;
                this.messageHandler.handleMessage((PCGenMessage)new RequestOpenPlayerCharacterMessage((Object)this, selectedFile, false));
            }
        }
        GMGenSystem.inst.setCursor(originalCursor);
    }

    public void initListeners() {
        this.theView.getRemoveButton().addActionListener(this);
        this.theView.getSaveButton().addActionListener(this);
        this.theView.getSaveAsButton().addActionListener(this);
        this.theView.getLoadButton().addActionListener(this);
    }

    public void removeSelected() {
        for (Object obj : this.theView.getLoadedList().getSelectedValuesList()) {
            PlayerCharacter pc = this.model.get(obj);
            this.model.removeElement(obj);
            this.messageHandler.handleMessage((PCGenMessage)new PlayerCharacterWasClosedMessage((Object)this, pc));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePC(PlayerCharacter aPC, boolean saveas) {
        File prevFile;
        boolean newPC = false;
        File file = null;
        String aPCFileName = aPC.getFileName();
        if (aPCFileName.isEmpty()) {
            prevFile = new File(PCGenSettings.getPcgDir(), aPC.getDisplay().getDisplayName() + ".pcg");
            aPCFileName = prevFile.getAbsolutePath();
            newPC = true;
        } else {
            prevFile = new File(aPCFileName);
        }
        if (saveas || newPC) {
            int reallyClose;
            JFileChooser fc = ImagePreview.decorateWithImagePreview((JFileChooser)new JFileChooser());
            String[] pcgs = new String[]{FILENAME_PCG};
            SimpleFileFilter ff = new SimpleFileFilter(pcgs, LanguageBundle.getString((String)"in_pcgen_file_char"));
            fc.setFileFilter((FileFilter)ff);
            fc.setSelectedFile(prevFile);
            FilenameChangeListener listener = new FilenameChangeListener(aPCFileName, fc);
            fc.addPropertyChangeListener(listener);
            int returnVal = fc.showSaveDialog((Component)GMGenSystem.inst);
            fc.removePropertyChangeListener(listener);
            if (returnVal != 0) return false;
            file = fc.getSelectedFile();
            if (!PCGFile.isPCGenCharacterFile((File)file)) {
                file = new File(file.getParent(), file.getName() + ".pcg");
            }
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(null, LanguageBundle.getString((String)"in_savePcDirOverwrite"), "PCGen", 0);
                return false;
            }
            if (file.exists() && (newPC || !file.getName().equals(prevFile.getName())) && (reallyClose = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, LanguageBundle.getFormattedString((String)"in_savePcConfirmOverMsg", (Object[])new Object[]{file.getName()}), LanguageBundle.getFormattedString((String)"in_savePcConfirmOverTitle", (Object[])new Object[]{file.getName()}), 0)) != 0) {
                return false;
            }
            aPC.setFileName(file.getAbsolutePath());
        } else {
            file = prevFile;
        }
        try {
            new PCGIOHandler().write(aPC, null, null, file);
            return true;
        }
        catch (Exception ex) {
            String formattedString = LanguageBundle.getFormattedString((String)"in_saveFailMsg", (Object[])new Object[]{aPC.getDisplay().getDisplayName()});
            JOptionPane.showMessageDialog(null, formattedString, "PCGen", 0);
            Logging.errorPrint((String)formattedString);
            Logging.errorPrint((String)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof PCGTrackerView)) continue;
            tp.setSelectedIndex(i);
        }
    }

    private void initMenus() {
        this.charToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)"in_mn_plugin_pcgtracker_name"));
        this.charToolsItem.setText(LanguageBundle.getString((String)IN_NAME));
        this.charToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PCGTrackerPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.charToolsItem));
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }

    static final class FilenameChangeListener
    implements PropertyChangeListener {
        private JFileChooser fileChooser;
        private String lastSelName;

        FilenameChangeListener(String aFileName, JFileChooser aFileChooser) {
            this.lastSelName = aFileName;
            this.fileChooser = aFileChooser;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("SelectedFileChangedProperty")) {
                this.onSelectedFileChange(evt);
            } else if (propName.equals("directoryChanged")) {
                this.onDirectoryChange();
            }
        }

        private void onDirectoryChange() {
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory(), this.lastSelName));
        }

        private void onSelectedFileChange(PropertyChangeEvent evt) {
            File newSelFile = (File)evt.getNewValue();
            if (newSelFile != null && !newSelFile.isDirectory()) {
                this.lastSelName = newSelFile.getName();
            }
        }
    }
}

