/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.Race;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class MonsterclassToken
extends AbstractNonEmptyToken<Race>
implements CDOMPrimaryToken<Race>,
DeferredToken<Race> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;

    public String getTokenName() {
        return "MONSTERCLASS";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Race race, String value) {
        ParsingSeparator sep = new ParsingSeparator(value, ':');
        String classString = sep.next();
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a colon: " + value, context);
        }
        String numLevels = sep.next();
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " must have only one colon: " + value, context);
        }
        CDOMSingleRef cl = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, classString);
        try {
            int lvls = Integer.parseInt(numLevels);
            if (lvls <= 0) {
                return new ParseResult.Fail("Number of levels in " + this.getTokenName() + " must be greater than zero: " + value, context);
            }
            LevelCommandFactory cf = new LevelCommandFactory(cl, FormulaFactory.getFormulaFor((Integer)lvls));
            context.getObjectContext().put((CDOMObject)race, ObjectKey.MONSTER_CLASS, (Object)cf);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Number of levels in " + this.getTokenName() + " must be an integer greater than zero: " + value, context);
        }
    }

    public String[] unparse(LoadContext context, Race race) {
        LevelCommandFactory lcf = (LevelCommandFactory)context.getObjectContext().getObject((CDOMObject)race, ObjectKey.MONSTER_CLASS);
        if (lcf == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(lcf.getLSTformat()).append(":").append(lcf.getLevelCount().toString());
        return new String[]{sb.toString()};
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }

    public Class<Race> getDeferredTokenClass() {
        return Race.class;
    }

    public boolean process(LoadContext context, Race r) {
        LevelCommandFactory lcf = (LevelCommandFactory)r.get(ObjectKey.MONSTER_CLASS);
        if (lcf != null) {
            String className = lcf.getLSTformat();
            PCClass pcc = (PCClass)context.getReferenceContext().silentlyGetConstructedCDOMObject(PCCLASS_CLASS, className);
            if (pcc != null && !pcc.isMonster()) {
                Logging.log((Level)Logging.LST_WARNING, (String)("Class " + className + " was used in RACE MONSTERCLASS, " + "but it is not a Monster class"));
            }
        }
        return true;
    }
}

