/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.enumeration.TypeSafeConstant;
import pcgen.base.formula.Formula;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.formula.FixedSizeFormula;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.SizeAdjustment;
import pcgen.core.analysis.SizeUtilities;

public class FormulaKey
implements TypeSafeConstant {
    private static CaseInsensitiveMap<FormulaKey> typeMap = new CaseInsensitiveMap();
    private static int ordinalCount = 0;
    public static final FormulaKey LEVEL_ADJUSTMENT = FormulaKey.getConstant("LEVEL_ADJUSTMENT");
    public static final FormulaKey START_SKILL_POINTS = FormulaKey.getConstant("START_SKILL_POINTS");
    public static final FormulaKey COST = FormulaKey.getConstant("COST");
    public static final FormulaKey BASECOST = FormulaKey.getConstant("BASECOST");
    public static final FormulaKey PAGE_USAGE = FormulaKey.getConstant("PAGE_USAGE");
    public static final FormulaKey CR = FormulaKey.getConstant("CR");
    public static final FormulaKey CRMOD = FormulaKey.getConstant("CRMOD");
    public static final FormulaKey SELECT = FormulaKey.getConstant("SELECT", FormulaFactory.ONE);
    public static final FormulaKey NUMCHOICES = FormulaKey.getConstant("NUMCHOICES");
    public static final FormulaKey SIZE;
    public static final FormulaKey STAT_MOD;
    public static final FormulaKey SKILL_POINTS_PER_LEVEL;
    private final String fieldName;
    private final Formula defaultValue;
    private final transient int ordinal;

    private FormulaKey(String name, Formula def) {
        if (name == null) {
            throw new IllegalArgumentException("Name for FormulaKey cannot be null");
        }
        if (def == null) {
            throw new IllegalArgumentException("Formula for FormulaKey cannot be null");
        }
        this.ordinal = ordinalCount++;
        this.fieldName = name;
        this.defaultValue = def;
    }

    public String toString() {
        return this.fieldName;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public Formula getDefault() {
        return this.defaultValue;
    }

    public static FormulaKey getConstant(String name) {
        FormulaKey key = (FormulaKey)typeMap.get((Object)name);
        if (key == null) {
            key = new FormulaKey(name, FormulaFactory.ZERO);
            typeMap.put((Object)name, (Object)key);
        }
        return key;
    }

    public static FormulaKey getConstant(String name, Formula formula) {
        FormulaKey key = (FormulaKey)typeMap.get((Object)name);
        if (key == null) {
            key = new FormulaKey(name, formula);
            typeMap.put((Object)name, (Object)key);
        }
        return key;
    }

    public static FormulaKey valueOf(String name) {
        FormulaKey key = (FormulaKey)typeMap.get((Object)name);
        if (key == null) {
            throw new IllegalArgumentException(name + " is not a previously defined FormulaKey");
        }
        return key;
    }

    public static Collection<FormulaKey> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    public static void clearConstants() {
        typeMap.clear();
    }

    static {
        STAT_MOD = FormulaKey.getConstant("STAT_MOD");
        SKILL_POINTS_PER_LEVEL = FormulaKey.getConstant("SKILL_POINTS_PER_LEVEL");
        SIZE = new FormulaKey("SIZE", FormulaFactory.ZERO){

            @Override
            public Formula getDefault() {
                SizeAdjustment def = SizeUtilities.getDefaultSizeAdjustment();
                CDOMDirectSingleRef<SizeAdjustment> ref = CDOMDirectSingleRef.getRef(def);
                return new FixedSizeFormula(ref);
            }
        };
        typeMap.put((Object)SIZE.toString(), (Object)SIZE);
    }
}

