/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.content.Processor;

public class ChangeArmorType
implements Processor<String> {
    private final String source;
    private final String result;

    public ChangeArmorType(String sourceType, String resultType) {
        if (sourceType == null) {
            throw new IllegalArgumentException("Source Type for ChangeArmorType cannot be null");
        }
        if (resultType == null) {
            throw new IllegalArgumentException("Resulting Type for ChangeArmorType cannot be null");
        }
        this.result = resultType;
        this.source = sourceType;
    }

    @Override
    public String applyProcessor(String sourceType, Object context) {
        return this.source.equalsIgnoreCase(sourceType) ? this.result : sourceType;
    }

    @Override
    public Class<String> getModifiedClass() {
        return String.class;
    }

    public int hashCode() {
        return 31 * this.source.hashCode() + this.result.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChangeArmorType)) {
            return false;
        }
        ChangeArmorType other = (ChangeArmorType)obj;
        if (this.result == null) {
            return other.result == null;
        }
        return this.result.equals(other.result) && this.source.equals(other.source);
    }

    public List<String> applyProcessor(Collection<String> armorTypes) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String type : armorTypes) {
            String mod = this.applyProcessor(type, (Object)null);
            if (mod == null) continue;
            returnList.add(mod.toUpperCase());
        }
        return returnList;
    }

    @Override
    public String getLSTformat() {
        return this.source + (this.result == null ? "" : "|" + this.result);
    }
}

