/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public final class LevelInfo {
    private String maxClassSkillString = "0";
    private String maxCrossClassSkillString = "0";
    private String levelString = "0";
    private String minXPString = "0";

    public void setLevelString(String arg) {
        this.levelString = arg;
    }

    public String getLevelString() {
        return this.levelString;
    }

    public void setMaxClassSkillString(String arg) {
        this.maxClassSkillString = arg;
    }

    public void setMaxCrossClassSkillString(String arg) {
        this.maxCrossClassSkillString = arg;
    }

    public void setMinXPString(String arg) {
        this.minXPString = arg;
    }

    public String toString() {
        return "Level: " + this.levelString + " MinXP: " + this.minXPString + " MaxClassSkill: " + this.maxClassSkillString + " MaxCrossClassSkill: " + this.maxCrossClassSkillString + ".";
    }

    public String getMinXPVariable(int levelArg) {
        return this.minXPString.replaceAll(this.levelString, String.valueOf(levelArg));
    }

    public BigDecimal getMaxClassSkillRank(int levelArg, PlayerCharacter calcPC) {
        return this.getMaxSkillRank(levelArg, calcPC, this.maxClassSkillString);
    }

    public BigDecimal getMaxCrossClassSkillRank(int levelArg, PlayerCharacter calcPC) {
        return this.getMaxSkillRank(levelArg, calcPC, this.maxCrossClassSkillString);
    }

    private BigDecimal getMaxSkillRank(int levelArg, PlayerCharacter calcPC, String maxSkillString) {
        double ranks;
        if (calcPC == null) {
            return BigDecimal.ZERO;
        }
        try {
            ranks = calcPC.getVariableValue(maxSkillString.replaceAll(this.levelString, String.valueOf(levelArg)), "").doubleValue();
        }
        catch (Exception e) {
            Logging.errorPrint("Exception while getting max rank for " + this.levelString, e);
            ranks = 0.0;
        }
        return new BigDecimal(ranks);
    }
}

