/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.npcgen.EqmodItem;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

public class EquipmentItem {
    private Equipment theEquipment = null;
    private List<EqmodItem> theEqMods = null;
    private EquipmentTable theLookupTable = null;
    private WeightedCollection<String> theChoices = null;
    private String theVariableEquipment = null;
    private String theTimes = null;
    private String theQuantity = null;

    public List<Equipment> getEquipment() {
        ArrayList<Equipment> ret = new ArrayList<Equipment>();
        int numTimes = 1;
        if (this.theTimes != null) {
            numTimes = this.getJepValue(this.theTimes);
            Logging.debugPrint("Rolling " + numTimes + " times");
        }
        for (int i = 0; i < numTimes; ++i) {
            if (this.theEquipment == null) {
                if (this.theLookupTable != null) {
                    Logging.debugPrint("Getting value from table: " + this.theLookupTable);
                    ret.addAll(this.theLookupTable.getEquipment());
                } else if (this.theChoices != null) {
                    String subst = this.theChoices.getRandomValue();
                    Logging.debugPrint("Selected " + subst + " as choice");
                    String equipKey = this.theVariableEquipment.replaceFirst("%CHOICE", subst);
                    Logging.debugPrint("\tUsing " + equipKey + " as the equipment");
                    Equipment eq = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, equipKey);
                    eq = eq.clone();
                    int quantity = 1;
                    if (this.theQuantity != null) {
                        quantity = this.getJepValue(this.theQuantity);
                    }
                    eq.setQty(quantity);
                    ret.add(eq);
                }
            } else {
                Logging.debugPrint("Selecting " + this.theEquipment);
                Equipment eq = this.theEquipment.clone();
                int quantity = 1;
                if (this.theQuantity != null) {
                    quantity = this.getJepValue(this.theQuantity);
                    Logging.debugPrint("Adding " + quantity + " items");
                }
                eq.setQty(quantity);
                ret.add(eq);
            }
            if (this.theEqMods == null) continue;
            for (Equipment eq : ret) {
                for (EqmodItem eqmodItem : this.theEqMods) {
                    for (String eqmod : eqmodItem.getEqMods()) {
                        Logging.debugPrint("Adding eqmod: " + eqmod);
                        eq.addEqModifiers(eqmod, true);
                    }
                }
                eq.resizeItem(null, eq.getSafe(ObjectKey.SIZE).resolvesTo());
                eq.nameItemFromModifiers(null);
            }
        }
        return ret;
    }

    public void setEquipment(Equipment anEquipment) {
        this.theEquipment = anEquipment;
    }

    public void addEqMod(EqmodItem aMod) {
        if (this.theEqMods == null) {
            this.theEqMods = new ArrayList<EqmodItem>();
        }
        this.theEqMods.add(aMod);
    }

    public void setLookup(EquipmentTable aTable) {
        this.theLookupTable = aTable;
    }

    public void setVariableEquipment(String anEquipString, List<String> aList) {
        this.theVariableEquipment = anEquipString;
        this.theChoices = new WeightedCollection<String>(aList);
    }

    public void setTimes(String aNumberTimes) {
        if (aNumberTimes.indexOf(100) != -1) {
            this.theTimes = "roll(\"";
        }
        this.theTimes = this.theTimes + aNumberTimes;
        if (aNumberTimes.indexOf(100) != -1) {
            this.theTimes = this.theTimes + "\")";
        }
    }

    public void setQuantity(String aQuantity) {
        this.theQuantity = aQuantity;
    }

    private int getJepValue(String anExpression) {
        try {
            return Integer.parseInt(anExpression);
        }
        catch (NumberFormatException e) {
            PJEP parser = PjepPool.getInstance().aquire(this, anExpression);
            parser.parseExpression(anExpression);
            int ret = 0;
            if (parser.hasError()) {
                Logging.errorPrint("Not a JEP expression: " + anExpression);
            } else {
                ret = (int)parser.getValue();
            }
            PjepPool.getInstance().release(parser);
            return ret;
        }
    }
}

