/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.LanguageBundle;

public class CopySettingsPanel
extends PCGenPrefsPanel {
    private static String in_copy_settings = LanguageBundle.getString("in_Prefs_copy");
    private JComboBoxEx gameModeSelect = new JComboBoxEx();
    private JButton copyButton = new JButton(LanguageBundle.getString("in_copy"));
    private List<PCGenPrefsPanel> affectedPanels = new ArrayList<PCGenPrefsPanel>();

    public CopySettingsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_copy_settings);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        this.gameModeSelect.setAllItems(SystemCollections.getUnmodifiableGameModeList().toArray());
        this.gameModeSelect.sortItems();
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getString("in_Prefs_copyFrom"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 2, 1, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.gameModeSelect, c);
        this.add(this.gameModeSelect);
        Utility.buildConstraints(c, 3, 1, 1, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getFormattedString("in_Prefs_copyTo", SettingsHandler.getGame().getName()));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 4, 1, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.copyButton, c);
        this.add(this.copyButton);
        this.copyButton.addActionListener(new CopyButtonListener());
        Utility.buildConstraints(c, 0, 2, 4, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_copyDesc"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 5, 20, 1, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    @Override
    public String getTitle() {
        return in_copy_settings;
    }

    @Override
    public void setOptionsBasedOnControls() {
    }

    @Override
    public void applyOptionValuesToControls() {
    }

    public void registerAffectedPanel(PCGenPrefsPanel panel) {
        this.affectedPanels.add(panel);
    }

    private final class CopyButtonListener
    implements ActionListener {
        private CopyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GameMode gmFrom = (GameMode)CopySettingsPanel.this.gameModeSelect.getSelectedItem();
            GameMode gmTo = SettingsHandler.getGame();
            gmTo.setAllStatsValue(gmFrom.getAllStatsValue());
            gmTo.setRollMethodExpressionByName(gmFrom.getRollMethodExpressionName());
            if (gmTo.getPurchaseMethodByName(gmFrom.getPurchaseModeMethodName()) != null) {
                gmTo.setPurchaseMethodName(gmFrom.getPurchaseModeMethodName());
            }
            gmTo.setRollMethod(gmFrom.getRollMethod());
            gmTo.selectUnitSet(gmFrom.getUnitSet().getKeyName());
            if (gmTo.getXPTableNames().contains(gmFrom.getDefaultXPTableName())) {
                gmTo.setDefaultXPTableName(gmFrom.getDefaultXPTableName());
            }
            String currentICS = SettingsHandler.getPCGenOption("InfoCharacterSheet." + gmTo.getName() + ".CurrentSheet", "");
            String fromGmICS = SettingsHandler.getPCGenOption("InfoCharacterSheet." + gmFrom.getName() + ".CurrentSheet", currentICS);
            SettingsHandler.setPCGenOption("InfoCharacterSheet." + gmTo.getName() + ".CurrentSheet", fromGmICS);
            for (PCGenPrefsPanel panel : CopySettingsPanel.this.affectedPanels) {
                panel.applyOptionValuesToControls();
            }
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_copyDone"), "PCGen", MessageType.INFORMATION);
        }
    }
}

