/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import pcgen.core.GameMode;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.EquipIconLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class EquipIconLoader
extends LstLineFileLoader {
    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) throws PersistenceLayerException {
        int idxColon = lstLine.indexOf(58);
        if (idxColon < 0) {
            return;
        }
        GameMode game = SystemCollections.getGameModeNamed(this.gameMode);
        String key = lstLine.substring(0, idxColon);
        String value = lstLine.substring(idxColon + 1);
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(EquipIconLstToken.class);
        EquipIconLstToken token = (EquipIconLstToken)tokenMap.get(key);
        if (token != null) {
            LstUtils.deprecationCheck(token, key, sourceURI, lstLine);
            if (!token.parse(game, value, sourceURI)) {
                Logging.errorPrint("Error parsing EquipIcon object: " + lstLine + " at " + sourceURI.toString());
            }
        } else {
            Logging.errorPrint("Illegal EquipIcon object: " + lstLine + " at " + sourceURI.toString());
        }
    }
}

