/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.Indirect;
import pcgen.base.util.ObjectContainer;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.CollectionChanges;
import pcgen.rules.context.MapChanges;
import pcgen.rules.context.ObjectCommitStrategy;
import pcgen.rules.context.PatternChanges;
import pcgen.util.Logging;

public abstract class AbstractObjectContext
implements ObjectCommitStrategy {
    private final TrackingObjectCommitStrategy edits = new TrackingObjectCommitStrategy();

    URI getSourceURI() {
        return this.edits.getSourceURI();
    }

    @Override
    public void setSourceURI(URI sourceURI) {
        this.edits.setSourceURI(sourceURI);
        this.getCommitStrategy().setSourceURI(sourceURI);
    }

    URI getExtractURI() {
        return this.edits.getExtractURI();
    }

    @Override
    public void setExtractURI(URI extractURI) {
        this.edits.setExtractURI(extractURI);
        this.getCommitStrategy().setExtractURI(extractURI);
    }

    @Override
    public <T> void addToList(CDOMObject cdo, ListKey<T> key, T value) {
        this.edits.addToList(cdo, key, value);
    }

    @Override
    public <T> void addToSet(CDOMObject cdo, FactSetKey<T> key, ObjectContainer<T> value) {
        this.edits.addToSet(cdo, key, value);
    }

    @Override
    public <K, V> void put(CDOMObject cdo, MapKey<K, V> mk, K key, V value) {
        this.edits.put(cdo, mk, key, value);
    }

    @Override
    public void put(CDOMObject cdo, FormulaKey fk, Formula f) {
        this.edits.put(cdo, fk, f);
    }

    @Override
    public void put(ConcretePrereqObject cpo, Prerequisite p) {
        this.edits.put(cpo, p);
    }

    @Override
    public void clearPrerequisiteList(ConcretePrereqObject cpo) {
        this.edits.clearPrerequisiteList(cpo);
    }

    @Override
    public void put(CDOMObject cdo, IntegerKey ik, Integer i) {
        this.edits.put(cdo, ik, i);
    }

    @Override
    public void remove(CDOMObject cdo, IntegerKey ik) {
        this.edits.remove(cdo, ik);
    }

    @Override
    public <T> void put(CDOMObject cdo, ObjectKey<T> sk, T s) {
        this.edits.put(cdo, sk, s);
    }

    @Override
    public void remove(CDOMObject cdo, ObjectKey<?> sk) {
        this.edits.remove(cdo, sk);
    }

    @Override
    public <T> void put(CDOMObject cdo, FactKey<T> sk, Indirect<T> s) {
        this.edits.put(cdo, sk, s);
    }

    @Override
    public void remove(CDOMObject cdo, FactKey<?> sk) {
        this.edits.remove(cdo, sk);
    }

    @Override
    public void put(CDOMObject cdo, StringKey sk, String s) {
        this.edits.put(cdo, sk, s);
    }

    @Override
    public void remove(CDOMObject cdo, StringKey sk) {
        this.edits.remove(cdo, sk);
    }

    @Override
    public void put(CDOMObject cdo, VariableKey vk, Formula f) {
        this.edits.put(cdo, vk, f);
    }

    @Override
    public <T> void removeFromList(CDOMObject cdo, ListKey<T> lk, T val) {
        this.edits.removeFromList(cdo, lk, val);
    }

    @Override
    public void removeList(CDOMObject cdo, ListKey<?> lk) {
        this.edits.removeList(cdo, lk);
    }

    @Override
    public <T> void removeFromSet(CDOMObject cdo, FactSetKey<T> lk, ObjectContainer<T> val) {
        this.edits.removeFromSet(cdo, lk, val);
    }

    @Override
    public void removeSet(CDOMObject cdo, FactSetKey<?> lk) {
        this.edits.removeSet(cdo, lk);
    }

    @Override
    public <K, V> void remove(CDOMObject cdo, MapKey<K, V> mk, K key) {
        this.edits.remove(cdo, mk, key);
    }

    void commit() {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        for (URI uri : this.edits.preClearSet.getKeySet()) {
            for (ConcretePrereqObject cpo : this.edits.preClearSet.getListFor((Object)uri)) {
                commit.clearPrerequisiteList(cpo);
            }
        }
        for (URI uri : this.edits.globalClearSet.getKeySet()) {
            for (CDOMObject cdo : this.edits.globalClearSet.getSecondaryKeySet((Object)uri)) {
                for (ListKey lk : this.edits.globalClearSet.getListFor((Object)uri, (Object)cdo)) {
                    commit.removeList(cdo, lk);
                }
            }
        }
        for (URI uri : this.edits.negativeMap.getKeySet()) {
            for (ConcretePrereqObject cpo : this.edits.negativeMap.getSecondaryKeySet((Object)uri)) {
                if (!(cpo instanceof CDOMObject)) continue;
                CDOMObject cdo = (CDOMObject)cpo;
                CDOMObject neg = (CDOMObject)this.edits.negativeMap.get((Object)uri, (Object)cdo);
                for (ObjectKey<?> objectKey : neg.getSafeListFor(ListKey.REMOVED_OBJECTKEY)) {
                    commit.remove(cdo, objectKey);
                }
                for (FactKey factKey : neg.getSafeListFor(ListKey.REMOVED_FACTKEY)) {
                    commit.remove(cdo, factKey);
                }
                for (StringKey stringKey : neg.getSafeListFor(ListKey.REMOVED_STRINGKEY)) {
                    commit.remove(cdo, stringKey);
                }
                for (IntegerKey integerKey : neg.getSafeListFor(ListKey.REMOVED_INTEGERKEY)) {
                    commit.remove(cdo, integerKey);
                }
                for (FactSetKey factSetKey : neg.getFactSetKeys()) {
                    this.removeFactSetKey(cdo, factSetKey, neg);
                }
                for (ListKey listKey : neg.getListKeys()) {
                    this.removeListKey(cdo, listKey, neg);
                }
                for (MapKey mapKey : neg.getMapKeys()) {
                    this.removeMapKey(cdo, mapKey, neg);
                }
            }
        }
        for (URI uri : this.edits.positiveMap.getKeySet()) {
            for (ConcretePrereqObject cpo : this.edits.positiveMap.getSecondaryKeySet((Object)uri)) {
                CDOMObject pos = (CDOMObject)this.edits.positiveMap.get((Object)uri, (Object)cpo);
                for (Prerequisite p : pos.getPrerequisiteList()) {
                    commit.put(cpo, p);
                }
                if (!(cpo instanceof CDOMObject)) continue;
                CDOMObject cdo = (CDOMObject)cpo;
                for (StringKey stringKey : pos.getStringKeys()) {
                    commit.put(cdo, stringKey, pos.get(stringKey));
                }
                for (IntegerKey integerKey : pos.getIntegerKeys()) {
                    commit.put(cdo, integerKey, pos.get(integerKey));
                }
                for (FormulaKey formulaKey : pos.getFormulaKeys()) {
                    commit.put(cdo, formulaKey, pos.get(formulaKey));
                }
                for (VariableKey variableKey : pos.getVariableKeys()) {
                    commit.put(cdo, variableKey, pos.get(variableKey));
                }
                for (ObjectKey objectKey : pos.getObjectKeys()) {
                    this.putObjectKey(cdo, objectKey, pos);
                }
                for (FactKey factKey : pos.getFactKeys()) {
                    this.putFactKey(cdo, factKey, pos);
                }
                for (ListKey listKey : pos.getListKeys()) {
                    this.putListKey(cdo, listKey, pos);
                }
                for (FactSetKey factSetKey : pos.getFactSetKeys()) {
                    this.putFactSetKey(cdo, factSetKey, pos);
                }
                for (MapKey mapKey : pos.getMapKeys()) {
                    this.putMapKey(cdo, mapKey, pos);
                }
            }
        }
        for (URI uri : this.edits.patternClearSet.getKeySet()) {
            for (CDOMObject cdo : this.edits.patternClearSet.getSecondaryKeySet((Object)uri)) {
                for (ListKey lk : this.edits.patternClearSet.getTertiaryKeySet((Object)uri, (Object)cdo)) {
                    for (String string : this.edits.patternClearSet.getListFor((Object)uri, (Object)cdo, (Object)lk)) {
                        commit.removePatternFromList(cdo, lk, string);
                    }
                }
            }
        }
        this.rollback();
    }

    private <T> void removeListKey(CDOMObject cdo, ListKey<T> key, CDOMObject neg) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        for (T obj : neg.getListFor(key)) {
            commit.removeFromList(cdo, key, obj);
        }
    }

    private <T> void removeFactSetKey(CDOMObject cdo, FactSetKey<T> key, CDOMObject neg) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        for (ObjectContainer<T> obj : neg.getSetFor(key)) {
            commit.removeFromSet(cdo, key, obj);
        }
    }

    private <T> void putListKey(CDOMObject cdo, ListKey<T> key, CDOMObject neg) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        for (T obj : neg.getListFor(key)) {
            commit.addToList(cdo, key, obj);
        }
    }

    private <T> void putFactSetKey(CDOMObject cdo, FactSetKey<T> key, CDOMObject neg) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        for (ObjectContainer<T> obj : neg.getSetFor(key)) {
            commit.addToSet(cdo, key, obj);
        }
    }

    private <T> void putObjectKey(CDOMObject cdo, ObjectKey<T> key, CDOMObject neg) {
        this.getCommitStrategy().put(cdo, key, neg.get(key));
    }

    private <T> void putFactKey(CDOMObject cdo, FactKey<T> key, CDOMObject neg) {
        this.getCommitStrategy().put(cdo, key, neg.get(key));
    }

    private <K, V> void removeMapKey(CDOMObject cdo, MapKey<K, V> key1, CDOMObject neg) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        Set<K> secKeys = neg.getKeysFor(key1);
        for (K key2 : secKeys) {
            commit.remove(cdo, key1, key2);
        }
    }

    private <K, V> void putMapKey(CDOMObject cdo, MapKey<K, V> key1, CDOMObject pos) {
        ObjectCommitStrategy commit = this.getCommitStrategy();
        Set<K> secKeys = pos.getKeysFor(key1);
        for (K key2 : secKeys) {
            commit.put(cdo, key1, key2, pos.get(key1, key2));
        }
    }

    void rollback() {
        this.edits.decommit();
    }

    @Override
    public Formula getFormula(CDOMObject cdo, FormulaKey fk) {
        return this.getCommitStrategy().getFormula(cdo, fk);
    }

    @Override
    public Integer getInteger(CDOMObject cdo, IntegerKey ik) {
        return this.getCommitStrategy().getInteger(cdo, ik);
    }

    @Override
    public <T> Changes<T> getListChanges(CDOMObject cdo, ListKey<T> lk) {
        return this.getCommitStrategy().getListChanges(cdo, lk);
    }

    @Override
    public <T> Changes<ObjectContainer<T>> getSetChanges(CDOMObject cdo, FactSetKey<T> lk) {
        return this.getCommitStrategy().getSetChanges(cdo, lk);
    }

    @Override
    public <K, V> MapChanges<K, V> getMapChanges(CDOMObject cdo, MapKey<K, V> mk) {
        return this.getCommitStrategy().getMapChanges(cdo, mk);
    }

    @Override
    public <T> T getObject(CDOMObject cdo, ObjectKey<T> ik) {
        return this.getCommitStrategy().getObject(cdo, ik);
    }

    @Override
    public <T> Indirect<T> getFact(CDOMObject cdo, FactKey<T> ik) {
        return this.getCommitStrategy().getFact(cdo, ik);
    }

    @Override
    public String getString(CDOMObject cdo, StringKey sk) {
        return this.getCommitStrategy().getString(cdo, sk);
    }

    @Override
    public Formula getVariable(CDOMObject obj, VariableKey key) {
        return this.getCommitStrategy().getVariable(obj, key);
    }

    @Override
    public Set<VariableKey> getVariableKeys(CDOMObject obj) {
        return this.getCommitStrategy().getVariableKeys(obj);
    }

    <T extends CDOMObject> T cloneConstructedCDOMObject(T obj, String newName) {
        return this.edits.cloneConstructedCDOMObject(obj, newName);
    }

    @Override
    public Changes<Prerequisite> getPrerequisiteChanges(ConcretePrereqObject obj) {
        return this.getCommitStrategy().getPrerequisiteChanges(obj);
    }

    @Override
    public boolean containsListFor(CDOMObject obj, ListKey<?> lk) {
        return this.getCommitStrategy().containsListFor(obj, lk);
    }

    @Override
    public boolean containsSetFor(CDOMObject obj, FactSetKey<?> lk) {
        return this.getCommitStrategy().containsSetFor(obj, lk);
    }

    @Override
    public <T> void removePatternFromList(CDOMObject cdo, ListKey<T> lk, String pattern) {
        this.edits.removePatternFromList(cdo, lk, pattern);
    }

    @Override
    public <T> PatternChanges<T> getListPatternChanges(CDOMObject cdo, ListKey<T> lk) {
        return this.getCommitStrategy().getListPatternChanges(cdo, lk);
    }

    @Override
    public boolean wasRemoved(CDOMObject cdo, ObjectKey<?> ok) {
        return this.getCommitStrategy().wasRemoved(cdo, ok);
    }

    @Override
    public boolean wasRemoved(CDOMObject cdo, FactKey<?> sk) {
        return this.getCommitStrategy().wasRemoved(cdo, sk);
    }

    @Override
    public boolean wasRemoved(CDOMObject cdo, FactSetKey<?> sk) {
        return this.getCommitStrategy().wasRemoved(cdo, sk);
    }

    @Override
    public boolean wasRemoved(CDOMObject cdo, StringKey sk) {
        return this.getCommitStrategy().wasRemoved(cdo, sk);
    }

    @Override
    public boolean wasRemoved(CDOMObject cdo, IntegerKey ik) {
        return this.getCommitStrategy().wasRemoved(cdo, ik);
    }

    protected abstract ObjectCommitStrategy getCommitStrategy();

    public static class TrackingObjectCommitStrategy
    implements ObjectCommitStrategy {
        private final DoubleKeyMap<URI, ConcretePrereqObject, CDOMObject> positiveMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMap<URI, ConcretePrereqObject, CDOMObject> negativeMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMapToList<URI, CDOMObject, ListKey<?>> globalClearSet = new DoubleKeyMapToList(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMapToList<URI, CDOMObject, FactSetKey<?>> globalClearFactSet = new DoubleKeyMapToList(HashMap.class, IdentityHashMap.class);
        private final HashMapToList<URI, ConcretePrereqObject> preClearSet = new HashMapToList();
        private final TripleKeyMapToList<URI, CDOMObject, ListKey<?>, String> patternClearSet = new TripleKeyMapToList(HashMap.class, IdentityHashMap.class, HashMap.class);
        private URI sourceURI;
        private URI extractURI;

        private CDOMObject getNegative(URI source, CDOMObject cdo) {
            if (cdo == null) {
                throw new IllegalArgumentException("Cannot remove contents from null object");
            }
            CDOMObject negative = (CDOMObject)this.negativeMap.get((Object)source, (Object)cdo);
            if (negative == null) {
                negative = new SimpleCDOMObject();
                this.negativeMap.put((Object)source, (Object)cdo, (Object)negative);
            }
            return negative;
        }

        @Override
        public void clearPrerequisiteList(ConcretePrereqObject cpo) {
            this.preClearSet.addToListFor((Object)this.sourceURI, (Object)cpo);
        }

        @Override
        public void put(ConcretePrereqObject cpo, Prerequisite p) {
            this.getPositive(this.sourceURI, cpo).addPrerequisite(p);
        }

        private CDOMObject getPositive(URI source, ConcretePrereqObject cdo) {
            if (cdo == null) {
                throw new IllegalArgumentException("Cannot assign contents to null object");
            }
            CDOMObject positive = (CDOMObject)this.positiveMap.get((Object)source, (Object)cdo);
            if (positive == null) {
                positive = new SimpleCDOMObject();
                this.positiveMap.put((Object)source, (Object)cdo, (Object)positive);
            }
            return positive;
        }

        @Override
        public void put(CDOMObject cdo, StringKey sk, String s) {
            if (s != null && s.startsWith(".CLEAR")) {
                throw new IllegalArgumentException("Cannot set a value to " + s);
            }
            this.getPositive(this.sourceURI, cdo).put(sk, s);
        }

        @Override
        public void remove(CDOMObject cdo, StringKey sk) {
            this.getNegative(this.sourceURI, cdo).addToListFor(ListKey.REMOVED_STRINGKEY, sk);
        }

        @Override
        public <T> void put(CDOMObject cdo, ObjectKey<T> sk, T s) {
            this.getPositive(this.sourceURI, cdo).put(sk, s);
        }

        @Override
        public void remove(CDOMObject cdo, ObjectKey<?> sk) {
            this.getNegative(this.sourceURI, cdo).addToListFor(ListKey.REMOVED_OBJECTKEY, sk);
        }

        @Override
        public <T> void put(CDOMObject cdo, FactKey<T> sk, Indirect<T> s) {
            this.getPositive(this.sourceURI, cdo).put(sk, s);
        }

        @Override
        public void remove(CDOMObject cdo, FactKey<?> sk) {
            this.getNegative(this.sourceURI, cdo).addToListFor(ListKey.REMOVED_FACTKEY, sk);
        }

        @Override
        public boolean containsSetFor(CDOMObject cdo, FactSetKey<?> key) {
            return cdo.containsSetFor(key);
        }

        @Override
        public <T> void addToSet(CDOMObject cdo, FactSetKey<T> key, ObjectContainer<T> value) {
            this.getPositive(this.sourceURI, cdo).addToSetFor(key, value);
        }

        @Override
        public void removeSet(CDOMObject cdo, FactSetKey<?> lk) {
            this.globalClearFactSet.addToListFor((Object)this.sourceURI, (Object)cdo, lk);
        }

        @Override
        public <T> void removeFromSet(CDOMObject cdo, FactSetKey<T> lk, ObjectContainer<T> val) {
            this.getNegative(this.sourceURI, cdo).addToSetFor(lk, val);
        }

        @Override
        public void put(CDOMObject cdo, IntegerKey ik, Integer i) {
            this.getPositive(this.sourceURI, cdo).put(ik, i);
        }

        @Override
        public void remove(CDOMObject cdo, IntegerKey ik) {
            this.getNegative(this.sourceURI, cdo).addToListFor(ListKey.REMOVED_INTEGERKEY, ik);
        }

        @Override
        public void put(CDOMObject cdo, FormulaKey fk, Formula f) {
            this.getPositive(this.sourceURI, cdo).put(fk, f);
        }

        @Override
        public void put(CDOMObject cdo, VariableKey vk, Formula f) {
            this.getPositive(this.sourceURI, cdo).put(vk, f);
        }

        @Override
        public boolean containsListFor(CDOMObject cdo, ListKey<?> key) {
            return cdo.containsListFor(key);
        }

        @Override
        public <T> void addToList(CDOMObject cdo, ListKey<T> key, T value) {
            this.getPositive(this.sourceURI, cdo).addToListFor(key, value);
        }

        @Override
        public void removeList(CDOMObject cdo, ListKey<?> lk) {
            this.globalClearSet.addToListFor((Object)this.sourceURI, (Object)cdo, lk);
        }

        @Override
        public <T> void removeFromList(CDOMObject cdo, ListKey<T> lk, T val) {
            this.getNegative(this.sourceURI, cdo).addToListFor(lk, val);
        }

        @Override
        public <K, V> void put(CDOMObject cdo, MapKey<K, V> mk, K key, V value) {
            this.getPositive(this.sourceURI, cdo).addToMapFor(mk, key, value);
        }

        @Override
        public <K, V> void remove(CDOMObject cdo, MapKey<K, V> mk, K key) {
            this.getNegative(this.sourceURI, cdo).addToMapFor(mk, key, null);
        }

        @Override
        public <K, V> MapChanges<K, V> getMapChanges(CDOMObject cdo, MapKey<K, V> mk) {
            return new MapChanges<K, V>(this.getPositive(this.extractURI, cdo).getMapFor(mk), this.getNegative(this.extractURI, cdo).getMapFor(mk), false);
        }

        @Override
        public String getString(CDOMObject cdo, StringKey sk) {
            return this.getPositive(this.extractURI, cdo).get(sk);
        }

        @Override
        public Integer getInteger(CDOMObject cdo, IntegerKey ik) {
            return this.getPositive(this.extractURI, cdo).get(ik);
        }

        @Override
        public Formula getFormula(CDOMObject cdo, FormulaKey fk) {
            return this.getPositive(this.extractURI, cdo).get(fk);
        }

        @Override
        public Formula getVariable(CDOMObject cdo, VariableKey key) {
            return this.getPositive(this.extractURI, cdo).get(key);
        }

        @Override
        public Set<VariableKey> getVariableKeys(CDOMObject cdo) {
            return this.getPositive(this.extractURI, cdo).getVariableKeys();
        }

        @Override
        public <T> T getObject(CDOMObject cdo, ObjectKey<T> ik) {
            return this.getPositive(this.extractURI, cdo).get(ik);
        }

        @Override
        public <T> Indirect<T> getFact(CDOMObject cdo, FactKey<T> ik) {
            return this.getPositive(this.extractURI, cdo).get(ik);
        }

        @Override
        public <T> Changes<T> getListChanges(CDOMObject cdo, ListKey<T> lk) {
            return new CollectionChanges<T>(this.getPositive(this.extractURI, cdo).getListFor(lk), this.getNegative(this.extractURI, cdo).getListFor(lk), this.globalClearSet.containsInList((Object)this.extractURI, (Object)cdo, lk));
        }

        @Override
        public <T> Changes<ObjectContainer<T>> getSetChanges(CDOMObject cdo, FactSetKey<T> lk) {
            return new CollectionChanges<ObjectContainer<T>>(this.getPositive(this.extractURI, cdo).getSetFor(lk), this.getNegative(this.extractURI, cdo).getSetFor(lk), this.globalClearFactSet.containsInList((Object)this.extractURI, (Object)cdo, lk));
        }

        @Override
        public <T> PatternChanges<T> getListPatternChanges(CDOMObject cdo, ListKey<T> lk) {
            return new PatternChanges<T>(this.getPositive(this.extractURI, cdo).getListFor(lk), this.patternClearSet.getListFor((Object)this.extractURI, (Object)cdo, lk), this.globalClearSet.containsInList((Object)this.extractURI, (Object)cdo, lk));
        }

        public URI getExtractURI() {
            return this.extractURI;
        }

        @Override
        public void setExtractURI(URI extractURI) {
            this.extractURI = extractURI;
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        @Override
        public void setSourceURI(URI sourceURI) {
            this.sourceURI = sourceURI;
        }

        public void decommit() {
            this.positiveMap.clear();
            this.negativeMap.clear();
            this.globalClearSet.clear();
            this.preClearSet.clear();
            this.patternClearSet.clear();
        }

        public <T extends CDOMObject> T cloneConstructedCDOMObject(T obj, String newName) {
            Class<?> cl = obj.getClass();
            try {
                CDOMObject newObj = (CDOMObject)cl.newInstance();
                newObj.setName(newName);
                return (T)newObj;
            }
            catch (InstantiationException e) {
                Logging.errorPrint("Error instantiating " + cl.getSimpleName(), e);
            }
            catch (IllegalAccessException e) {
                Logging.errorPrint("Error instantiating " + cl.getSimpleName(), e);
            }
            return null;
        }

        @Override
        public Changes<Prerequisite> getPrerequisiteChanges(ConcretePrereqObject obj) {
            return new CollectionChanges<Prerequisite>(this.getPositive(this.extractURI, obj).getPrerequisiteList(), null, this.preClearSet.containsInList((Object)this.extractURI, (Object)obj));
        }

        @Override
        public <T> void removePatternFromList(CDOMObject cdo, ListKey<T> lk, String pattern) {
            this.patternClearSet.addToListFor((Object)this.sourceURI, (Object)cdo, lk, (Object)pattern);
        }

        @Override
        public boolean wasRemoved(CDOMObject cdo, ObjectKey<?> ok) {
            return this.getNegative(this.extractURI, cdo).containsInList(ListKey.REMOVED_OBJECTKEY, ok);
        }

        @Override
        public boolean wasRemoved(CDOMObject cdo, FactKey<?> ok) {
            return this.getNegative(this.extractURI, cdo).containsInList(ListKey.REMOVED_FACTKEY, ok);
        }

        @Override
        public boolean wasRemoved(CDOMObject cdo, FactSetKey<?> ok) {
            return this.getNegative(this.extractURI, cdo).containsInList(ListKey.REMOVED_FACTSETKEY, ok);
        }

        @Override
        public boolean wasRemoved(CDOMObject cdo, StringKey sk) {
            return this.getNegative(this.extractURI, cdo).containsInList(ListKey.REMOVED_STRINGKEY, sk);
        }

        @Override
        public boolean wasRemoved(CDOMObject cdo, IntegerKey ik) {
            return this.getNegative(this.extractURI, cdo).containsInList(ListKey.REMOVED_INTEGERKEY, ik);
        }

        public void purge(CDOMObject cdo) {
            this.positiveMap.remove((Object)this.sourceURI, (Object)cdo);
            this.negativeMap.remove((Object)this.sourceURI, (Object)cdo);
            this.globalClearSet.removeListFor((Object)this.sourceURI, (Object)cdo);
            this.preClearSet.removeFromListFor((Object)this.sourceURI, (Object)cdo);
            this.patternClearSet.removeListsFor((Object)this.sourceURI, (Object)cdo);
        }
    }

    private static class SimpleCDOMObject
    extends CDOMObject {
        private SimpleCDOMObject() {
        }

        @Override
        public boolean isType(String str) {
            return false;
        }
    }
}

