/*
 * Decompiled with CFR 0.152.
 */
package translation.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.time.DateFormatUtils;

public class Tips {
    private static final char QUOTE = '\"';
    private static final String COMMENT_PREFIX = "#";
    private static final String DEFAULT_TIPS_FILENAME = "tips.txt";
    private static final boolean MARK_UNTRANSLATED = true;

    public static void generatePOT(File rootDirectory, String potFilename) {
        Tips.generatePOT(rootDirectory, potFilename, DEFAULT_TIPS_FILENAME);
    }

    public static void generatePOT(File rootDirectory, String potFilename, String filename) {
        HashSet<String> tips = new HashSet<String>();
        if (rootDirectory.isDirectory()) {
            SpecificFilenameFilter filter = new SpecificFilenameFilter(filename);
            File[] subfiles = rootDirectory.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                if (!subfiles[i].isDirectory()) continue;
                File[] tipsFiles = subfiles[i].listFiles(filter);
                for (int j = 0; j < tipsFiles.length; ++j) {
                    Tips.log("Found {0}", tipsFiles[j]);
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(tipsFiles[j]));
                        Tips.addTips(tips, reader);
                        reader.close();
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        Tips.logError("Warning: file found then not found {0}, ignoring this file", tipsFiles[j]);
                        e.printStackTrace();
                        continue;
                    }
                    catch (IOException e) {
                        Tips.logError("Warning: IO error reading {0}, ignoring this file", tipsFiles[j]);
                        e.printStackTrace();
                    }
                }
            }
        }
        Tips.writePOT(tips, potFilename);
        Tips.log("Done", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writePOT(Set<String> tips, String potFilename) {
        block13: {
            File pot = new File(potFilename);
            pot.getParentFile().mkdirs();
            BufferedWriter bw = null;
            bw = new BufferedWriter(new FileWriter(pot));
            Tips.writePOT(tips, bw);
            Tips.log("Wrote {0}", potFilename);
            try {
                if (bw != null) {
                    bw.close();
                }
                break block13;
            }
            catch (IOException e) {
                Tips.logError("IO error while closing {0}", pot);
                e.printStackTrace();
            }
            break block13;
            catch (IOException e) {
                try {
                    Tips.logError("IO error while writing {0}", pot);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e2) {
                        Tips.logError("IO error while closing {0}", pot);
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e3) {
                    Tips.logError("IO error while closing {0}", pot);
                    e3.printStackTrace();
                }
            }
        }
    }

    private static void writePOT(Set<String> tips, BufferedWriter bw) throws IOException {
        Calendar now = Calendar.getInstance();
        bw.write("msgid \"\"\nmsgstr \"\"\n\"Project-Id-Version: PCGen-tips 6.x/SVN?\\n\"\n\"Report-Msgid-Bugs-To: \\n\"\n\"POT-Creation-Date: " + DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(now) + "\\n\"\n" + "\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"\n" + "\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\"\n" + "\"Language-Team: LANGUAGE <LL@li.org>\\n\"\n" + "\"MIME-Version: 1.0\\n\"\n" + "\"Content-Type: text/plain; charset=UTF-8\\n\"\n" + "\"Content-Transfer-Encoding: 8bit\\n\"\n\n");
        MessageFormat msgid = new MessageFormat("msgid \"{0}\"");
        String msgstr = "msgstr \"\"";
        for (String tip : tips) {
            bw.write(msgid.format(new Object[]{Tips.escape(tip)}));
            bw.write("\n");
            bw.write(msgstr);
            bw.write("\n\n");
        }
    }

    protected static void addTips(Set<String> tips, BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (Tips.isTip(line)) {
                    Tips.addTip(tips, line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Tips.logError("Warning: IO error reading a line, ignoring it", new Object[0]);
            e.printStackTrace();
        }
    }

    protected static boolean isTip(String line) {
        return line != null && !line.isEmpty() && !line.startsWith(COMMENT_PREFIX);
    }

    protected static void addTip(Set<String> tips, String tip) {
        tips.add(tip);
    }

    public static void generateTips(File rootDirectory, File translation, String translationName) {
        Tips.generateTips(rootDirectory, translation, translationName, DEFAULT_TIPS_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTips(File rootDirectory, File translation, String translationName, String originalName) {
        int statUntranslated = 0;
        int statTranslated = 0;
        HashMap<String, String> tipsTranslated = new HashMap<String, String>();
        BufferedReader translationReader = null;
        try {
            translationReader = new BufferedReader(new FileReader(translation));
            String line = translationReader.readLine();
            String key = null;
            StringBuilder str = new StringBuilder();
            while (line != null) {
                if (line.startsWith("msgid")) {
                    if (key != null) {
                        tipsTranslated.put(key, str.toString());
                        if (str.toString().isEmpty()) {
                            ++statUntranslated;
                        } else {
                            ++statTranslated;
                        }
                        str = new StringBuilder();
                    }
                    key = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                }
                if (line.startsWith("msgstr") || line.startsWith("\"")) {
                    String substring = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                    substring = Tips.removeEscaped(substring);
                    str.append(substring);
                }
                line = translationReader.readLine();
            }
            if (key != null) {
                tipsTranslated.put(key, str.toString());
                if (str.toString().isEmpty()) {
                    ++statUntranslated;
                } else {
                    ++statTranslated;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (translationReader != null) {
                try {
                    translationReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Tips.log("Translated tips: {0}", statTranslated);
        Tips.log("Untranslated tips: {0}", statUntranslated);
        if (rootDirectory.isDirectory()) {
            SpecificFilenameFilter filter = new SpecificFilenameFilter(originalName);
            File[] subfiles = rootDirectory.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                if (!subfiles[i].isDirectory()) continue;
                File[] tipsFiles = subfiles[i].listFiles(filter);
                for (int j = 0; j < tipsFiles.length; ++j) {
                    File newFile = new File(subfiles[i], translationName);
                    Tips.log("Found {0}, creating {1}", tipsFiles[j], newFile);
                    BufferedWriter bw = null;
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new FileReader(tipsFiles[j]));
                        bw = new BufferedWriter(new FileWriter(newFile));
                        String readLine = reader.readLine();
                        while (readLine != null) {
                            if (Tips.isTip(readLine)) {
                                String translatedLine = (String)tipsTranslated.get(readLine);
                                if (translatedLine == null) {
                                    Tips.log("null translated line in {1}, original {0}", readLine, translation);
                                    translatedLine = readLine;
                                } else if (translatedLine.isEmpty()) {
                                    translatedLine = "<em>Not yet translated</em><br>" + readLine;
                                }
                                bw.write(translatedLine);
                            } else {
                                bw.write(readLine);
                            }
                            bw.write("\n");
                            readLine = reader.readLine();
                        }
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (bw != null) {
                                bw.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Tips.log("Done", new Object[0]);
    }

    protected static String removeEscaped(String string) {
        return string.replaceAll("\\\\'", "'").replaceAll("\\\\\"", "\"").replaceAll("\\\\\\\\", "\\\\");
    }

    protected static String escape(String string) {
        return string.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Tips.logError("Missing argument", new Object[0]);
            Tips.usage();
            return;
        }
        if ("POT".equals(args[0])) {
            if (args.length == 4) {
                Tips.generatePOT(new File(args[1]), args[2], args[3]);
            } else {
                Tips.generatePOT(new File(args[1]), args[2]);
            }
        } else if ("tips".equals(args[0])) {
            if (args.length == 5) {
                Tips.generateTips(new File(args[1]), new File(args[2]), args[3], args[4]);
            } else {
                Tips.generateTips(new File(args[1]), new File(args[2]), args[3]);
            }
        } else {
            Tips.logError("Unknown command", new Object[0]);
            Tips.usage();
        }
    }

    private static void usage() {
        Tips.log("Usage:", new Object[0]);
        Tips.log("\t<command> POT rootDirectory potFilename [tipsFilename]", new Object[0]);
        Tips.log("\t<command> tips rootDirectory translationFilename TranslationFilename(ie. tips_xx.txt) [tipsFilename]", new Object[0]);
        Tips.log("\tIf tipsFilename is missing, the default ({0}) is used.", DEFAULT_TIPS_FILENAME);
    }

    private static void log(String string, Object ... o) {
        System.out.println(MessageFormat.format(string, o));
    }

    private static void logError(String string, Object ... o) {
        System.err.println(MessageFormat.format(string, o));
    }

    static class SpecificFilenameFilter
    implements FilenameFilter {
        private final String filename;

        public SpecificFilenameFilter(String filename) {
            this.filename = filename;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.filename.equals(name);
        }
    }
}

