/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import plugin.overland.model.TravelMethod;
import plugin.overland.model.TravelMethodListener;
import plugin.overland.model.TravelSpeedEvent;
import plugin.overland.util.Localized;

class TravelMethodImplementation
implements TravelMethod {
    private static final String UNKNOWN_WAY_0_PLEASE_FIX_1_XML = "in_plugin_overland_error_noWay";
    private Localized name;
    private Map<String, Map<String, Combo>> multByRoadByTerrains;
    private List<Method> methods;
    private Map<String, Map<Localized, String>> terrainsId;
    private Map<String, Map<Localized, String>> routesId;
    private MethodModel methodModel = new MethodModel();
    private ListByWayModel routesModel;
    private ListByWayModel terrainsModel;
    private PaceModel paceModel = new PaceModel();
    private ChoiceModel choiceModel = new ChoiceModel();
    private Method selectedMethod;
    protected EventListenerList listenerList = new EventListenerList();

    public TravelMethodImplementation(Localized name, Map<String, Map<String, Combo>> multByRoadByTerrains, Map<String, List<Localized>> terrains, Map<String, Map<Localized, String>> terrainsById, Map<String, List<Localized>> routes, Map<String, Map<Localized, String>> routesById, List<Method> methods) {
        this.name = name;
        this.multByRoadByTerrains = multByRoadByTerrains;
        this.terrainsId = terrainsById;
        this.routesId = routesById;
        this.methods = methods;
        this.routesModel = new ListByWayModel(routes);
        this.terrainsModel = new ListByWayModel(terrains);
    }

    @Override
    public ComboBoxModel getRoutesModel() {
        return this.routesModel;
    }

    @Override
    public ComboBoxModel getTerrainsModel() {
        return this.terrainsModel;
    }

    @Override
    public ComboBoxModel getMethodsModel() {
        return this.methodModel;
    }

    @Override
    public ComboBoxModel getPaceModel() {
        return this.paceModel;
    }

    @Override
    public ComboBoxModel getChoiceModel() {
        return this.choiceModel;
    }

    public String toString() {
        return this.name.toString();
    }

    private Number getMult() {
        Combo c = this.getSelectedCombo();
        if (c == null) {
            return null;
        }
        return c.getMult();
    }

    private Combo getSelectedCombo() {
        if (this.terrainsModel.getSelectedItem() == null || this.routesModel.getSelectedItem() == null) {
            return null;
        }
        String way = this.selectedMethod.getWay();
        Map<Localized, String> map = this.terrainsId.get(way);
        if (map == null) {
            Logging.errorPrintLocalised((String)UNKNOWN_WAY_0_PLEASE_FIX_1_XML, (Object[])new Object[]{way, this.name});
            return null;
        }
        String tId = map.get(this.terrainsModel.getSelectedItem());
        if (!this.multByRoadByTerrains.containsKey(tId)) {
            return null;
        }
        String rId = this.routesId.get(this.selectedMethod.getWay()).get(this.routesModel.getSelectedItem());
        if (!this.multByRoadByTerrains.get(tId).containsKey(rId)) {
            return null;
        }
        return this.multByRoadByTerrains.get(tId).get(rId);
    }

    private String getMultString() {
        Combo c = this.getSelectedCombo();
        Number n2 = c.getMult();
        if (n2 == null) {
            return null;
        }
        StringBuilder n = new StringBuilder();
        n.append(LanguageBundle.getPrettyMultiplier((double)n2.doubleValue()));
        if (c.getAddMph().doubleValue() != 0.0) {
            n.append("\n").append(MessageFormat.format(LanguageBundle.getString((String)"in_plusMph"), c.getAddMph()));
        }
        if (c.getAddMph().doubleValue() != 0.0) {
            n.append("\n").append(MessageFormat.format(LanguageBundle.getString((String)"in_plusKmh"), c.getAddKmh()));
        }
        return n.toString();
    }

    @Override
    public String getUnmodifiedImperialSpeedString() {
        return this.formatImperialSpeed(this.getUnmodifiedImperialSpeed());
    }

    @Override
    public String getImperialSpeedString() {
        return this.formatImperialSpeed(this.getImperialSpeed());
    }

    private String formatImperialSpeed(Number imperialSpeed) {
        if (imperialSpeed != null) {
            Pace selectedPace = (Pace)this.paceModel.getSelected();
            if (selectedPace != null) {
                String unit = selectedPace.isUseDays() ? LanguageBundle.getString((String)"in_mpd") : LanguageBundle.getString((String)"in_mph");
                return MessageFormat.format(unit, imperialSpeed);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getUnmodifiedMetricSpeedString() {
        return this.formatMetricSpeed(this.getUnmodifiedMetricSpeed());
    }

    @Override
    public String getMetricSpeedString() {
        return this.formatMetricSpeed(this.getMetricSpeed());
    }

    private String formatMetricSpeed(Number metricSpeed) {
        Pace selectedPace;
        if (metricSpeed != null && (selectedPace = (Pace)this.paceModel.getSelected()) != null) {
            String unit = selectedPace.isUseDays() ? LanguageBundle.getString((String)"in_kmd") : LanguageBundle.getString((String)"in_kmh");
            return MessageFormat.format(unit, metricSpeed);
        }
        return null;
    }

    private Double getUnmodifiedMetricSpeed() {
        Pace selectedPace = (Pace)this.paceModel.getSelected();
        Choice selectedChoice = (Choice)this.choiceModel.getSelected();
        if (selectedPace != null && selectedChoice != null) {
            double speed = selectedPace.getMult().doubleValue() * selectedChoice.getKmh().doubleValue();
            if (selectedPace.isUseDays()) {
                speed *= selectedChoice.getHoursInDay().doubleValue();
            }
            return speed;
        }
        return null;
    }

    private Double getUnmodifiedImperialSpeed() {
        Pace selectedPace = (Pace)this.paceModel.getSelected();
        Choice selectedChoice = (Choice)this.choiceModel.getSelected();
        if (selectedPace != null && selectedChoice != null) {
            double speed = selectedPace.getMult().doubleValue() * selectedChoice.getMph().doubleValue();
            if (selectedPace.isUseDays()) {
                speed *= selectedChoice.getHoursInDay().doubleValue();
            }
            return speed;
        }
        return null;
    }

    private Double getMetricSpeed() {
        Double d = this.getUnmodifiedMetricSpeed();
        Combo c = this.getSelectedCombo();
        if (d != null && c != null) {
            return d * c.getMult().doubleValue() + c.getAddKmh().doubleValue() * this.getHoursInDays();
        }
        return null;
    }

    private Double getImperialSpeed() {
        Double d = this.getUnmodifiedImperialSpeed();
        Combo c = this.getSelectedCombo();
        if (d != null && c != null) {
            return d * c.getMult().doubleValue() + c.getAddMph().doubleValue() * this.getHoursInDays();
        }
        return null;
    }

    private double getHoursInDays() {
        Pace selectedPace = (Pace)this.paceModel.getSelected();
        Choice selectedChoice = (Choice)this.choiceModel.getSelected();
        if (selectedChoice != null && selectedPace != null && selectedPace.isUseDays()) {
            return selectedChoice.getHoursInDay().doubleValue();
        }
        return 1.0;
    }

    private String selectedUseDays() {
        Pace selectedPace = (Pace)this.paceModel.getSelected();
        if (selectedPace == null) {
            return LanguageBundle.getString((String)"in_unitUnknown");
        }
        if (selectedPace.isUseDays()) {
            return LanguageBundle.getString((String)"in_unitDays");
        }
        return LanguageBundle.getString((String)"in_unitHours");
    }

    private String getSelectedComment() {
        Pace selectedPace = (Pace)this.paceModel.getSelected();
        if (selectedPace == null) {
            return "";
        }
        return selectedPace.comment.toString();
    }

    @Override
    public Number convertToMiles(double time) {
        Double d = this.getImperialSpeed();
        if (d != null) {
            return d * time;
        }
        return null;
    }

    @Override
    public Number convertToKm(double time) {
        Double d = this.getMetricSpeed();
        if (d != null) {
            return d * time;
        }
        return null;
    }

    @Override
    public Number convertToTimeFromImperial(double distance) {
        Double d = this.getImperialSpeed();
        if (d != null) {
            return distance / d;
        }
        return null;
    }

    @Override
    public Number convertToTimeFromMetric(double distance) {
        Double d = this.getMetricSpeed();
        if (d != null) {
            return distance / d;
        }
        return null;
    }

    @Override
    public void addTravelMethodListener(TravelMethodListener l) {
        this.listenerList.add(TravelMethodListener.class, l);
    }

    @Override
    public void removeTravelMethodListener(TravelMethodListener l) {
        this.listenerList.remove(TravelMethodListener.class, l);
    }

    public TravelMethodListener[] getMultListeners() {
        return (TravelMethodListener[])this.listenerList.getListeners(TravelMethodListener.class);
    }

    protected void fireMultChanged(Object source) {
        if (this.terrainsModel.getSelectedItem() == null || this.routesModel.getSelectedItem() == null) {
            return;
        }
        String n2 = this.getMultString();
        if (n2 == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        TravelSpeedEvent e = null;
        boolean hasUnmod = this.getUnmodifiedMetricSpeedString() != null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TravelMethodListener.class) continue;
            if (e == null) {
                e = new TravelSpeedEvent(source, n2);
            }
            ((TravelMethodListener)listeners[i + 1]).multUpdated(e);
            if (!hasUnmod) continue;
            ((TravelMethodListener)listeners[i + 1]).speedUpdated(e);
        }
    }

    protected void fireUnmodifiableSpeedChanged(Object source) {
        if (this.paceModel.getSelectedItem() == null || this.choiceModel.getSelectedItem() == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        EventObject e = null;
        boolean hasMult = this.getMult() != null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TravelMethodListener.class) continue;
            if (e == null) {
                e = new EventObject(source);
            }
            ((TravelMethodListener)listeners[i + 1]).unmodifiedSpeedUpdated(e);
            if (!hasMult) continue;
            ((TravelMethodListener)listeners[i + 1]).speedUpdated(e);
        }
    }

    protected void fireCommentDaysChanged(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        TravelSpeedEvent e = null;
        TravelSpeedEvent e2 = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TravelMethodListener.class) continue;
            if (e == null || e2 == null) {
                e = new TravelSpeedEvent(source, this.getSelectedComment());
                e2 = new TravelSpeedEvent(source, this.selectedUseDays());
            }
            ((TravelMethodListener)listeners[i + 1]).commentChanged(e);
            ((TravelMethodListener)listeners[i + 1]).useDaysChanged(e2);
        }
    }

    protected void fireAllChanged(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        TravelSpeedEvent eComment = null;
        TravelSpeedEvent eDays = null;
        TravelSpeedEvent eMult = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TravelMethodListener.class) continue;
            if (eComment == null || eDays == null || eMult == null) {
                eComment = new TravelSpeedEvent(source, this.getSelectedComment());
                eDays = new TravelSpeedEvent(source, this.selectedUseDays());
                eMult = new TravelSpeedEvent(source, this.getMultString());
            }
            ((TravelMethodListener)listeners[i + 1]).commentChanged(eComment);
            ((TravelMethodListener)listeners[i + 1]).useDaysChanged(eDays);
            ((TravelMethodListener)listeners[i + 1]).unmodifiedSpeedUpdated(eComment);
            ((TravelMethodListener)listeners[i + 1]).speedUpdated(eComment);
            ((TravelMethodListener)listeners[i + 1]).multUpdated(eMult);
        }
    }

    class ChoiceModel
    extends TModel<Choice> {
        private static final long serialVersionUID = 3502580215371087556L;

        ChoiceModel() {
        }

        @Override
        List<Choice> getList(Method m) {
            return m.choices;
        }
    }

    class PaceModel
    extends TModel<Pace> {
        private static final long serialVersionUID = 8980884569594225313L;

        PaceModel() {
        }

        @Override
        List<Pace> getList(Method m) {
            return m.paces;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            super.setSelectedItem(anItem);
            TravelMethodImplementation.this.fireCommentDaysChanged(this);
        }
    }

    protected abstract class TModel<T>
    extends AbstractListModel
    implements ComboBoxModel {
        private T selected;

        protected TModel() {
        }

        @Override
        public int getSize() {
            if (TravelMethodImplementation.this.selectedMethod == null) {
                return 0;
            }
            return this.getList(TravelMethodImplementation.this.selectedMethod).size();
        }

        abstract List<T> getList(Method var1);

        @Override
        public Object getElementAt(int index) {
            if (TravelMethodImplementation.this.selectedMethod == null || index < 0 || this.getList(TravelMethodImplementation.this.selectedMethod).size() <= index) {
                return null;
            }
            return this.getList(TravelMethodImplementation.this.selectedMethod).get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int indexOf = this.getList(TravelMethodImplementation.this.selectedMethod).indexOf(anItem);
            if (indexOf >= 0) {
                this.selected = this.getList(TravelMethodImplementation.this.selectedMethod).get(indexOf);
                TravelMethodImplementation.this.fireUnmodifiableSpeedChanged(this);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        protected void fireMethodChanged(MethodModel source, Method previousMethod) {
            int start = 0;
            int end = this.getSize();
            if (previousMethod != null) {
                int previousSize;
                List<T> previousList = this.getList(previousMethod);
                List<T> selectedList = this.getList(TravelMethodImplementation.this.selectedMethod);
                int previousIndex = previousList.indexOf(this.selected);
                if (TravelMethodImplementation.this.selectedMethod != null) {
                    this.selected = previousIndex < end && previousIndex >= 0 ? selectedList.get(previousIndex) : selectedList.get(0);
                }
                if (end > (previousSize = previousList.size())) {
                    this.fireIntervalAdded(source, previousSize, end);
                }
                if (end < previousSize) {
                    this.fireIntervalRemoved(source, end, previousSize);
                }
                end = Math.min(end, previousSize);
                int i = 0;
                while (i < end && previousList.get(i).equals(selectedList.get(i))) {
                    ++i;
                    ++start;
                }
                i = end - 1;
                while (i > start && previousList.get(i).equals(selectedList.get(i))) {
                    --i;
                    --end;
                }
                if (start != end) {
                    this.fireContentsChanged(source, start, end - 1);
                } else if (previousIndex >= this.getSize()) {
                    this.fireContentsChanged(source, -1, -1);
                }
            } else {
                this.fireIntervalAdded(source, 0, end);
            }
        }

        T getSelected() {
            return this.selected;
        }
    }

    class ListByWayModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -5596276376727073581L;
        private Map<String, List<Localized>> listByWay;
        private Localized selected;

        public ListByWayModel(Map<String, List<Localized>> list) {
            this.listByWay = list;
        }

        private int getSize(Method m) {
            if (m == null || !this.listByWay.containsKey(m.getWay())) {
                return 0;
            }
            return this.listByWay.get(m.getWay()).size();
        }

        @Override
        public int getSize() {
            return this.getSize(TravelMethodImplementation.this.selectedMethod);
        }

        @Override
        public Object getElementAt(int index) {
            if (TravelMethodImplementation.this.selectedMethod == null || !this.listByWay.containsKey(TravelMethodImplementation.this.selectedMethod.getWay())) {
                return null;
            }
            return this.listByWay.get(TravelMethodImplementation.this.selectedMethod.getWay()).get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int indexOf = this.listByWay.get(TravelMethodImplementation.this.selectedMethod.getWay()).indexOf(anItem);
            if (indexOf >= 0) {
                this.selected = this.listByWay.get(TravelMethodImplementation.this.selectedMethod.getWay()).get(indexOf);
                TravelMethodImplementation.this.fireMultChanged(this);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        private void fireMethodChanged(MethodModel source, Method previousMethod) {
            int start = 0;
            int end = this.getSize();
            if (previousMethod != null) {
                int previousSize;
                String selectedWay;
                String previousWay = previousMethod.getWay();
                if (previousWay.equals(selectedWay = TravelMethodImplementation.this.selectedMethod.getWay())) {
                    return;
                }
                List<Localized> previousList = this.listByWay.get(previousWay);
                int previousIndex = previousList.indexOf(this.selected);
                List<Localized> selectedList = this.listByWay.get(selectedWay);
                if (selectedList == null) {
                    Logging.errorPrintLocalised((String)TravelMethodImplementation.UNKNOWN_WAY_0_PLEASE_FIX_1_XML, (Object[])new Object[]{selectedWay, TravelMethodImplementation.this.name});
                    return;
                }
                if (TravelMethodImplementation.this.selectedMethod != null) {
                    this.selected = previousIndex < end && previousIndex >= 0 ? selectedList.get(previousIndex) : selectedList.get(0);
                }
                if (end > (previousSize = this.getSize(previousMethod))) {
                    this.fireIntervalAdded(source, previousSize, end - 1);
                }
                if (end < previousSize) {
                    this.fireIntervalRemoved(source, end, previousSize - 1);
                }
                end = Math.min(end, previousSize);
                int i = 0;
                while (i < end && previousList.get(i).equals(selectedList.get(i))) {
                    ++i;
                    ++start;
                }
                i = end - 1;
                while (i > start && previousList.get(i).equals(selectedList.get(i))) {
                    --i;
                    --end;
                }
                if (start != end) {
                    this.fireContentsChanged(source, start, end - 1);
                } else if (previousIndex >= this.getSize()) {
                    this.fireContentsChanged(source, -1, -1);
                }
            } else {
                this.fireIntervalAdded(source, 0, end - 1);
            }
        }
    }

    class MethodModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 2804199879316856684L;

        MethodModel() {
        }

        @Override
        public int getSize() {
            return TravelMethodImplementation.this.methods.size();
        }

        @Override
        public Object getElementAt(int index) {
            return TravelMethodImplementation.this.methods.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            Method previousMethod = TravelMethodImplementation.this.selectedMethod;
            int indexOf = TravelMethodImplementation.this.methods.indexOf(anItem);
            if (indexOf >= 0) {
                TravelMethodImplementation.this.selectedMethod = (Method)TravelMethodImplementation.this.methods.get(indexOf);
                this.fireContentsChanged(this, -1, -1);
                TravelMethodImplementation.this.paceModel.fireMethodChanged(this, previousMethod);
                TravelMethodImplementation.this.choiceModel.fireMethodChanged(this, previousMethod);
                TravelMethodImplementation.this.terrainsModel.fireMethodChanged(this, previousMethod);
                TravelMethodImplementation.this.routesModel.fireMethodChanged(this, previousMethod);
                TravelMethodImplementation.this.fireAllChanged(this);
            }
        }

        @Override
        public Object getSelectedItem() {
            return TravelMethodImplementation.this.selectedMethod;
        }
    }

    static class Combo {
        private final Number mult;
        private final Number addMph;
        private final Number addKmh;

        public Combo(Number mult, Number addMph, Number addKmh) {
            this.mult = mult;
            this.addMph = addMph;
            this.addKmh = addKmh;
        }

        public Number getMult() {
            return this.mult;
        }

        public Number getAddMph() {
            return this.addMph;
        }

        public Number getAddKmh() {
            return this.addKmh;
        }
    }

    static class Named {
        private Localized name;

        public Named(Localized name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }
    }

    static class Choice
    extends Named {
        private Number hoursInDay;
        private Number kmh;
        private Number mph;

        public Choice(Localized name, Number hoursInDay, double kmh, double mph) {
            super(name);
            this.hoursInDay = hoursInDay;
            this.kmh = kmh;
            this.mph = mph;
        }

        public Number getHoursInDay() {
            return this.hoursInDay;
        }

        public Number getKmh() {
            return this.kmh;
        }

        public Number getMph() {
            return this.mph;
        }
    }

    public static class Pace
    extends Named {
        private boolean useDays = false;
        private Number mult = 1;
        private Localized comment;

        public Pace(Localized name2, Localized comment2, boolean useDays2, Number mult2) {
            super(name2);
            this.comment = comment2;
            this.useDays = useDays2;
            this.mult = mult2;
        }

        public boolean isUseDays() {
            return this.useDays;
        }

        public Number getMult() {
            return this.mult;
        }

        public Localized getComment() {
            return this.comment;
        }
    }

    static class Method
    extends Named {
        private List<Pace> paces;
        private List<Choice> choices;
        private String way;

        public Method(Localized name, String way) {
            super(name);
            this.way = way;
            this.paces = new ArrayList<Pace>();
            this.choices = new ArrayList<Choice>();
        }

        public void add(Choice c) {
            this.choices.add(c);
        }

        public void add(Pace newPace) {
            this.paces.add(newPace);
        }

        public String getWay() {
            return this.way;
        }
    }
}

