/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ImagePreview;
import gmgen.gui.PreferencesPanel;
import gmgen.io.SimpleFileFilter;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.CombatHasBeenInitiatedMessage;
import gmgen.pluginmgr.messages.FileMenuOpenMessage;
import gmgen.pluginmgr.messages.FileMenuSaveMessage;
import gmgen.pluginmgr.messages.GMGenBeingClosedMessage;
import gmgen.pluginmgr.messages.RequestAddPreferencesPanelMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import gmgen.util.LogUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.io.PCGFile;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.PlayerCharacterWasClosedMessage;
import pcgen.pluginmgr.messages.PlayerCharacterWasLoadedMessage;
import pcgen.pluginmgr.messages.RequestOpenPlayerCharacterMessage;
import pcgen.pluginmgr.messages.RequestToSavePlayerCharacterMessage;
import pcgen.pluginmgr.messages.TransmitInitiativeValuesBetweenComponentsMessage;
import pcgen.system.PCGenSettings;
import plugin.initiative.gui.Initiative;
import plugin.initiative.gui.PreferencesDamagePanel;
import plugin.initiative.gui.PreferencesInitiativePanel;
import plugin.initiative.gui.PreferencesMassiveDamagePanel;
import plugin.initiative.gui.PreferencesPerformancePanel;

public class InitiativePlugin
implements InteractivePlugin {
    public static final String LOG_NAME = "Initiative";
    private Initiative theView;
    private JMenuItem initToolsItem = new JMenuItem();
    private String name = "Initiative";
    private String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public FileFilter[] getFileTypes() {
        FileFilter[] ff = new FileFilter[]{this.getFileType()};
        return ff;
    }

    public FileFilter getFileType() {
        String[] init = new String[]{"gmi", "init"};
        return new SimpleFileFilter(init, "Initiative Export");
    }

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.theView = new Initiative();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.name, (PreferencesPanel)new PreferencesDamagePanel()));
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.name, (PreferencesPanel)new PreferencesMassiveDamagePanel()));
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.name, (PreferencesPanel)new PreferencesInitiativePanel()));
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.name, (PreferencesPanel)new PreferencesPerformancePanel()));
        this.theView.setLog(LogUtilities.inst());
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.name, this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)"Initiative.LoadOrder", (int)40);
    }

    public String getPluginName() {
        return this.name;
    }

    public Component getView() {
        return this.theView;
    }

    public void fileOpen() {
        JFileChooser chooser = ImagePreview.decorateWithImagePreview((JFileChooser)new JFileChooser());
        File defaultFile = new File(PCGenSettings.getPcgDir());
        if (defaultFile.exists()) {
            chooser.setCurrentDirectory(defaultFile);
        }
        String[] pcgs = new String[]{"pcg", "pcp"};
        String[] init = new String[]{"gmi", "init"};
        SimpleFileFilter ff = new SimpleFileFilter(init, "Initiative Export");
        chooser.addChoosableFileFilter((FileFilter)ff);
        chooser.addChoosableFileFilter((FileFilter)new SimpleFileFilter(pcgs, "PCGen File"));
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter((FileFilter)ff);
        chooser.setMultiSelectionEnabled(true);
        Cursor originalCursor = this.theView.getCursor();
        this.theView.setCursor(Cursor.getPredefinedCursor(3));
        int option = chooser.showOpenDialog(this.theView);
        if (option == 0) {
            File[] pcFiles = chooser.getSelectedFiles();
            for (int i = 0; i < pcFiles.length; ++i) {
                if (PCGFile.isPCGenCharacterOrPartyFile((File)pcFiles[i])) {
                    this.messageHandler.handleMessage((PCGenMessage)new RequestOpenPlayerCharacterMessage((Object)this, pcFiles[i], false));
                    continue;
                }
                if (!pcFiles[i].toString().endsWith(".init") && !pcFiles[i].toString().endsWith(".gmi")) continue;
                this.loadINIT(pcFiles[i]);
            }
            this.theView.refreshTable();
        }
        this.theView.setCursor(originalCursor);
    }

    public void handleCombatRequestMessage(CombatHasBeenInitiatedMessage message) {
        message.setCombat(this.theView.initList);
    }

    public void handleFileOpenMessage(FileMenuOpenMessage message) {
        if (GMGenSystemView.getTabPane().getSelectedComponent() instanceof Initiative) {
            this.fileOpen();
        }
    }

    public void handleInitHolderListSendMessage(TransmitInitiativeValuesBetweenComponentsMessage message) {
        if (message.getSource() != this) {
            InitHolderList cl = message.getInitHolderList();
            for (int i = 0; i < cl.size(); ++i) {
                InitHolder iH = (InitHolder)cl.get(i);
                this.theView.addInitHolder(iH);
            }
            this.theView.refreshTable();
        }
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof FileMenuOpenMessage) {
            this.handleFileOpenMessage((FileMenuOpenMessage)message);
        } else if (message instanceof FileMenuSaveMessage) {
            this.handleSaveMessage((FileMenuSaveMessage)message);
        } else if (message instanceof TransmitInitiativeValuesBetweenComponentsMessage) {
            this.handleInitHolderListSendMessage((TransmitInitiativeValuesBetweenComponentsMessage)message);
        } else if (message instanceof PlayerCharacterWasLoadedMessage) {
            this.handlePCLoadedMessage((PlayerCharacterWasLoadedMessage)message);
        } else if (message instanceof PlayerCharacterWasClosedMessage) {
            this.handlePCClosedMessage((PlayerCharacterWasClosedMessage)message);
        } else if (message instanceof GMGenBeingClosedMessage) {
            this.handleWindowClosedMessage((GMGenBeingClosedMessage)message);
        } else if (message instanceof FocusOrStateChangeOccurredMessage) {
            this.handleStateChangedMessage((FocusOrStateChangeOccurredMessage)message);
        } else if (message instanceof CombatHasBeenInitiatedMessage) {
            this.handleCombatRequestMessage((CombatHasBeenInitiatedMessage)message);
        }
    }

    public void handlePCClosedMessage(PlayerCharacterWasClosedMessage message) {
        this.theView.removePcgCombatant(message.getPC());
        this.theView.refreshTable();
    }

    public void handlePCLoadedMessage(PlayerCharacterWasLoadedMessage message) {
        PlayerCharacter pc = message.getPc();
        String type = "PC";
        String player = pc.getDisplay().getPlayersName();
        if (player.equalsIgnoreCase("Ally")) {
            type = "Ally";
        } else if (player.equalsIgnoreCase("GM") || player.equalsIgnoreCase("DM") || player.equalsIgnoreCase("Enemy")) {
            type = "Enemy";
        } else if (player.equals("-")) {
            type = "-";
        }
        this.theView.addPcgCombatant(pc, type);
        this.theView.refreshTable();
    }

    public void fileSave() {
        for (int i = 0; i < this.theView.initList.size(); ++i) {
            InitHolder iH = (InitHolder)this.theView.initList.get(i);
            if (!(iH instanceof PcgCombatant)) continue;
            PcgCombatant pcgcbt = (PcgCombatant)iH;
            this.messageHandler.handleMessage((PCGenMessage)new RequestToSavePlayerCharacterMessage((Object)this, pcgcbt.getPC()));
        }
        this.theView.saveToFile();
    }

    public void handleSaveMessage(FileMenuSaveMessage message) {
        if (this.isActive()) {
            this.fileSave();
            message.consume();
        }
    }

    public void handleStateChangedMessage(FocusOrStateChangeOccurredMessage message) {
        if (this.isActive()) {
            this.initToolsItem.setEnabled(false);
            if (GMGenSystem.inst != null) {
                GMGenSystem.inst.openFileItem.setEnabled(true);
                GMGenSystem.inst.saveFileItem.setEnabled(true);
            }
            this.theView.refreshTable();
            if (SettingsHandler.getGMGenOption((String)"Initiative.refreshOnStateChange", (boolean)true)) {
                this.theView.refreshTabs();
            }
        } else {
            this.initToolsItem.setEnabled(true);
        }
    }

    public void handleWindowClosedMessage(GMGenBeingClosedMessage message) {
        this.theView.setExitPrefs();
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    public void initMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof Initiative)) continue;
            tp.setSelectedIndex(i);
        }
    }

    public void initMenus() {
        this.initToolsItem.setMnemonic('I');
        this.initToolsItem.setText(LOG_NAME);
        this.initToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InitiativePlugin.this.initMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.initToolsItem));
    }

    public void loadINIT(File initFile) {
        this.theView.loadINIT(initFile, (PCGenMessageHandler)this);
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

