/*
;   Copyright (C) 2011, Alain Gibaud   alain.gibaud@free.fr
;
;   This file is part of the CPIK library
;   ------------------------------------------------------- 
;   This library is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by the
;   Free Software Foundation; either version 2.1, or (at your option) any
;   later version.
 
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
 
;  You should have received a copy of the GNU General Public License 
;   along with this library; see the file COPYING. If not, write to the
;   Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
;   MA 02110-1301, USA.
 
;   As a special exception, if you link this library with other files,
;   some of which are compiled with CPIK, to produce an executable,
;   this library does not by itself cause the resulting executable to
;   be covered by the GNU General Public License. This exception does
;   not however invalidate any other reasons why the executable file
;   might be covered by the GNU General Public License.

*/
#ifndef PINS_H
#define PINS_H

#include <macros.h>

#define PORTA0_PORT PORTA
#define PORTA1_PORT PORTA
#define PORTA2_PORT PORTA
#define PORTA3_PORT PORTA
#define PORTA4_PORT PORTA
#define PORTA5_PORT PORTA
#define PORTA6_PORT PORTA
#define PORTA7_PORT PORTA

#define PORTA0_TRIS TRISA
#define PORTA1_TRIS TRISA
#define PORTA2_TRIS TRISA
#define PORTA3_TRIS TRISA
#define PORTA4_TRIS TRISA
#define PORTA5_TRIS TRISA
#define PORTA6_TRIS TRISA
#define PORTA7_TRIS TRISA

#define PORTA0_BIT  0
#define PORTA1_BIT  1
#define PORTA2_BIT  2
#define PORTA3_BIT  3
#define PORTA4_BIT  4
#define PORTA5_BIT  5
#define PORTA6_BIT  6
#define PORTA7_BIT  7



#define PORTB0_PORT PORTB
#define PORTB1_PORT PORTB
#define PORTB2_PORT PORTB
#define PORTB3_PORT PORTB
#define PORTB4_PORT PORTB
#define PORTB5_PORT PORTB
#define PORTB6_PORT PORTB
#define PORTB7_PORT PORTB

#define PORTB0_TRIS TRISB
#define PORTB1_TRIS TRISB
#define PORTB2_TRIS TRISB
#define PORTB3_TRIS TRISB
#define PORTB4_TRIS TRISB
#define PORTB5_TRIS TRISB
#define PORTB6_TRIS TRISB
#define PORTB7_TRIS TRISB

#define PORTB0_BIT  0
#define PORTB1_BIT  1
#define PORTB2_BIT  2
#define PORTB3_BIT  3
#define PORTB4_BIT  4
#define PORTB5_BIT  5
#define PORTB6_BIT  6
#define PORTB7_BIT  7



#define PORTC0_PORT PORTC
#define PORTC1_PORT PORTC
#define PORTC2_PORT PORTC
#define PORTC3_PORT PORTC
#define PORTC4_PORT PORTC
#define PORTC5_PORT PORTC
#define PORTC6_PORT PORTC
#define PORTC7_PORT PORTC

#define PORTC0_TRIS TRISC
#define PORTC1_TRIS TRISC
#define PORTC2_TRIS TRISC
#define PORTC3_TRIS TRISC
#define PORTC4_TRIS TRISC
#define PORTC5_TRIS TRISC
#define PORTC6_TRIS TRISC
#define PORTC7_TRIS TRISC

#define PORTC0_BIT  0
#define PORTC1_BIT  1
#define PORTC2_BIT  2
#define PORTC3_BIT  3
#define PORTC4_BIT  4
#define PORTC5_BIT  5
#define PORTC6_BIT  6
#define PORTC7_BIT  7



#define PORTD0_PORT PORTD
#define PORTD1_PORT PORTD
#define PORTD2_PORT PORTD
#define PORTD3_PORT PORTD
#define PORTD4_PORT PORTD
#define PORTD5_PORT PORTD
#define PORTD6_PORT PORTD
#define PORTD7_PORT PORTD

#define PORTD0_TRIS TRISD
#define PORTD1_TRIS TRISD
#define PORTD2_TRIS TRISD
#define PORTD3_TRIS TRISD
#define PORTD4_TRIS TRISD
#define PORTD5_TRIS TRISD
#define PORTD6_TRIS TRISD
#define PORTD7_TRIS TRISD

#define PORTD0_BIT  0
#define PORTD1_BIT  1
#define PORTD2_BIT  2
#define PORTD3_BIT  3
#define PORTD4_BIT  4
#define PORTD5_BIT  5
#define PORTD6_BIT  6
#define PORTD7_BIT  7



#define PORTE0_PORT PORTE
#define PORTE1_PORT PORTE
#define PORTE2_PORT PORTE
#define PORTE3_PORT PORTE
#define PORTE4_PORT PORTE
#define PORTE5_PORT PORTE
#define PORTE6_PORT PORTE
#define PORTE7_PORT PORTE

#define PORTE0_TRIS TRISE
#define PORTE1_TRIS TRISE
#define PORTE2_TRIS TRISE
#define PORTE3_TRIS TRISE
#define PORTE4_TRIS TRISE
#define PORTE5_TRIS TRISE
#define PORTE6_TRIS TRISE
#define PORTE7_TRIS TRISE

#define PORTE0_BIT  0
#define PORTE1_BIT  1
#define PORTE2_BIT  2
#define PORTE3_BIT  3
#define PORTE4_BIT  4
#define PORTE5_BIT  5
#define PORTE6_BIT  6
#define PORTE7_BIT  7



#define PORTF0_PORT PORTF
#define PORTF1_PORT PORTF
#define PORTF2_PORT PORTF
#define PORTF3_PORT PORTF
#define PORTF4_PORT PORTF
#define PORTF5_PORT PORTF
#define PORTF6_PORT PORTF
#define PORTF7_PORT PORTF

#define PORTF0_TRIS TRISF
#define PORTF1_TRIS TRISF
#define PORTF2_TRIS TRISF
#define PORTF3_TRIS TRISF
#define PORTF4_TRIS TRISF
#define PORTF5_TRIS TRISF
#define PORTF6_TRIS TRISF
#define PORTF7_TRIS TRISF

#define PORTF0_BIT  0
#define PORTF1_BIT  1
#define PORTF2_BIT  2
#define PORTF3_BIT  3
#define PORTF4_BIT  4
#define PORTF5_BIT  5
#define PORTF6_BIT  6
#define PORTF7_BIT  7



#define PORTG0_PORT PORTG
#define PORTG1_PORT PORTG
#define PORTG2_PORT PORTG
#define PORTG3_PORT PORTG
#define PORTG4_PORT PORTG
#define PORTG5_PORT PORTG
#define PORTG6_PORT PORTG
#define PORTG7_PORT PORTG

#define PORTG0_TRIS TRISG
#define PORTG1_TRIS TRISG
#define PORTG2_TRIS TRISG
#define PORTG3_TRIS TRISG
#define PORTG4_TRIS TRISG
#define PORTG5_TRIS TRISG
#define PORTG6_TRIS TRISG
#define PORTG7_TRIS TRISG

#define PORTG0_BIT  0
#define PORTG1_BIT  1
#define PORTG2_BIT  2
#define PORTG3_BIT  3
#define PORTG4_BIT  4
#define PORTG5_BIT  5
#define PORTG6_BIT  6
#define PORTG7_BIT  7



#define PORTH0_PORT PORTH
#define PORTH1_PORT PORTH
#define PORTH2_PORT PORTH
#define PORTH3_PORT PORTH
#define PORTH4_PORT PORTH
#define PORTH5_PORT PORTH
#define PORTH6_PORT PORTH
#define PORTH7_PORT PORTH

#define PORTH0_TRIS TRISH
#define PORTH1_TRIS TRISH
#define PORTH2_TRIS TRISH
#define PORTH3_TRIS TRISH
#define PORTH4_TRIS TRISH
#define PORTH5_TRIS TRISH
#define PORTH6_TRIS TRISH
#define PORTH7_TRIS TRISH

#define PORTH0_BIT  0
#define PORTH1_BIT  1
#define PORTH2_BIT  2
#define PORTH3_BIT  3
#define PORTH4_BIT  4
#define PORTH5_BIT  5
#define PORTH6_BIT  6
#define PORTH7_BIT  7



#define PORTJ0_PORT PORTJ
#define PORTJ1_PORT PORTJ
#define PORTJ2_PORT PORTJ
#define PORTJ3_PORT PORTJ
#define PORTJ4_PORT PORTJ
#define PORTJ5_PORT PORTJ
#define PORTJ6_PORT PORTJ
#define PORTJ7_PORT PORTJ

#define PORTJ0_TRIS TRISJ
#define PORTJ1_TRIS TRISJ
#define PORTJ2_TRIS TRISJ
#define PORTJ3_TRIS TRISJ
#define PORTJ4_TRIS TRISJ
#define PORTJ5_TRIS TRISJ
#define PORTJ6_TRIS TRISJ
#define PORTJ7_TRIS TRISJ

#define PORTJ0_BIT  0
#define PORTJ1_BIT  1
#define PORTJ2_BIT  2
#define PORTJ3_BIT  3
#define PORTJ4_BIT  4
#define PORTJ5_BIT  5
#define PORTJ6_BIT  6
#define PORTJ7_BIT  7



#include <macros.h>

#define _PSET(NAME)    BIT_1(NAME ## _PORT, NAME ## _BIT)
#define _PCLR(NAME)    BIT_0(NAME ## _PORT, NAME ## _BIT)
#define _PTOGGLE(NAME) BIT_TOGGLE(NAME ## _PORT, NAME ## _BIT) 
#define _PREAD(NAME)   BIT_TST(NAME ## _PORT, NAME ## _BIT)

#define _PWRITE(NAME, VALUE) do { if (VALUE) _PSET(NAME); else _PCLR(NAME); } while (0)

#define _PSETOUT(NAME) BIT_0(NAME ## _TRIS, NAME ## _BIT)
#define _PSETIN(NAME)  BIT_1(NAME ## _TRIS, NAME ## _BIT)

// the preprocessor must first resolve symbolic name to i.e. PORTA0 
// and only after concatenate it with _PORT and _BIT
#define PIN_SET(NAME)           _PSET(NAME)
#define PIN_1(NAME)             _PSET(NAME)
#define PIN_CLR(NAME)           _PCLR(NAME)
#define PIN_0(NAME)             _PCLR(NAME)
#define PIN_TOGGLE(NAME)        _PTOGGLE(NAME)
#define PIN_READ(NAME)          _PREAD(NAME)
#define PIN_TST(NAME)           _PREAD(NAME)
#define PIN_WRITE(NAME, VALUE)  _PWRITE(NAME, VALUE)
#define PIN_SET_OUTPUT0(NAME)   do { _PCLR(NAME);  _PSETOUT(NAME); } while (0)
#define PIN_SET_OUTPUT1(NAME)   do { _PSET(NAME);  _PSETOUT(NAME); } while (0)
#define PIN_SET_OUTPUT(NAME)    _PSETOUT(NAME)
#define PIN_SET_INPUT(NAME)     _PSETIN(NAME)
                         

#endif //PINS_H
