// Copyright 2023-2025 The Inspektor Gadget authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package syscalls

// This file is automatically generated from:
//     https://raw.githubusercontent.com/seccomp/libseccomp/refs/heads/main/src/syscalls.csv
//
// To update it, run:
//     make -C tools/syscalls-update
//
// Linux version: v6.13.0 2025-01-23

var syscallsNameToNumber = map[string]int{
	"_sysctl":                 156,
	"accept":                  43,
	"accept4":                 288,
	"access":                  21,
	"acct":                    163,
	"add_key":                 248,
	"adjtimex":                159,
	"afs_syscall":             183,
	"alarm":                   37,
	"arch_prctl":              158,
	"bind":                    49,
	"bpf":                     321,
	"brk":                     12,
	"cachestat":               451,
	"capget":                  125,
	"capset":                  126,
	"chdir":                   80,
	"chmod":                   90,
	"chown":                   92,
	"chroot":                  161,
	"clock_adjtime":           305,
	"clock_getres":            229,
	"clock_gettime":           228,
	"clock_nanosleep":         230,
	"clock_settime":           227,
	"clone":                   56,
	"clone3":                  435,
	"close":                   3,
	"close_range":             436,
	"connect":                 42,
	"copy_file_range":         326,
	"creat":                   85,
	"create_module":           174,
	"delete_module":           176,
	"dup":                     32,
	"dup2":                    33,
	"dup3":                    292,
	"epoll_create":            213,
	"epoll_create1":           291,
	"epoll_ctl":               233,
	"epoll_ctl_old":           214,
	"epoll_pwait":             281,
	"epoll_pwait2":            441,
	"epoll_wait":              232,
	"epoll_wait_old":          215,
	"eventfd":                 284,
	"eventfd2":                290,
	"execve":                  59,
	"execveat":                322,
	"exit":                    60,
	"exit_group":              231,
	"faccessat":               269,
	"faccessat2":              439,
	"fadvise64":               221,
	"fallocate":               285,
	"fanotify_init":           300,
	"fanotify_mark":           301,
	"fchdir":                  81,
	"fchmod":                  91,
	"fchmodat":                268,
	"fchmodat2":               452,
	"fchown":                  93,
	"fchownat":                260,
	"fcntl":                   72,
	"fdatasync":               75,
	"fgetxattr":               193,
	"finit_module":            313,
	"flistxattr":              196,
	"flock":                   73,
	"fork":                    57,
	"fremovexattr":            199,
	"fsconfig":                431,
	"fsetxattr":               190,
	"fsmount":                 432,
	"fsopen":                  430,
	"fspick":                  433,
	"fstat":                   5,
	"fstatfs":                 138,
	"fsync":                   74,
	"ftruncate":               77,
	"futex":                   202,
	"futex_requeue":           456,
	"futex_wait":              455,
	"futex_waitv":             449,
	"futex_wake":              454,
	"futimesat":               261,
	"get_kernel_syms":         177,
	"get_mempolicy":           239,
	"get_robust_list":         274,
	"get_thread_area":         211,
	"getcpu":                  309,
	"getcwd":                  79,
	"getdents":                78,
	"getdents64":              217,
	"getegid":                 108,
	"geteuid":                 107,
	"getgid":                  104,
	"getgroups":               115,
	"getitimer":               36,
	"getpeername":             52,
	"getpgid":                 121,
	"getpgrp":                 111,
	"getpid":                  39,
	"getpmsg":                 181,
	"getppid":                 110,
	"getpriority":             140,
	"getrandom":               318,
	"getresgid":               120,
	"getresuid":               118,
	"getrlimit":               97,
	"getrusage":               98,
	"getsid":                  124,
	"getsockname":             51,
	"getsockopt":              55,
	"gettid":                  186,
	"gettimeofday":            96,
	"getuid":                  102,
	"getxattr":                191,
	"getxattrat":              464,
	"init_module":             175,
	"inotify_add_watch":       254,
	"inotify_init":            253,
	"inotify_init1":           294,
	"inotify_rm_watch":        255,
	"io_cancel":               210,
	"io_destroy":              207,
	"io_getevents":            208,
	"io_pgetevents":           333,
	"io_setup":                206,
	"io_submit":               209,
	"io_uring_enter":          426,
	"io_uring_register":       427,
	"io_uring_setup":          425,
	"ioctl":                   16,
	"ioperm":                  173,
	"iopl":                    172,
	"ioprio_get":              252,
	"ioprio_set":              251,
	"kcmp":                    312,
	"kexec_file_load":         320,
	"kexec_load":              246,
	"keyctl":                  250,
	"kill":                    62,
	"landlock_add_rule":       445,
	"landlock_create_ruleset": 444,
	"landlock_restrict_self":  446,
	"lchown":                  94,
	"lgetxattr":               192,
	"link":                    86,
	"linkat":                  265,
	"listen":                  50,
	"listmount":               458,
	"listxattr":               194,
	"listxattrat":             465,
	"llistxattr":              195,
	"lookup_dcookie":          212,
	"lremovexattr":            198,
	"lseek":                   8,
	"lsetxattr":               189,
	"lsm_get_self_attr":       459,
	"lsm_list_modules":        461,
	"lsm_set_self_attr":       460,
	"lstat":                   6,
	"madvise":                 28,
	"map_shadow_stack":        453,
	"mbind":                   237,
	"membarrier":              324,
	"memfd_create":            319,
	"memfd_secret":            447,
	"migrate_pages":           256,
	"mincore":                 27,
	"mkdir":                   83,
	"mkdirat":                 258,
	"mknod":                   133,
	"mknodat":                 259,
	"mlock":                   149,
	"mlock2":                  325,
	"mlockall":                151,
	"mmap":                    9,
	"modify_ldt":              154,
	"mount":                   165,
	"mount_setattr":           442,
	"move_mount":              429,
	"move_pages":              279,
	"mprotect":                10,
	"mq_getsetattr":           245,
	"mq_notify":               244,
	"mq_open":                 240,
	"mq_timedreceive":         243,
	"mq_timedsend":            242,
	"mq_unlink":               241,
	"mremap":                  25,
	"mseal":                   462,
	"msgctl":                  71,
	"msgget":                  68,
	"msgrcv":                  70,
	"msgsnd":                  69,
	"msync":                   26,
	"munlock":                 150,
	"munlockall":              152,
	"munmap":                  11,
	"name_to_handle_at":       303,
	"nanosleep":               35,
	"newfstatat":              262,
	"nfsservctl":              180,
	"open":                    2,
	"open_by_handle_at":       304,
	"open_tree":               428,
	"openat":                  257,
	"openat2":                 437,
	"pause":                   34,
	"perf_event_open":         298,
	"personality":             135,
	"pidfd_getfd":             438,
	"pidfd_open":              434,
	"pidfd_send_signal":       424,
	"pipe":                    22,
	"pipe2":                   293,
	"pivot_root":              155,
	"pkey_alloc":              330,
	"pkey_free":               331,
	"pkey_mprotect":           329,
	"poll":                    7,
	"ppoll":                   271,
	"prctl":                   157,
	"pread64":                 17,
	"preadv":                  295,
	"preadv2":                 327,
	"prlimit64":               302,
	"process_madvise":         440,
	"process_mrelease":        448,
	"process_vm_readv":        310,
	"process_vm_writev":       311,
	"pselect6":                270,
	"ptrace":                  101,
	"putpmsg":                 182,
	"pwrite64":                18,
	"pwritev":                 296,
	"pwritev2":                328,
	"query_module":            178,
	"quotactl":                179,
	"quotactl_fd":             443,
	"read":                    0,
	"readahead":               187,
	"readlink":                89,
	"readlinkat":              267,
	"readv":                   19,
	"reboot":                  169,
	"recvfrom":                45,
	"recvmmsg":                299,
	"recvmsg":                 47,
	"remap_file_pages":        216,
	"removexattr":             197,
	"removexattrat":           466,
	"rename":                  82,
	"renameat":                264,
	"renameat2":               316,
	"request_key":             249,
	"restart_syscall":         219,
	"rmdir":                   84,
	"rseq":                    334,
	"rt_sigaction":            13,
	"rt_sigpending":           127,
	"rt_sigprocmask":          14,
	"rt_sigqueueinfo":         129,
	"rt_sigreturn":            15,
	"rt_sigsuspend":           130,
	"rt_sigtimedwait":         128,
	"rt_tgsigqueueinfo":       297,
	"sched_get_priority_max":  146,
	"sched_get_priority_min":  147,
	"sched_getaffinity":       204,
	"sched_getattr":           315,
	"sched_getparam":          143,
	"sched_getscheduler":      145,
	"sched_rr_get_interval":   148,
	"sched_setaffinity":       203,
	"sched_setattr":           314,
	"sched_setparam":          142,
	"sched_setscheduler":      144,
	"sched_yield":             24,
	"seccomp":                 317,
	"security":                185,
	"select":                  23,
	"semctl":                  66,
	"semget":                  64,
	"semop":                   65,
	"semtimedop":              220,
	"sendfile":                40,
	"sendmmsg":                307,
	"sendmsg":                 46,
	"sendto":                  44,
	"set_mempolicy":           238,
	"set_mempolicy_home_node": 450,
	"set_robust_list":         273,
	"set_thread_area":         205,
	"set_tid_address":         218,
	"setdomainname":           171,
	"setfsgid":                123,
	"setfsuid":                122,
	"setgid":                  106,
	"setgroups":               116,
	"sethostname":             170,
	"setitimer":               38,
	"setns":                   308,
	"setpgid":                 109,
	"setpriority":             141,
	"setregid":                114,
	"setresgid":               119,
	"setresuid":               117,
	"setreuid":                113,
	"setrlimit":               160,
	"setsid":                  112,
	"setsockopt":              54,
	"settimeofday":            164,
	"setuid":                  105,
	"setxattr":                188,
	"setxattrat":              463,
	"shmat":                   30,
	"shmctl":                  31,
	"shmdt":                   67,
	"shmget":                  29,
	"shutdown":                48,
	"sigaltstack":             131,
	"signalfd":                282,
	"signalfd4":               289,
	"socket":                  41,
	"socketpair":              53,
	"splice":                  275,
	"stat":                    4,
	"statfs":                  137,
	"statmount":               457,
	"statx":                   332,
	"swapoff":                 168,
	"swapon":                  167,
	"symlink":                 88,
	"symlinkat":               266,
	"sync":                    162,
	"sync_file_range":         277,
	"syncfs":                  306,
	"sysfs":                   139,
	"sysinfo":                 99,
	"syslog":                  103,
	"tee":                     276,
	"tgkill":                  234,
	"time":                    201,
	"timer_create":            222,
	"timer_delete":            226,
	"timer_getoverrun":        225,
	"timer_gettime":           224,
	"timer_settime":           223,
	"timerfd_create":          283,
	"timerfd_gettime":         287,
	"timerfd_settime":         286,
	"times":                   100,
	"tkill":                   200,
	"truncate":                76,
	"tuxcall":                 184,
	"umask":                   95,
	"umount2":                 166,
	"uname":                   63,
	"unlink":                  87,
	"unlinkat":                263,
	"unshare":                 272,
	"uretprobe":               335,
	"uselib":                  134,
	"userfaultfd":             323,
	"ustat":                   136,
	"utime":                   132,
	"utimensat":               280,
	"utimes":                  235,
	"vfork":                   58,
	"vhangup":                 153,
	"vmsplice":                278,
	"vserver":                 236,
	"wait4":                   61,
	"waitid":                  247,
	"write":                   1,
	"writev":                  20,
}

var syscallsNumberToName = map[int]string{
	156: "_sysctl",
	43:  "accept",
	288: "accept4",
	21:  "access",
	163: "acct",
	248: "add_key",
	159: "adjtimex",
	183: "afs_syscall",
	37:  "alarm",
	158: "arch_prctl",
	49:  "bind",
	321: "bpf",
	12:  "brk",
	451: "cachestat",
	125: "capget",
	126: "capset",
	80:  "chdir",
	90:  "chmod",
	92:  "chown",
	161: "chroot",
	305: "clock_adjtime",
	229: "clock_getres",
	228: "clock_gettime",
	230: "clock_nanosleep",
	227: "clock_settime",
	56:  "clone",
	435: "clone3",
	3:   "close",
	436: "close_range",
	42:  "connect",
	326: "copy_file_range",
	85:  "creat",
	174: "create_module",
	176: "delete_module",
	32:  "dup",
	33:  "dup2",
	292: "dup3",
	213: "epoll_create",
	291: "epoll_create1",
	233: "epoll_ctl",
	214: "epoll_ctl_old",
	281: "epoll_pwait",
	441: "epoll_pwait2",
	232: "epoll_wait",
	215: "epoll_wait_old",
	284: "eventfd",
	290: "eventfd2",
	59:  "execve",
	322: "execveat",
	60:  "exit",
	231: "exit_group",
	269: "faccessat",
	439: "faccessat2",
	221: "fadvise64",
	285: "fallocate",
	300: "fanotify_init",
	301: "fanotify_mark",
	81:  "fchdir",
	91:  "fchmod",
	268: "fchmodat",
	452: "fchmodat2",
	93:  "fchown",
	260: "fchownat",
	72:  "fcntl",
	75:  "fdatasync",
	193: "fgetxattr",
	313: "finit_module",
	196: "flistxattr",
	73:  "flock",
	57:  "fork",
	199: "fremovexattr",
	431: "fsconfig",
	190: "fsetxattr",
	432: "fsmount",
	430: "fsopen",
	433: "fspick",
	5:   "fstat",
	138: "fstatfs",
	74:  "fsync",
	77:  "ftruncate",
	202: "futex",
	456: "futex_requeue",
	455: "futex_wait",
	449: "futex_waitv",
	454: "futex_wake",
	261: "futimesat",
	177: "get_kernel_syms",
	239: "get_mempolicy",
	274: "get_robust_list",
	211: "get_thread_area",
	309: "getcpu",
	79:  "getcwd",
	78:  "getdents",
	217: "getdents64",
	108: "getegid",
	107: "geteuid",
	104: "getgid",
	115: "getgroups",
	36:  "getitimer",
	52:  "getpeername",
	121: "getpgid",
	111: "getpgrp",
	39:  "getpid",
	181: "getpmsg",
	110: "getppid",
	140: "getpriority",
	318: "getrandom",
	120: "getresgid",
	118: "getresuid",
	97:  "getrlimit",
	98:  "getrusage",
	124: "getsid",
	51:  "getsockname",
	55:  "getsockopt",
	186: "gettid",
	96:  "gettimeofday",
	102: "getuid",
	191: "getxattr",
	464: "getxattrat",
	175: "init_module",
	254: "inotify_add_watch",
	253: "inotify_init",
	294: "inotify_init1",
	255: "inotify_rm_watch",
	210: "io_cancel",
	207: "io_destroy",
	208: "io_getevents",
	333: "io_pgetevents",
	206: "io_setup",
	209: "io_submit",
	426: "io_uring_enter",
	427: "io_uring_register",
	425: "io_uring_setup",
	16:  "ioctl",
	173: "ioperm",
	172: "iopl",
	252: "ioprio_get",
	251: "ioprio_set",
	312: "kcmp",
	320: "kexec_file_load",
	246: "kexec_load",
	250: "keyctl",
	62:  "kill",
	445: "landlock_add_rule",
	444: "landlock_create_ruleset",
	446: "landlock_restrict_self",
	94:  "lchown",
	192: "lgetxattr",
	86:  "link",
	265: "linkat",
	50:  "listen",
	458: "listmount",
	194: "listxattr",
	465: "listxattrat",
	195: "llistxattr",
	212: "lookup_dcookie",
	198: "lremovexattr",
	8:   "lseek",
	189: "lsetxattr",
	459: "lsm_get_self_attr",
	461: "lsm_list_modules",
	460: "lsm_set_self_attr",
	6:   "lstat",
	28:  "madvise",
	453: "map_shadow_stack",
	237: "mbind",
	324: "membarrier",
	319: "memfd_create",
	447: "memfd_secret",
	256: "migrate_pages",
	27:  "mincore",
	83:  "mkdir",
	258: "mkdirat",
	133: "mknod",
	259: "mknodat",
	149: "mlock",
	325: "mlock2",
	151: "mlockall",
	9:   "mmap",
	154: "modify_ldt",
	165: "mount",
	442: "mount_setattr",
	429: "move_mount",
	279: "move_pages",
	10:  "mprotect",
	245: "mq_getsetattr",
	244: "mq_notify",
	240: "mq_open",
	243: "mq_timedreceive",
	242: "mq_timedsend",
	241: "mq_unlink",
	25:  "mremap",
	462: "mseal",
	71:  "msgctl",
	68:  "msgget",
	70:  "msgrcv",
	69:  "msgsnd",
	26:  "msync",
	150: "munlock",
	152: "munlockall",
	11:  "munmap",
	303: "name_to_handle_at",
	35:  "nanosleep",
	262: "newfstatat",
	180: "nfsservctl",
	2:   "open",
	304: "open_by_handle_at",
	428: "open_tree",
	257: "openat",
	437: "openat2",
	34:  "pause",
	298: "perf_event_open",
	135: "personality",
	438: "pidfd_getfd",
	434: "pidfd_open",
	424: "pidfd_send_signal",
	22:  "pipe",
	293: "pipe2",
	155: "pivot_root",
	330: "pkey_alloc",
	331: "pkey_free",
	329: "pkey_mprotect",
	7:   "poll",
	271: "ppoll",
	157: "prctl",
	17:  "pread64",
	295: "preadv",
	327: "preadv2",
	302: "prlimit64",
	440: "process_madvise",
	448: "process_mrelease",
	310: "process_vm_readv",
	311: "process_vm_writev",
	270: "pselect6",
	101: "ptrace",
	182: "putpmsg",
	18:  "pwrite64",
	296: "pwritev",
	328: "pwritev2",
	178: "query_module",
	179: "quotactl",
	443: "quotactl_fd",
	0:   "read",
	187: "readahead",
	89:  "readlink",
	267: "readlinkat",
	19:  "readv",
	169: "reboot",
	45:  "recvfrom",
	299: "recvmmsg",
	47:  "recvmsg",
	216: "remap_file_pages",
	197: "removexattr",
	466: "removexattrat",
	82:  "rename",
	264: "renameat",
	316: "renameat2",
	249: "request_key",
	219: "restart_syscall",
	84:  "rmdir",
	334: "rseq",
	13:  "rt_sigaction",
	127: "rt_sigpending",
	14:  "rt_sigprocmask",
	129: "rt_sigqueueinfo",
	15:  "rt_sigreturn",
	130: "rt_sigsuspend",
	128: "rt_sigtimedwait",
	297: "rt_tgsigqueueinfo",
	146: "sched_get_priority_max",
	147: "sched_get_priority_min",
	204: "sched_getaffinity",
	315: "sched_getattr",
	143: "sched_getparam",
	145: "sched_getscheduler",
	148: "sched_rr_get_interval",
	203: "sched_setaffinity",
	314: "sched_setattr",
	142: "sched_setparam",
	144: "sched_setscheduler",
	24:  "sched_yield",
	317: "seccomp",
	185: "security",
	23:  "select",
	66:  "semctl",
	64:  "semget",
	65:  "semop",
	220: "semtimedop",
	40:  "sendfile",
	307: "sendmmsg",
	46:  "sendmsg",
	44:  "sendto",
	238: "set_mempolicy",
	450: "set_mempolicy_home_node",
	273: "set_robust_list",
	205: "set_thread_area",
	218: "set_tid_address",
	171: "setdomainname",
	123: "setfsgid",
	122: "setfsuid",
	106: "setgid",
	116: "setgroups",
	170: "sethostname",
	38:  "setitimer",
	308: "setns",
	109: "setpgid",
	141: "setpriority",
	114: "setregid",
	119: "setresgid",
	117: "setresuid",
	113: "setreuid",
	160: "setrlimit",
	112: "setsid",
	54:  "setsockopt",
	164: "settimeofday",
	105: "setuid",
	188: "setxattr",
	463: "setxattrat",
	30:  "shmat",
	31:  "shmctl",
	67:  "shmdt",
	29:  "shmget",
	48:  "shutdown",
	131: "sigaltstack",
	282: "signalfd",
	289: "signalfd4",
	41:  "socket",
	53:  "socketpair",
	275: "splice",
	4:   "stat",
	137: "statfs",
	457: "statmount",
	332: "statx",
	168: "swapoff",
	167: "swapon",
	88:  "symlink",
	266: "symlinkat",
	162: "sync",
	277: "sync_file_range",
	306: "syncfs",
	139: "sysfs",
	99:  "sysinfo",
	103: "syslog",
	276: "tee",
	234: "tgkill",
	201: "time",
	222: "timer_create",
	226: "timer_delete",
	225: "timer_getoverrun",
	224: "timer_gettime",
	223: "timer_settime",
	283: "timerfd_create",
	287: "timerfd_gettime",
	286: "timerfd_settime",
	100: "times",
	200: "tkill",
	76:  "truncate",
	184: "tuxcall",
	95:  "umask",
	166: "umount2",
	63:  "uname",
	87:  "unlink",
	263: "unlinkat",
	272: "unshare",
	335: "uretprobe",
	134: "uselib",
	323: "userfaultfd",
	136: "ustat",
	132: "utime",
	280: "utimensat",
	235: "utimes",
	58:  "vfork",
	153: "vhangup",
	278: "vmsplice",
	236: "vserver",
	61:  "wait4",
	247: "waitid",
	1:   "write",
	20:  "writev",
}
