package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/apimanagement/ctrl/2017-03-01/apimanagement"

// AccessInformationContract tenant access information contract of the API Management service.
type AccessInformationContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier.
	ID *string `json:"id,omitempty"`
	// PrimaryKey - Primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters tenant access information update parameters of the API Management service.
type AccessInformationUpdateParameters struct {
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// APICollection paged Api list representation.
type APICollection struct {
	autorest.Response `json:"-"`
	Value             *[]APIContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APICollectionIterator provides access to a complete listing of APIContract values.
type APICollectionIterator struct {
	i    int
	page APICollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APICollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APICollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APICollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APICollectionIterator) Response() APICollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APICollectionIterator) Value() APIContract {
	if !iter.page.NotDone() {
		return APIContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APICollectionIterator type.
func NewAPICollectionIterator(page APICollectionPage) APICollectionIterator {
	return APICollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac APICollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac APICollection) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// aPICollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac APICollection) aPICollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// APICollectionPage contains a page of APIContract values.
type APICollectionPage struct {
	fn func(context.Context, APICollection) (APICollection, error)
	ac APICollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APICollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APICollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APICollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APICollectionPage) Response() APICollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APICollectionPage) Values() []APIContract {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the APICollectionPage type.
func NewAPICollectionPage(getNextPage func(context.Context, APICollection) (APICollection, error)) APICollectionPage {
	return APICollectionPage{fn: getNextPage}
}

// APIContract api Contract Details
type APIContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Entity
	ID *string `json:"id,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
}

// APIContractProperties api Entity Properties
type APIContractProperties struct {
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
}

// APICreateOrUpdateParameter api Create or Update Properties.
type APICreateOrUpdateParameter struct {
	// ID - Identifier of the entity
	ID *string `json:"id,omitempty"`
	// ContentValue - Content value when Importing an API.
	ContentValue *string `json:"contentValue,omitempty"`
	// ContentFormat - Format of the Content in which the API is getting imported. Possible values include: 'WadlXML', 'WadlLinkJSON', 'SwaggerJSON', 'SwaggerLinkJSON', 'Wsdl', 'WsdlLink'
	ContentFormat ContentFormat `json:"contentFormat,omitempty"`
	// WsdlSelector - Criteria to limit import of WSDL to a subset of the document.
	WsdlSelector *APICreateOrUpdateParameterWsdlSelector `json:"wsdlSelector,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
}

// APICreateOrUpdateParameterWsdlSelector criteria to limit import of WSDL to a subset of the document.
type APICreateOrUpdateParameterWsdlSelector struct {
	// WsdlServiceName - Name of service to import from WSDL
	WsdlServiceName *string `json:"wsdlServiceName,omitempty"`
	// WsdlEndpointName - Name of endpoint(port) to import from WSDL
	WsdlEndpointName *string `json:"wsdlEndpointName,omitempty"`
}

// APIEntityBaseContract API base contract details.
type APIEntityBaseContract struct {
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
}

// APIExportResult API Export result Blob Uri.
type APIExportResult struct {
	autorest.Response `json:"-"`
	// Link - Link to the Storage Blob containing the result of the export operation. The Blob Uri is only valid for 5 minutes.
	Link *string `json:"link,omitempty"`
}

// APIUpdateContract API update contract properties.
type APIUpdateContract struct {
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
}

// AuthenticationSettingsContract API Authentication Settings.
type AuthenticationSettingsContract struct {
	// OAuth2 - OAuth2 Authentication settings
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`
}

// AuthorizationServerCollection paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]AuthorizationServerContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationServerCollectionIterator provides access to a complete listing of AuthorizationServerContract
// values.
type AuthorizationServerCollectionIterator struct {
	i    int
	page AuthorizationServerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationServerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationServerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationServerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationServerCollectionIterator) Response() AuthorizationServerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationServerCollectionIterator) Value() AuthorizationServerContract {
	if !iter.page.NotDone() {
		return AuthorizationServerContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationServerCollectionIterator type.
func NewAuthorizationServerCollectionIterator(page AuthorizationServerCollectionPage) AuthorizationServerCollectionIterator {
	return AuthorizationServerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asc AuthorizationServerCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asc AuthorizationServerCollection) hasNextLink() bool {
	return asc.NextLink != nil && len(*asc.NextLink) != 0
}

// authorizationServerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc AuthorizationServerCollection) authorizationServerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// AuthorizationServerCollectionPage contains a page of AuthorizationServerContract values.
type AuthorizationServerCollectionPage struct {
	fn  func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)
	asc AuthorizationServerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationServerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asc)
		if err != nil {
			return err
		}
		page.asc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationServerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationServerCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationServerCollectionPage) Response() AuthorizationServerCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationServerCollectionPage) Values() []AuthorizationServerContract {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// Creates a new instance of the AuthorizationServerCollectionPage type.
func NewAuthorizationServerCollectionPage(getNextPage func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)) AuthorizationServerCollectionPage {
	return AuthorizationServerCollectionPage{fn: getNextPage}
}

// AuthorizationServerContract external OAuth authorization server settings.
type AuthorizationServerContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Authorization Server entity.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantType `json:"grantTypes,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// AuthorizationServerContractBaseProperties external OAuth authorization server Update settings contract.
type AuthorizationServerContractBaseProperties struct {
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// AuthorizationServerContractProperties external OAuth authorization server settings Properties.
type AuthorizationServerContractProperties struct {
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantType `json:"grantTypes,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// AuthorizationServerUpdateContract external OAuth authorization server Update settings contract.
type AuthorizationServerUpdateContract struct {
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantType `json:"grantTypes,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// BackendAuthorizationHeaderCredentials authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	// Scheme - Authentication Scheme name.
	Scheme *string `json:"scheme,omitempty"`
	// Parameter - Authentication Parameter value.
	Parameter *string `json:"parameter,omitempty"`
}

// BackendBaseParameters backend entity base Parameter set.
type BackendBaseParameters struct {
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendCollection paged Backend list representation.
type BackendCollection struct {
	autorest.Response `json:"-"`
	// Value - Backend values.
	Value *[]BackendContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackendCollectionIterator provides access to a complete listing of BackendContract values.
type BackendCollectionIterator struct {
	i    int
	page BackendCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackendCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackendCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackendCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackendCollectionIterator) Response() BackendCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackendCollectionIterator) Value() BackendContract {
	if !iter.page.NotDone() {
		return BackendContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackendCollectionIterator type.
func NewBackendCollectionIterator(page BackendCollectionPage) BackendCollectionIterator {
	return BackendCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bc BackendCollection) IsEmpty() bool {
	return bc.Value == nil || len(*bc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bc BackendCollection) hasNextLink() bool {
	return bc.NextLink != nil && len(*bc.NextLink) != 0
}

// backendCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bc BackendCollection) backendCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bc.NextLink)))
}

// BackendCollectionPage contains a page of BackendContract values.
type BackendCollectionPage struct {
	fn func(context.Context, BackendCollection) (BackendCollection, error)
	bc BackendCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackendCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bc)
		if err != nil {
			return err
		}
		page.bc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackendCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackendCollectionPage) NotDone() bool {
	return !page.bc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackendCollectionPage) Response() BackendCollection {
	return page.bc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackendCollectionPage) Values() []BackendContract {
	if page.bc.IsEmpty() {
		return nil
	}
	return *page.bc.Value
}

// Creates a new instance of the BackendCollectionPage type.
func NewBackendCollectionPage(getNextPage func(context.Context, BackendCollection) (BackendCollection, error)) BackendCollectionPage {
	return BackendCollectionPage{fn: getNextPage}
}

// BackendContract backend details.
type BackendContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Backend entity.
	ID *string `json:"id,omitempty"`
	// URL - Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendContractProperties parameters supplied to the Create Backend operation.
type BackendContractProperties struct {
	// URL - Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendCredentialsContract details of the Credentials used to connect to Backend.
type BackendCredentialsContract struct {
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// Authorization - Authorization header authentication
	Authorization *BackendAuthorizationHeaderCredentials `json:"authorization,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendCredentialsContract.
func (bcc BackendCredentialsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bcc.Certificate != nil {
		objectMap["certificate"] = bcc.Certificate
	}
	if bcc.Query != nil {
		objectMap["query"] = bcc.Query
	}
	if bcc.Header != nil {
		objectMap["header"] = bcc.Header
	}
	if bcc.Authorization != nil {
		objectMap["authorization"] = bcc.Authorization
	}
	return json.Marshal(objectMap)
}

// BackendProperties properties specific to the Backend Type.
type BackendProperties struct {
	// ServiceFabricCluster - Backend Service Fabric Cluster Properties
	ServiceFabricCluster *BackendServiceFabricClusterProperties `json:"serviceFabricCluster,omitempty"`
}

// BackendProxyContract details of the Backend WebProxy Server to use in the Request to Backend.
type BackendProxyContract struct {
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
}

// BackendServiceFabricClusterProperties properties of the Service Fabric Type Backend.
type BackendServiceFabricClusterProperties struct {
	// ClientCertificateThumbprint - The client certificate thumbprint for the management endpoint.
	ClientCertificateThumbprint *string `json:"clientCertificateThumbprint,omitempty"`
	// MaxPartitionResolutionRetries - Maximum number of retries while attempting resolve the partition.
	MaxPartitionResolutionRetries *int32 `json:"maxPartitionResolutionRetries,omitempty"`
	// PartitionResolutionRequestTimeout - Maximum time allowed to update partition resolution data. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
	PartitionResolutionRequestTimeout *string `json:"partitionResolutionRequestTimeout,omitempty"`
	// ManagementEndpoints - The cluster management endpoint.
	ManagementEndpoints *[]string `json:"managementEndpoints,omitempty"`
	// ServerCertificateThumbprints - Thumbprints of certificates cluster management service uses for tls communication
	ServerCertificateThumbprints *[]string `json:"serverCertificateThumbprints,omitempty"`
	// ServerX509Names - Server X509 Certificate Names Collection
	ServerX509Names *[]X509CertificateName `json:"serverX509Names,omitempty"`
}

// BackendTLSProperties properties controlling TLS Certificate Validation.
type BackendTLSProperties struct {
	// ValidateCertificateChain - Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
	ValidateCertificateChain *bool `json:"validateCertificateChain,omitempty"`
	// ValidateCertificateName - Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
	ValidateCertificateName *bool `json:"validateCertificateName,omitempty"`
}

// BackendUpdateParameters parameters supplied to the Update Backend operation.
type BackendUpdateParameters struct {
	// URL - Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// CertificateCollection paged Certificates list representation.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]CertificateContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of CertificateContract values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() CertificateContract {
	if !iter.page.NotDone() {
		return CertificateContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cc CertificateCollection) hasNextLink() bool {
	return cc.NextLink != nil && len(*cc.NextLink) != 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of CertificateContract values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cc)
		if err != nil {
			return err
		}
		page.cc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []CertificateContract {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{fn: getNextPage}
}

// CertificateContract certificate details.
type CertificateContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Certificate entity.
	ID *string `json:"id,omitempty"`
	// Subject - Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpirationDate - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// CertificateContractProperties properties of the Certificate contract.
type CertificateContractProperties struct {
	// Subject - Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpirationDate - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// CertificateCreateOrUpdateParameters parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// Data - Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string `json:"data,omitempty"`
	// Password - Password for the Certificate
	Password *string `json:"password,omitempty"`
}

// DeployConfigurationParameters parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameters struct {
	// Branch - The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string `json:"branch,omitempty"`
	// Force - The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool `json:"force,omitempty"`
}

// EmailTemplateCollection paged email template list representation.
type EmailTemplateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]EmailTemplateContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EmailTemplateCollectionIterator provides access to a complete listing of EmailTemplateContract values.
type EmailTemplateCollectionIterator struct {
	i    int
	page EmailTemplateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EmailTemplateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EmailTemplateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EmailTemplateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EmailTemplateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EmailTemplateCollectionIterator) Response() EmailTemplateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EmailTemplateCollectionIterator) Value() EmailTemplateContract {
	if !iter.page.NotDone() {
		return EmailTemplateContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EmailTemplateCollectionIterator type.
func NewEmailTemplateCollectionIterator(page EmailTemplateCollectionPage) EmailTemplateCollectionIterator {
	return EmailTemplateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (etc EmailTemplateCollection) IsEmpty() bool {
	return etc.Value == nil || len(*etc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (etc EmailTemplateCollection) hasNextLink() bool {
	return etc.NextLink != nil && len(*etc.NextLink) != 0
}

// emailTemplateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (etc EmailTemplateCollection) emailTemplateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !etc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(etc.NextLink)))
}

// EmailTemplateCollectionPage contains a page of EmailTemplateContract values.
type EmailTemplateCollectionPage struct {
	fn  func(context.Context, EmailTemplateCollection) (EmailTemplateCollection, error)
	etc EmailTemplateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EmailTemplateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EmailTemplateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.etc)
		if err != nil {
			return err
		}
		page.etc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EmailTemplateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EmailTemplateCollectionPage) NotDone() bool {
	return !page.etc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EmailTemplateCollectionPage) Response() EmailTemplateCollection {
	return page.etc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EmailTemplateCollectionPage) Values() []EmailTemplateContract {
	if page.etc.IsEmpty() {
		return nil
	}
	return *page.etc.Value
}

// Creates a new instance of the EmailTemplateCollectionPage type.
func NewEmailTemplateCollectionPage(getNextPage func(context.Context, EmailTemplateCollection) (EmailTemplateCollection, error)) EmailTemplateCollectionPage {
	return EmailTemplateCollectionPage{fn: getNextPage}
}

// EmailTemplateContract email Template details.
type EmailTemplateContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Template Contract.
	ID *string `json:"id,omitempty"`
	// Subject - Subject of the Template.
	Subject *string `json:"subject,omitempty"`
	// Body - Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`
	// Title - Title of the Template.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Email Template.
	Description *string `json:"description,omitempty"`
	// IsDefault - READ-ONLY; Whether the template is the default template provided by Api Management or has been edited.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Parameters - Email Template Parameter values.
	Parameters *[]EmailTemplateParametersContractProperties `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailTemplateContract.
func (etc EmailTemplateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if etc.ID != nil {
		objectMap["id"] = etc.ID
	}
	if etc.Subject != nil {
		objectMap["subject"] = etc.Subject
	}
	if etc.Body != nil {
		objectMap["body"] = etc.Body
	}
	if etc.Title != nil {
		objectMap["title"] = etc.Title
	}
	if etc.Description != nil {
		objectMap["description"] = etc.Description
	}
	if etc.Parameters != nil {
		objectMap["parameters"] = etc.Parameters
	}
	return json.Marshal(objectMap)
}

// EmailTemplateContractProperties email Template Contract properties.
type EmailTemplateContractProperties struct {
	// Subject - Subject of the Template.
	Subject *string `json:"subject,omitempty"`
	// Body - Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`
	// Title - Title of the Template.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Email Template.
	Description *string `json:"description,omitempty"`
	// IsDefault - READ-ONLY; Whether the template is the default template provided by Api Management or has been edited.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Parameters - Email Template Parameter values.
	Parameters *[]EmailTemplateParametersContractProperties `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailTemplateContractProperties.
func (etcp EmailTemplateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if etcp.Subject != nil {
		objectMap["subject"] = etcp.Subject
	}
	if etcp.Body != nil {
		objectMap["body"] = etcp.Body
	}
	if etcp.Title != nil {
		objectMap["title"] = etcp.Title
	}
	if etcp.Description != nil {
		objectMap["description"] = etcp.Description
	}
	if etcp.Parameters != nil {
		objectMap["parameters"] = etcp.Parameters
	}
	return json.Marshal(objectMap)
}

// EmailTemplateParametersContractProperties email Template Parameter contract.
type EmailTemplateParametersContractProperties struct {
	// Name - Template parameter name.
	Name *string `json:"name,omitempty"`
	// Title - Template parameter title.
	Title *string `json:"title,omitempty"`
	// Description - Template parameter description.
	Description *string `json:"description,omitempty"`
}

// EmailTemplateUpdateParameters email Template Update Contract properties.
type EmailTemplateUpdateParameters struct {
	// Subject - Subject of the Template.
	Subject *string `json:"subject,omitempty"`
	// Title - Title of the Template.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Email Template.
	Description *string `json:"description,omitempty"`
	// Body - Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`
	// Parameters - Email Template Parameter values.
	Parameters *[]EmailTemplateParametersContractProperties `json:"parameters,omitempty"`
}

// ErrorFieldContract error Field contract.
type ErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error Body contract.
type ErrorResponse struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]ErrorFieldContract `json:"details,omitempty"`
}

// GenerateSsoURLResult generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	autorest.Response `json:"-"`
	// Value - Redirect Url containing the SSO URL value.
	Value *string `json:"value,omitempty"`
}

// GroupCollection paged Group list representation.
type GroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]GroupContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupCollectionIterator provides access to a complete listing of GroupContract values.
type GroupCollectionIterator struct {
	i    int
	page GroupCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupCollectionIterator) Response() GroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupCollectionIterator) Value() GroupContract {
	if !iter.page.NotDone() {
		return GroupContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupCollectionIterator type.
func NewGroupCollectionIterator(page GroupCollectionPage) GroupCollectionIterator {
	return GroupCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gc GroupCollection) IsEmpty() bool {
	return gc.Value == nil || len(*gc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gc GroupCollection) hasNextLink() bool {
	return gc.NextLink != nil && len(*gc.NextLink) != 0
}

// groupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gc GroupCollection) groupCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !gc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gc.NextLink)))
}

// GroupCollectionPage contains a page of GroupContract values.
type GroupCollectionPage struct {
	fn func(context.Context, GroupCollection) (GroupCollection, error)
	gc GroupCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gc)
		if err != nil {
			return err
		}
		page.gc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupCollectionPage) NotDone() bool {
	return !page.gc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupCollectionPage) Response() GroupCollection {
	return page.gc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupCollectionPage) Values() []GroupContract {
	if page.gc.IsEmpty() {
		return nil
	}
	return *page.gc.Value
}

// Creates a new instance of the GroupCollectionPage type.
func NewGroupCollectionPage(getNextPage func(context.Context, GroupCollection) (GroupCollection, error)) GroupCollectionPage {
	return GroupCollectionPage{fn: getNextPage}
}

// GroupContract contract details.
type GroupContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Group entity.
	ID *string `json:"id,omitempty"`
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// BuiltIn - READ-ONLY; true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupContract.
func (gc GroupContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gc.ID != nil {
		objectMap["id"] = gc.ID
	}
	if gc.Name != nil {
		objectMap["name"] = gc.Name
	}
	if gc.Description != nil {
		objectMap["description"] = gc.Description
	}
	if gc.Type != "" {
		objectMap["type"] = gc.Type
	}
	if gc.ExternalID != nil {
		objectMap["externalId"] = gc.ExternalID
	}
	return json.Marshal(objectMap)
}

// GroupContractProperties developer group.
type GroupContractProperties struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// BuiltIn - READ-ONLY; true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupContractProperties.
func (gcp GroupContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcp.Name != nil {
		objectMap["name"] = gcp.Name
	}
	if gcp.Description != nil {
		objectMap["description"] = gcp.Description
	}
	if gcp.Type != "" {
		objectMap["type"] = gcp.Type
	}
	if gcp.ExternalID != nil {
		objectMap["externalId"] = gcp.ExternalID
	}
	return json.Marshal(objectMap)
}

// GroupCreateParameters parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupUpdateParameters parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// IdentityProviderBaseParameters identity Provider Base Parameter Properties.
type IdentityProviderBaseParameters struct {
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IdentityProviderContract identity Provider details.
type IdentityProviderContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the identity provider.
	ID *string `json:"id,omitempty"`
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IdentityProviderContractProperties the external Identity Providers like Facebook, Google, Microsoft, Twitter
// or Azure Active Directory which can be used to enable access to the API Management service developer portal
// for all users.
type IdentityProviderContractProperties struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IdentityProviderList list of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	autorest.Response `json:"-"`
	// Value - Identity Provider configuration values.
	Value *[]IdentityProviderContract `json:"value,omitempty"`
	// Count - Total number of identity providers
	Count *int32 `json:"count,omitempty"`
}

// IdentityProviderUpdateParameters parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateParameters struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// LoggerCollection paged Logger list representation.
type LoggerCollection struct {
	autorest.Response `json:"-"`
	// Value - Logger values.
	Value *[]LoggerContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoggerCollectionIterator provides access to a complete listing of LoggerContract values.
type LoggerCollectionIterator struct {
	i    int
	page LoggerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoggerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoggerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoggerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoggerCollectionIterator) Response() LoggerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoggerCollectionIterator) Value() LoggerContract {
	if !iter.page.NotDone() {
		return LoggerContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoggerCollectionIterator type.
func NewLoggerCollectionIterator(page LoggerCollectionPage) LoggerCollectionIterator {
	return LoggerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lc LoggerCollection) IsEmpty() bool {
	return lc.Value == nil || len(*lc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lc LoggerCollection) hasNextLink() bool {
	return lc.NextLink != nil && len(*lc.NextLink) != 0
}

// loggerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lc LoggerCollection) loggerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !lc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lc.NextLink)))
}

// LoggerCollectionPage contains a page of LoggerContract values.
type LoggerCollectionPage struct {
	fn func(context.Context, LoggerCollection) (LoggerCollection, error)
	lc LoggerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoggerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lc)
		if err != nil {
			return err
		}
		page.lc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoggerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoggerCollectionPage) NotDone() bool {
	return !page.lc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoggerCollectionPage) Response() LoggerCollection {
	return page.lc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoggerCollectionPage) Values() []LoggerContract {
	if page.lc.IsEmpty() {
		return nil
	}
	return *page.lc.Value
}

// Creates a new instance of the LoggerCollectionPage type.
func NewLoggerCollectionPage(getNextPage func(context.Context, LoggerCollection) (LoggerCollection, error)) LoggerCollectionPage {
	return LoggerCollectionPage{fn: getNextPage}
}

// LoggerContract logger details.
type LoggerContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Logger Entity.
	ID *string `json:"id,omitempty"`
	// LoggerType - Logger type.
	LoggerType *string `json:"loggerType,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerContract.
func (lc LoggerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.ID != nil {
		objectMap["id"] = lc.ID
	}
	if lc.LoggerType != nil {
		objectMap["loggerType"] = lc.LoggerType
	}
	if lc.Description != nil {
		objectMap["description"] = lc.Description
	}
	if lc.Credentials != nil {
		objectMap["credentials"] = lc.Credentials
	}
	if lc.IsBuffered != nil {
		objectMap["isBuffered"] = lc.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerContractProperties the Logger entity in API Management represents an event sink that you can use to
// log API Management events. Currently the Logger entity supports logging API Management events to Azure Event
// Hubs.
type LoggerContractProperties struct {
	// LoggerType - Logger type.
	LoggerType *string `json:"loggerType,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerContractProperties.
func (lcp LoggerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcp.LoggerType != nil {
		objectMap["loggerType"] = lcp.LoggerType
	}
	if lcp.Description != nil {
		objectMap["description"] = lcp.Description
	}
	if lcp.Credentials != nil {
		objectMap["credentials"] = lcp.Credentials
	}
	if lcp.IsBuffered != nil {
		objectMap["isBuffered"] = lcp.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerUpdateContract parameters supplied to the Update Logger operation.
type LoggerUpdateContract struct {
	// LoggerType - Logger type. Possible values include: 'AzureEventHub'
	LoggerType LoggerType `json:"loggerType,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - Logger credentials.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerUpdateContract.
func (luc LoggerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if luc.LoggerType != "" {
		objectMap["loggerType"] = luc.LoggerType
	}
	if luc.Description != nil {
		objectMap["description"] = luc.Description
	}
	if luc.Credentials != nil {
		objectMap["credentials"] = luc.Credentials
	}
	if luc.IsBuffered != nil {
		objectMap["isBuffered"] = luc.IsBuffered
	}
	return json.Marshal(objectMap)
}

// OAuth2AuthenticationSettingsContract API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// AuthorizationServerID - OAuth authorization server identifier.
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`
	// Scope - operations scope.
	Scope *string `json:"scope,omitempty"`
}

// OpenIDConnectProviderCollection paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OpenidConnectProviderContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OpenIDConnectProviderCollectionIterator provides access to a complete listing of
// OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionIterator struct {
	i    int
	page OpenIDConnectProviderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OpenIDConnectProviderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OpenIDConnectProviderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OpenIDConnectProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OpenIDConnectProviderCollectionIterator) Response() OpenIDConnectProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OpenIDConnectProviderCollectionIterator) Value() OpenidConnectProviderContract {
	if !iter.page.NotDone() {
		return OpenidConnectProviderContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OpenIDConnectProviderCollectionIterator type.
func NewOpenIDConnectProviderCollectionIterator(page OpenIDConnectProviderCollectionPage) OpenIDConnectProviderCollectionIterator {
	return OpenIDConnectProviderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oicpc OpenIDConnectProviderCollection) IsEmpty() bool {
	return oicpc.Value == nil || len(*oicpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oicpc OpenIDConnectProviderCollection) hasNextLink() bool {
	return oicpc.NextLink != nil && len(*oicpc.NextLink) != 0
}

// openIDConnectProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oicpc OpenIDConnectProviderCollection) openIDConnectProviderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oicpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oicpc.NextLink)))
}

// OpenIDConnectProviderCollectionPage contains a page of OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionPage struct {
	fn    func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)
	oicpc OpenIDConnectProviderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OpenIDConnectProviderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oicpc)
		if err != nil {
			return err
		}
		page.oicpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OpenIDConnectProviderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OpenIDConnectProviderCollectionPage) NotDone() bool {
	return !page.oicpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OpenIDConnectProviderCollectionPage) Response() OpenIDConnectProviderCollection {
	return page.oicpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OpenIDConnectProviderCollectionPage) Values() []OpenidConnectProviderContract {
	if page.oicpc.IsEmpty() {
		return nil
	}
	return *page.oicpc.Value
}

// Creates a new instance of the OpenIDConnectProviderCollectionPage type.
func NewOpenIDConnectProviderCollectionPage(getNextPage func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)) OpenIDConnectProviderCollectionPage {
	return OpenIDConnectProviderCollectionPage{fn: getNextPage}
}

// OpenidConnectProviderContract openId Connect Provider details.
type OpenidConnectProviderContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the OpenId Connect Provider.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderContractProperties openID Connect Providers Contract.
type OpenidConnectProviderContractProperties struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderUpdateContract parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OperationCollection paged Operation list representation.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OperationContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationCollectionIterator provides access to a complete listing of OperationContract values.
type OperationCollectionIterator struct {
	i    int
	page OperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationCollectionIterator) Response() OperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationCollectionIterator) Value() OperationContract {
	if !iter.page.NotDone() {
		return OperationContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationCollectionIterator type.
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return OperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oc OperationCollection) IsEmpty() bool {
	return oc.Value == nil || len(*oc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oc OperationCollection) hasNextLink() bool {
	return oc.NextLink != nil && len(*oc.NextLink) != 0
}

// operationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oc OperationCollection) operationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oc.NextLink)))
}

// OperationCollectionPage contains a page of OperationContract values.
type OperationCollectionPage struct {
	fn func(context.Context, OperationCollection) (OperationCollection, error)
	oc OperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oc)
		if err != nil {
			return err
		}
		page.oc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationCollectionPage) NotDone() bool {
	return !page.oc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationCollectionPage) Response() OperationCollection {
	return page.oc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationCollectionPage) Values() []OperationContract {
	if page.oc.IsEmpty() {
		return nil
	}
	return *page.oc.Value
}

// Creates a new instance of the OperationCollectionPage type.
func NewOperationCollectionPage(getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return OperationCollectionPage{fn: getNextPage}
}

// OperationContract api Operation details.
type OperationContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Operation.
	ID *string `json:"id,omitempty"`
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// OperationContractProperties operation Contract Properties
type OperationContractProperties struct {
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// OperationEntityBaseContract api Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// OperationResultContract operation Result.
type OperationResultContract struct {
	autorest.Response `json:"-"`
	// ID - Operation result identifier.
	ID *string `json:"id,omitempty"`
	// Status - Status of an async operation. Possible values include: 'Started', 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationStatus `json:"status,omitempty"`
	// Started - Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Started *date.Time `json:"started,omitempty"`
	// Updated - Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Updated *date.Time `json:"updated,omitempty"`
	// ResultInfo - Optional result info.
	ResultInfo *string `json:"resultInfo,omitempty"`
	// Error - Error Body Contract
	Error *ErrorResponse `json:"error,omitempty"`
	// ActionLog - READ-ONLY; This property if only provided as part of the TenantConfiguration_Validate operation. It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy operation.
	ActionLog *[]OperationResultLogItemContract `json:"actionLog,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResultContract.
func (orc OperationResultContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orc.ID != nil {
		objectMap["id"] = orc.ID
	}
	if orc.Status != "" {
		objectMap["status"] = orc.Status
	}
	if orc.Started != nil {
		objectMap["started"] = orc.Started
	}
	if orc.Updated != nil {
		objectMap["updated"] = orc.Updated
	}
	if orc.ResultInfo != nil {
		objectMap["resultInfo"] = orc.ResultInfo
	}
	if orc.Error != nil {
		objectMap["error"] = orc.Error
	}
	return json.Marshal(objectMap)
}

// OperationResultLogItemContract log of the entity being created, updated or deleted.
type OperationResultLogItemContract struct {
	// ObjectType - The type of entity contract.
	ObjectType *string `json:"objectType,omitempty"`
	// Action - Action like create/update/delete.
	Action *string `json:"action,omitempty"`
	// ObjectKey - Identifier of the entity being created/updated/deleted.
	ObjectKey *string `json:"objectKey,omitempty"`
}

// OperationUpdateContract operation Update Contract Properties.
type OperationUpdateContract struct {
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// ParameterContract operation parameters details.
type ParameterContract struct {
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// Description - Parameter description.
	Description *string `json:"description,omitempty"`
	// Type - Parameter type.
	Type *string `json:"type,omitempty"`
	// DefaultValue - Default parameter value.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// Required - whether parameter is required or not.
	Required *bool `json:"required,omitempty"`
	// Values - Parameter values.
	Values *[]string `json:"values,omitempty"`
}

// PolicyCollection the response of the list policy operation.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - Policy Contract value.
	Value *[]PolicyContract `json:"value,omitempty"`
	// Count - Total number of records
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyContract policy contract Properties.
type PolicyContract struct {
	autorest.Response `json:"-"`
	// ID - Policy identifier.
	ID *string `json:"id,omitempty"`
	// PolicyContent - Json escaped Xml Encoded contents of the Policy.
	PolicyContent *string `json:"policyContent,omitempty"`
}

// PolicySnippetContract policy snippet.
type PolicySnippetContract struct {
	// Name - READ-ONLY; Snippet name.
	Name *string `json:"name,omitempty"`
	// Content - READ-ONLY; Snippet content.
	Content *string `json:"content,omitempty"`
	// ToolTip - READ-ONLY; Snippet toolTip.
	ToolTip *string `json:"toolTip,omitempty"`
	// Scope - READ-ONLY; Binary OR value of the Snippet scope.
	Scope *int32 `json:"scope,omitempty"`
}

// PolicySnippetsCollection the response of the list policy snippets operation.
type PolicySnippetsCollection struct {
	autorest.Response `json:"-"`
	// Value - Policy snippet value.
	Value *[]PolicySnippetContract `json:"value,omitempty"`
}

// PortalDelegationSettings delegation settings for a developer portal.
type PortalDelegationSettings struct {
	autorest.Response `json:"-"`
	// URL - A delegation Url.
	URL *string `json:"url,omitempty"`
	// ValidationKey - A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string `json:"validationKey,omitempty"`
	// Subscriptions - Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties `json:"subscriptions,omitempty"`
	// UserRegistration - User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties `json:"userRegistration,omitempty"`
}

// PortalSigninSettings sign-In settings for the Developer Portal.
type PortalSigninSettings struct {
	autorest.Response `json:"-"`
	// Enabled - Redirect Anonymous users to the Sign-In page.
	Enabled *bool `json:"enabled,omitempty"`
}

// PortalSignupSettings sign-up settings contract properties.
type PortalSignupSettings struct {
	autorest.Response `json:"-"`
	// Enabled - Allow users to sign up on a developer portal.
	Enabled *bool `json:"enabled,omitempty"`
	// TermsOfService - Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties `json:"termsOfService,omitempty"`
}

// ProductCollection paged Products list representation.
type ProductCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ProductContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductCollectionIterator provides access to a complete listing of ProductContract values.
type ProductCollectionIterator struct {
	i    int
	page ProductCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductCollectionIterator) Response() ProductCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductCollectionIterator) Value() ProductContract {
	if !iter.page.NotDone() {
		return ProductContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductCollectionIterator type.
func NewProductCollectionIterator(page ProductCollectionPage) ProductCollectionIterator {
	return ProductCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProductCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pc ProductCollection) hasNextLink() bool {
	return pc.NextLink != nil && len(*pc.NextLink) != 0
}

// productCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProductCollection) productCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProductCollectionPage contains a page of ProductContract values.
type ProductCollectionPage struct {
	fn func(context.Context, ProductCollection) (ProductCollection, error)
	pc ProductCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pc)
		if err != nil {
			return err
		}
		page.pc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductCollectionPage) Response() ProductCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductCollectionPage) Values() []ProductContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the ProductCollectionPage type.
func NewProductCollectionPage(getNextPage func(context.Context, ProductCollection) (ProductCollection, error)) ProductCollectionPage {
	return ProductCollectionPage{fn: getNextPage}
}

// ProductContract product details.
type ProductContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Product entity.
	ID *string `json:"id,omitempty"`
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductContractProperties product profile.
type ProductContractProperties struct {
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductEntityBaseParameters product Entity Base Parameters
type ProductEntityBaseParameters struct {
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductUpdateParameters parameters supplied to the Update Product operation.
type ProductUpdateParameters struct {
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// PropertyCollection paged Property list representation.
type PropertyCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]PropertyContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PropertyCollectionIterator provides access to a complete listing of PropertyContract values.
type PropertyCollectionIterator struct {
	i    int
	page PropertyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PropertyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PropertyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PropertyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PropertyCollectionIterator) Response() PropertyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PropertyCollectionIterator) Value() PropertyContract {
	if !iter.page.NotDone() {
		return PropertyContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PropertyCollectionIterator type.
func NewPropertyCollectionIterator(page PropertyCollectionPage) PropertyCollectionIterator {
	return PropertyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PropertyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pc PropertyCollection) hasNextLink() bool {
	return pc.NextLink != nil && len(*pc.NextLink) != 0
}

// propertyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PropertyCollection) propertyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PropertyCollectionPage contains a page of PropertyContract values.
type PropertyCollectionPage struct {
	fn func(context.Context, PropertyCollection) (PropertyCollection, error)
	pc PropertyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PropertyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pc)
		if err != nil {
			return err
		}
		page.pc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PropertyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PropertyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PropertyCollectionPage) Response() PropertyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PropertyCollectionPage) Values() []PropertyContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the PropertyCollectionPage type.
func NewPropertyCollectionPage(getNextPage func(context.Context, PropertyCollection) (PropertyCollection, error)) PropertyCollectionPage {
	return PropertyCollectionPage{fn: getNextPage}
}

// PropertyContract property details.
type PropertyContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Property.
	ID *string `json:"id,omitempty"`
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyContractProperties property Contract properties.
type PropertyContractProperties struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyEntityBaseParameters property Entity Base Parameters set.
type PropertyEntityBaseParameters struct {
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyUpdateParameters property Contract properties.
type PropertyUpdateParameters struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// QuotaCounterCollection paged Quota Counter list representation.
type QuotaCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Quota counter values.
	Value *[]QuotaCounterContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaCounterContract quota counter details.
type QuotaCounterContract struct {
	autorest.Response `json:"-"`
	// CounterKey - The Key value of the Counter. Must not be empty.
	CounterKey *string `json:"counterKey,omitempty"`
	// PeriodKey - Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string `json:"periodKey,omitempty"`
	// PeriodStartTime - The date of the start of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodStartTime *date.Time `json:"periodStartTime,omitempty"`
	// PeriodEndTime - The date of the end of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodEndTime *date.Time `json:"periodEndTime,omitempty"`
	// Value - Quota Value Properties
	Value *QuotaCounterValueContractProperties `json:"Value,omitempty"`
}

// QuotaCounterValueContract quota counter value details.
type QuotaCounterValueContract struct {
	// QuotaCounterValueContractProperties - Quota counter Value Properties.
	*QuotaCounterValueContractProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaCounterValueContract.
func (qcvc QuotaCounterValueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qcvc.QuotaCounterValueContractProperties != nil {
		objectMap["value"] = qcvc.QuotaCounterValueContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaCounterValueContract struct.
func (qcvc *QuotaCounterValueContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				var quotaCounterValueContractProperties QuotaCounterValueContractProperties
				err = json.Unmarshal(*v, &quotaCounterValueContractProperties)
				if err != nil {
					return err
				}
				qcvc.QuotaCounterValueContractProperties = &quotaCounterValueContractProperties
			}
		}
	}

	return nil
}

// QuotaCounterValueContractProperties quota counter value details.
type QuotaCounterValueContractProperties struct {
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// RegionContract region profile.
type RegionContract struct {
	// Name - READ-ONLY; Region name.
	Name *string `json:"name,omitempty"`
	// IsMasterRegion - whether Region is the master region.
	IsMasterRegion *bool `json:"isMasterRegion,omitempty"`
	// IsDeleted - whether Region is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty"`
}

// MarshalJSON is the custom marshaler for RegionContract.
func (rc RegionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rc.IsMasterRegion != nil {
		objectMap["isMasterRegion"] = rc.IsMasterRegion
	}
	if rc.IsDeleted != nil {
		objectMap["isDeleted"] = rc.IsDeleted
	}
	return json.Marshal(objectMap)
}

// RegionListResult lists Regions operation response details.
type RegionListResult struct {
	autorest.Response `json:"-"`
	// Value - Lists of Regions.
	Value *[]RegionContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegistrationDelegationSettingsProperties user registration delegation settings properties.
type RegistrationDelegationSettingsProperties struct {
	// Enabled - Enable or disable delegation for user registration.
	Enabled *bool `json:"enabled,omitempty"`
}

// ReportCollection paged Report records list representation.
type ReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ReportRecordContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReportCollectionIterator provides access to a complete listing of ReportRecordContract values.
type ReportCollectionIterator struct {
	i    int
	page ReportCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReportCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReportCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReportCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReportCollectionIterator) Response() ReportCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReportCollectionIterator) Value() ReportRecordContract {
	if !iter.page.NotDone() {
		return ReportRecordContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReportCollectionIterator type.
func NewReportCollectionIterator(page ReportCollectionPage) ReportCollectionIterator {
	return ReportCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ReportCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rc ReportCollection) hasNextLink() bool {
	return rc.NextLink != nil && len(*rc.NextLink) != 0
}

// reportCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ReportCollection) reportCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ReportCollectionPage contains a page of ReportRecordContract values.
type ReportCollectionPage struct {
	fn func(context.Context, ReportCollection) (ReportCollection, error)
	rc ReportCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReportCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rc)
		if err != nil {
			return err
		}
		page.rc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReportCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReportCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReportCollectionPage) Response() ReportCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReportCollectionPage) Values() []ReportRecordContract {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the ReportCollectionPage type.
func NewReportCollectionPage(getNextPage func(context.Context, ReportCollection) (ReportCollection, error)) ReportCollectionPage {
	return ReportCollectionPage{fn: getNextPage}
}

// ReportRecordContract report data.
type ReportRecordContract struct {
	// Name - Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string `json:"name,omitempty"`
	// Timestamp - Start of aggregation period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Interval - Length of aggregation period.  Interval must be multiple of 15 minutes and may not be zero. The value should be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	Interval *string `json:"interval,omitempty"`
	// Country - Country to which this record data is related.
	Country *string `json:"country,omitempty"`
	// Region - Country region to which this record data is related.
	Region *string `json:"region,omitempty"`
	// Zip - Zip code to which this record data is related.
	Zip *string `json:"zip,omitempty"`
	// UserID - READ-ONLY; User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// ProductID - READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// APIRegion - API region identifier.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// CallCountSuccess - Number of successful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect
	CallCountSuccess *int32 `json:"callCountSuccess,omitempty"`
	// CallCountBlocked - Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests
	CallCountBlocked *int32 `json:"callCountBlocked,omitempty"`
	// CallCountFailed - Number of calls failed due to proxy or backend errors. This includes calls returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600
	CallCountFailed *int32 `json:"callCountFailed,omitempty"`
	// CallCountOther - Number of other calls.
	CallCountOther *int32 `json:"callCountOther,omitempty"`
	// CallCountTotal - Total number of calls.
	CallCountTotal *int32 `json:"callCountTotal,omitempty"`
	// Bandwidth - Bandwidth consumed.
	Bandwidth *int64 `json:"bandwidth,omitempty"`
	// CacheHitCount - Number of times when content was served from cache policy.
	CacheHitCount *int32 `json:"cacheHitCount,omitempty"`
	// CacheMissCount - Number of times content was fetched from backend.
	CacheMissCount *int32 `json:"cacheMissCount,omitempty"`
	// APITimeAvg - Average time it took to process request.
	APITimeAvg *float64 `json:"apiTimeAvg,omitempty"`
	// APITimeMin - Minimum time it took to process request.
	APITimeMin *float64 `json:"apiTimeMin,omitempty"`
	// APITimeMax - Maximum time it took to process request.
	APITimeMax *float64 `json:"apiTimeMax,omitempty"`
	// ServiceTimeAvg - Average time it took to process request on backend.
	ServiceTimeAvg *float64 `json:"serviceTimeAvg,omitempty"`
	// ServiceTimeMin - Minimum time it took to process request on backend.
	ServiceTimeMin *float64 `json:"serviceTimeMin,omitempty"`
	// ServiceTimeMax - Maximum time it took to process request on backend.
	ServiceTimeMax *float64 `json:"serviceTimeMax,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportRecordContract.
func (rrc ReportRecordContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrc.Name != nil {
		objectMap["name"] = rrc.Name
	}
	if rrc.Timestamp != nil {
		objectMap["timestamp"] = rrc.Timestamp
	}
	if rrc.Interval != nil {
		objectMap["interval"] = rrc.Interval
	}
	if rrc.Country != nil {
		objectMap["country"] = rrc.Country
	}
	if rrc.Region != nil {
		objectMap["region"] = rrc.Region
	}
	if rrc.Zip != nil {
		objectMap["zip"] = rrc.Zip
	}
	if rrc.APIID != nil {
		objectMap["apiId"] = rrc.APIID
	}
	if rrc.OperationID != nil {
		objectMap["operationId"] = rrc.OperationID
	}
	if rrc.APIRegion != nil {
		objectMap["apiRegion"] = rrc.APIRegion
	}
	if rrc.SubscriptionID != nil {
		objectMap["subscriptionId"] = rrc.SubscriptionID
	}
	if rrc.CallCountSuccess != nil {
		objectMap["callCountSuccess"] = rrc.CallCountSuccess
	}
	if rrc.CallCountBlocked != nil {
		objectMap["callCountBlocked"] = rrc.CallCountBlocked
	}
	if rrc.CallCountFailed != nil {
		objectMap["callCountFailed"] = rrc.CallCountFailed
	}
	if rrc.CallCountOther != nil {
		objectMap["callCountOther"] = rrc.CallCountOther
	}
	if rrc.CallCountTotal != nil {
		objectMap["callCountTotal"] = rrc.CallCountTotal
	}
	if rrc.Bandwidth != nil {
		objectMap["bandwidth"] = rrc.Bandwidth
	}
	if rrc.CacheHitCount != nil {
		objectMap["cacheHitCount"] = rrc.CacheHitCount
	}
	if rrc.CacheMissCount != nil {
		objectMap["cacheMissCount"] = rrc.CacheMissCount
	}
	if rrc.APITimeAvg != nil {
		objectMap["apiTimeAvg"] = rrc.APITimeAvg
	}
	if rrc.APITimeMin != nil {
		objectMap["apiTimeMin"] = rrc.APITimeMin
	}
	if rrc.APITimeMax != nil {
		objectMap["apiTimeMax"] = rrc.APITimeMax
	}
	if rrc.ServiceTimeAvg != nil {
		objectMap["serviceTimeAvg"] = rrc.ServiceTimeAvg
	}
	if rrc.ServiceTimeMin != nil {
		objectMap["serviceTimeMin"] = rrc.ServiceTimeMin
	}
	if rrc.ServiceTimeMax != nil {
		objectMap["serviceTimeMax"] = rrc.ServiceTimeMax
	}
	return json.Marshal(objectMap)
}

// RepresentationContract operation request/response representation details.
type RepresentationContract struct {
	// ContentType - Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string `json:"contentType,omitempty"`
	// Sample - An example of the representation.
	Sample *string `json:"sample,omitempty"`
	// SchemaID - Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	SchemaID *string `json:"schemaId,omitempty"`
	// TypeName - Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	TypeName *string `json:"typeName,omitempty"`
	// FormParameters - Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
	FormParameters *[]ParameterContract `json:"formParameters,omitempty"`
}

// RequestContract operation request details.
type RequestContract struct {
	// Description - Operation request description.
	Description *string `json:"description,omitempty"`
	// QueryParameters - Collection of operation request query parameters.
	QueryParameters *[]ParameterContract `json:"queryParameters,omitempty"`
	// Headers - Collection of operation request headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
	// Representations - Collection of operation request representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// RequestReportCollection paged Report records list representation.
type RequestReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]RequestReportRecordContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
}

// RequestReportRecordContract request Report data.
type RequestReportRecordContract struct {
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// ProductID - READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// UserID - READ-ONLY; User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// Method - The HTTP method associated with this request..
	Method *string `json:"method,omitempty"`
	// URL - The full URL associated with this request.
	URL *string `json:"url,omitempty"`
	// IPAddress - The client IP address associated with this request.
	IPAddress *string `json:"ipAddress,omitempty"`
	// BackendResponseCode - The HTTP status code received by the gateway as a result of forwarding this request to the backend.
	BackendResponseCode *string `json:"backendResponseCode,omitempty"`
	// ResponseCode - The HTTP status code returned by the gateway.
	ResponseCode *int32 `json:"responseCode,omitempty"`
	// ResponseSize - The size of the response returned by the gateway.
	ResponseSize *int32 `json:"responseSize,omitempty"`
	// Timestamp - The date and time when this request was received by the gateway in ISO 8601 format.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Cache - Specifies if response cache was involved in generating the response. If the value is none, the cache was not used. If the value is hit, cached response was returned. If the value is miss, the cache was used but lookup resulted in a miss and request was fulfilled by the backend.
	Cache *string `json:"cache,omitempty"`
	// APITime - The total time it took to process this request.
	APITime *float64 `json:"apiTime,omitempty"`
	// ServiceTime - he time it took to forward this request to the backend and get the response back.
	ServiceTime *float64 `json:"serviceTime,omitempty"`
	// APIRegion - Azure region where the gateway that processed this request is located.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// RequestID - Request Identifier.
	RequestID *string `json:"requestId,omitempty"`
	// RequestSize - The size of this request..
	RequestSize *int32 `json:"requestSize,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestReportRecordContract.
func (rrrc RequestReportRecordContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrrc.APIID != nil {
		objectMap["apiId"] = rrrc.APIID
	}
	if rrrc.OperationID != nil {
		objectMap["operationId"] = rrrc.OperationID
	}
	if rrrc.Method != nil {
		objectMap["method"] = rrrc.Method
	}
	if rrrc.URL != nil {
		objectMap["url"] = rrrc.URL
	}
	if rrrc.IPAddress != nil {
		objectMap["ipAddress"] = rrrc.IPAddress
	}
	if rrrc.BackendResponseCode != nil {
		objectMap["backendResponseCode"] = rrrc.BackendResponseCode
	}
	if rrrc.ResponseCode != nil {
		objectMap["responseCode"] = rrrc.ResponseCode
	}
	if rrrc.ResponseSize != nil {
		objectMap["responseSize"] = rrrc.ResponseSize
	}
	if rrrc.Timestamp != nil {
		objectMap["timestamp"] = rrrc.Timestamp
	}
	if rrrc.Cache != nil {
		objectMap["cache"] = rrrc.Cache
	}
	if rrrc.APITime != nil {
		objectMap["apiTime"] = rrrc.APITime
	}
	if rrrc.ServiceTime != nil {
		objectMap["serviceTime"] = rrrc.ServiceTime
	}
	if rrrc.APIRegion != nil {
		objectMap["apiRegion"] = rrrc.APIRegion
	}
	if rrrc.SubscriptionID != nil {
		objectMap["subscriptionId"] = rrrc.SubscriptionID
	}
	if rrrc.RequestID != nil {
		objectMap["requestId"] = rrrc.RequestID
	}
	if rrrc.RequestSize != nil {
		objectMap["requestSize"] = rrrc.RequestSize
	}
	return json.Marshal(objectMap)
}

// ResponseContract operation response details.
type ResponseContract struct {
	// StatusCode - Operation response HTTP status code.
	StatusCode *int32 `json:"statusCode,omitempty"`
	// Description - Operation response description.
	Description *string `json:"description,omitempty"`
	// Representations - Collection of operation response representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
	// Headers - Collection of operation response headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
}

// SaveConfigurationParameter parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameter struct {
	// Branch - The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string `json:"branch,omitempty"`
	// Force - The value if true, the current configuration database is committed to the Git repository, even if the Git repository has newer changes that would be overwritten.
	Force *bool `json:"force,omitempty"`
}

// SchemaCollection the response of the list schema operation.
type SchemaCollection struct {
	autorest.Response `json:"-"`
	// Value - Api Schema Contract value.
	Value *[]SchemaContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SchemaCollectionIterator provides access to a complete listing of SchemaContract values.
type SchemaCollectionIterator struct {
	i    int
	page SchemaCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SchemaCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchemaCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SchemaCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SchemaCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SchemaCollectionIterator) Response() SchemaCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SchemaCollectionIterator) Value() SchemaContract {
	if !iter.page.NotDone() {
		return SchemaContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SchemaCollectionIterator type.
func NewSchemaCollectionIterator(page SchemaCollectionPage) SchemaCollectionIterator {
	return SchemaCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SchemaCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc SchemaCollection) hasNextLink() bool {
	return sc.NextLink != nil && len(*sc.NextLink) != 0
}

// schemaCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SchemaCollection) schemaCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SchemaCollectionPage contains a page of SchemaContract values.
type SchemaCollectionPage struct {
	fn func(context.Context, SchemaCollection) (SchemaCollection, error)
	sc SchemaCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SchemaCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchemaCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SchemaCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SchemaCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SchemaCollectionPage) Response() SchemaCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SchemaCollectionPage) Values() []SchemaContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SchemaCollectionPage type.
func NewSchemaCollectionPage(getNextPage func(context.Context, SchemaCollection) (SchemaCollection, error)) SchemaCollectionPage {
	return SchemaCollectionPage{fn: getNextPage}
}

// SchemaContract schema Contract details.
type SchemaContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Schema.
	ID *string `json:"id,omitempty"`
	// ContentType - Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml).
	ContentType *string `json:"contentType,omitempty"`
	// SchemaDocumentProperties - Properties of the Schema Document.
	*SchemaDocumentProperties `json:"document,omitempty"`
}

// SchemaContractProperties schema contract Properties.
type SchemaContractProperties struct {
	// ContentType - Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml).
	ContentType *string `json:"contentType,omitempty"`
	// SchemaDocumentProperties - Properties of the Schema Document.
	*SchemaDocumentProperties `json:"document,omitempty"`
}

// MarshalJSON is the custom marshaler for SchemaContractProperties.
func (scp SchemaContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ContentType != nil {
		objectMap["contentType"] = scp.ContentType
	}
	if scp.SchemaDocumentProperties != nil {
		objectMap["document"] = scp.SchemaDocumentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SchemaContractProperties struct.
func (scp *SchemaContractProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentType":
			if v != nil {
				var contentType string
				err = json.Unmarshal(*v, &contentType)
				if err != nil {
					return err
				}
				scp.ContentType = &contentType
			}
		case "document":
			if v != nil {
				var schemaDocumentProperties SchemaDocumentProperties
				err = json.Unmarshal(*v, &schemaDocumentProperties)
				if err != nil {
					return err
				}
				scp.SchemaDocumentProperties = &schemaDocumentProperties
			}
		}
	}

	return nil
}

// SchemaDocumentProperties schema Document Properties.
type SchemaDocumentProperties struct {
	// Value - Json escaped string defining the document representing the Schema.
	Value *string `json:"value,omitempty"`
}

// SubscriptionCollection paged Subscriptions list representation.
type SubscriptionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]SubscriptionContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionCollectionIterator provides access to a complete listing of SubscriptionContract values.
type SubscriptionCollectionIterator struct {
	i    int
	page SubscriptionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionCollectionIterator) Response() SubscriptionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionCollectionIterator) Value() SubscriptionContract {
	if !iter.page.NotDone() {
		return SubscriptionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionCollectionIterator type.
func NewSubscriptionCollectionIterator(page SubscriptionCollectionPage) SubscriptionCollectionIterator {
	return SubscriptionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SubscriptionCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc SubscriptionCollection) hasNextLink() bool {
	return sc.NextLink != nil && len(*sc.NextLink) != 0
}

// subscriptionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SubscriptionCollection) subscriptionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SubscriptionCollectionPage contains a page of SubscriptionContract values.
type SubscriptionCollectionPage struct {
	fn func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)
	sc SubscriptionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionCollectionPage) Response() SubscriptionCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionCollectionPage) Values() []SubscriptionContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SubscriptionCollectionPage type.
func NewSubscriptionCollectionPage(getNextPage func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)) SubscriptionCollectionPage {
	return SubscriptionCollectionPage{fn: getNextPage}
}

// SubscriptionContract subscription details.
type SubscriptionContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the Subscription.
	ID *string `json:"id,omitempty"`
	// UserID - The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{uid} where {uid} is a user identifier.
	UserID *string `json:"userId,omitempty"`
	// ProductID - The product resource identifier of the subscribed product. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ProductID *string `json:"productId,omitempty"`
	// Name - The name of the subscription, or null if the subscription has no name.
	Name *string `json:"name,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
	// CreatedDate - READ-ONLY; Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// StartDate - Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// EndDate - Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	EndDate *date.Time `json:"endDate,omitempty"`
	// NotificationDate - Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	NotificationDate *date.Time `json:"notificationDate,omitempty"`
	// PrimaryKey - Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// StateComment - Optional subscription comment added by an administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionContract.
func (sc SubscriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.UserID != nil {
		objectMap["userId"] = sc.UserID
	}
	if sc.ProductID != nil {
		objectMap["productId"] = sc.ProductID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.State != "" {
		objectMap["state"] = sc.State
	}
	if sc.StartDate != nil {
		objectMap["startDate"] = sc.StartDate
	}
	if sc.ExpirationDate != nil {
		objectMap["expirationDate"] = sc.ExpirationDate
	}
	if sc.EndDate != nil {
		objectMap["endDate"] = sc.EndDate
	}
	if sc.NotificationDate != nil {
		objectMap["notificationDate"] = sc.NotificationDate
	}
	if sc.PrimaryKey != nil {
		objectMap["primaryKey"] = sc.PrimaryKey
	}
	if sc.SecondaryKey != nil {
		objectMap["secondaryKey"] = sc.SecondaryKey
	}
	if sc.StateComment != nil {
		objectMap["stateComment"] = sc.StateComment
	}
	return json.Marshal(objectMap)
}

// SubscriptionContractProperties subscription details.
type SubscriptionContractProperties struct {
	// UserID - The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{uid} where {uid} is a user identifier.
	UserID *string `json:"userId,omitempty"`
	// ProductID - The product resource identifier of the subscribed product. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ProductID *string `json:"productId,omitempty"`
	// Name - The name of the subscription, or null if the subscription has no name.
	Name *string `json:"name,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
	// CreatedDate - READ-ONLY; Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// StartDate - Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// EndDate - Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	EndDate *date.Time `json:"endDate,omitempty"`
	// NotificationDate - Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	NotificationDate *date.Time `json:"notificationDate,omitempty"`
	// PrimaryKey - Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// StateComment - Optional subscription comment added by an administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionContractProperties.
func (scp SubscriptionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.UserID != nil {
		objectMap["userId"] = scp.UserID
	}
	if scp.ProductID != nil {
		objectMap["productId"] = scp.ProductID
	}
	if scp.Name != nil {
		objectMap["name"] = scp.Name
	}
	if scp.State != "" {
		objectMap["state"] = scp.State
	}
	if scp.StartDate != nil {
		objectMap["startDate"] = scp.StartDate
	}
	if scp.ExpirationDate != nil {
		objectMap["expirationDate"] = scp.ExpirationDate
	}
	if scp.EndDate != nil {
		objectMap["endDate"] = scp.EndDate
	}
	if scp.NotificationDate != nil {
		objectMap["notificationDate"] = scp.NotificationDate
	}
	if scp.PrimaryKey != nil {
		objectMap["primaryKey"] = scp.PrimaryKey
	}
	if scp.SecondaryKey != nil {
		objectMap["secondaryKey"] = scp.SecondaryKey
	}
	if scp.StateComment != nil {
		objectMap["stateComment"] = scp.StateComment
	}
	return json.Marshal(objectMap)
}

// SubscriptionCreateParameters parameters supplied to the Create subscription operation.
type SubscriptionCreateParameters struct {
	// UserID - User (user id path) for whom subscription is being created in form /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product (product id path) for which subscription is being created in form /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
}

// SubscriptionKeyParameterNamesContract subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Header - Subscription key header name.
	Header *string `json:"header,omitempty"`
	// Query - Subscription key query string parameter name.
	Query *string `json:"query,omitempty"`
}

// SubscriptionsDelegationSettingsProperties subscriptions delegation settings properties.
type SubscriptionsDelegationSettingsProperties struct {
	// Enabled - Enable or disable delegation for subscriptions.
	Enabled *bool `json:"enabled,omitempty"`
}

// SubscriptionUpdateParameters parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameters struct {
	// UserID - User identifier path: /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path: /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// ExpirationDate - Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
	// StateComment - Comments describing subscription state change by the administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// TenantConfigurationDeployFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationDeployFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationDeployFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationDeployFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.DeployResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TenantConfigurationSaveFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationSaveFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationSaveFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationSaveFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.SaveResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TenantConfigurationSyncStateContract tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContract struct {
	autorest.Response `json:"-"`
	// Branch - The name of Git branch.
	Branch *string `json:"branch,omitempty"`
	// CommitID - The latest commit Id.
	CommitID *string `json:"commitId,omitempty"`
	// IsExport - value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool `json:"isExport,omitempty"`
	// IsSynced - value indicating if last synchronization was later than the configuration change.
	IsSynced *bool `json:"isSynced,omitempty"`
	// IsGitEnabled - value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool `json:"isGitEnabled,omitempty"`
	// SyncDate - The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	SyncDate *date.Time `json:"syncDate,omitempty"`
	// ConfigurationChangeDate - The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ConfigurationChangeDate *date.Time `json:"configurationChangeDate,omitempty"`
}

// TenantConfigurationValidateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationValidateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationValidateFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationValidateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.ValidateResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TermsOfServiceProperties terms of service contract properties.
type TermsOfServiceProperties struct {
	// Text - A terms of service text.
	Text *string `json:"text,omitempty"`
	// Enabled - Display terms of service during a sign-up process.
	Enabled *bool `json:"enabled,omitempty"`
	// ConsentRequired - Ask user for consent to the terms of service.
	ConsentRequired *bool `json:"consentRequired,omitempty"`
}

// TokenBodyParameterContract oAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// Name - body parameter name.
	Name *string `json:"name,omitempty"`
	// Value - body parameter value.
	Value *string `json:"value,omitempty"`
}

// UserCollection paged Users list representation.
type UserCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]UserContract `json:"value,omitempty"`
	// Count - Total number of entities
	Count *int32 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserCollectionIterator provides access to a complete listing of UserContract values.
type UserCollectionIterator struct {
	i    int
	page UserCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserCollectionIterator) Response() UserCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserCollectionIterator) Value() UserContract {
	if !iter.page.NotDone() {
		return UserContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserCollectionIterator type.
func NewUserCollectionIterator(page UserCollectionPage) UserCollectionIterator {
	return UserCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UserCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uc UserCollection) hasNextLink() bool {
	return uc.NextLink != nil && len(*uc.NextLink) != 0
}

// userCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UserCollection) userCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !uc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UserCollectionPage contains a page of UserContract values.
type UserCollectionPage struct {
	fn func(context.Context, UserCollection) (UserCollection, error)
	uc UserCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uc)
		if err != nil {
			return err
		}
		page.uc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserCollectionPage) Response() UserCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserCollectionPage) Values() []UserContract {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UserCollectionPage type.
func NewUserCollectionPage(getNextPage func(context.Context, UserCollection) (UserCollection, error)) UserCollectionPage {
	return UserCollectionPage{fn: getNextPage}
}

// UserContract user details.
type UserContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the entity.
	ID *string `json:"id,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// RegistrationDate - Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// Groups - READ-ONLY; Collection of groups user is part of.
	Groups *[]GroupContract `json:"groups,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserContract.
func (uc UserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uc.ID != nil {
		objectMap["id"] = uc.ID
	}
	if uc.FirstName != nil {
		objectMap["firstName"] = uc.FirstName
	}
	if uc.LastName != nil {
		objectMap["lastName"] = uc.LastName
	}
	if uc.Email != nil {
		objectMap["email"] = uc.Email
	}
	if uc.RegistrationDate != nil {
		objectMap["registrationDate"] = uc.RegistrationDate
	}
	if uc.State != "" {
		objectMap["state"] = uc.State
	}
	if uc.Note != nil {
		objectMap["note"] = uc.Note
	}
	return json.Marshal(objectMap)
}

// UserContractProperties user profile.
type UserContractProperties struct {
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// RegistrationDate - Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// Groups - READ-ONLY; Collection of groups user is part of.
	Groups *[]GroupContract `json:"groups,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserContractProperties.
func (ucp UserContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucp.FirstName != nil {
		objectMap["firstName"] = ucp.FirstName
	}
	if ucp.LastName != nil {
		objectMap["lastName"] = ucp.LastName
	}
	if ucp.Email != nil {
		objectMap["email"] = ucp.Email
	}
	if ucp.RegistrationDate != nil {
		objectMap["registrationDate"] = ucp.RegistrationDate
	}
	if ucp.State != "" {
		objectMap["state"] = ucp.State
	}
	if ucp.Note != nil {
		objectMap["note"] = ucp.Note
	}
	return json.Marshal(objectMap)
}

// UserCreateParameters parameters supplied to the Create User operation.
type UserCreateParameters struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Password - User Password. If no value is provided, a default password is generated.
	Password *string `json:"password,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserCreateParameters.
func (ucp UserCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucp.Email != nil {
		objectMap["email"] = ucp.Email
	}
	if ucp.FirstName != nil {
		objectMap["firstName"] = ucp.FirstName
	}
	if ucp.LastName != nil {
		objectMap["lastName"] = ucp.LastName
	}
	if ucp.Password != nil {
		objectMap["password"] = ucp.Password
	}
	if ucp.State != "" {
		objectMap["state"] = ucp.State
	}
	if ucp.Note != nil {
		objectMap["note"] = ucp.Note
	}
	return json.Marshal(objectMap)
}

// UserEntityBaseParameters user Entity Base Parameters set.
type UserEntityBaseParameters struct {
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserEntityBaseParameters.
func (uebp UserEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uebp.State != "" {
		objectMap["state"] = uebp.State
	}
	if uebp.Note != nil {
		objectMap["note"] = uebp.Note
	}
	return json.Marshal(objectMap)
}

// UserIdentityCollection list of Users Identity list representation.
type UserIdentityCollection struct {
	autorest.Response `json:"-"`
	// Value - User Identity values.
	Value *[]UserIdentityContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserIdentityContract user identity details.
type UserIdentityContract struct {
	// Provider - Identity provider name.
	Provider *string `json:"provider,omitempty"`
	// ID - Identifier value within provider.
	ID *string `json:"id,omitempty"`
}

// UserTokenParameters parameters supplied to the Get User Token operation.
type UserTokenParameters struct {
	// KeyType - The Key to be used to generate token for user. Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
	// Expiry - The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
}

// UserTokenResult get User Token response details.
type UserTokenResult struct {
	autorest.Response `json:"-"`
	// Value - Shared Access Authorization token for the User.
	Value *string `json:"value,omitempty"`
}

// UserUpdateParameters parameters supplied to the Update User operation.
type UserUpdateParameters struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// Password - User Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserUpdateParameters.
func (uup UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uup.Email != nil {
		objectMap["email"] = uup.Email
	}
	if uup.Password != nil {
		objectMap["password"] = uup.Password
	}
	if uup.FirstName != nil {
		objectMap["firstName"] = uup.FirstName
	}
	if uup.LastName != nil {
		objectMap["lastName"] = uup.LastName
	}
	if uup.State != "" {
		objectMap["state"] = uup.State
	}
	if uup.Note != nil {
		objectMap["note"] = uup.Note
	}
	return json.Marshal(objectMap)
}

// X509CertificateName properties of server X509Names.
type X509CertificateName struct {
	// Name - Common Name of the Certificate.
	Name *string `json:"name,omitempty"`
	// IssuerCertificateThumbprint - Thumbprint for the Issuer of the Certificate.
	IssuerCertificateThumbprint *string `json:"issuerCertificateThumbprint,omitempty"`
}
