package hybridnetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeDevicePropertiesFormat ...
	DeviceTypeDevicePropertiesFormat DeviceType = "DevicePropertiesFormat"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{DeviceTypeDevicePropertiesFormat}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
	// Unknown ...
	Unknown IPAllocationMethod = "Unknown"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static, Unknown}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPVersionIPv4 ...
	IPVersionIPv4 IPVersion = "IPv4"
	// IPVersionUnknown ...
	IPVersionUnknown IPVersion = "Unknown"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPVersionIPv4, IPVersionUnknown}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// OperatingSystemTypesLinux ...
	OperatingSystemTypesLinux OperatingSystemTypes = "Linux"
	// OperatingSystemTypesUnknown ...
	OperatingSystemTypesUnknown OperatingSystemTypes = "Unknown"
	// OperatingSystemTypesWindows ...
	OperatingSystemTypesWindows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{OperatingSystemTypesLinux, OperatingSystemTypesUnknown, OperatingSystemTypesWindows}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleted ...
	ProvisioningStateDeleted ProvisioningState = "Deleted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUnknown ...
	ProvisioningStateUnknown ProvisioningState = "Unknown"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateDeleted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUnknown}
}

// SkuDeploymentMode enumerates the values for sku deployment mode.
type SkuDeploymentMode string

const (
	// SkuDeploymentModeAzure ...
	SkuDeploymentModeAzure SkuDeploymentMode = "Azure"
	// SkuDeploymentModePrivateEdgeZone ...
	SkuDeploymentModePrivateEdgeZone SkuDeploymentMode = "PrivateEdgeZone"
	// SkuDeploymentModeUnknown ...
	SkuDeploymentModeUnknown SkuDeploymentMode = "Unknown"
)

// PossibleSkuDeploymentModeValues returns an array of possible values for the SkuDeploymentMode const type.
func PossibleSkuDeploymentModeValues() []SkuDeploymentMode {
	return []SkuDeploymentMode{SkuDeploymentModeAzure, SkuDeploymentModePrivateEdgeZone, SkuDeploymentModeUnknown}
}

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// SkuTypeEvolvedPacketCore ...
	SkuTypeEvolvedPacketCore SkuType = "EvolvedPacketCore"
	// SkuTypeSDWAN ...
	SkuTypeSDWAN SkuType = "SDWAN"
	// SkuTypeUnknown ...
	SkuTypeUnknown SkuType = "Unknown"
)

// PossibleSkuTypeValues returns an array of possible values for the SkuType const type.
func PossibleSkuTypeValues() []SkuType {
	return []SkuType{SkuTypeEvolvedPacketCore, SkuTypeSDWAN, SkuTypeUnknown}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusNotRegistered ...
	StatusNotRegistered Status = "NotRegistered"
	// StatusRegistered ...
	StatusRegistered Status = "Registered"
	// StatusUnknown ...
	StatusUnknown Status = "Unknown"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusNotRegistered, StatusRegistered, StatusUnknown}
}

// VendorProvisioningState enumerates the values for vendor provisioning state.
type VendorProvisioningState string

const (
	// VendorProvisioningStateDeprovisioned ...
	VendorProvisioningStateDeprovisioned VendorProvisioningState = "Deprovisioned"
	// VendorProvisioningStateNotProvisioned ...
	VendorProvisioningStateNotProvisioned VendorProvisioningState = "NotProvisioned"
	// VendorProvisioningStateProvisioned ...
	VendorProvisioningStateProvisioned VendorProvisioningState = "Provisioned"
	// VendorProvisioningStateProvisioning ...
	VendorProvisioningStateProvisioning VendorProvisioningState = "Provisioning"
	// VendorProvisioningStateUnknown ...
	VendorProvisioningStateUnknown VendorProvisioningState = "Unknown"
	// VendorProvisioningStateUserDataValidationFailed ...
	VendorProvisioningStateUserDataValidationFailed VendorProvisioningState = "UserDataValidationFailed"
)

// PossibleVendorProvisioningStateValues returns an array of possible values for the VendorProvisioningState const type.
func PossibleVendorProvisioningStateValues() []VendorProvisioningState {
	return []VendorProvisioningState{VendorProvisioningStateDeprovisioned, VendorProvisioningStateNotProvisioned, VendorProvisioningStateProvisioned, VendorProvisioningStateProvisioning, VendorProvisioningStateUnknown, VendorProvisioningStateUserDataValidationFailed}
}

// VHDType enumerates the values for vhd type.
type VHDType string

const (
	// VHDTypeUnknown ...
	VHDTypeUnknown VHDType = "Unknown"
	// VHDTypeVHD ...
	VHDTypeVHD VHDType = "VHD"
	// VHDTypeVHDX ...
	VHDTypeVHDX VHDType = "VHDX"
)

// PossibleVHDTypeValues returns an array of possible values for the VHDType const type.
func PossibleVHDTypeValues() []VHDType {
	return []VHDType{VHDTypeUnknown, VHDTypeVHD, VHDTypeVHDX}
}

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// VirtualMachineSizeTypesStandardD11V2 ...
	VirtualMachineSizeTypesStandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// VirtualMachineSizeTypesStandardD12V2 ...
	VirtualMachineSizeTypesStandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// VirtualMachineSizeTypesStandardD13V2 ...
	VirtualMachineSizeTypesStandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// VirtualMachineSizeTypesStandardD1V2 ...
	VirtualMachineSizeTypesStandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// VirtualMachineSizeTypesStandardD2V2 ...
	VirtualMachineSizeTypesStandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// VirtualMachineSizeTypesStandardD3V2 ...
	VirtualMachineSizeTypesStandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// VirtualMachineSizeTypesStandardD4V2 ...
	VirtualMachineSizeTypesStandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// VirtualMachineSizeTypesStandardD5V2 ...
	VirtualMachineSizeTypesStandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// VirtualMachineSizeTypesStandardDS11V2 ...
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// VirtualMachineSizeTypesStandardDS12V2 ...
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// VirtualMachineSizeTypesStandardDS13V2 ...
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// VirtualMachineSizeTypesStandardDS1V2 ...
	VirtualMachineSizeTypesStandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// VirtualMachineSizeTypesStandardDS2V2 ...
	VirtualMachineSizeTypesStandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// VirtualMachineSizeTypesStandardDS3V2 ...
	VirtualMachineSizeTypesStandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// VirtualMachineSizeTypesStandardDS4V2 ...
	VirtualMachineSizeTypesStandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// VirtualMachineSizeTypesStandardDS5V2 ...
	VirtualMachineSizeTypesStandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// VirtualMachineSizeTypesUnknown ...
	VirtualMachineSizeTypesUnknown VirtualMachineSizeTypes = "Unknown"
)

// PossibleVirtualMachineSizeTypesValues returns an array of possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{VirtualMachineSizeTypesStandardD11V2, VirtualMachineSizeTypesStandardD12V2, VirtualMachineSizeTypesStandardD13V2, VirtualMachineSizeTypesStandardD1V2, VirtualMachineSizeTypesStandardD2V2, VirtualMachineSizeTypesStandardD3V2, VirtualMachineSizeTypesStandardD4V2, VirtualMachineSizeTypesStandardD5V2, VirtualMachineSizeTypesStandardDS11V2, VirtualMachineSizeTypesStandardDS12V2, VirtualMachineSizeTypesStandardDS13V2, VirtualMachineSizeTypesStandardDS1V2, VirtualMachineSizeTypesStandardDS2V2, VirtualMachineSizeTypesStandardDS3V2, VirtualMachineSizeTypesStandardDS4V2, VirtualMachineSizeTypesStandardDS5V2, VirtualMachineSizeTypesUnknown}
}

// VirtualNetworkFunctionRoleConfigurationType enumerates the values for virtual network function role
// configuration type.
type VirtualNetworkFunctionRoleConfigurationType string

const (
	// VirtualNetworkFunctionRoleConfigurationTypeUnknown ...
	VirtualNetworkFunctionRoleConfigurationTypeUnknown VirtualNetworkFunctionRoleConfigurationType = "Unknown"
	// VirtualNetworkFunctionRoleConfigurationTypeVirtualMachine ...
	VirtualNetworkFunctionRoleConfigurationTypeVirtualMachine VirtualNetworkFunctionRoleConfigurationType = "VirtualMachine"
)

// PossibleVirtualNetworkFunctionRoleConfigurationTypeValues returns an array of possible values for the VirtualNetworkFunctionRoleConfigurationType const type.
func PossibleVirtualNetworkFunctionRoleConfigurationTypeValues() []VirtualNetworkFunctionRoleConfigurationType {
	return []VirtualNetworkFunctionRoleConfigurationType{VirtualNetworkFunctionRoleConfigurationTypeUnknown, VirtualNetworkFunctionRoleConfigurationTypeVirtualMachine}
}

// VMSwitchType enumerates the values for vm switch type.
type VMSwitchType string

const (
	// VMSwitchTypeInternal ...
	VMSwitchTypeInternal VMSwitchType = "Internal"
	// VMSwitchTypeLan ...
	VMSwitchTypeLan VMSwitchType = "Lan"
	// VMSwitchTypeManagement ...
	VMSwitchTypeManagement VMSwitchType = "Management"
	// VMSwitchTypeUnknown ...
	VMSwitchTypeUnknown VMSwitchType = "Unknown"
	// VMSwitchTypeWan ...
	VMSwitchTypeWan VMSwitchType = "Wan"
)

// PossibleVMSwitchTypeValues returns an array of possible values for the VMSwitchType const type.
func PossibleVMSwitchTypeValues() []VMSwitchType {
	return []VMSwitchType{VMSwitchTypeInternal, VMSwitchTypeLan, VMSwitchTypeManagement, VMSwitchTypeUnknown, VMSwitchTypeWan}
}
