package storagetables

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/storage/tables/2019-02-02-preview/storagetables"

// AccessPolicy an Access policy.
type AccessPolicy struct {
	// Start - The start datetime from which the policy is active.
	Start *date.Time `json:"Start,omitempty"`
	// Expiry - The datetime that the policy expires.
	Expiry *date.Time `json:"Expiry,omitempty"`
	// Permission - The permissions for the acl policy.
	Permission *string `json:"Permission,omitempty"`
}

// CorsRule CORS is an HTTP feature that enables a web application running under one domain to access resources
// in another domain. Web browsers implement a security restriction known as same-origin policy that prevents a
// web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin
// domain) to call APIs in another domain.
type CorsRule struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the service via CORS. The origin domain is the domain from which the request originates. Note that the origin must be an exact case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains to make requests via CORS.
	AllowedOrigins *string `json:"AllowedOrigins,omitempty"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods *string `json:"AllowedMethods,omitempty"`
	// AllowedHeaders - The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `json:"AllowedHeaders,omitempty"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
	ExposedHeaders *string `json:"ExposedHeaders,omitempty"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int32 `json:"MaxAgeInSeconds,omitempty"`
}

// GeoReplication ...
type GeoReplication struct {
	// Status - The status of the secondary location. Possible values include: 'Live', 'Bootstrap', 'Unavailable'
	Status GeoReplicationStatusType `json:"Status,omitempty"`
	// LastSyncTime - A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or may not be available for reads.
	LastSyncTime *date.TimeRFC1123 `json:"LastSyncTime,omitempty"`
}

// ListSignedIdentifier ...
type ListSignedIdentifier struct {
	autorest.Response `json:"-"`
	Value             *[]SignedIdentifier `json:"value,omitempty"`
}

// Logging azure Analytics Logging settings.
type Logging struct {
	// Version - The version of Analytics to configure.
	Version *string `json:"Version,omitempty"`
	// Delete - Indicates whether all delete requests should be logged.
	Delete *bool `json:"Delete,omitempty"`
	// Read - Indicates whether all read requests should be logged.
	Read *bool `json:"Read,omitempty"`
	// Write - Indicates whether all write requests should be logged.
	Write           *bool            `json:"Write,omitempty"`
	RetentionPolicy *RetentionPolicy `json:"RetentionPolicy,omitempty"`
}

// Metrics ...
type Metrics struct {
	// Version - The version of Analytics to configure.
	Version *string `json:"Version,omitempty"`
	// Enabled - Indicates whether metrics are enabled for the Table service.
	Enabled *bool `json:"Enabled,omitempty"`
	// IncludeAPIs - Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs     *bool            `json:"IncludeAPIs,omitempty"`
	RetentionPolicy *RetentionPolicy `json:"RetentionPolicy,omitempty"`
}

// RetentionPolicy the retention policy.
type RetentionPolicy struct {
	// Enabled - Indicates whether a retention policy is enabled for the service.
	Enabled *bool `json:"Enabled,omitempty"`
	// Days - Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than this value will be deleted.
	Days *int32 `json:"Days,omitempty"`
}

// SetSetObject ...
type SetSetObject struct {
	autorest.Response `json:"-"`
	Value             map[string]interface{} `json:"value"`
}

// MarshalJSON is the custom marshaler for SetSetObject.
func (sso SetSetObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sso.Value != nil {
		objectMap["value"] = sso.Value
	}
	return json.Marshal(objectMap)
}

// SignedIdentifier a signed identifier.
type SignedIdentifier struct {
	// ID - A unique id.
	ID *string `json:"Id,omitempty"`
	// AccessPolicy - The access policy.
	AccessPolicy *AccessPolicy `json:"AccessPolicy,omitempty"`
}

// TableEntityQueryResponse the properties for the table entity query response.
type TableEntityQueryResponse struct {
	autorest.Response `json:"-"`
	// OdataMetadata - The metadata response of the table.
	OdataMetadata *string `json:"odata.metadata,omitempty"`
	// Value - List of table entities.
	Value *[]map[string]interface{} `json:"value,omitempty"`
}

// TableProperties the properties for creating a table.
type TableProperties struct {
	// TableName - The name of the table to create.
	TableName *string `json:"TableName,omitempty"`
}

// TableQueryResponse the properties for the table query response.
type TableQueryResponse struct {
	autorest.Response `json:"-"`
	// OdataMetadata - The metadata response of the table.
	OdataMetadata *string `json:"odata.metadata,omitempty"`
	// Value - List of tables.
	Value *[]TableResponseProperties `json:"value,omitempty"`
}

// TableResponse the response for a single table.
type TableResponse struct {
	autorest.Response `json:"-"`
	// OdataMetadata - The metadata response of the table.
	OdataMetadata *string `json:"odata.metadata,omitempty"`
	// TableName - The name of the table.
	TableName *string `json:"TableName,omitempty"`
	// OdataType - The odata type of the table.
	OdataType *string `json:"odata.type,omitempty"`
	// OdataID - The id of the table.
	OdataID *string `json:"odata.id,omitempty"`
	// OdataEditLink - The edit link of the table.
	OdataEditLink *string `json:"odata.editLink,omitempty"`
}

// TableResponseProperties the properties for the table response.
type TableResponseProperties struct {
	// TableName - The name of the table.
	TableName *string `json:"TableName,omitempty"`
	// OdataType - The odata type of the table.
	OdataType *string `json:"odata.type,omitempty"`
	// OdataID - The id of the table.
	OdataID *string `json:"odata.id,omitempty"`
	// OdataEditLink - The edit link of the table.
	OdataEditLink *string `json:"odata.editLink,omitempty"`
}

// TableServiceError table Service error.
type TableServiceError struct {
	// Message - The error message.
	Message *string `json:"Message,omitempty"`
}

// TableServiceProperties table Service Properties.
type TableServiceProperties struct {
	autorest.Response `json:"-"`
	// Logging - Azure Analytics Logging settings.
	Logging *Logging `json:"Logging,omitempty"`
	// HourMetrics - A summary of request statistics grouped by API in hourly aggregates for tables.
	HourMetrics *Metrics `json:"HourMetrics,omitempty"`
	// MinuteMetrics - A summary of request statistics grouped by API in minute aggregates for tables.
	MinuteMetrics *Metrics `json:"MinuteMetrics,omitempty"`
	// Cors - The set of CORS rules.
	Cors *[]CorsRule `json:"Cors,omitempty"`
}

// TableServiceStats stats for the service.
type TableServiceStats struct {
	autorest.Response `json:"-"`
	// GeoReplication - Geo-Replication information for the Secondary Storage Service.
	GeoReplication *GeoReplication `json:"GeoReplication,omitempty"`
}
