/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical invert (modes updated v2.15)
 * from M3D. Formula by Luca GN 2011, updated May 2012.
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_inv.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalInvIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 oldZ = z;
	REAL rr = 1.0f;
	z += fractal->mandelbox.offset;
	z *= fractal->transformCommon.scale;
	aux->DE = aux->DE * fabs(fractal->transformCommon.scale) + 1.0f;

	if (!fractal->transformCommon.functionEnabledyFalse)
		rr = dot(z, z);
	else
		rr = dot(oldZ, oldZ);
	REAL mde = rr;

	if (!fractal->transformCommon.functionEnabledzFalse)
	{
		mde = 1.0f / mde;
		z *= mde;
		aux->DE *= mde;
	}
	else // conditional
	{

		z += fractal->transformCommon.offset000;
		if (rr < fractal->mandelbox.foldingSphericalFixed)
		{
			REAL mode = rr;
			if (fractal->transformCommon.functionEnabledFalse) // Mode 1 minR0
			{
				if (rr < fractal->transformCommon.minR0) mode = fractal->transformCommon.minR0;
			}
			if (fractal->transformCommon.functionEnabledxFalse) // Mode 2
			{
				if (rr < fractal->transformCommon.minR0) mode = 2.0f * fractal->transformCommon.minR0 - rr;
			}
			mode = 1.0f / mode;
			z *= mode;
			aux->DE *= fabs(mode);
		}
		z -= fractal->transformCommon.offset000;
	}

	z -= fractal->mandelbox.offset + fractal->transformCommon.additionConstant000;

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}

	// color added v2.32
	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addCol = 0.0f;
		addCol += fractal->foldColor.difs0000.x * mde;
		if (rr > fractal->mandelbox.foldingSphericalFixed) addCol += fractal->foldColor.difs0000.y;
		if (rr < fractal->transformCommon.minR0) addCol += fractal->foldColor.difs0000.z;

		aux->color += addCol;
	}
	return z;
}