package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePdnsUdpIpSegments invokes the alidns.DescribePdnsUdpIpSegments API synchronously
func (client *Client) DescribePdnsUdpIpSegments(request *DescribePdnsUdpIpSegmentsRequest) (response *DescribePdnsUdpIpSegmentsResponse, err error) {
	response = CreateDescribePdnsUdpIpSegmentsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePdnsUdpIpSegmentsWithChan invokes the alidns.DescribePdnsUdpIpSegments API asynchronously
func (client *Client) DescribePdnsUdpIpSegmentsWithChan(request *DescribePdnsUdpIpSegmentsRequest) (<-chan *DescribePdnsUdpIpSegmentsResponse, <-chan error) {
	responseChan := make(chan *DescribePdnsUdpIpSegmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePdnsUdpIpSegments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePdnsUdpIpSegmentsWithCallback invokes the alidns.DescribePdnsUdpIpSegments API asynchronously
func (client *Client) DescribePdnsUdpIpSegmentsWithCallback(request *DescribePdnsUdpIpSegmentsRequest, callback func(response *DescribePdnsUdpIpSegmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePdnsUdpIpSegmentsResponse
		var err error
		defer close(result)
		response, err = client.DescribePdnsUdpIpSegments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePdnsUdpIpSegmentsRequest is the request struct for api DescribePdnsUdpIpSegments
type DescribePdnsUdpIpSegmentsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Lang       string           `position:"Query" name:"Lang"`
}

// DescribePdnsUdpIpSegmentsResponse is the response struct for api DescribePdnsUdpIpSegments
type DescribePdnsUdpIpSegmentsResponse struct {
	*responses.BaseResponse
	TotalCount int64       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	PageSize   int64       `json:"PageSize" xml:"PageSize"`
	PageNumber int64       `json:"PageNumber" xml:"PageNumber"`
	IpSegments []IpSegment `json:"IpSegments" xml:"IpSegments"`
}

// CreateDescribePdnsUdpIpSegmentsRequest creates a request to invoke DescribePdnsUdpIpSegments API
func CreateDescribePdnsUdpIpSegmentsRequest() (request *DescribePdnsUdpIpSegmentsRequest) {
	request = &DescribePdnsUdpIpSegmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribePdnsUdpIpSegments", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePdnsUdpIpSegmentsResponse creates a response to parse from DescribePdnsUdpIpSegments response
func CreateDescribePdnsUdpIpSegmentsResponse() (response *DescribePdnsUdpIpSegmentsResponse) {
	response = &DescribePdnsUdpIpSegmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
