package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserTags invokes the cdn.DescribeUserTags API synchronously
func (client *Client) DescribeUserTags(request *DescribeUserTagsRequest) (response *DescribeUserTagsResponse, err error) {
	response = CreateDescribeUserTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserTagsWithChan invokes the cdn.DescribeUserTags API asynchronously
func (client *Client) DescribeUserTagsWithChan(request *DescribeUserTagsRequest) (<-chan *DescribeUserTagsResponse, <-chan error) {
	responseChan := make(chan *DescribeUserTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserTagsWithCallback invokes the cdn.DescribeUserTags API asynchronously
func (client *Client) DescribeUserTagsWithCallback(request *DescribeUserTagsRequest, callback func(response *DescribeUserTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserTagsResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserTagsRequest is the request struct for api DescribeUserTags
type DescribeUserTagsRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeUserTagsResponse is the response struct for api DescribeUserTags
type DescribeUserTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Tags      []Tag  `json:"Tags" xml:"Tags"`
}

// CreateDescribeUserTagsRequest creates a request to invoke DescribeUserTags API
func CreateDescribeUserTagsRequest() (request *DescribeUserTagsRequest) {
	request = &DescribeUserTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeUserTags", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUserTagsResponse creates a response to parse from DescribeUserTags response
func CreateDescribeUserTagsResponse() (response *DescribeUserTagsResponse) {
	response = &DescribeUserTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
