package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMQRole invokes the cloudcallcenter.CheckMQRole API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkmqrole.html
func (client *Client) CheckMQRole(request *CheckMQRoleRequest) (response *CheckMQRoleResponse, err error) {
	response = CreateCheckMQRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMQRoleWithChan invokes the cloudcallcenter.CheckMQRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkmqrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckMQRoleWithChan(request *CheckMQRoleRequest) (<-chan *CheckMQRoleResponse, <-chan error) {
	responseChan := make(chan *CheckMQRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMQRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMQRoleWithCallback invokes the cloudcallcenter.CheckMQRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkmqrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckMQRoleWithCallback(request *CheckMQRoleRequest, callback func(response *CheckMQRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMQRoleResponse
		var err error
		defer close(result)
		response, err = client.CheckMQRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMQRoleRequest is the request struct for api CheckMQRole
type CheckMQRoleRequest struct {
	*requests.RpcRequest
}

// CheckMQRoleResponse is the response struct for api CheckMQRole
type CheckMQRoleResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	HasMQRole      bool   `json:"HasMQRole" xml:"HasMQRole"`
}

// CreateCheckMQRoleRequest creates a request to invoke CheckMQRole API
func CreateCheckMQRoleRequest() (request *CheckMQRoleRequest) {
	request = &CheckMQRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CheckMQRole", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckMQRoleResponse creates a response to parse from CheckMQRole response
func CreateCheckMQRoleResponse() (response *CheckMQRoleResponse) {
	response = &CheckMQRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
