package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCnameAutoStatus invokes the ddospro.ModifyCnameAutoStatus API synchronously
// api document: https://help.aliyun.com/api/ddospro/modifycnameautostatus.html
func (client *Client) ModifyCnameAutoStatus(request *ModifyCnameAutoStatusRequest) (response *ModifyCnameAutoStatusResponse, err error) {
	response = CreateModifyCnameAutoStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCnameAutoStatusWithChan invokes the ddospro.ModifyCnameAutoStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifycnameautostatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCnameAutoStatusWithChan(request *ModifyCnameAutoStatusRequest) (<-chan *ModifyCnameAutoStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyCnameAutoStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCnameAutoStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCnameAutoStatusWithCallback invokes the ddospro.ModifyCnameAutoStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifycnameautostatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCnameAutoStatusWithCallback(request *ModifyCnameAutoStatusRequest, callback func(response *ModifyCnameAutoStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCnameAutoStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyCnameAutoStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCnameAutoStatusRequest is the request struct for api ModifyCnameAutoStatus
type ModifyCnameAutoStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	Enable          requests.Boolean `position:"Query" name:"Enable"`
}

// ModifyCnameAutoStatusResponse is the response struct for api ModifyCnameAutoStatus
type ModifyCnameAutoStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCnameAutoStatusRequest creates a request to invoke ModifyCnameAutoStatus API
func CreateModifyCnameAutoStatusRequest() (request *ModifyCnameAutoStatusRequest) {
	request = &ModifyCnameAutoStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "ModifyCnameAutoStatus", "", "")
	return
}

// CreateModifyCnameAutoStatusResponse creates a response to parse from ModifyCnameAutoStatus response
func CreateModifyCnameAutoStatusResponse() (response *ModifyCnameAutoStatusResponse) {
	response = &ModifyCnameAutoStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
