package ivpd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSegmentBodyJob invokes the ivpd.CreateSegmentBodyJob API synchronously
// api document: https://help.aliyun.com/api/ivpd/createsegmentbodyjob.html
func (client *Client) CreateSegmentBodyJob(request *CreateSegmentBodyJobRequest) (response *CreateSegmentBodyJobResponse, err error) {
	response = CreateCreateSegmentBodyJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSegmentBodyJobWithChan invokes the ivpd.CreateSegmentBodyJob API asynchronously
// api document: https://help.aliyun.com/api/ivpd/createsegmentbodyjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSegmentBodyJobWithChan(request *CreateSegmentBodyJobRequest) (<-chan *CreateSegmentBodyJobResponse, <-chan error) {
	responseChan := make(chan *CreateSegmentBodyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSegmentBodyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSegmentBodyJobWithCallback invokes the ivpd.CreateSegmentBodyJob API asynchronously
// api document: https://help.aliyun.com/api/ivpd/createsegmentbodyjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSegmentBodyJobWithCallback(request *CreateSegmentBodyJobRequest, callback func(response *CreateSegmentBodyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSegmentBodyJobResponse
		var err error
		defer close(result)
		response, err = client.CreateSegmentBodyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSegmentBodyJobRequest is the request struct for api CreateSegmentBodyJob
type CreateSegmentBodyJobRequest struct {
	*requests.RpcRequest
	DataList   *[]CreateSegmentBodyJobDataList `position:"Body" name:"DataList"  type:"Repeated"`
	Async      requests.Boolean                `position:"Body" name:"Async"`
	JobId      string                          `position:"Body" name:"JobId"`
	TimeToLive requests.Integer                `position:"Body" name:"TimeToLive"`
}

// CreateSegmentBodyJobDataList is a repeated param struct in CreateSegmentBodyJobRequest
type CreateSegmentBodyJobDataList struct {
	DataId   string `name:"DataId"`
	ImageUrl string `name:"ImageUrl"`
}

// CreateSegmentBodyJobResponse is the response struct for api CreateSegmentBodyJob
type CreateSegmentBodyJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateSegmentBodyJobRequest creates a request to invoke CreateSegmentBodyJob API
func CreateCreateSegmentBodyJobRequest() (request *CreateSegmentBodyJobRequest) {
	request = &CreateSegmentBodyJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivpd", "2019-06-25", "CreateSegmentBodyJob", "ivpd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSegmentBodyJobResponse creates a response to parse from CreateSegmentBodyJob response
func CreateCreateSegmentBodyJobResponse() (response *CreateSegmentBodyJobResponse) {
	response = &CreateSegmentBodyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
