package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableVodRealtimeLogDelivery invokes the vod.DisableVodRealtimeLogDelivery API synchronously
func (client *Client) DisableVodRealtimeLogDelivery(request *DisableVodRealtimeLogDeliveryRequest) (response *DisableVodRealtimeLogDeliveryResponse, err error) {
	response = CreateDisableVodRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DisableVodRealtimeLogDeliveryWithChan invokes the vod.DisableVodRealtimeLogDelivery API asynchronously
func (client *Client) DisableVodRealtimeLogDeliveryWithChan(request *DisableVodRealtimeLogDeliveryRequest) (<-chan *DisableVodRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DisableVodRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableVodRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableVodRealtimeLogDeliveryWithCallback invokes the vod.DisableVodRealtimeLogDelivery API asynchronously
func (client *Client) DisableVodRealtimeLogDeliveryWithCallback(request *DisableVodRealtimeLogDeliveryRequest, callback func(response *DisableVodRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableVodRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DisableVodRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableVodRealtimeLogDeliveryRequest is the request struct for api DisableVodRealtimeLogDelivery
type DisableVodRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DisableVodRealtimeLogDeliveryResponse is the response struct for api DisableVodRealtimeLogDelivery
type DisableVodRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableVodRealtimeLogDeliveryRequest creates a request to invoke DisableVodRealtimeLogDelivery API
func CreateDisableVodRealtimeLogDeliveryRequest() (request *DisableVodRealtimeLogDeliveryRequest) {
	request = &DisableVodRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DisableVodRealtimeLogDelivery", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDisableVodRealtimeLogDeliveryResponse creates a response to parse from DisableVodRealtimeLogDelivery response
func CreateDisableVodRealtimeLogDeliveryResponse() (response *DisableVodRealtimeLogDeliveryResponse) {
	response = &DisableVodRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
