// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#include "google/cloud/aiplatform/v1/featurestore_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

FeaturestoreServiceConnectionIdempotencyPolicy::
    ~FeaturestoreServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<FeaturestoreServiceConnectionIdempotencyPolicy>
FeaturestoreServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<FeaturestoreServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::CreateFeaturestore(
    google::cloud::aiplatform::v1::CreateFeaturestoreRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::GetFeaturestore(
    google::cloud::aiplatform::v1::GetFeaturestoreRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::ListFeaturestores(
    google::cloud::aiplatform::v1::ListFeaturestoresRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::UpdateFeaturestore(
    google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::DeleteFeaturestore(
    google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::CreateEntityType(
    google::cloud::aiplatform::v1::CreateEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::GetEntityType(
    google::cloud::aiplatform::v1::GetEntityTypeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::ListEntityTypes(
    google::cloud::aiplatform::v1::ListEntityTypesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::UpdateEntityType(
    google::cloud::aiplatform::v1::UpdateEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::DeleteEntityType(
    google::cloud::aiplatform::v1::DeleteEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::CreateFeature(
    google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::BatchCreateFeatures(
    google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::GetFeature(
    google::cloud::aiplatform::v1::GetFeatureRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::ListFeatures(
    google::cloud::aiplatform::v1::ListFeaturesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::UpdateFeature(
    google::cloud::aiplatform::v1::UpdateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::DeleteFeature(
    google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::ImportFeatureValues(
    google::cloud::aiplatform::v1::ImportFeatureValuesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
FeaturestoreServiceConnectionIdempotencyPolicy::BatchReadFeatureValues(
    google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::ExportFeatureValues(
    google::cloud::aiplatform::v1::ExportFeatureValuesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::DeleteFeatureValues(
    google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeaturestoreServiceConnectionIdempotencyPolicy::SearchFeatures(
    google::cloud::aiplatform::v1::SearchFeaturesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<FeaturestoreServiceConnectionIdempotencyPolicy>
MakeDefaultFeaturestoreServiceConnectionIdempotencyPolicy() {
  return std::make_unique<FeaturestoreServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
