// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PIPELINE_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PIPELINE_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/pipeline_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PipelineServiceStub {
 public:
  virtual ~PipelineServiceStub() = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  CreateTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  GetTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetTrainingPipelineRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::ListTrainingPipelinesResponse>
  ListTrainingPipelines(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListTrainingPipelinesRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteTrainingPipeline(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteTrainingPipeline(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request) = 0;

  virtual Status CancelTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::PipelineJob>
  CreatePipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CreatePipelineJobRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::PipelineJob> GetPipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetPipelineJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::ListPipelineJobsResponse>
  ListPipelineJobs(grpc::ClientContext& context, Options const& options,
                   google::cloud::aiplatform::v1::ListPipelineJobsRequest const&
                       request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeletePipelineJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeletePipelineJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncBatchDeletePipelineJobs(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> BatchDeletePipelineJobs(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request) = 0;

  virtual Status CancelPipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CancelPipelineJobRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncBatchCancelPipelineJobs(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> BatchCancelPipelineJobs(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultPipelineServiceStub : public PipelineServiceStub {
 public:
  DefaultPipelineServiceStub(
      std::unique_ptr<
          google::cloud::aiplatform::v1::PipelineService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  CreateTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline> GetTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListTrainingPipelinesResponse>
  ListTrainingPipelines(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListTrainingPipelinesRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteTrainingPipeline(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteTrainingPipeline(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request) override;

  Status CancelTrainingPipeline(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::PipelineJob> CreatePipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::PipelineJob> GetPipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetPipelineJobRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListPipelineJobsResponse>
  ListPipelineJobs(grpc::ClientContext& context, Options const& options,
                   google::cloud::aiplatform::v1::ListPipelineJobsRequest const&
                       request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeletePipelineJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeletePipelineJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchDeletePipelineJobs(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchDeletePipelineJobs(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request) override;

  Status CancelPipelineJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchCancelPipelineJobs(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchCancelPipelineJobs(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::aiplatform::v1::PipelineService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PIPELINE_STUB_H
