// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/table.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_TABLE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_TABLE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/v2/table.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TableServiceConnectionIdempotencyPolicy {
 public:
  virtual ~TableServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<TableServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency GetTable(
      google::cloud::bigquery::v2::GetTableRequest const& request);

  virtual google::cloud::Idempotency InsertTable(
      google::cloud::bigquery::v2::InsertTableRequest const& request);

  virtual google::cloud::Idempotency PatchTable(
      google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request);

  virtual google::cloud::Idempotency UpdateTable(
      google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request);

  virtual google::cloud::Idempotency DeleteTable(
      google::cloud::bigquery::v2::DeleteTableRequest const& request);

  virtual google::cloud::Idempotency ListTables(
      google::cloud::bigquery::v2::ListTablesRequest request);
};

std::unique_ptr<TableServiceConnectionIdempotencyPolicy>
MakeDefaultTableServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_TABLE_CONNECTION_IDEMPOTENCY_POLICY_H
