// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_pools/v1/target_pools.proto

#include "google/cloud/compute/target_pools/v1/internal/target_pools_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_target_pools_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TargetPoolsTracingConnection::TargetPoolsTracingConnection(
    std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::AddHealthCheck(
    google::cloud::cpp::compute::target_pools::v1::AddHealthCheckRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::AddHealthCheck(
    NoAwaitTag,
    google::cloud::cpp::compute::target_pools::v1::AddHealthCheckRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->AddHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::AddHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddHealthCheck(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::AddInstance(
    google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddInstance(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::AddInstance(
    NoAwaitTag,
    google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->AddInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::AddInstance(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::AddInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddInstance(operation));
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::TargetPoolsScopedList>>
TargetPoolsTracingConnection::AggregatedListTargetPools(
    google::cloud::cpp::compute::target_pools::v1::
        AggregatedListTargetPoolsRequest request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::"
      "AggregatedListTargetPools");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListTargetPools(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::TargetPoolsScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::DeleteTargetPool(
    google::cloud::cpp::compute::target_pools::v1::
        DeleteTargetPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::DeleteTargetPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTargetPool(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::DeleteTargetPool(
    NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                    DeleteTargetPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::DeleteTargetPool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteTargetPool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::DeleteTargetPool(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::DeleteTargetPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTargetPool(operation));
}

StatusOr<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsTracingConnection::GetTargetPool(
    google::cloud::cpp::compute::target_pools::v1::GetTargetPoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::GetTargetPool");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTargetPool(request));
}

StatusOr<google::cloud::cpp::compute::v1::TargetPoolInstanceHealth>
TargetPoolsTracingConnection::GetHealth(
    google::cloud::cpp::compute::target_pools::v1::GetHealthRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::GetHealth");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHealth(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::InsertTargetPool(
    google::cloud::cpp::compute::target_pools::v1::
        InsertTargetPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::InsertTargetPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertTargetPool(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::InsertTargetPool(
    NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                    InsertTargetPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::InsertTargetPool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertTargetPool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::InsertTargetPool(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::InsertTargetPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertTargetPool(operation));
}

StreamRange<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsTracingConnection::ListTargetPools(
    google::cloud::cpp::compute::target_pools::v1::ListTargetPoolsRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::ListTargetPools");
  internal::OTelScope scope(span);
  auto sr = child_->ListTargetPools(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::TargetPool>(std::move(span),
                                                   std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::RemoveHealthCheck(
    google::cloud::cpp::compute::target_pools::v1::
        RemoveHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RemoveHealthCheck(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::RemoveHealthCheck(
    NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                    RemoveHealthCheckRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveHealthCheck");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RemoveHealthCheck(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::RemoveHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveHealthCheck");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RemoveHealthCheck(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::RemoveInstance(
    google::cloud::cpp::compute::target_pools::v1::RemoveInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RemoveInstance(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::RemoveInstance(
    NoAwaitTag,
    google::cloud::cpp::compute::target_pools::v1::RemoveInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RemoveInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::RemoveInstance(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::RemoveInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RemoveInstance(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::SetBackup(
    google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetBackup(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::SetBackup(
    NoAwaitTag,
    google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::SetBackup(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetBackup(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::SetSecurityPolicy(
    google::cloud::cpp::compute::target_pools::v1::
        SetSecurityPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetSecurityPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetSecurityPolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetPoolsTracingConnection::SetSecurityPolicy(
    NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                    SetSecurityPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetSecurityPolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->SetSecurityPolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsTracingConnection::SetSecurityPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_target_pools_v1::TargetPoolsConnection::SetSecurityPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SetSecurityPolicy(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection>
MakeTargetPoolsTracingConnection(
    std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TargetPoolsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_pools_v1_internal
}  // namespace cloud
}  // namespace google
