// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATA_SCAN_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATA_SCAN_TRACING_CONNECTION_H

#include "google/cloud/dataplex/v1/data_scan_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DataScanServiceTracingConnection
    : public dataplex_v1::DataScanServiceConnection {
 public:
  ~DataScanServiceTracingConnection() override = default;

  explicit DataScanServiceTracingConnection(
      std::shared_ptr<dataplex_v1::DataScanServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::dataplex::v1::DataScan>> CreateDataScan(
      google::cloud::dataplex::v1::CreateDataScanRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDataScan(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateDataScanRequest const& request)
      override;

  future<StatusOr<google::cloud::dataplex::v1::DataScan>> CreateDataScan(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataplex::v1::DataScan>> UpdateDataScan(
      google::cloud::dataplex::v1::UpdateDataScanRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateDataScan(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateDataScanRequest const& request)
      override;

  future<StatusOr<google::cloud::dataplex::v1::DataScan>> UpdateDataScan(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataScan(google::cloud::dataplex::v1::DeleteDataScanRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteDataScan(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteDataScanRequest const& request)
      override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataScan(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::dataplex::v1::DataScan> GetDataScan(
      google::cloud::dataplex::v1::GetDataScanRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::DataScan> ListDataScans(
      google::cloud::dataplex::v1::ListDataScansRequest request) override;

  StatusOr<google::cloud::dataplex::v1::RunDataScanResponse> RunDataScan(
      google::cloud::dataplex::v1::RunDataScanRequest const& request) override;

  StatusOr<google::cloud::dataplex::v1::DataScanJob> GetDataScanJob(
      google::cloud::dataplex::v1::GetDataScanJobRequest const& request)
      override;

  StreamRange<google::cloud::dataplex::v1::DataScanJob> ListDataScanJobs(
      google::cloud::dataplex::v1::ListDataScanJobsRequest request) override;

  StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
  GenerateDataQualityRules(
      google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
          request) override;

 private:
  std::shared_ptr<dataplex_v1::DataScanServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataplex_v1::DataScanServiceConnection>
MakeDataScanServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataScanServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATA_SCAN_TRACING_CONNECTION_H
